// Copyright 2022 Juan Pablo Tosso and the OWASP Coraza contributors
// SPDX-License-Identifier: Apache-2.0

//go:build !coraza.disabled_operators.gt

package operators

import (
	"strconv"

	"github.com/crowdsecurity/coraza/v3/experimental/plugins/macro"
	"github.com/crowdsecurity/coraza/v3/experimental/plugins/plugintypes"
)

type gt struct {
	data macro.Macro
}

var _ plugintypes.Operator = (*gt)(nil)

func newGT(options plugintypes.OperatorOptions) (plugintypes.Operator, error) {
	data := options.Arguments

	m, err := macro.NewMacro(data)
	if err != nil {
		return nil, err
	}
	return &gt{data: m}, nil
}

func (o *gt) Evaluate(tx plugintypes.TransactionState, value string) bool {
	v, _ := strconv.Atoi(value)
	k, _ := strconv.Atoi(o.data.Expand(tx))
	return k < v
}

func init() {
	Register("gt", newGT)
}
