// Copyright 2022 Juan Pablo Tosso and the OWASP Coraza contributors
// SPDX-License-Identifier: Apache-2.0

//go:build !coraza.disabled_operators.lt

package operators

import (
	"strconv"

	"github.com/crowdsecurity/coraza/v3/experimental/plugins/macro"
	"github.com/crowdsecurity/coraza/v3/experimental/plugins/plugintypes"
)

type lt struct {
	data macro.Macro
}

var _ plugintypes.Operator = (*lt)(nil)

func newLT(options plugintypes.OperatorOptions) (plugintypes.Operator, error) {
	data := options.Arguments

	m, err := macro.NewMacro(data)
	if err != nil {
		return nil, err
	}
	return &lt{data: m}, nil
}

func (o *lt) Evaluate(tx plugintypes.TransactionState, value string) bool {
	vv := o.data.Expand(tx)
	data, _ := strconv.Atoi(vv)
	v, _ := strconv.Atoi(value)
	return v < data
}

func init() {
	Register("lt", newLT)
}
