// Copyright 2019 the u-root Authors. All rights reserved
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Package json2test parses Go JSON test output.
package json2test

import (
	"time"
)

// Action is a TestEvent action.
type Action string

// These are the possible Actions generated by `go test -json` or `test2json`.
const (
	Run       Action = "run"
	Pause     Action = "pause"
	Continue  Action = "cont"
	Pass      Action = "pass"
	Fail      Action = "fail"
	Skip      Action = "skip"
	Output    Action = "output"
	Benchmark Action = "benchmark"
)

// TestEvent is an event generated by `test2json`.
type TestEvent struct {
	Time    time.Time `json:",omitempty"`
	Action  Action
	Package string  `json:",omitempty"`
	Test    string  `json:",omitempty"`
	Elapsed float64 `json:",omitempty"`
	Output  string  `json:",omitempty"`
}
