/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JIFunction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class NativeJavaTopPackage
extends NativeJavaPackage
implements Function {
    private static final String commonPackages = "java.lang;java.lang.reflectjava.io;java.math;java.net;java.util;java.util.zip;java.text;java.text.resources;java.applet;javax.swing;";

    NativeJavaTopPackage(ClassLoader loader) {
        super(true, "", loader);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) throws JavaScriptException {
        return this.construct(cx, scope, args);
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) throws JavaScriptException {
        ClassLoader loader = null;
        if (args.length != 0) {
            Object arg = args[0];
            if (arg instanceof Wrapper) {
                arg = ((Wrapper)arg).unwrap();
            }
            if (arg instanceof ClassLoader) {
                loader = (ClassLoader)arg;
            }
        }
        if (loader == null) {
            Context.reportRuntimeError0("msg.not.classloader");
            return null;
        }
        return new NativeJavaPackage(true, "", loader);
    }

    public static void init(Context cx, Scriptable scope, boolean sealed) {
        ClassLoader loader = cx.getApplicationClassLoader();
        final NativeJavaTopPackage top = new NativeJavaTopPackage(loader);
        top.setPrototype(ScriptableObject.getObjectPrototype(scope));
        top.setParentScope(scope);
        String[] names = Kit.semicolonSplit(commonPackages);
        int i = 0;
        while (i != names.length) {
            top.forcePackage(names[i]);
            ++i;
        }
        JIFunction getClass = new JIFunction("getClass", 1){

            public Object call(Context fcx, Scriptable fscope, Scriptable thisObj, Object[] args) {
                return top.js_getClass(fcx, fscope, args);
            }
        };
        NativeJavaPackage javaAlias = (NativeJavaPackage)top.get("java", (Scriptable)top);
        ScriptableObject global = (ScriptableObject)scope;
        getClass.defineAsProperty(global, 2);
        global.defineProperty("Packages", top, 2);
        global.defineProperty("java", javaAlias, 2);
    }

    final Scriptable js_getClass(Context cx, Scriptable scope, Object[] args) {
        if (args.length > 0 && args[0] instanceof Wrapper) {
            int index;
            String propName;
            Object prop;
            Scriptable result = this;
            Class<?> cl = ((Wrapper)args[0]).unwrap().getClass();
            String name = cl.getName();
            int offset = 0;
            while ((prop = result.get(propName = (index = name.indexOf(46, offset)) == -1 ? name.substring(offset) : name.substring(offset, index), result)) instanceof Scriptable) {
                result = (Scriptable)prop;
                if (index == -1) {
                    return result;
                }
                offset = index + 1;
            }
        }
        throw Context.reportRuntimeError(Context.getMessage0("msg.not.java.obj"));
    }
}

