// Copyright ©2015 The Gonum Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Copyright ©2013 The bíogo Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Apache-Style Software License for ColorBrewer software and ColorBrewer Color Schemes
//
// Copyright ©2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State University.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software distributed
// under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
// CONDITIONS OF ANY KIND, either express or implied. See the License for the
// specific language governing permissions and limitations under the License.

// Palette Copyright ©2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State University.

package brewer

import (
	"image/color"
)

var (
	BrBG = Diverging{
		3: DivergingPalette{
			ID:         "BrBG",
			Name:       "Brown-Blue-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'E', color.RGBA{0xd8, 0xb3, 0x65, 0xff}},
				Color{'H', color.RGBA{0xf5, 0xf5, 0xf5, 0xff}},
				Color{'K', color.RGBA{0x5a, 0xb4, 0xac, 0xff}},
			},
		},
		4: DivergingPalette{
			ID:         "BrBG",
			Name:       "Brown-Blue-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xa6, 0x61, 0x1a, 0xff}},
				Color{'F', color.RGBA{0xdf, 0xc2, 0x7d, 0xff}},
				Color{'J', color.RGBA{0x80, 0xcd, 0xc1, 0xff}},
				Color{'M', color.RGBA{0x01, 0x85, 0x71, 0xff}},
			},
		},
		5: DivergingPalette{
			ID:         "BrBG",
			Name:       "Brown-Blue-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xa6, 0x61, 0x1a, 0xff}},
				Color{'F', color.RGBA{0xdf, 0xc2, 0x7d, 0xff}},
				Color{'H', color.RGBA{0xf5, 0xf5, 0xf5, 0xff}},
				Color{'J', color.RGBA{0x80, 0xcd, 0xc1, 0xff}},
				Color{'M', color.RGBA{0x01, 0x85, 0x71, 0xff}},
			},
		},
		6: DivergingPalette{
			ID:         "BrBG",
			Name:       "Brown-Blue-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0x8c, 0x51, 0x0a, 0xff}},
				Color{'E', color.RGBA{0xd8, 0xb3, 0x65, 0xff}},
				Color{'G', color.RGBA{0xf6, 0xe8, 0xc3, 0xff}},
				Color{'I', color.RGBA{0xc7, 0xea, 0xe5, 0xff}},
				Color{'K', color.RGBA{0x5a, 0xb4, 0xac, 0xff}},
				Color{'N', color.RGBA{0x01, 0x66, 0x5e, 0xff}},
			},
		},
		7: DivergingPalette{
			ID:         "BrBG",
			Name:       "Brown-Blue-Green",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0x8c, 0x51, 0x0a, 0xff}},
				Color{'E', color.RGBA{0xd8, 0xb3, 0x65, 0xff}},
				Color{'G', color.RGBA{0xf6, 0xe8, 0xc3, 0xff}},
				Color{'H', color.RGBA{0xf5, 0xf5, 0xf5, 0xff}},
				Color{'I', color.RGBA{0xc7, 0xea, 0xe5, 0xff}},
				Color{'K', color.RGBA{0x5a, 0xb4, 0xac, 0xff}},
				Color{'N', color.RGBA{0x01, 0x66, 0x5e, 0xff}},
			},
		},
		8: DivergingPalette{
			ID:         "BrBG",
			Name:       "Brown-Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0x8c, 0x51, 0x0a, 0xff}},
				Color{'D', color.RGBA{0xbf, 0x81, 0x2d, 0xff}},
				Color{'F', color.RGBA{0xdf, 0xc2, 0x7d, 0xff}},
				Color{'G', color.RGBA{0xf6, 0xe8, 0xc3, 0xff}},
				Color{'I', color.RGBA{0xc7, 0xea, 0xe5, 0xff}},
				Color{'J', color.RGBA{0x80, 0xcd, 0xc1, 0xff}},
				Color{'L', color.RGBA{0x35, 0x97, 0x8f, 0xff}},
				Color{'N', color.RGBA{0x01, 0x66, 0x5e, 0xff}},
			},
		},
		9: DivergingPalette{
			ID:         "BrBG",
			Name:       "Brown-Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'B', color.RGBA{0x8c, 0x51, 0x0a, 0xff}},
				Color{'D', color.RGBA{0xbf, 0x81, 0x2d, 0xff}},
				Color{'F', color.RGBA{0xdf, 0xc2, 0x7d, 0xff}},
				Color{'G', color.RGBA{0xf6, 0xe8, 0xc3, 0xff}},
				Color{'H', color.RGBA{0xf5, 0xf5, 0xf5, 0xff}},
				Color{'I', color.RGBA{0xc7, 0xea, 0xe5, 0xff}},
				Color{'J', color.RGBA{0x80, 0xcd, 0xc1, 0xff}},
				Color{'L', color.RGBA{0x35, 0x97, 0x8f, 0xff}},
				Color{'N', color.RGBA{0x01, 0x66, 0x5e, 0xff}},
			},
		},
		10: DivergingPalette{
			ID:         "BrBG",
			Name:       "Brown-Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x54, 0x30, 0x05, 0xff}},
				Color{'B', color.RGBA{0x8c, 0x51, 0x0a, 0xff}},
				Color{'D', color.RGBA{0xbf, 0x81, 0x2d, 0xff}},
				Color{'F', color.RGBA{0xdf, 0xc2, 0x7d, 0xff}},
				Color{'G', color.RGBA{0xf6, 0xe8, 0xc3, 0xff}},
				Color{'I', color.RGBA{0xc7, 0xea, 0xe5, 0xff}},
				Color{'J', color.RGBA{0x80, 0xcd, 0xc1, 0xff}},
				Color{'L', color.RGBA{0x35, 0x97, 0x8f, 0xff}},
				Color{'N', color.RGBA{0x01, 0x66, 0x5e, 0xff}},
				Color{'O', color.RGBA{0x00, 0x3c, 0x30, 0xff}},
			},
		},
		11: DivergingPalette{
			ID:         "BrBG",
			Name:       "Brown-Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x54, 0x30, 0x05, 0xff}},
				Color{'B', color.RGBA{0x8c, 0x51, 0x0a, 0xff}},
				Color{'D', color.RGBA{0xbf, 0x81, 0x2d, 0xff}},
				Color{'F', color.RGBA{0xdf, 0xc2, 0x7d, 0xff}},
				Color{'G', color.RGBA{0xf6, 0xe8, 0xc3, 0xff}},
				Color{'H', color.RGBA{0xf5, 0xf5, 0xf5, 0xff}},
				Color{'I', color.RGBA{0xc7, 0xea, 0xe5, 0xff}},
				Color{'J', color.RGBA{0x80, 0xcd, 0xc1, 0xff}},
				Color{'L', color.RGBA{0x35, 0x97, 0x8f, 0xff}},
				Color{'N', color.RGBA{0x01, 0x66, 0x5e, 0xff}},
				Color{'O', color.RGBA{0x00, 0x3c, 0x30, 0xff}},
			},
		},
	}
	PiYG = Diverging{
		3: DivergingPalette{
			ID:         "PiYG",
			Name:       "Pink-Yellow-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'E', color.RGBA{0xe9, 0xa3, 0xc9, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'K', color.RGBA{0xa1, 0xd7, 0x6a, 0xff}},
			},
		},
		4: DivergingPalette{
			ID:         "PiYG",
			Name:       "Pink-Yellow-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xd0, 0x1c, 0x8b, 0xff}},
				Color{'F', color.RGBA{0xf1, 0xb6, 0xda, 0xff}},
				Color{'J', color.RGBA{0xb8, 0xe1, 0x86, 0xff}},
				Color{'M', color.RGBA{0x4d, 0xac, 0x26, 0xff}},
			},
		},
		5: DivergingPalette{
			ID:         "PiYG",
			Name:       "Pink-Yellow-Green",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'C', color.RGBA{0xd0, 0x1c, 0x8b, 0xff}},
				Color{'F', color.RGBA{0xf1, 0xb6, 0xda, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'J', color.RGBA{0xb8, 0xe1, 0x86, 0xff}},
				Color{'M', color.RGBA{0x4d, 0xac, 0x26, 0xff}},
			},
		},
		6: DivergingPalette{
			ID:         "PiYG",
			Name:       "Pink-Yellow-Green",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xc5, 0x1b, 0x7d, 0xff}},
				Color{'E', color.RGBA{0xe9, 0xa3, 0xc9, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xe0, 0xef, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0xd0, 0xff}},
				Color{'K', color.RGBA{0xa1, 0xd7, 0x6a, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x92, 0x21, 0xff}},
			},
		},
		7: DivergingPalette{
			ID:         "PiYG",
			Name:       "Pink-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xc5, 0x1b, 0x7d, 0xff}},
				Color{'E', color.RGBA{0xe9, 0xa3, 0xc9, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xe0, 0xef, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0xd0, 0xff}},
				Color{'K', color.RGBA{0xa1, 0xd7, 0x6a, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x92, 0x21, 0xff}},
			},
		},
		8: DivergingPalette{
			ID:         "PiYG",
			Name:       "Pink-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xc5, 0x1b, 0x7d, 0xff}},
				Color{'D', color.RGBA{0xde, 0x77, 0xae, 0xff}},
				Color{'F', color.RGBA{0xf1, 0xb6, 0xda, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xe0, 0xef, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0xd0, 0xff}},
				Color{'J', color.RGBA{0xb8, 0xe1, 0x86, 0xff}},
				Color{'L', color.RGBA{0x7f, 0xbc, 0x41, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x92, 0x21, 0xff}},
			},
		},
		9: DivergingPalette{
			ID:         "PiYG",
			Name:       "Pink-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xc5, 0x1b, 0x7d, 0xff}},
				Color{'D', color.RGBA{0xde, 0x77, 0xae, 0xff}},
				Color{'F', color.RGBA{0xf1, 0xb6, 0xda, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xe0, 0xef, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0xd0, 0xff}},
				Color{'J', color.RGBA{0xb8, 0xe1, 0x86, 0xff}},
				Color{'L', color.RGBA{0x7f, 0xbc, 0x41, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x92, 0x21, 0xff}},
			},
		},
		10: DivergingPalette{
			ID:         "PiYG",
			Name:       "Pink-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8e, 0x01, 0x52, 0xff}},
				Color{'B', color.RGBA{0xc5, 0x1b, 0x7d, 0xff}},
				Color{'D', color.RGBA{0xde, 0x77, 0xae, 0xff}},
				Color{'F', color.RGBA{0xf1, 0xb6, 0xda, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xe0, 0xef, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0xd0, 0xff}},
				Color{'J', color.RGBA{0xb8, 0xe1, 0x86, 0xff}},
				Color{'L', color.RGBA{0x7f, 0xbc, 0x41, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x92, 0x21, 0xff}},
				Color{'O', color.RGBA{0x27, 0x64, 0x19, 0xff}},
			},
		},
		11: DivergingPalette{
			ID:         "PiYG",
			Name:       "Pink-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8e, 0x01, 0x52, 0xff}},
				Color{'B', color.RGBA{0xc5, 0x1b, 0x7d, 0xff}},
				Color{'D', color.RGBA{0xde, 0x77, 0xae, 0xff}},
				Color{'F', color.RGBA{0xf1, 0xb6, 0xda, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xe0, 0xef, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0xd0, 0xff}},
				Color{'J', color.RGBA{0xb8, 0xe1, 0x86, 0xff}},
				Color{'L', color.RGBA{0x7f, 0xbc, 0x41, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x92, 0x21, 0xff}},
				Color{'O', color.RGBA{0x27, 0x64, 0x19, 0xff}},
			},
		},
	}
	PRGn = Diverging{
		3: DivergingPalette{
			ID:         "PRGn",
			Name:       "Purple-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'E', color.RGBA{0xaf, 0x8d, 0xc3, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'K', color.RGBA{0x7f, 0xbf, 0x7b, 0xff}},
			},
		},
		4: DivergingPalette{
			ID:         "PRGn",
			Name:       "Purple-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0x7b, 0x32, 0x94, 0xff}},
				Color{'F', color.RGBA{0xc2, 0xa5, 0xcf, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xdb, 0xa0, 0xff}},
				Color{'M', color.RGBA{0x00, 0x88, 0x37, 0xff}},
			},
		},
		5: DivergingPalette{
			ID:         "PRGn",
			Name:       "Purple-Green",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'C', color.RGBA{0x7b, 0x32, 0x94, 0xff}},
				Color{'F', color.RGBA{0xc2, 0xa5, 0xcf, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xdb, 0xa0, 0xff}},
				Color{'M', color.RGBA{0x00, 0x88, 0x37, 0xff}},
			},
		},
		6: DivergingPalette{
			ID:         "PRGn",
			Name:       "Purple-Green",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0x76, 0x2a, 0x83, 0xff}},
				Color{'E', color.RGBA{0xaf, 0x8d, 0xc3, 0xff}},
				Color{'G', color.RGBA{0xe7, 0xd4, 0xe8, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xf0, 0xd3, 0xff}},
				Color{'K', color.RGBA{0x7f, 0xbf, 0x7b, 0xff}},
				Color{'N', color.RGBA{0x1b, 0x78, 0x37, 0xff}},
			},
		},
		7: DivergingPalette{
			ID:         "PRGn",
			Name:       "Purple-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0x76, 0x2a, 0x83, 0xff}},
				Color{'E', color.RGBA{0xaf, 0x8d, 0xc3, 0xff}},
				Color{'G', color.RGBA{0xe7, 0xd4, 0xe8, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xf0, 0xd3, 0xff}},
				Color{'K', color.RGBA{0x7f, 0xbf, 0x7b, 0xff}},
				Color{'N', color.RGBA{0x1b, 0x78, 0x37, 0xff}},
			},
		},
		8: DivergingPalette{
			ID:         "PRGn",
			Name:       "Purple-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0x76, 0x2a, 0x83, 0xff}},
				Color{'D', color.RGBA{0x99, 0x70, 0xab, 0xff}},
				Color{'F', color.RGBA{0xc2, 0xa5, 0xcf, 0xff}},
				Color{'G', color.RGBA{0xe7, 0xd4, 0xe8, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xf0, 0xd3, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xdb, 0xa0, 0xff}},
				Color{'L', color.RGBA{0x5a, 0xae, 0x61, 0xff}},
				Color{'N', color.RGBA{0x1b, 0x78, 0x37, 0xff}},
			},
		},
		9: DivergingPalette{
			ID:         "PRGn",
			Name:       "Purple-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0x76, 0x2a, 0x83, 0xff}},
				Color{'D', color.RGBA{0x99, 0x70, 0xab, 0xff}},
				Color{'F', color.RGBA{0xc2, 0xa5, 0xcf, 0xff}},
				Color{'G', color.RGBA{0xe7, 0xd4, 0xe8, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xf0, 0xd3, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xdb, 0xa0, 0xff}},
				Color{'L', color.RGBA{0x5a, 0xae, 0x61, 0xff}},
				Color{'N', color.RGBA{0x1b, 0x78, 0x37, 0xff}},
			},
		},
		10: DivergingPalette{
			ID:         "PRGn",
			Name:       "Purple-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x40, 0x00, 0x4b, 0xff}},
				Color{'B', color.RGBA{0x76, 0x2a, 0x83, 0xff}},
				Color{'D', color.RGBA{0x99, 0x70, 0xab, 0xff}},
				Color{'F', color.RGBA{0xc2, 0xa5, 0xcf, 0xff}},
				Color{'G', color.RGBA{0xe7, 0xd4, 0xe8, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xf0, 0xd3, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xdb, 0xa0, 0xff}},
				Color{'L', color.RGBA{0x5a, 0xae, 0x61, 0xff}},
				Color{'N', color.RGBA{0x1b, 0x78, 0x37, 0xff}},
				Color{'O', color.RGBA{0x00, 0x44, 0x1b, 0xff}},
			},
		},
		11: DivergingPalette{
			ID:         "PRGn",
			Name:       "Purple-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x40, 0x00, 0x4b, 0xff}},
				Color{'B', color.RGBA{0x76, 0x2a, 0x83, 0xff}},
				Color{'D', color.RGBA{0x99, 0x70, 0xab, 0xff}},
				Color{'F', color.RGBA{0xc2, 0xa5, 0xcf, 0xff}},
				Color{'G', color.RGBA{0xe7, 0xd4, 0xe8, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xf0, 0xd3, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xdb, 0xa0, 0xff}},
				Color{'L', color.RGBA{0x5a, 0xae, 0x61, 0xff}},
				Color{'N', color.RGBA{0x1b, 0x78, 0x37, 0xff}},
				Color{'O', color.RGBA{0x00, 0x44, 0x1b, 0xff}},
			},
		},
	}
	PuOr = Diverging{
		3: DivergingPalette{
			ID:         "PuOr",
			Name:       "Purple-Orange",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'E', color.RGBA{0xf1, 0xa3, 0x40, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'K', color.RGBA{0x99, 0x8e, 0xc3, 0xff}},
			},
		},
		4: DivergingPalette{
			ID:         "PuOr",
			Name:       "Purple-Orange",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xe6, 0x61, 0x01, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb8, 0x63, 0xff}},
				Color{'J', color.RGBA{0xb2, 0xab, 0xd2, 0xff}},
				Color{'M', color.RGBA{0x5e, 0x3c, 0x99, 0xff}},
			},
		},
		5: DivergingPalette{
			ID:         "PuOr",
			Name:       "Purple-Orange",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xe6, 0x61, 0x01, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb8, 0x63, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'J', color.RGBA{0xb2, 0xab, 0xd2, 0xff}},
				Color{'M', color.RGBA{0x5e, 0x3c, 0x99, 0xff}},
			},
		},
		6: DivergingPalette{
			ID:         "PuOr",
			Name:       "Purple-Orange",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb3, 0x58, 0x06, 0xff}},
				Color{'E', color.RGBA{0xf1, 0xa3, 0x40, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0xb6, 0xff}},
				Color{'I', color.RGBA{0xd8, 0xda, 0xeb, 0xff}},
				Color{'K', color.RGBA{0x99, 0x8e, 0xc3, 0xff}},
				Color{'N', color.RGBA{0x54, 0x27, 0x88, 0xff}},
			},
		},
		7: DivergingPalette{
			ID:         "PuOr",
			Name:       "Purple-Orange",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb3, 0x58, 0x06, 0xff}},
				Color{'E', color.RGBA{0xf1, 0xa3, 0x40, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0xb6, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xd8, 0xda, 0xeb, 0xff}},
				Color{'K', color.RGBA{0x99, 0x8e, 0xc3, 0xff}},
				Color{'N', color.RGBA{0x54, 0x27, 0x88, 0xff}},
			},
		},
		8: DivergingPalette{
			ID:         "PuOr",
			Name:       "Purple-Orange",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb3, 0x58, 0x06, 0xff}},
				Color{'D', color.RGBA{0xe0, 0x82, 0x14, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb8, 0x63, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0xb6, 0xff}},
				Color{'I', color.RGBA{0xd8, 0xda, 0xeb, 0xff}},
				Color{'J', color.RGBA{0xb2, 0xab, 0xd2, 0xff}},
				Color{'L', color.RGBA{0x80, 0x73, 0xac, 0xff}},
				Color{'N', color.RGBA{0x54, 0x27, 0x88, 0xff}},
			},
		},
		9: DivergingPalette{
			ID:         "PuOr",
			Name:       "Purple-Orange",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb3, 0x58, 0x06, 0xff}},
				Color{'D', color.RGBA{0xe0, 0x82, 0x14, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb8, 0x63, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0xb6, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xd8, 0xda, 0xeb, 0xff}},
				Color{'J', color.RGBA{0xb2, 0xab, 0xd2, 0xff}},
				Color{'L', color.RGBA{0x80, 0x73, 0xac, 0xff}},
				Color{'N', color.RGBA{0x54, 0x27, 0x88, 0xff}},
			},
		},
		10: DivergingPalette{
			ID:         "PuOr",
			Name:       "Purple-Orange",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x7f, 0x3b, 0x08, 0xff}},
				Color{'B', color.RGBA{0xb3, 0x58, 0x06, 0xff}},
				Color{'D', color.RGBA{0xe0, 0x82, 0x14, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb8, 0x63, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0xb6, 0xff}},
				Color{'I', color.RGBA{0xd8, 0xda, 0xeb, 0xff}},
				Color{'J', color.RGBA{0xb2, 0xab, 0xd2, 0xff}},
				Color{'L', color.RGBA{0x80, 0x73, 0xac, 0xff}},
				Color{'N', color.RGBA{0x54, 0x27, 0x88, 0xff}},
				Color{'O', color.RGBA{0x2d, 0x00, 0x4b, 0xff}},
			},
		},
		11: DivergingPalette{
			ID:         "PuOr",
			Name:       "Purple-Orange",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x7f, 0x3b, 0x08, 0xff}},
				Color{'B', color.RGBA{0xb3, 0x58, 0x06, 0xff}},
				Color{'D', color.RGBA{0xe0, 0x82, 0x14, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb8, 0x63, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0xb6, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xd8, 0xda, 0xeb, 0xff}},
				Color{'J', color.RGBA{0xb2, 0xab, 0xd2, 0xff}},
				Color{'L', color.RGBA{0x80, 0x73, 0xac, 0xff}},
				Color{'N', color.RGBA{0x54, 0x27, 0x88, 0xff}},
				Color{'O', color.RGBA{0x2d, 0x00, 0x4b, 0xff}},
			},
		},
	}
	RdBu = Diverging{
		3: DivergingPalette{
			ID:         "RdBu",
			Name:       "Red-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'E', color.RGBA{0xef, 0x8a, 0x62, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'K', color.RGBA{0x67, 0xa9, 0xcf, 0xff}},
			},
		},
		4: DivergingPalette{
			ID:         "RdBu",
			Name:       "Red-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xca, 0x00, 0x20, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'J', color.RGBA{0x92, 0xc5, 0xde, 0xff}},
				Color{'M', color.RGBA{0x05, 0x71, 0xb0, 0xff}},
			},
		},
		5: DivergingPalette{
			ID:         "RdBu",
			Name:       "Red-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'C', color.RGBA{0xca, 0x00, 0x20, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'J', color.RGBA{0x92, 0xc5, 0xde, 0xff}},
				Color{'M', color.RGBA{0x05, 0x71, 0xb0, 0xff}},
			},
		},
		6: DivergingPalette{
			ID:         "RdBu",
			Name:       "Red-Blue",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'E', color.RGBA{0xef, 0x8a, 0x62, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'I', color.RGBA{0xd1, 0xe5, 0xf0, 0xff}},
				Color{'K', color.RGBA{0x67, 0xa9, 0xcf, 0xff}},
				Color{'N', color.RGBA{0x21, 0x66, 0xac, 0xff}},
			},
		},
		7: DivergingPalette{
			ID:         "RdBu",
			Name:       "Red-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'E', color.RGBA{0xef, 0x8a, 0x62, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xd1, 0xe5, 0xf0, 0xff}},
				Color{'K', color.RGBA{0x67, 0xa9, 0xcf, 0xff}},
				Color{'N', color.RGBA{0x21, 0x66, 0xac, 0xff}},
			},
		},
		8: DivergingPalette{
			ID:         "RdBu",
			Name:       "Red-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'D', color.RGBA{0xd6, 0x60, 0x4d, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'I', color.RGBA{0xd1, 0xe5, 0xf0, 0xff}},
				Color{'J', color.RGBA{0x92, 0xc5, 0xde, 0xff}},
				Color{'L', color.RGBA{0x43, 0x93, 0xc3, 0xff}},
				Color{'N', color.RGBA{0x21, 0x66, 0xac, 0xff}},
			},
		},
		9: DivergingPalette{
			ID:         "RdBu",
			Name:       "Red-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'D', color.RGBA{0xd6, 0x60, 0x4d, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xd1, 0xe5, 0xf0, 0xff}},
				Color{'J', color.RGBA{0x92, 0xc5, 0xde, 0xff}},
				Color{'L', color.RGBA{0x43, 0x93, 0xc3, 0xff}},
				Color{'N', color.RGBA{0x21, 0x66, 0xac, 0xff}},
			},
		},
		10: DivergingPalette{
			ID:         "RdBu",
			Name:       "Red-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x67, 0x00, 0x1f, 0xff}},
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'D', color.RGBA{0xd6, 0x60, 0x4d, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'I', color.RGBA{0xd1, 0xe5, 0xf0, 0xff}},
				Color{'J', color.RGBA{0x92, 0xc5, 0xde, 0xff}},
				Color{'L', color.RGBA{0x43, 0x93, 0xc3, 0xff}},
				Color{'N', color.RGBA{0x21, 0x66, 0xac, 0xff}},
				Color{'O', color.RGBA{0x05, 0x30, 0x61, 0xff}},
			},
		},
		11: DivergingPalette{
			ID:         "RdBu",
			Name:       "Red-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x67, 0x00, 0x1f, 0xff}},
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'D', color.RGBA{0xd6, 0x60, 0x4d, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'H', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'I', color.RGBA{0xd1, 0xe5, 0xf0, 0xff}},
				Color{'J', color.RGBA{0x92, 0xc5, 0xde, 0xff}},
				Color{'L', color.RGBA{0x43, 0x93, 0xc3, 0xff}},
				Color{'N', color.RGBA{0x21, 0x66, 0xac, 0xff}},
				Color{'O', color.RGBA{0x05, 0x30, 0x61, 0xff}},
			},
		},
	}
	RdGy = Diverging{
		3: DivergingPalette{
			ID:         "RdGy",
			Name:       "Red-Grey",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'E', color.RGBA{0xef, 0x8a, 0x62, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xff, 0xff}},
				Color{'K', color.RGBA{0x99, 0x99, 0x99, 0xff}},
			},
		},
		4: DivergingPalette{
			ID:         "RdGy",
			Name:       "Red-Grey",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xca, 0x00, 0x20, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'J', color.RGBA{0xba, 0xba, 0xba, 0xff}},
				Color{'M', color.RGBA{0x40, 0x40, 0x40, 0xff}},
			},
		},
		5: DivergingPalette{
			ID:         "RdGy",
			Name:       "Red-Grey",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'C', color.RGBA{0xca, 0x00, 0x20, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xff, 0xff}},
				Color{'J', color.RGBA{0xba, 0xba, 0xba, 0xff}},
				Color{'M', color.RGBA{0x40, 0x40, 0x40, 0xff}},
			},
		},
		6: DivergingPalette{
			ID:         "RdGy",
			Name:       "Red-Grey",
			Laptop:     Bad,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'E', color.RGBA{0xef, 0x8a, 0x62, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xe0, 0xe0, 0xff}},
				Color{'K', color.RGBA{0x99, 0x99, 0x99, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x4d, 0x4d, 0xff}},
			},
		},
		7: DivergingPalette{
			ID:         "RdGy",
			Name:       "Red-Grey",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'E', color.RGBA{0xef, 0x8a, 0x62, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xff, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xe0, 0xe0, 0xff}},
				Color{'K', color.RGBA{0x99, 0x99, 0x99, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x4d, 0x4d, 0xff}},
			},
		},
		8: DivergingPalette{
			ID:         "RdGy",
			Name:       "Red-Grey",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'D', color.RGBA{0xd6, 0x60, 0x4d, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xe0, 0xe0, 0xff}},
				Color{'J', color.RGBA{0xba, 0xba, 0xba, 0xff}},
				Color{'L', color.RGBA{0x87, 0x87, 0x87, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x4d, 0x4d, 0xff}},
			},
		},
		9: DivergingPalette{
			ID:         "RdGy",
			Name:       "Red-Grey",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'D', color.RGBA{0xd6, 0x60, 0x4d, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xff, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xe0, 0xe0, 0xff}},
				Color{'J', color.RGBA{0xba, 0xba, 0xba, 0xff}},
				Color{'L', color.RGBA{0x87, 0x87, 0x87, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x4d, 0x4d, 0xff}},
			},
		},
		10: DivergingPalette{
			ID:         "RdGy",
			Name:       "Red-Grey",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x67, 0x00, 0x1f, 0xff}},
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'D', color.RGBA{0xd6, 0x60, 0x4d, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xe0, 0xe0, 0xff}},
				Color{'J', color.RGBA{0xba, 0xba, 0xba, 0xff}},
				Color{'L', color.RGBA{0x87, 0x87, 0x87, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x4d, 0x4d, 0xff}},
				Color{'O', color.RGBA{0x1a, 0x1a, 0x1a, 0xff}},
			},
		},
		11: DivergingPalette{
			ID:         "RdGy",
			Name:       "Red-Grey",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x67, 0x00, 0x1f, 0xff}},
				Color{'B', color.RGBA{0xb2, 0x18, 0x2b, 0xff}},
				Color{'D', color.RGBA{0xd6, 0x60, 0x4d, 0xff}},
				Color{'F', color.RGBA{0xf4, 0xa5, 0x82, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xdb, 0xc7, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xff, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xe0, 0xe0, 0xff}},
				Color{'J', color.RGBA{0xba, 0xba, 0xba, 0xff}},
				Color{'L', color.RGBA{0x87, 0x87, 0x87, 0xff}},
				Color{'N', color.RGBA{0x4d, 0x4d, 0x4d, 0xff}},
				Color{'O', color.RGBA{0x1a, 0x1a, 0x1a, 0xff}},
			},
		},
	}
	RdYlBu = Diverging{
		3: DivergingPalette{
			ID:         "RdYlBu",
			Name:       "Red-Yellow-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'E', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'K', color.RGBA{0x91, 0xbf, 0xdb, 0xff}},
			},
		},
		4: DivergingPalette{
			ID:         "RdYlBu",
			Name:       "Red-Yellow-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xd7, 0x19, 0x1c, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'J', color.RGBA{0xab, 0xd9, 0xe9, 0xff}},
				Color{'M', color.RGBA{0x2c, 0x7b, 0xb6, 0xff}},
			},
		},
		5: DivergingPalette{
			ID:         "RdYlBu",
			Name:       "Red-Yellow-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xd7, 0x19, 0x1c, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'J', color.RGBA{0xab, 0xd9, 0xe9, 0xff}},
				Color{'M', color.RGBA{0x2c, 0x7b, 0xb6, 0xff}},
			},
		},
		6: DivergingPalette{
			ID:         "RdYlBu",
			Name:       "Red-Yellow-Blue",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'E', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x90, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xf3, 0xf8, 0xff}},
				Color{'K', color.RGBA{0x91, 0xbf, 0xdb, 0xff}},
				Color{'N', color.RGBA{0x45, 0x75, 0xb4, 0xff}},
			},
		},
		7: DivergingPalette{
			ID:         "RdYlBu",
			Name:       "Red-Yellow-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'E', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x90, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xf3, 0xf8, 0xff}},
				Color{'K', color.RGBA{0x91, 0xbf, 0xdb, 0xff}},
				Color{'N', color.RGBA{0x45, 0x75, 0xb4, 0xff}},
			},
		},
		8: DivergingPalette{
			ID:         "RdYlBu",
			Name:       "Red-Yellow-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x90, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xf3, 0xf8, 0xff}},
				Color{'J', color.RGBA{0xab, 0xd9, 0xe9, 0xff}},
				Color{'L', color.RGBA{0x74, 0xad, 0xd1, 0xff}},
				Color{'N', color.RGBA{0x45, 0x75, 0xb4, 0xff}},
			},
		},
		9: DivergingPalette{
			ID:         "RdYlBu",
			Name:       "Red-Yellow-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x90, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xf3, 0xf8, 0xff}},
				Color{'J', color.RGBA{0xab, 0xd9, 0xe9, 0xff}},
				Color{'L', color.RGBA{0x74, 0xad, 0xd1, 0xff}},
				Color{'N', color.RGBA{0x45, 0x75, 0xb4, 0xff}},
			},
		},
		10: DivergingPalette{
			ID:         "RdYlBu",
			Name:       "Red-Yellow-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa5, 0x00, 0x26, 0xff}},
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x90, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xf3, 0xf8, 0xff}},
				Color{'J', color.RGBA{0xab, 0xd9, 0xe9, 0xff}},
				Color{'L', color.RGBA{0x74, 0xad, 0xd1, 0xff}},
				Color{'N', color.RGBA{0x45, 0x75, 0xb4, 0xff}},
				Color{'O', color.RGBA{0x31, 0x36, 0x95, 0xff}},
			},
		},
		11: DivergingPalette{
			ID:         "RdYlBu",
			Name:       "Red-Yellow-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa5, 0x00, 0x26, 0xff}},
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x90, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'I', color.RGBA{0xe0, 0xf3, 0xf8, 0xff}},
				Color{'J', color.RGBA{0xab, 0xd9, 0xe9, 0xff}},
				Color{'L', color.RGBA{0x74, 0xad, 0xd1, 0xff}},
				Color{'N', color.RGBA{0x45, 0x75, 0xb4, 0xff}},
				Color{'O', color.RGBA{0x31, 0x36, 0x95, 0xff}},
			},
		},
	}
	RdYlGn = Diverging{
		3: DivergingPalette{
			ID:         "RdYlGn",
			Name:       "Red-Yellow-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'E', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'K', color.RGBA{0x91, 0xcf, 0x60, 0xff}},
			},
		},
		4: DivergingPalette{
			ID:         "RdYlGn",
			Name:       "Red-Yellow-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xd7, 0x19, 0x1c, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xd9, 0x6a, 0xff}},
				Color{'M', color.RGBA{0x1a, 0x96, 0x41, 0xff}},
			},
		},
		5: DivergingPalette{
			ID:         "RdYlGn",
			Name:       "Red-Yellow-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xd7, 0x19, 0x1c, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xd9, 0x6a, 0xff}},
				Color{'M', color.RGBA{0x1a, 0x96, 0x41, 0xff}},
			},
		},
		6: DivergingPalette{
			ID:         "RdYlGn",
			Name:       "Red-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'E', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xef, 0x8b, 0xff}},
				Color{'K', color.RGBA{0x91, 0xcf, 0x60, 0xff}},
				Color{'N', color.RGBA{0x1a, 0x98, 0x50, 0xff}},
			},
		},
		7: DivergingPalette{
			ID:         "RdYlGn",
			Name:       "Red-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'E', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xef, 0x8b, 0xff}},
				Color{'K', color.RGBA{0x91, 0xcf, 0x60, 0xff}},
				Color{'N', color.RGBA{0x1a, 0x98, 0x50, 0xff}},
			},
		},
		8: DivergingPalette{
			ID:         "RdYlGn",
			Name:       "Red-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xef, 0x8b, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xd9, 0x6a, 0xff}},
				Color{'L', color.RGBA{0x66, 0xbd, 0x63, 0xff}},
				Color{'N', color.RGBA{0x1a, 0x98, 0x50, 0xff}},
			},
		},
		9: DivergingPalette{
			ID:         "RdYlGn",
			Name:       "Red-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xef, 0x8b, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xd9, 0x6a, 0xff}},
				Color{'L', color.RGBA{0x66, 0xbd, 0x63, 0xff}},
				Color{'N', color.RGBA{0x1a, 0x98, 0x50, 0xff}},
			},
		},
		10: DivergingPalette{
			ID:         "RdYlGn",
			Name:       "Red-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa5, 0x00, 0x26, 0xff}},
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xef, 0x8b, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xd9, 0x6a, 0xff}},
				Color{'L', color.RGBA{0x66, 0xbd, 0x63, 0xff}},
				Color{'N', color.RGBA{0x1a, 0x98, 0x50, 0xff}},
				Color{'O', color.RGBA{0x00, 0x68, 0x37, 0xff}},
			},
		},
		11: DivergingPalette{
			ID:         "RdYlGn",
			Name:       "Red-Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa5, 0x00, 0x26, 0xff}},
				Color{'B', color.RGBA{0xd7, 0x30, 0x27, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xef, 0x8b, 0xff}},
				Color{'J', color.RGBA{0xa6, 0xd9, 0x6a, 0xff}},
				Color{'L', color.RGBA{0x66, 0xbd, 0x63, 0xff}},
				Color{'N', color.RGBA{0x1a, 0x98, 0x50, 0xff}},
				Color{'O', color.RGBA{0x00, 0x68, 0x37, 0xff}},
			},
		},
	}
	Spectral = Diverging{
		3: DivergingPalette{
			ID:         "Spectral",
			Name:       "Spectral",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'E', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'K', color.RGBA{0x99, 0xd5, 0x94, 0xff}},
			},
		},
		4: DivergingPalette{
			ID:         "Spectral",
			Name:       "Spectral",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xd7, 0x19, 0x1c, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'J', color.RGBA{0xab, 0xdd, 0xa4, 0xff}},
				Color{'M', color.RGBA{0x2b, 0x83, 0xba, 0xff}},
			},
		},
		5: DivergingPalette{
			ID:         "Spectral",
			Name:       "Spectral",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xd7, 0x19, 0x1c, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'J', color.RGBA{0xab, 0xdd, 0xa4, 0xff}},
				Color{'M', color.RGBA{0x2b, 0x83, 0xba, 0xff}},
			},
		},
		6: DivergingPalette{
			ID:         "Spectral",
			Name:       "Spectral",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd5, 0x3e, 0x4f, 0xff}},
				Color{'E', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0x98, 0xff}},
				Color{'K', color.RGBA{0x99, 0xd5, 0x94, 0xff}},
				Color{'N', color.RGBA{0x32, 0x88, 0xbd, 0xff}},
			},
		},
		7: DivergingPalette{
			ID:         "Spectral",
			Name:       "Spectral",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd5, 0x3e, 0x4f, 0xff}},
				Color{'E', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0x98, 0xff}},
				Color{'K', color.RGBA{0x99, 0xd5, 0x94, 0xff}},
				Color{'N', color.RGBA{0x32, 0x88, 0xbd, 0xff}},
			},
		},
		8: DivergingPalette{
			ID:         "Spectral",
			Name:       "Spectral",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd5, 0x3e, 0x4f, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0x98, 0xff}},
				Color{'J', color.RGBA{0xab, 0xdd, 0xa4, 0xff}},
				Color{'L', color.RGBA{0x66, 0xc2, 0xa5, 0xff}},
				Color{'N', color.RGBA{0x32, 0x88, 0xbd, 0xff}},
			},
		},
		9: DivergingPalette{
			ID:         "Spectral",
			Name:       "Spectral",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xd5, 0x3e, 0x4f, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0x98, 0xff}},
				Color{'J', color.RGBA{0xab, 0xdd, 0xa4, 0xff}},
				Color{'L', color.RGBA{0x66, 0xc2, 0xa5, 0xff}},
				Color{'N', color.RGBA{0x32, 0x88, 0xbd, 0xff}},
			},
		},
		10: DivergingPalette{
			ID:         "Spectral",
			Name:       "Spectral",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x9e, 0x01, 0x42, 0xff}},
				Color{'B', color.RGBA{0xd5, 0x3e, 0x4f, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0x98, 0xff}},
				Color{'J', color.RGBA{0xab, 0xdd, 0xa4, 0xff}},
				Color{'L', color.RGBA{0x66, 0xc2, 0xa5, 0xff}},
				Color{'N', color.RGBA{0x32, 0x88, 0xbd, 0xff}},
				Color{'O', color.RGBA{0x5e, 0x4f, 0xa2, 0xff}},
			},
		},
		11: DivergingPalette{
			ID:         "Spectral",
			Name:       "Spectral",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x9e, 0x01, 0x42, 0xff}},
				Color{'B', color.RGBA{0xd5, 0x3e, 0x4f, 0xff}},
				Color{'D', color.RGBA{0xf4, 0x6d, 0x43, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x61, 0xff}},
				Color{'G', color.RGBA{0xfe, 0xe0, 0x8b, 0xff}},
				Color{'H', color.RGBA{0xff, 0xff, 0xbf, 0xff}},
				Color{'I', color.RGBA{0xe6, 0xf5, 0x98, 0xff}},
				Color{'J', color.RGBA{0xab, 0xdd, 0xa4, 0xff}},
				Color{'L', color.RGBA{0x66, 0xc2, 0xa5, 0xff}},
				Color{'N', color.RGBA{0x32, 0x88, 0xbd, 0xff}},
				Color{'O', color.RGBA{0x5e, 0x4f, 0xa2, 0xff}},
			},
		},
	}
)
var (
	Accent = Qualitative{
		3: NonDivergingPalette{
			ID:         "Accent",
			Name:       "Accent",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x7f, 0xc9, 0x7f, 0xff}},
				Color{'B', color.RGBA{0xbe, 0xae, 0xd4, 0xff}},
				Color{'C', color.RGBA{0xfd, 0xc0, 0x86, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Accent",
			Name:       "Accent",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x7f, 0xc9, 0x7f, 0xff}},
				Color{'B', color.RGBA{0xbe, 0xae, 0xd4, 0xff}},
				Color{'C', color.RGBA{0xfd, 0xc0, 0x86, 0xff}},
				Color{'D', color.RGBA{0xff, 0xff, 0x99, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Accent",
			Name:       "Accent",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x7f, 0xc9, 0x7f, 0xff}},
				Color{'B', color.RGBA{0xbe, 0xae, 0xd4, 0xff}},
				Color{'C', color.RGBA{0xfd, 0xc0, 0x86, 0xff}},
				Color{'D', color.RGBA{0xff, 0xff, 0x99, 0xff}},
				Color{'E', color.RGBA{0x38, 0x6c, 0xb0, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Accent",
			Name:       "Accent",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x7f, 0xc9, 0x7f, 0xff}},
				Color{'B', color.RGBA{0xbe, 0xae, 0xd4, 0xff}},
				Color{'C', color.RGBA{0xfd, 0xc0, 0x86, 0xff}},
				Color{'D', color.RGBA{0xff, 0xff, 0x99, 0xff}},
				Color{'E', color.RGBA{0x38, 0x6c, 0xb0, 0xff}},
				Color{'F', color.RGBA{0xf0, 0x02, 0x7f, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Accent",
			Name:       "Accent",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0x7f, 0xc9, 0x7f, 0xff}},
				Color{'B', color.RGBA{0xbe, 0xae, 0xd4, 0xff}},
				Color{'C', color.RGBA{0xfd, 0xc0, 0x86, 0xff}},
				Color{'D', color.RGBA{0xff, 0xff, 0x99, 0xff}},
				Color{'E', color.RGBA{0x38, 0x6c, 0xb0, 0xff}},
				Color{'F', color.RGBA{0xf0, 0x02, 0x7f, 0xff}},
				Color{'G', color.RGBA{0xbf, 0x5b, 0x17, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Accent",
			Name:       "Accent",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0x7f, 0xc9, 0x7f, 0xff}},
				Color{'B', color.RGBA{0xbe, 0xae, 0xd4, 0xff}},
				Color{'C', color.RGBA{0xfd, 0xc0, 0x86, 0xff}},
				Color{'D', color.RGBA{0xff, 0xff, 0x99, 0xff}},
				Color{'E', color.RGBA{0x38, 0x6c, 0xb0, 0xff}},
				Color{'F', color.RGBA{0xf0, 0x02, 0x7f, 0xff}},
				Color{'G', color.RGBA{0xbf, 0x5b, 0x17, 0xff}},
				Color{'H', color.RGBA{0x66, 0x66, 0x66, 0xff}},
			},
		},
	}
	Dark2 = Qualitative{
		3: NonDivergingPalette{
			ID:         "Dark2",
			Name:       "Dark 2",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x1b, 0x9e, 0x77, 0xff}},
				Color{'B', color.RGBA{0xd9, 0x5f, 0x02, 0xff}},
				Color{'C', color.RGBA{0x75, 0x70, 0xb3, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Dark2",
			Name:       "Dark 2",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x1b, 0x9e, 0x77, 0xff}},
				Color{'B', color.RGBA{0xd9, 0x5f, 0x02, 0xff}},
				Color{'C', color.RGBA{0x75, 0x70, 0xb3, 0xff}},
				Color{'D', color.RGBA{0xe7, 0x29, 0x8a, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Dark2",
			Name:       "Dark 2",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0x1b, 0x9e, 0x77, 0xff}},
				Color{'B', color.RGBA{0xd9, 0x5f, 0x02, 0xff}},
				Color{'C', color.RGBA{0x75, 0x70, 0xb3, 0xff}},
				Color{'D', color.RGBA{0xe7, 0x29, 0x8a, 0xff}},
				Color{'E', color.RGBA{0x66, 0xa6, 0x1e, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Dark2",
			Name:       "Dark 2",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0x1b, 0x9e, 0x77, 0xff}},
				Color{'B', color.RGBA{0xd9, 0x5f, 0x02, 0xff}},
				Color{'C', color.RGBA{0x75, 0x70, 0xb3, 0xff}},
				Color{'D', color.RGBA{0xe7, 0x29, 0x8a, 0xff}},
				Color{'E', color.RGBA{0x66, 0xa6, 0x1e, 0xff}},
				Color{'F', color.RGBA{0xe6, 0xab, 0x02, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Dark2",
			Name:       "Dark 2",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0x1b, 0x9e, 0x77, 0xff}},
				Color{'B', color.RGBA{0xd9, 0x5f, 0x02, 0xff}},
				Color{'C', color.RGBA{0x75, 0x70, 0xb3, 0xff}},
				Color{'D', color.RGBA{0xe7, 0x29, 0x8a, 0xff}},
				Color{'E', color.RGBA{0x66, 0xa6, 0x1e, 0xff}},
				Color{'F', color.RGBA{0xe6, 0xab, 0x02, 0xff}},
				Color{'G', color.RGBA{0xa6, 0x76, 0x1d, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Dark2",
			Name:       "Dark 2",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0x1b, 0x9e, 0x77, 0xff}},
				Color{'B', color.RGBA{0xd9, 0x5f, 0x02, 0xff}},
				Color{'C', color.RGBA{0x75, 0x70, 0xb3, 0xff}},
				Color{'D', color.RGBA{0xe7, 0x29, 0x8a, 0xff}},
				Color{'E', color.RGBA{0x66, 0xa6, 0x1e, 0xff}},
				Color{'F', color.RGBA{0xe6, 0xab, 0x02, 0xff}},
				Color{'G', color.RGBA{0xa6, 0x76, 0x1d, 0xff}},
				Color{'H', color.RGBA{0x66, 0x66, 0x66, 0xff}},
			},
		},
	}
	Paired = Qualitative{
		3: NonDivergingPalette{
			ID:         "Paired",
			Name:       "Paired",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa6, 0xce, 0xe3, 0xff}},
				Color{'B', color.RGBA{0x1f, 0x78, 0xb4, 0xff}},
				Color{'C', color.RGBA{0xb2, 0xdf, 0x8a, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Paired",
			Name:       "Paired",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa6, 0xce, 0xe3, 0xff}},
				Color{'B', color.RGBA{0x1f, 0x78, 0xb4, 0xff}},
				Color{'C', color.RGBA{0xb2, 0xdf, 0x8a, 0xff}},
				Color{'D', color.RGBA{0x33, 0xa0, 0x2c, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Paired",
			Name:       "Paired",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa6, 0xce, 0xe3, 0xff}},
				Color{'B', color.RGBA{0x1f, 0x78, 0xb4, 0xff}},
				Color{'C', color.RGBA{0xb2, 0xdf, 0x8a, 0xff}},
				Color{'D', color.RGBA{0x33, 0xa0, 0x2c, 0xff}},
				Color{'E', color.RGBA{0xfb, 0x9a, 0x99, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Paired",
			Name:       "Paired",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa6, 0xce, 0xe3, 0xff}},
				Color{'B', color.RGBA{0x1f, 0x78, 0xb4, 0xff}},
				Color{'C', color.RGBA{0xb2, 0xdf, 0x8a, 0xff}},
				Color{'D', color.RGBA{0x33, 0xa0, 0x2c, 0xff}},
				Color{'E', color.RGBA{0xfb, 0x9a, 0x99, 0xff}},
				Color{'F', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Paired",
			Name:       "Paired",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa6, 0xce, 0xe3, 0xff}},
				Color{'B', color.RGBA{0x1f, 0x78, 0xb4, 0xff}},
				Color{'C', color.RGBA{0xb2, 0xdf, 0x8a, 0xff}},
				Color{'D', color.RGBA{0x33, 0xa0, 0x2c, 0xff}},
				Color{'E', color.RGBA{0xfb, 0x9a, 0x99, 0xff}},
				Color{'F', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xbf, 0x6f, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Paired",
			Name:       "Paired",
			Laptop:     Good,
			CRT:        Unsure,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa6, 0xce, 0xe3, 0xff}},
				Color{'B', color.RGBA{0x1f, 0x78, 0xb4, 0xff}},
				Color{'C', color.RGBA{0xb2, 0xdf, 0x8a, 0xff}},
				Color{'D', color.RGBA{0x33, 0xa0, 0x2c, 0xff}},
				Color{'E', color.RGBA{0xfb, 0x9a, 0x99, 0xff}},
				Color{'F', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xbf, 0x6f, 0xff}},
				Color{'H', color.RGBA{0xff, 0x7f, 0x00, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "Paired",
			Name:       "Paired",
			Laptop:     Good,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa6, 0xce, 0xe3, 0xff}},
				Color{'B', color.RGBA{0x1f, 0x78, 0xb4, 0xff}},
				Color{'C', color.RGBA{0xb2, 0xdf, 0x8a, 0xff}},
				Color{'D', color.RGBA{0x33, 0xa0, 0x2c, 0xff}},
				Color{'E', color.RGBA{0xfb, 0x9a, 0x99, 0xff}},
				Color{'F', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xbf, 0x6f, 0xff}},
				Color{'H', color.RGBA{0xff, 0x7f, 0x00, 0xff}},
				Color{'I', color.RGBA{0xca, 0xb2, 0xd6, 0xff}},
			},
		},
		10: NonDivergingPalette{
			ID:         "Paired",
			Name:       "Paired",
			Laptop:     Good,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa6, 0xce, 0xe3, 0xff}},
				Color{'B', color.RGBA{0x1f, 0x78, 0xb4, 0xff}},
				Color{'C', color.RGBA{0xb2, 0xdf, 0x8a, 0xff}},
				Color{'D', color.RGBA{0x33, 0xa0, 0x2c, 0xff}},
				Color{'E', color.RGBA{0xfb, 0x9a, 0x99, 0xff}},
				Color{'F', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xbf, 0x6f, 0xff}},
				Color{'H', color.RGBA{0xff, 0x7f, 0x00, 0xff}},
				Color{'I', color.RGBA{0xca, 0xb2, 0xd6, 0xff}},
				Color{'J', color.RGBA{0x6a, 0x3d, 0x9a, 0xff}},
			},
		},
		11: NonDivergingPalette{
			ID:         "Paired",
			Name:       "Paired",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa6, 0xce, 0xe3, 0xff}},
				Color{'B', color.RGBA{0x1f, 0x78, 0xb4, 0xff}},
				Color{'C', color.RGBA{0xb2, 0xdf, 0x8a, 0xff}},
				Color{'D', color.RGBA{0x33, 0xa0, 0x2c, 0xff}},
				Color{'E', color.RGBA{0xfb, 0x9a, 0x99, 0xff}},
				Color{'F', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xbf, 0x6f, 0xff}},
				Color{'H', color.RGBA{0xff, 0x7f, 0x00, 0xff}},
				Color{'I', color.RGBA{0xca, 0xb2, 0xd6, 0xff}},
				Color{'J', color.RGBA{0x6a, 0x3d, 0x9a, 0xff}},
				Color{'K', color.RGBA{0xff, 0xff, 0x99, 0xff}},
			},
		},
		12: NonDivergingPalette{
			ID:         "Paired",
			Name:       "Paired",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0xa6, 0xce, 0xe3, 0xff}},
				Color{'B', color.RGBA{0x1f, 0x78, 0xb4, 0xff}},
				Color{'C', color.RGBA{0xb2, 0xdf, 0x8a, 0xff}},
				Color{'D', color.RGBA{0x33, 0xa0, 0x2c, 0xff}},
				Color{'E', color.RGBA{0xfb, 0x9a, 0x99, 0xff}},
				Color{'F', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0xbf, 0x6f, 0xff}},
				Color{'H', color.RGBA{0xff, 0x7f, 0x00, 0xff}},
				Color{'I', color.RGBA{0xca, 0xb2, 0xd6, 0xff}},
				Color{'J', color.RGBA{0x6a, 0x3d, 0x9a, 0xff}},
				Color{'K', color.RGBA{0xff, 0xff, 0x99, 0xff}},
				Color{'L', color.RGBA{0xb1, 0x59, 0x28, 0xff}},
			},
		},
	}
	Pastel1 = Qualitative{
		3: NonDivergingPalette{
			ID:         "Pastel1",
			Name:       "Pastel 1",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xfb, 0xb4, 0xae, 0xff}},
				Color{'B', color.RGBA{0xb3, 0xcd, 0xe3, 0xff}},
				Color{'C', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Pastel1",
			Name:       "Pastel 1",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xfb, 0xb4, 0xae, 0xff}},
				Color{'B', color.RGBA{0xb3, 0xcd, 0xe3, 0xff}},
				Color{'C', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'D', color.RGBA{0xde, 0xcb, 0xe4, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Pastel1",
			Name:       "Pastel 1",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xfb, 0xb4, 0xae, 0xff}},
				Color{'B', color.RGBA{0xb3, 0xcd, 0xe3, 0xff}},
				Color{'C', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'D', color.RGBA{0xde, 0xcb, 0xe4, 0xff}},
				Color{'E', color.RGBA{0xfe, 0xd9, 0xa6, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Pastel1",
			Name:       "Pastel 1",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0xfb, 0xb4, 0xae, 0xff}},
				Color{'B', color.RGBA{0xb3, 0xcd, 0xe3, 0xff}},
				Color{'C', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'D', color.RGBA{0xde, 0xcb, 0xe4, 0xff}},
				Color{'E', color.RGBA{0xfe, 0xd9, 0xa6, 0xff}},
				Color{'F', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Pastel1",
			Name:       "Pastel 1",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xfb, 0xb4, 0xae, 0xff}},
				Color{'B', color.RGBA{0xb3, 0xcd, 0xe3, 0xff}},
				Color{'C', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'D', color.RGBA{0xde, 0xcb, 0xe4, 0xff}},
				Color{'E', color.RGBA{0xfe, 0xd9, 0xa6, 0xff}},
				Color{'F', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'G', color.RGBA{0xe5, 0xd8, 0xbd, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Pastel1",
			Name:       "Pastel 1",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xfb, 0xb4, 0xae, 0xff}},
				Color{'B', color.RGBA{0xb3, 0xcd, 0xe3, 0xff}},
				Color{'C', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'D', color.RGBA{0xde, 0xcb, 0xe4, 0xff}},
				Color{'E', color.RGBA{0xfe, 0xd9, 0xa6, 0xff}},
				Color{'F', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'G', color.RGBA{0xe5, 0xd8, 0xbd, 0xff}},
				Color{'H', color.RGBA{0xfd, 0xda, 0xec, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "Pastel1",
			Name:       "Pastel 1",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xfb, 0xb4, 0xae, 0xff}},
				Color{'B', color.RGBA{0xb3, 0xcd, 0xe3, 0xff}},
				Color{'C', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'D', color.RGBA{0xde, 0xcb, 0xe4, 0xff}},
				Color{'E', color.RGBA{0xfe, 0xd9, 0xa6, 0xff}},
				Color{'F', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'G', color.RGBA{0xe5, 0xd8, 0xbd, 0xff}},
				Color{'H', color.RGBA{0xfd, 0xda, 0xec, 0xff}},
				Color{'I', color.RGBA{0xf2, 0xf2, 0xf2, 0xff}},
			},
		},
	}
	Pastel2 = Qualitative{
		3: NonDivergingPalette{
			ID:         "Pastel2",
			Name:       "Pastel 2",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0xb3, 0xe2, 0xcd, 0xff}},
				Color{'B', color.RGBA{0xfd, 0xcd, 0xac, 0xff}},
				Color{'C', color.RGBA{0xcb, 0xd5, 0xe8, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Pastel2",
			Name:       "Pastel 2",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0xb3, 0xe2, 0xcd, 0xff}},
				Color{'B', color.RGBA{0xfd, 0xcd, 0xac, 0xff}},
				Color{'C', color.RGBA{0xcb, 0xd5, 0xe8, 0xff}},
				Color{'D', color.RGBA{0xf4, 0xca, 0xe4, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Pastel2",
			Name:       "Pastel 2",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xb3, 0xe2, 0xcd, 0xff}},
				Color{'B', color.RGBA{0xfd, 0xcd, 0xac, 0xff}},
				Color{'C', color.RGBA{0xcb, 0xd5, 0xe8, 0xff}},
				Color{'D', color.RGBA{0xf4, 0xca, 0xe4, 0xff}},
				Color{'E', color.RGBA{0xe6, 0xf5, 0xc9, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Pastel2",
			Name:       "Pastel 2",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xb3, 0xe2, 0xcd, 0xff}},
				Color{'B', color.RGBA{0xfd, 0xcd, 0xac, 0xff}},
				Color{'C', color.RGBA{0xcb, 0xd5, 0xe8, 0xff}},
				Color{'D', color.RGBA{0xf4, 0xca, 0xe4, 0xff}},
				Color{'E', color.RGBA{0xe6, 0xf5, 0xc9, 0xff}},
				Color{'F', color.RGBA{0xff, 0xf2, 0xae, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Pastel2",
			Name:       "Pastel 2",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xb3, 0xe2, 0xcd, 0xff}},
				Color{'B', color.RGBA{0xfd, 0xcd, 0xac, 0xff}},
				Color{'C', color.RGBA{0xcb, 0xd5, 0xe8, 0xff}},
				Color{'D', color.RGBA{0xf4, 0xca, 0xe4, 0xff}},
				Color{'E', color.RGBA{0xe6, 0xf5, 0xc9, 0xff}},
				Color{'F', color.RGBA{0xff, 0xf2, 0xae, 0xff}},
				Color{'G', color.RGBA{0xf1, 0xe2, 0xcc, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Pastel2",
			Name:       "Pastel 2",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xb3, 0xe2, 0xcd, 0xff}},
				Color{'B', color.RGBA{0xfd, 0xcd, 0xac, 0xff}},
				Color{'C', color.RGBA{0xcb, 0xd5, 0xe8, 0xff}},
				Color{'D', color.RGBA{0xf4, 0xca, 0xe4, 0xff}},
				Color{'E', color.RGBA{0xe6, 0xf5, 0xc9, 0xff}},
				Color{'F', color.RGBA{0xff, 0xf2, 0xae, 0xff}},
				Color{'G', color.RGBA{0xf1, 0xe2, 0xcc, 0xff}},
				Color{'H', color.RGBA{0xcc, 0xcc, 0xcc, 0xff}},
			},
		},
	}
	Set1 = Qualitative{
		3: NonDivergingPalette{
			ID:         "Set1",
			Name:       "Set 1",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xe4, 0x1a, 0x1c, 0xff}},
				Color{'B', color.RGBA{0x37, 0x7e, 0xb8, 0xff}},
				Color{'C', color.RGBA{0x4d, 0xaf, 0x4a, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Set1",
			Name:       "Set 1",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xe4, 0x1a, 0x1c, 0xff}},
				Color{'B', color.RGBA{0x37, 0x7e, 0xb8, 0xff}},
				Color{'C', color.RGBA{0x4d, 0xaf, 0x4a, 0xff}},
				Color{'D', color.RGBA{0x98, 0x4e, 0xa3, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Set1",
			Name:       "Set 1",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xe4, 0x1a, 0x1c, 0xff}},
				Color{'B', color.RGBA{0x37, 0x7e, 0xb8, 0xff}},
				Color{'C', color.RGBA{0x4d, 0xaf, 0x4a, 0xff}},
				Color{'D', color.RGBA{0x98, 0x4e, 0xa3, 0xff}},
				Color{'E', color.RGBA{0xff, 0x7f, 0x00, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Set1",
			Name:       "Set 1",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xe4, 0x1a, 0x1c, 0xff}},
				Color{'B', color.RGBA{0x37, 0x7e, 0xb8, 0xff}},
				Color{'C', color.RGBA{0x4d, 0xaf, 0x4a, 0xff}},
				Color{'D', color.RGBA{0x98, 0x4e, 0xa3, 0xff}},
				Color{'E', color.RGBA{0xff, 0x7f, 0x00, 0xff}},
				Color{'F', color.RGBA{0xff, 0xff, 0x33, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Set1",
			Name:       "Set 1",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xe4, 0x1a, 0x1c, 0xff}},
				Color{'B', color.RGBA{0x37, 0x7e, 0xb8, 0xff}},
				Color{'C', color.RGBA{0x4d, 0xaf, 0x4a, 0xff}},
				Color{'D', color.RGBA{0x98, 0x4e, 0xa3, 0xff}},
				Color{'E', color.RGBA{0xff, 0x7f, 0x00, 0xff}},
				Color{'F', color.RGBA{0xff, 0xff, 0x33, 0xff}},
				Color{'G', color.RGBA{0xa6, 0x56, 0x28, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Set1",
			Name:       "Set 1",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xe4, 0x1a, 0x1c, 0xff}},
				Color{'B', color.RGBA{0x37, 0x7e, 0xb8, 0xff}},
				Color{'C', color.RGBA{0x4d, 0xaf, 0x4a, 0xff}},
				Color{'D', color.RGBA{0x98, 0x4e, 0xa3, 0xff}},
				Color{'E', color.RGBA{0xff, 0x7f, 0x00, 0xff}},
				Color{'F', color.RGBA{0xff, 0xff, 0x33, 0xff}},
				Color{'G', color.RGBA{0xa6, 0x56, 0x28, 0xff}},
				Color{'H', color.RGBA{0xf7, 0x81, 0xbf, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "Set1",
			Name:       "Set 1",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0xe4, 0x1a, 0x1c, 0xff}},
				Color{'B', color.RGBA{0x37, 0x7e, 0xb8, 0xff}},
				Color{'C', color.RGBA{0x4d, 0xaf, 0x4a, 0xff}},
				Color{'D', color.RGBA{0x98, 0x4e, 0xa3, 0xff}},
				Color{'E', color.RGBA{0xff, 0x7f, 0x00, 0xff}},
				Color{'F', color.RGBA{0xff, 0xff, 0x33, 0xff}},
				Color{'G', color.RGBA{0xa6, 0x56, 0x28, 0xff}},
				Color{'H', color.RGBA{0xf7, 0x81, 0xbf, 0xff}},
				Color{'I', color.RGBA{0x99, 0x99, 0x99, 0xff}},
			},
		},
	}
	Set2 = Qualitative{
		3: NonDivergingPalette{
			ID:         "Set2",
			Name:       "Set 2",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x66, 0xc2, 0xa5, 0xff}},
				Color{'B', color.RGBA{0xfc, 0x8d, 0x62, 0xff}},
				Color{'C', color.RGBA{0x8d, 0xa0, 0xcb, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Set2",
			Name:       "Set 2",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x66, 0xc2, 0xa5, 0xff}},
				Color{'B', color.RGBA{0xfc, 0x8d, 0x62, 0xff}},
				Color{'C', color.RGBA{0x8d, 0xa0, 0xcb, 0xff}},
				Color{'D', color.RGBA{0xe7, 0x8a, 0xc3, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Set2",
			Name:       "Set 2",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x66, 0xc2, 0xa5, 0xff}},
				Color{'B', color.RGBA{0xfc, 0x8d, 0x62, 0xff}},
				Color{'C', color.RGBA{0x8d, 0xa0, 0xcb, 0xff}},
				Color{'D', color.RGBA{0xe7, 0x8a, 0xc3, 0xff}},
				Color{'E', color.RGBA{0xa6, 0xd8, 0x54, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Set2",
			Name:       "Set 2",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Unsure,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x66, 0xc2, 0xa5, 0xff}},
				Color{'B', color.RGBA{0xfc, 0x8d, 0x62, 0xff}},
				Color{'C', color.RGBA{0x8d, 0xa0, 0xcb, 0xff}},
				Color{'D', color.RGBA{0xe7, 0x8a, 0xc3, 0xff}},
				Color{'E', color.RGBA{0xa6, 0xd8, 0x54, 0xff}},
				Color{'F', color.RGBA{0xff, 0xd9, 0x2f, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Set2",
			Name:       "Set 2",
			Laptop:     Unsure,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x66, 0xc2, 0xa5, 0xff}},
				Color{'B', color.RGBA{0xfc, 0x8d, 0x62, 0xff}},
				Color{'C', color.RGBA{0x8d, 0xa0, 0xcb, 0xff}},
				Color{'D', color.RGBA{0xe7, 0x8a, 0xc3, 0xff}},
				Color{'E', color.RGBA{0xa6, 0xd8, 0x54, 0xff}},
				Color{'F', color.RGBA{0xff, 0xd9, 0x2f, 0xff}},
				Color{'G', color.RGBA{0xe5, 0xc4, 0x94, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Set2",
			Name:       "Set 2",
			Laptop:     Unsure,
			CRT:        Bad,
			ColorBlind: Bad,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0x66, 0xc2, 0xa5, 0xff}},
				Color{'B', color.RGBA{0xfc, 0x8d, 0x62, 0xff}},
				Color{'C', color.RGBA{0x8d, 0xa0, 0xcb, 0xff}},
				Color{'D', color.RGBA{0xe7, 0x8a, 0xc3, 0xff}},
				Color{'E', color.RGBA{0xa6, 0xd8, 0x54, 0xff}},
				Color{'F', color.RGBA{0xff, 0xd9, 0x2f, 0xff}},
				Color{'G', color.RGBA{0xe5, 0xc4, 0x94, 0xff}},
				Color{'H', color.RGBA{0xb3, 0xb3, 0xb3, 0xff}},
			},
		},
	}
	Set3 = Qualitative{
		3: NonDivergingPalette{
			ID:         "Set3",
			Name:       "Set 3",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8d, 0xd3, 0xc7, 0xff}},
				Color{'B', color.RGBA{0xff, 0xff, 0xb3, 0xff}},
				Color{'C', color.RGBA{0xbe, 0xba, 0xda, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Set3",
			Name:       "Set 3",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Unsure,
			Copy:       Unsure,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8d, 0xd3, 0xc7, 0xff}},
				Color{'B', color.RGBA{0xff, 0xff, 0xb3, 0xff}},
				Color{'C', color.RGBA{0xbe, 0xba, 0xda, 0xff}},
				Color{'D', color.RGBA{0xfb, 0x80, 0x72, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Set3",
			Name:       "Set 3",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Bad,
			Copy:       Unsure,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8d, 0xd3, 0xc7, 0xff}},
				Color{'B', color.RGBA{0xff, 0xff, 0xb3, 0xff}},
				Color{'C', color.RGBA{0xbe, 0xba, 0xda, 0xff}},
				Color{'D', color.RGBA{0xfb, 0x80, 0x72, 0xff}},
				Color{'E', color.RGBA{0x80, 0xb1, 0xd3, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Set3",
			Name:       "Set 3",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Bad,
			Copy:       Unsure,
			Projector:  Good,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8d, 0xd3, 0xc7, 0xff}},
				Color{'B', color.RGBA{0xff, 0xff, 0xb3, 0xff}},
				Color{'C', color.RGBA{0xbe, 0xba, 0xda, 0xff}},
				Color{'D', color.RGBA{0xfb, 0x80, 0x72, 0xff}},
				Color{'E', color.RGBA{0x80, 0xb1, 0xd3, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb4, 0x62, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Set3",
			Name:       "Set 3",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Bad,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8d, 0xd3, 0xc7, 0xff}},
				Color{'B', color.RGBA{0xff, 0xff, 0xb3, 0xff}},
				Color{'C', color.RGBA{0xbe, 0xba, 0xda, 0xff}},
				Color{'D', color.RGBA{0xfb, 0x80, 0x72, 0xff}},
				Color{'E', color.RGBA{0x80, 0xb1, 0xd3, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb4, 0x62, 0xff}},
				Color{'G', color.RGBA{0xb3, 0xde, 0x69, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Set3",
			Name:       "Set 3",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Bad,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8d, 0xd3, 0xc7, 0xff}},
				Color{'B', color.RGBA{0xff, 0xff, 0xb3, 0xff}},
				Color{'C', color.RGBA{0xbe, 0xba, 0xda, 0xff}},
				Color{'D', color.RGBA{0xfb, 0x80, 0x72, 0xff}},
				Color{'E', color.RGBA{0x80, 0xb1, 0xd3, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb4, 0x62, 0xff}},
				Color{'G', color.RGBA{0xb3, 0xde, 0x69, 0xff}},
				Color{'H', color.RGBA{0xfc, 0xcd, 0xe5, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "Set3",
			Name:       "Set 3",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8d, 0xd3, 0xc7, 0xff}},
				Color{'B', color.RGBA{0xff, 0xff, 0xb3, 0xff}},
				Color{'C', color.RGBA{0xbe, 0xba, 0xda, 0xff}},
				Color{'D', color.RGBA{0xfb, 0x80, 0x72, 0xff}},
				Color{'E', color.RGBA{0x80, 0xb1, 0xd3, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb4, 0x62, 0xff}},
				Color{'G', color.RGBA{0xb3, 0xde, 0x69, 0xff}},
				Color{'H', color.RGBA{0xfc, 0xcd, 0xe5, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xd9, 0xd9, 0xff}},
			},
		},
		10: NonDivergingPalette{
			ID:         "Set3",
			Name:       "Set 3",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8d, 0xd3, 0xc7, 0xff}},
				Color{'B', color.RGBA{0xff, 0xff, 0xb3, 0xff}},
				Color{'C', color.RGBA{0xbe, 0xba, 0xda, 0xff}},
				Color{'D', color.RGBA{0xfb, 0x80, 0x72, 0xff}},
				Color{'E', color.RGBA{0x80, 0xb1, 0xd3, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb4, 0x62, 0xff}},
				Color{'G', color.RGBA{0xb3, 0xde, 0x69, 0xff}},
				Color{'H', color.RGBA{0xfc, 0xcd, 0xe5, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xd9, 0xd9, 0xff}},
				Color{'J', color.RGBA{0xbc, 0x80, 0xbd, 0xff}},
			},
		},
		11: NonDivergingPalette{
			ID:         "Set3",
			Name:       "Set 3",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8d, 0xd3, 0xc7, 0xff}},
				Color{'B', color.RGBA{0xff, 0xff, 0xb3, 0xff}},
				Color{'C', color.RGBA{0xbe, 0xba, 0xda, 0xff}},
				Color{'D', color.RGBA{0xfb, 0x80, 0x72, 0xff}},
				Color{'E', color.RGBA{0x80, 0xb1, 0xd3, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb4, 0x62, 0xff}},
				Color{'G', color.RGBA{0xb3, 0xde, 0x69, 0xff}},
				Color{'H', color.RGBA{0xfc, 0xcd, 0xe5, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xd9, 0xd9, 0xff}},
				Color{'J', color.RGBA{0xbc, 0x80, 0xbd, 0xff}},
				Color{'K', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
			},
		},
		12: NonDivergingPalette{
			ID:         "Set3",
			Name:       "Set 3",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Bad,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0x8d, 0xd3, 0xc7, 0xff}},
				Color{'B', color.RGBA{0xff, 0xff, 0xb3, 0xff}},
				Color{'C', color.RGBA{0xbe, 0xba, 0xda, 0xff}},
				Color{'D', color.RGBA{0xfb, 0x80, 0x72, 0xff}},
				Color{'E', color.RGBA{0x80, 0xb1, 0xd3, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xb4, 0x62, 0xff}},
				Color{'G', color.RGBA{0xb3, 0xde, 0x69, 0xff}},
				Color{'H', color.RGBA{0xfc, 0xcd, 0xe5, 0xff}},
				Color{'I', color.RGBA{0xd9, 0xd9, 0xd9, 0xff}},
				Color{'J', color.RGBA{0xbc, 0x80, 0xbd, 0xff}},
				Color{'K', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'L', color.RGBA{0xff, 0xed, 0x6f, 0xff}},
			},
		},
	}
)
var (
	Blues = Sequential{
		3: NonDivergingPalette{
			ID:         "Blues",
			Name:       "Blues",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'C', color.RGBA{0xde, 0xeb, 0xf7, 0xff}},
				Color{'F', color.RGBA{0x9e, 0xca, 0xe1, 0xff}},
				Color{'I', color.RGBA{0x31, 0x82, 0xbd, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Blues",
			Name:       "Blues",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xef, 0xf3, 0xff, 0xff}},
				Color{'E', color.RGBA{0xbd, 0xd7, 0xe7, 0xff}},
				Color{'G', color.RGBA{0x6b, 0xae, 0xd6, 0xff}},
				Color{'J', color.RGBA{0x21, 0x71, 0xb5, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Blues",
			Name:       "Blues",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xef, 0xf3, 0xff, 0xff}},
				Color{'E', color.RGBA{0xbd, 0xd7, 0xe7, 0xff}},
				Color{'G', color.RGBA{0x6b, 0xae, 0xd6, 0xff}},
				Color{'I', color.RGBA{0x31, 0x82, 0xbd, 0xff}},
				Color{'K', color.RGBA{0x08, 0x51, 0x9c, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Blues",
			Name:       "Blues",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xef, 0xf3, 0xff, 0xff}},
				Color{'D', color.RGBA{0xc6, 0xdb, 0xef, 0xff}},
				Color{'F', color.RGBA{0x9e, 0xca, 0xe1, 0xff}},
				Color{'G', color.RGBA{0x6b, 0xae, 0xd6, 0xff}},
				Color{'I', color.RGBA{0x31, 0x82, 0xbd, 0xff}},
				Color{'K', color.RGBA{0x08, 0x51, 0x9c, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Blues",
			Name:       "Blues",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xef, 0xf3, 0xff, 0xff}},
				Color{'D', color.RGBA{0xc6, 0xdb, 0xef, 0xff}},
				Color{'F', color.RGBA{0x9e, 0xca, 0xe1, 0xff}},
				Color{'G', color.RGBA{0x6b, 0xae, 0xd6, 0xff}},
				Color{'H', color.RGBA{0x42, 0x92, 0xc6, 0xff}},
				Color{'J', color.RGBA{0x21, 0x71, 0xb5, 0xff}},
				Color{'L', color.RGBA{0x08, 0x45, 0x94, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Blues",
			Name:       "Blues",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xfb, 0xff, 0xff}},
				Color{'C', color.RGBA{0xde, 0xeb, 0xf7, 0xff}},
				Color{'D', color.RGBA{0xc6, 0xdb, 0xef, 0xff}},
				Color{'F', color.RGBA{0x9e, 0xca, 0xe1, 0xff}},
				Color{'G', color.RGBA{0x6b, 0xae, 0xd6, 0xff}},
				Color{'H', color.RGBA{0x42, 0x92, 0xc6, 0xff}},
				Color{'J', color.RGBA{0x21, 0x71, 0xb5, 0xff}},
				Color{'L', color.RGBA{0x08, 0x45, 0x94, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "Blues",
			Name:       "Blues",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xfb, 0xff, 0xff}},
				Color{'C', color.RGBA{0xde, 0xeb, 0xf7, 0xff}},
				Color{'D', color.RGBA{0xc6, 0xdb, 0xef, 0xff}},
				Color{'F', color.RGBA{0x9e, 0xca, 0xe1, 0xff}},
				Color{'G', color.RGBA{0x6b, 0xae, 0xd6, 0xff}},
				Color{'H', color.RGBA{0x42, 0x92, 0xc6, 0xff}},
				Color{'J', color.RGBA{0x21, 0x71, 0xb5, 0xff}},
				Color{'K', color.RGBA{0x08, 0x51, 0x9c, 0xff}},
				Color{'M', color.RGBA{0x08, 0x30, 0x6b, 0xff}},
			},
		},
	}
	BuGn = Sequential{
		3: NonDivergingPalette{
			ID:         "BuGn",
			Name:       "Blue-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'C', color.RGBA{0xe5, 0xf5, 0xf9, 0xff}},
				Color{'F', color.RGBA{0x99, 0xd8, 0xc9, 0xff}},
				Color{'I', color.RGBA{0x2c, 0xa2, 0x5f, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "BuGn",
			Name:       "Blue-Green",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xfb, 0xff}},
				Color{'E', color.RGBA{0xb2, 0xe2, 0xe2, 0xff}},
				Color{'G', color.RGBA{0x66, 0xc2, 0xa4, 0xff}},
				Color{'J', color.RGBA{0x23, 0x8b, 0x45, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "BuGn",
			Name:       "Blue-Green",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xfb, 0xff}},
				Color{'E', color.RGBA{0xb2, 0xe2, 0xe2, 0xff}},
				Color{'G', color.RGBA{0x66, 0xc2, 0xa4, 0xff}},
				Color{'I', color.RGBA{0x2c, 0xa2, 0x5f, 0xff}},
				Color{'K', color.RGBA{0x00, 0x6d, 0x2c, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "BuGn",
			Name:       "Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xfb, 0xff}},
				Color{'D', color.RGBA{0xcc, 0xec, 0xe6, 0xff}},
				Color{'F', color.RGBA{0x99, 0xd8, 0xc9, 0xff}},
				Color{'G', color.RGBA{0x66, 0xc2, 0xa4, 0xff}},
				Color{'I', color.RGBA{0x2c, 0xa2, 0x5f, 0xff}},
				Color{'K', color.RGBA{0x00, 0x6d, 0x2c, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "BuGn",
			Name:       "Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xfb, 0xff}},
				Color{'D', color.RGBA{0xcc, 0xec, 0xe6, 0xff}},
				Color{'F', color.RGBA{0x99, 0xd8, 0xc9, 0xff}},
				Color{'G', color.RGBA{0x66, 0xc2, 0xa4, 0xff}},
				Color{'H', color.RGBA{0x41, 0xae, 0x76, 0xff}},
				Color{'J', color.RGBA{0x23, 0x8b, 0x45, 0xff}},
				Color{'L', color.RGBA{0x00, 0x58, 0x24, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "BuGn",
			Name:       "Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xfc, 0xfd, 0xff}},
				Color{'C', color.RGBA{0xe5, 0xf5, 0xf9, 0xff}},
				Color{'D', color.RGBA{0xcc, 0xec, 0xe6, 0xff}},
				Color{'F', color.RGBA{0x99, 0xd8, 0xc9, 0xff}},
				Color{'G', color.RGBA{0x66, 0xc2, 0xa4, 0xff}},
				Color{'H', color.RGBA{0x41, 0xae, 0x76, 0xff}},
				Color{'J', color.RGBA{0x23, 0x8b, 0x45, 0xff}},
				Color{'L', color.RGBA{0x00, 0x58, 0x24, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "BuGn",
			Name:       "Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xfc, 0xfd, 0xff}},
				Color{'C', color.RGBA{0xe5, 0xf5, 0xf9, 0xff}},
				Color{'D', color.RGBA{0xcc, 0xec, 0xe6, 0xff}},
				Color{'F', color.RGBA{0x99, 0xd8, 0xc9, 0xff}},
				Color{'G', color.RGBA{0x66, 0xc2, 0xa4, 0xff}},
				Color{'H', color.RGBA{0x41, 0xae, 0x76, 0xff}},
				Color{'J', color.RGBA{0x23, 0x8b, 0x45, 0xff}},
				Color{'K', color.RGBA{0x00, 0x6d, 0x2c, 0xff}},
				Color{'M', color.RGBA{0x00, 0x44, 0x1b, 0xff}},
			},
		},
	}
	BuPu = Sequential{
		3: NonDivergingPalette{
			ID:         "BuPu",
			Name:       "Blue-Purple",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xe0, 0xec, 0xf4, 0xff}},
				Color{'F', color.RGBA{0x9e, 0xbc, 0xda, 0xff}},
				Color{'I', color.RGBA{0x88, 0x56, 0xa7, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "BuPu",
			Name:       "Blue-Purple",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xfb, 0xff}},
				Color{'E', color.RGBA{0xb3, 0xcd, 0xe3, 0xff}},
				Color{'G', color.RGBA{0x8c, 0x96, 0xc6, 0xff}},
				Color{'J', color.RGBA{0x88, 0x41, 0x9d, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "BuPu",
			Name:       "Blue-Purple",
			Laptop:     Good,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xfb, 0xff}},
				Color{'E', color.RGBA{0xb3, 0xcd, 0xe3, 0xff}},
				Color{'G', color.RGBA{0x8c, 0x96, 0xc6, 0xff}},
				Color{'I', color.RGBA{0x88, 0x56, 0xa7, 0xff}},
				Color{'K', color.RGBA{0x81, 0x0f, 0x7c, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "BuPu",
			Name:       "Blue-Purple",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xfb, 0xff}},
				Color{'D', color.RGBA{0xbf, 0xd3, 0xe6, 0xff}},
				Color{'F', color.RGBA{0x9e, 0xbc, 0xda, 0xff}},
				Color{'G', color.RGBA{0x8c, 0x96, 0xc6, 0xff}},
				Color{'I', color.RGBA{0x88, 0x56, 0xa7, 0xff}},
				Color{'K', color.RGBA{0x81, 0x0f, 0x7c, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "BuPu",
			Name:       "Blue-Purple",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xfb, 0xff}},
				Color{'D', color.RGBA{0xbf, 0xd3, 0xe6, 0xff}},
				Color{'F', color.RGBA{0x9e, 0xbc, 0xda, 0xff}},
				Color{'G', color.RGBA{0x8c, 0x96, 0xc6, 0xff}},
				Color{'H', color.RGBA{0x8c, 0x6b, 0xb1, 0xff}},
				Color{'J', color.RGBA{0x88, 0x41, 0x9d, 0xff}},
				Color{'L', color.RGBA{0x6e, 0x01, 0x6b, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "BuPu",
			Name:       "Blue-Purple",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xfc, 0xfd, 0xff}},
				Color{'C', color.RGBA{0xe0, 0xec, 0xf4, 0xff}},
				Color{'D', color.RGBA{0xbf, 0xd3, 0xe6, 0xff}},
				Color{'F', color.RGBA{0x9e, 0xbc, 0xda, 0xff}},
				Color{'G', color.RGBA{0x8c, 0x96, 0xc6, 0xff}},
				Color{'H', color.RGBA{0x8c, 0x6b, 0xb1, 0xff}},
				Color{'J', color.RGBA{0x88, 0x41, 0x9d, 0xff}},
				Color{'L', color.RGBA{0x6e, 0x01, 0x6b, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "BuPu",
			Name:       "Blue-Purple",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xfc, 0xfd, 0xff}},
				Color{'C', color.RGBA{0xe0, 0xec, 0xf4, 0xff}},
				Color{'D', color.RGBA{0xbf, 0xd3, 0xe6, 0xff}},
				Color{'F', color.RGBA{0x9e, 0xbc, 0xda, 0xff}},
				Color{'G', color.RGBA{0x8c, 0x96, 0xc6, 0xff}},
				Color{'H', color.RGBA{0x8c, 0x6b, 0xb1, 0xff}},
				Color{'J', color.RGBA{0x88, 0x41, 0x9d, 0xff}},
				Color{'K', color.RGBA{0x81, 0x0f, 0x7c, 0xff}},
				Color{'M', color.RGBA{0x4d, 0x00, 0x4b, 0xff}},
			},
		},
	}
	GnBu = Sequential{
		3: NonDivergingPalette{
			ID:         "GnBu",
			Name:       "Green-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xe0, 0xf3, 0xdb, 0xff}},
				Color{'F', color.RGBA{0xa8, 0xdd, 0xb5, 0xff}},
				Color{'I', color.RGBA{0x43, 0xa2, 0xca, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "GnBu",
			Name:       "Green-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Good,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf0, 0xf9, 0xe8, 0xff}},
				Color{'E', color.RGBA{0xba, 0xe4, 0xbc, 0xff}},
				Color{'G', color.RGBA{0x7b, 0xcc, 0xc4, 0xff}},
				Color{'J', color.RGBA{0x2b, 0x8c, 0xbe, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "GnBu",
			Name:       "Green-Blue",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf0, 0xf9, 0xe8, 0xff}},
				Color{'E', color.RGBA{0xba, 0xe4, 0xbc, 0xff}},
				Color{'G', color.RGBA{0x7b, 0xcc, 0xc4, 0xff}},
				Color{'I', color.RGBA{0x43, 0xa2, 0xca, 0xff}},
				Color{'K', color.RGBA{0x08, 0x68, 0xac, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "GnBu",
			Name:       "Green-Blue",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf0, 0xf9, 0xe8, 0xff}},
				Color{'D', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'F', color.RGBA{0xa8, 0xdd, 0xb5, 0xff}},
				Color{'G', color.RGBA{0x7b, 0xcc, 0xc4, 0xff}},
				Color{'I', color.RGBA{0x43, 0xa2, 0xca, 0xff}},
				Color{'K', color.RGBA{0x08, 0x68, 0xac, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "GnBu",
			Name:       "Green-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf0, 0xf9, 0xe8, 0xff}},
				Color{'D', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'F', color.RGBA{0xa8, 0xdd, 0xb5, 0xff}},
				Color{'G', color.RGBA{0x7b, 0xcc, 0xc4, 0xff}},
				Color{'H', color.RGBA{0x4e, 0xb3, 0xd3, 0xff}},
				Color{'J', color.RGBA{0x2b, 0x8c, 0xbe, 0xff}},
				Color{'L', color.RGBA{0x08, 0x58, 0x9e, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "GnBu",
			Name:       "Green-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xfc, 0xf0, 0xff}},
				Color{'C', color.RGBA{0xe0, 0xf3, 0xdb, 0xff}},
				Color{'D', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'F', color.RGBA{0xa8, 0xdd, 0xb5, 0xff}},
				Color{'G', color.RGBA{0x7b, 0xcc, 0xc4, 0xff}},
				Color{'H', color.RGBA{0x4e, 0xb3, 0xd3, 0xff}},
				Color{'J', color.RGBA{0x2b, 0x8c, 0xbe, 0xff}},
				Color{'L', color.RGBA{0x08, 0x58, 0x9e, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "GnBu",
			Name:       "Green-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xfc, 0xf0, 0xff}},
				Color{'C', color.RGBA{0xe0, 0xf3, 0xdb, 0xff}},
				Color{'D', color.RGBA{0xcc, 0xeb, 0xc5, 0xff}},
				Color{'F', color.RGBA{0xa8, 0xdd, 0xb5, 0xff}},
				Color{'G', color.RGBA{0x7b, 0xcc, 0xc4, 0xff}},
				Color{'H', color.RGBA{0x4e, 0xb3, 0xd3, 0xff}},
				Color{'J', color.RGBA{0x2b, 0x8c, 0xbe, 0xff}},
				Color{'K', color.RGBA{0x08, 0x68, 0xac, 0xff}},
				Color{'M', color.RGBA{0x08, 0x40, 0x81, 0xff}},
			},
		},
	}
	Greens = Sequential{
		3: NonDivergingPalette{
			ID:         "Greens",
			Name:       "Greens",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'C', color.RGBA{0xe5, 0xf5, 0xe0, 0xff}},
				Color{'F', color.RGBA{0xa1, 0xd9, 0x9b, 0xff}},
				Color{'I', color.RGBA{0x31, 0xa3, 0x54, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Greens",
			Name:       "Greens",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xe9, 0xff}},
				Color{'E', color.RGBA{0xba, 0xe4, 0xb3, 0xff}},
				Color{'G', color.RGBA{0x74, 0xc4, 0x76, 0xff}},
				Color{'J', color.RGBA{0x23, 0x8b, 0x45, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Greens",
			Name:       "Greens",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xe9, 0xff}},
				Color{'E', color.RGBA{0xba, 0xe4, 0xb3, 0xff}},
				Color{'G', color.RGBA{0x74, 0xc4, 0x76, 0xff}},
				Color{'I', color.RGBA{0x31, 0xa3, 0x54, 0xff}},
				Color{'K', color.RGBA{0x00, 0x6d, 0x2c, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Greens",
			Name:       "Greens",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xe9, 0xff}},
				Color{'D', color.RGBA{0xc7, 0xe9, 0xc0, 0xff}},
				Color{'F', color.RGBA{0xa1, 0xd9, 0x9b, 0xff}},
				Color{'G', color.RGBA{0x74, 0xc4, 0x76, 0xff}},
				Color{'I', color.RGBA{0x31, 0xa3, 0x54, 0xff}},
				Color{'K', color.RGBA{0x00, 0x6d, 0x2c, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Greens",
			Name:       "Greens",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xed, 0xf8, 0xe9, 0xff}},
				Color{'D', color.RGBA{0xc7, 0xe9, 0xc0, 0xff}},
				Color{'F', color.RGBA{0xa1, 0xd9, 0x9b, 0xff}},
				Color{'G', color.RGBA{0x74, 0xc4, 0x76, 0xff}},
				Color{'H', color.RGBA{0x41, 0xab, 0x5d, 0xff}},
				Color{'J', color.RGBA{0x23, 0x8b, 0x45, 0xff}},
				Color{'L', color.RGBA{0x00, 0x5a, 0x32, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Greens",
			Name:       "Greens",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xfc, 0xf5, 0xff}},
				Color{'C', color.RGBA{0xe5, 0xf5, 0xe0, 0xff}},
				Color{'D', color.RGBA{0xc7, 0xe9, 0xc0, 0xff}},
				Color{'F', color.RGBA{0xa1, 0xd9, 0x9b, 0xff}},
				Color{'G', color.RGBA{0x74, 0xc4, 0x76, 0xff}},
				Color{'H', color.RGBA{0x41, 0xab, 0x5d, 0xff}},
				Color{'J', color.RGBA{0x23, 0x8b, 0x45, 0xff}},
				Color{'L', color.RGBA{0x00, 0x5a, 0x32, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "Greens",
			Name:       "Greens",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xfc, 0xf5, 0xff}},
				Color{'C', color.RGBA{0xe5, 0xf5, 0xe0, 0xff}},
				Color{'D', color.RGBA{0xc7, 0xe9, 0xc0, 0xff}},
				Color{'F', color.RGBA{0xa1, 0xd9, 0x9b, 0xff}},
				Color{'G', color.RGBA{0x74, 0xc4, 0x76, 0xff}},
				Color{'H', color.RGBA{0x41, 0xab, 0x5d, 0xff}},
				Color{'J', color.RGBA{0x23, 0x8b, 0x45, 0xff}},
				Color{'K', color.RGBA{0x00, 0x6d, 0x2c, 0xff}},
				Color{'M', color.RGBA{0x00, 0x44, 0x1b, 0xff}},
			},
		},
	}
	Greys = Sequential{
		3: NonDivergingPalette{
			ID:         "Greys",
			Name:       "Greys",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'C', color.RGBA{0xf0, 0xf0, 0xf0, 0xff}},
				Color{'F', color.RGBA{0xbd, 0xbd, 0xbd, 0xff}},
				Color{'I', color.RGBA{0x63, 0x63, 0x63, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Greys",
			Name:       "Greys",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'E', color.RGBA{0xcc, 0xcc, 0xcc, 0xff}},
				Color{'G', color.RGBA{0x96, 0x96, 0x96, 0xff}},
				Color{'J', color.RGBA{0x52, 0x52, 0x52, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Greys",
			Name:       "Greys",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'E', color.RGBA{0xcc, 0xcc, 0xcc, 0xff}},
				Color{'G', color.RGBA{0x96, 0x96, 0x96, 0xff}},
				Color{'I', color.RGBA{0x63, 0x63, 0x63, 0xff}},
				Color{'K', color.RGBA{0x25, 0x25, 0x25, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Greys",
			Name:       "Greys",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'D', color.RGBA{0xd9, 0xd9, 0xd9, 0xff}},
				Color{'F', color.RGBA{0xbd, 0xbd, 0xbd, 0xff}},
				Color{'G', color.RGBA{0x96, 0x96, 0x96, 0xff}},
				Color{'I', color.RGBA{0x63, 0x63, 0x63, 0xff}},
				Color{'K', color.RGBA{0x25, 0x25, 0x25, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Greys",
			Name:       "Greys",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf7, 0xf7, 0xf7, 0xff}},
				Color{'D', color.RGBA{0xd9, 0xd9, 0xd9, 0xff}},
				Color{'F', color.RGBA{0xbd, 0xbd, 0xbd, 0xff}},
				Color{'G', color.RGBA{0x96, 0x96, 0x96, 0xff}},
				Color{'H', color.RGBA{0x73, 0x73, 0x73, 0xff}},
				Color{'J', color.RGBA{0x52, 0x52, 0x52, 0xff}},
				Color{'L', color.RGBA{0x25, 0x25, 0x25, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Greys",
			Name:       "Greys",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xff, 0xff, 0xff}},
				Color{'C', color.RGBA{0xf0, 0xf0, 0xf0, 0xff}},
				Color{'D', color.RGBA{0xd9, 0xd9, 0xd9, 0xff}},
				Color{'F', color.RGBA{0xbd, 0xbd, 0xbd, 0xff}},
				Color{'G', color.RGBA{0x96, 0x96, 0x96, 0xff}},
				Color{'H', color.RGBA{0x73, 0x73, 0x73, 0xff}},
				Color{'J', color.RGBA{0x52, 0x52, 0x52, 0xff}},
				Color{'L', color.RGBA{0x25, 0x25, 0x25, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "Greys",
			Name:       "Greys",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xff, 0xff, 0xff}},
				Color{'C', color.RGBA{0xf0, 0xf0, 0xf0, 0xff}},
				Color{'D', color.RGBA{0xd9, 0xd9, 0xd9, 0xff}},
				Color{'F', color.RGBA{0xbd, 0xbd, 0xbd, 0xff}},
				Color{'G', color.RGBA{0x96, 0x96, 0x96, 0xff}},
				Color{'H', color.RGBA{0x73, 0x73, 0x73, 0xff}},
				Color{'J', color.RGBA{0x52, 0x52, 0x52, 0xff}},
				Color{'K', color.RGBA{0x25, 0x25, 0x25, 0xff}},
				Color{'M', color.RGBA{0x00, 0x00, 0x00, 0xff}},
			},
		},
	}
	Oranges = Sequential{
		3: NonDivergingPalette{
			ID:         "Oranges",
			Name:       "Oranges",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'C', color.RGBA{0xfe, 0xe6, 0xce, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x6b, 0xff}},
				Color{'I', color.RGBA{0xe6, 0x55, 0x0d, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Oranges",
			Name:       "Oranges",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xed, 0xde, 0xff}},
				Color{'E', color.RGBA{0xfd, 0xbe, 0x85, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'J', color.RGBA{0xd9, 0x47, 0x01, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Oranges",
			Name:       "Oranges",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xed, 0xde, 0xff}},
				Color{'E', color.RGBA{0xfd, 0xbe, 0x85, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'I', color.RGBA{0xe6, 0x55, 0x0d, 0xff}},
				Color{'K', color.RGBA{0xa6, 0x36, 0x03, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Oranges",
			Name:       "Oranges",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xed, 0xde, 0xff}},
				Color{'D', color.RGBA{0xfd, 0xd0, 0xa2, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x6b, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'I', color.RGBA{0xe6, 0x55, 0x0d, 0xff}},
				Color{'K', color.RGBA{0xa6, 0x36, 0x03, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Oranges",
			Name:       "Oranges",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xed, 0xde, 0xff}},
				Color{'D', color.RGBA{0xfd, 0xd0, 0xa2, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x6b, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'H', color.RGBA{0xf1, 0x69, 0x13, 0xff}},
				Color{'J', color.RGBA{0xd9, 0x48, 0x01, 0xff}},
				Color{'L', color.RGBA{0x8c, 0x2d, 0x04, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Oranges",
			Name:       "Oranges",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf5, 0xeb, 0xff}},
				Color{'C', color.RGBA{0xfe, 0xe6, 0xce, 0xff}},
				Color{'D', color.RGBA{0xfd, 0xd0, 0xa2, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x6b, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'H', color.RGBA{0xf1, 0x69, 0x13, 0xff}},
				Color{'J', color.RGBA{0xd9, 0x48, 0x01, 0xff}},
				Color{'L', color.RGBA{0x8c, 0x2d, 0x04, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "Oranges",
			Name:       "Oranges",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf5, 0xeb, 0xff}},
				Color{'C', color.RGBA{0xfe, 0xe6, 0xce, 0xff}},
				Color{'D', color.RGBA{0xfd, 0xd0, 0xa2, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xae, 0x6b, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'H', color.RGBA{0xf1, 0x69, 0x13, 0xff}},
				Color{'J', color.RGBA{0xd9, 0x48, 0x01, 0xff}},
				Color{'K', color.RGBA{0xa6, 0x36, 0x03, 0xff}},
				Color{'M', color.RGBA{0x7f, 0x27, 0x04, 0xff}},
			},
		},
	}
	OrRd = Sequential{
		3: NonDivergingPalette{
			ID:         "OrRd",
			Name:       "Orange-Red",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xfe, 0xe8, 0xc8, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xbb, 0x84, 0xff}},
				Color{'I', color.RGBA{0xe3, 0x4a, 0x33, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "OrRd",
			Name:       "Orange-Red",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xf0, 0xd9, 0xff}},
				Color{'E', color.RGBA{0xfd, 0xcc, 0x8a, 0xff}},
				Color{'G', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'J', color.RGBA{0xd7, 0x30, 0x1f, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "OrRd",
			Name:       "Orange-Red",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xf0, 0xd9, 0xff}},
				Color{'E', color.RGBA{0xfd, 0xcc, 0x8a, 0xff}},
				Color{'G', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'I', color.RGBA{0xe3, 0x4a, 0x33, 0xff}},
				Color{'K', color.RGBA{0xb3, 0x00, 0x00, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "OrRd",
			Name:       "Orange-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xf0, 0xd9, 0xff}},
				Color{'D', color.RGBA{0xfd, 0xd4, 0x9e, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xbb, 0x84, 0xff}},
				Color{'G', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'I', color.RGBA{0xe3, 0x4a, 0x33, 0xff}},
				Color{'K', color.RGBA{0xb3, 0x00, 0x00, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "OrRd",
			Name:       "Orange-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xf0, 0xd9, 0xff}},
				Color{'D', color.RGBA{0xfd, 0xd4, 0x9e, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xbb, 0x84, 0xff}},
				Color{'G', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'H', color.RGBA{0xef, 0x65, 0x48, 0xff}},
				Color{'J', color.RGBA{0xd7, 0x30, 0x1f, 0xff}},
				Color{'L', color.RGBA{0x99, 0x00, 0x00, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "OrRd",
			Name:       "Orange-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf7, 0xec, 0xff}},
				Color{'C', color.RGBA{0xfe, 0xe8, 0xc8, 0xff}},
				Color{'D', color.RGBA{0xfd, 0xd4, 0x9e, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xbb, 0x84, 0xff}},
				Color{'G', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'H', color.RGBA{0xef, 0x65, 0x48, 0xff}},
				Color{'J', color.RGBA{0xd7, 0x30, 0x1f, 0xff}},
				Color{'L', color.RGBA{0x99, 0x00, 0x00, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "OrRd",
			Name:       "Orange-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf7, 0xec, 0xff}},
				Color{'C', color.RGBA{0xfe, 0xe8, 0xc8, 0xff}},
				Color{'D', color.RGBA{0xfd, 0xd4, 0x9e, 0xff}},
				Color{'F', color.RGBA{0xfd, 0xbb, 0x84, 0xff}},
				Color{'G', color.RGBA{0xfc, 0x8d, 0x59, 0xff}},
				Color{'H', color.RGBA{0xef, 0x65, 0x48, 0xff}},
				Color{'J', color.RGBA{0xd7, 0x30, 0x1f, 0xff}},
				Color{'K', color.RGBA{0xb3, 0x00, 0x00, 0xff}},
				Color{'M', color.RGBA{0x7f, 0x00, 0x00, 0xff}},
			},
		},
	}
	PuBu = Sequential{
		3: NonDivergingPalette{
			ID:         "PuBu",
			Name:       "Purple-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xec, 0xe7, 0xf2, 0xff}},
				Color{'F', color.RGBA{0xa6, 0xbd, 0xdb, 0xff}},
				Color{'I', color.RGBA{0x2b, 0x8c, 0xbe, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "PuBu",
			Name:       "Purple-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf1, 0xee, 0xf6, 0xff}},
				Color{'E', color.RGBA{0xbd, 0xc9, 0xe1, 0xff}},
				Color{'G', color.RGBA{0x74, 0xa9, 0xcf, 0xff}},
				Color{'J', color.RGBA{0x05, 0x70, 0xb0, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "PuBu",
			Name:       "Purple-Blue",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf1, 0xee, 0xf6, 0xff}},
				Color{'E', color.RGBA{0xbd, 0xc9, 0xe1, 0xff}},
				Color{'G', color.RGBA{0x74, 0xa9, 0xcf, 0xff}},
				Color{'I', color.RGBA{0x2b, 0x8c, 0xbe, 0xff}},
				Color{'K', color.RGBA{0x04, 0x5a, 0x8d, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "PuBu",
			Name:       "Purple-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf1, 0xee, 0xf6, 0xff}},
				Color{'D', color.RGBA{0xd0, 0xd1, 0xe6, 0xff}},
				Color{'F', color.RGBA{0xa6, 0xbd, 0xdb, 0xff}},
				Color{'G', color.RGBA{0x74, 0xa9, 0xcf, 0xff}},
				Color{'I', color.RGBA{0x2b, 0x8c, 0xbe, 0xff}},
				Color{'K', color.RGBA{0x04, 0x5a, 0x8d, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "PuBu",
			Name:       "Purple-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf1, 0xee, 0xf6, 0xff}},
				Color{'D', color.RGBA{0xd0, 0xd1, 0xe6, 0xff}},
				Color{'F', color.RGBA{0xa6, 0xbd, 0xdb, 0xff}},
				Color{'G', color.RGBA{0x74, 0xa9, 0xcf, 0xff}},
				Color{'H', color.RGBA{0x36, 0x90, 0xc0, 0xff}},
				Color{'J', color.RGBA{0x05, 0x70, 0xb0, 0xff}},
				Color{'L', color.RGBA{0x03, 0x4e, 0x7b, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "PuBu",
			Name:       "Purple-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf7, 0xfb, 0xff}},
				Color{'C', color.RGBA{0xec, 0xe7, 0xf2, 0xff}},
				Color{'D', color.RGBA{0xd0, 0xd1, 0xe6, 0xff}},
				Color{'F', color.RGBA{0xa6, 0xbd, 0xdb, 0xff}},
				Color{'G', color.RGBA{0x74, 0xa9, 0xcf, 0xff}},
				Color{'H', color.RGBA{0x36, 0x90, 0xc0, 0xff}},
				Color{'J', color.RGBA{0x05, 0x70, 0xb0, 0xff}},
				Color{'L', color.RGBA{0x03, 0x4e, 0x7b, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "PuBu",
			Name:       "Purple-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf7, 0xfb, 0xff}},
				Color{'C', color.RGBA{0xec, 0xe7, 0xf2, 0xff}},
				Color{'D', color.RGBA{0xd0, 0xd1, 0xe6, 0xff}},
				Color{'F', color.RGBA{0xa6, 0xbd, 0xdb, 0xff}},
				Color{'G', color.RGBA{0x74, 0xa9, 0xcf, 0xff}},
				Color{'H', color.RGBA{0x36, 0x90, 0xc0, 0xff}},
				Color{'J', color.RGBA{0x05, 0x70, 0xb0, 0xff}},
				Color{'K', color.RGBA{0x04, 0x5a, 0x8d, 0xff}},
				Color{'M', color.RGBA{0x02, 0x38, 0x58, 0xff}},
			},
		},
	}
	PuBuGn = Sequential{
		3: NonDivergingPalette{
			ID:         "PuBuGn",
			Name:       "Purple-Blue-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xec, 0xe2, 0xf0, 0xff}},
				Color{'F', color.RGBA{0xa6, 0xbd, 0xdb, 0xff}},
				Color{'I', color.RGBA{0x1c, 0x90, 0x99, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "PuBuGn",
			Name:       "Purple-Blue-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf6, 0xef, 0xf7, 0xff}},
				Color{'E', color.RGBA{0xbd, 0xc9, 0xe1, 0xff}},
				Color{'G', color.RGBA{0x67, 0xa9, 0xcf, 0xff}},
				Color{'J', color.RGBA{0x02, 0x81, 0x8a, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "PuBuGn",
			Name:       "Purple-Blue-Green",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf6, 0xef, 0xf7, 0xff}},
				Color{'E', color.RGBA{0xbd, 0xc9, 0xe1, 0xff}},
				Color{'G', color.RGBA{0x67, 0xa9, 0xcf, 0xff}},
				Color{'I', color.RGBA{0x1c, 0x90, 0x99, 0xff}},
				Color{'K', color.RGBA{0x01, 0x6c, 0x59, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "PuBuGn",
			Name:       "Purple-Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf6, 0xef, 0xf7, 0xff}},
				Color{'D', color.RGBA{0xd0, 0xd1, 0xe6, 0xff}},
				Color{'F', color.RGBA{0xa6, 0xbd, 0xdb, 0xff}},
				Color{'G', color.RGBA{0x67, 0xa9, 0xcf, 0xff}},
				Color{'I', color.RGBA{0x1c, 0x90, 0x99, 0xff}},
				Color{'K', color.RGBA{0x01, 0x6c, 0x59, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "PuBuGn",
			Name:       "Purple-Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf6, 0xef, 0xf7, 0xff}},
				Color{'D', color.RGBA{0xd0, 0xd1, 0xe6, 0xff}},
				Color{'F', color.RGBA{0xa6, 0xbd, 0xdb, 0xff}},
				Color{'G', color.RGBA{0x67, 0xa9, 0xcf, 0xff}},
				Color{'H', color.RGBA{0x36, 0x90, 0xc0, 0xff}},
				Color{'J', color.RGBA{0x02, 0x81, 0x8a, 0xff}},
				Color{'L', color.RGBA{0x01, 0x64, 0x50, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "PuBuGn",
			Name:       "Purple-Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf7, 0xfb, 0xff}},
				Color{'C', color.RGBA{0xec, 0xe2, 0xf0, 0xff}},
				Color{'D', color.RGBA{0xd0, 0xd1, 0xe6, 0xff}},
				Color{'F', color.RGBA{0xa6, 0xbd, 0xdb, 0xff}},
				Color{'G', color.RGBA{0x67, 0xa9, 0xcf, 0xff}},
				Color{'H', color.RGBA{0x36, 0x90, 0xc0, 0xff}},
				Color{'J', color.RGBA{0x02, 0x81, 0x8a, 0xff}},
				Color{'L', color.RGBA{0x01, 0x64, 0x50, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "PuBuGn",
			Name:       "Purple-Blue-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf7, 0xfb, 0xff}},
				Color{'C', color.RGBA{0xec, 0xe2, 0xf0, 0xff}},
				Color{'D', color.RGBA{0xd0, 0xd1, 0xe6, 0xff}},
				Color{'F', color.RGBA{0xa6, 0xbd, 0xdb, 0xff}},
				Color{'G', color.RGBA{0x67, 0xa9, 0xcf, 0xff}},
				Color{'H', color.RGBA{0x36, 0x90, 0xc0, 0xff}},
				Color{'J', color.RGBA{0x02, 0x81, 0x8a, 0xff}},
				Color{'K', color.RGBA{0x01, 0x6c, 0x59, 0xff}},
				Color{'M', color.RGBA{0x01, 0x46, 0x36, 0xff}},
			},
		},
	}
	PuRd = Sequential{
		3: NonDivergingPalette{
			ID:         "PuRd",
			Name:       "Purple-Red",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xe7, 0xe1, 0xef, 0xff}},
				Color{'F', color.RGBA{0xc9, 0x94, 0xc7, 0xff}},
				Color{'I', color.RGBA{0xdd, 0x1c, 0x77, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "PuRd",
			Name:       "Purple-Red",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf1, 0xee, 0xf6, 0xff}},
				Color{'E', color.RGBA{0xd7, 0xb5, 0xd8, 0xff}},
				Color{'G', color.RGBA{0xdf, 0x65, 0xb0, 0xff}},
				Color{'J', color.RGBA{0xce, 0x12, 0x56, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "PuRd",
			Name:       "Purple-Red",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf1, 0xee, 0xf6, 0xff}},
				Color{'E', color.RGBA{0xd7, 0xb5, 0xd8, 0xff}},
				Color{'G', color.RGBA{0xdf, 0x65, 0xb0, 0xff}},
				Color{'I', color.RGBA{0xdd, 0x1c, 0x77, 0xff}},
				Color{'K', color.RGBA{0x98, 0x00, 0x43, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "PuRd",
			Name:       "Purple-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf1, 0xee, 0xf6, 0xff}},
				Color{'D', color.RGBA{0xd4, 0xb9, 0xda, 0xff}},
				Color{'F', color.RGBA{0xc9, 0x94, 0xc7, 0xff}},
				Color{'G', color.RGBA{0xdf, 0x65, 0xb0, 0xff}},
				Color{'I', color.RGBA{0xdd, 0x1c, 0x77, 0xff}},
				Color{'K', color.RGBA{0x98, 0x00, 0x43, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "PuRd",
			Name:       "Purple-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf1, 0xee, 0xf6, 0xff}},
				Color{'D', color.RGBA{0xd4, 0xb9, 0xda, 0xff}},
				Color{'F', color.RGBA{0xc9, 0x94, 0xc7, 0xff}},
				Color{'G', color.RGBA{0xdf, 0x65, 0xb0, 0xff}},
				Color{'H', color.RGBA{0xe7, 0x29, 0x8a, 0xff}},
				Color{'J', color.RGBA{0xce, 0x12, 0x56, 0xff}},
				Color{'L', color.RGBA{0x91, 0x00, 0x3f, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "PuRd",
			Name:       "Purple-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xf4, 0xf9, 0xff}},
				Color{'C', color.RGBA{0xe7, 0xe1, 0xef, 0xff}},
				Color{'D', color.RGBA{0xd4, 0xb9, 0xda, 0xff}},
				Color{'F', color.RGBA{0xc9, 0x94, 0xc7, 0xff}},
				Color{'G', color.RGBA{0xdf, 0x65, 0xb0, 0xff}},
				Color{'H', color.RGBA{0xe7, 0x29, 0x8a, 0xff}},
				Color{'J', color.RGBA{0xce, 0x12, 0x56, 0xff}},
				Color{'L', color.RGBA{0x91, 0x00, 0x3f, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "PuRd",
			Name:       "Purple-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xf7, 0xf4, 0xf9, 0xff}},
				Color{'C', color.RGBA{0xe7, 0xe1, 0xef, 0xff}},
				Color{'D', color.RGBA{0xd4, 0xb9, 0xda, 0xff}},
				Color{'F', color.RGBA{0xc9, 0x94, 0xc7, 0xff}},
				Color{'G', color.RGBA{0xdf, 0x65, 0xb0, 0xff}},
				Color{'H', color.RGBA{0xe7, 0x29, 0x8a, 0xff}},
				Color{'J', color.RGBA{0xce, 0x12, 0x56, 0xff}},
				Color{'K', color.RGBA{0x98, 0x00, 0x43, 0xff}},
				Color{'M', color.RGBA{0x67, 0x00, 0x1f, 0xff}},
			},
		},
	}
	Purples = Sequential{
		3: NonDivergingPalette{
			ID:         "Purples",
			Name:       "Purples",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'C', color.RGBA{0xef, 0xed, 0xf5, 0xff}},
				Color{'F', color.RGBA{0xbc, 0xbd, 0xdc, 0xff}},
				Color{'I', color.RGBA{0x75, 0x6b, 0xb1, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Purples",
			Name:       "Purples",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf2, 0xf0, 0xf7, 0xff}},
				Color{'E', color.RGBA{0xcb, 0xc9, 0xe2, 0xff}},
				Color{'G', color.RGBA{0x9e, 0x9a, 0xc8, 0xff}},
				Color{'J', color.RGBA{0x6a, 0x51, 0xa3, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Purples",
			Name:       "Purples",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf2, 0xf0, 0xf7, 0xff}},
				Color{'E', color.RGBA{0xcb, 0xc9, 0xe2, 0xff}},
				Color{'G', color.RGBA{0x9e, 0x9a, 0xc8, 0xff}},
				Color{'I', color.RGBA{0x75, 0x6b, 0xb1, 0xff}},
				Color{'K', color.RGBA{0x54, 0x27, 0x8f, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Purples",
			Name:       "Purples",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf2, 0xf0, 0xf7, 0xff}},
				Color{'D', color.RGBA{0xda, 0xda, 0xeb, 0xff}},
				Color{'F', color.RGBA{0xbc, 0xbd, 0xdc, 0xff}},
				Color{'G', color.RGBA{0x9e, 0x9a, 0xc8, 0xff}},
				Color{'I', color.RGBA{0x75, 0x6b, 0xb1, 0xff}},
				Color{'K', color.RGBA{0x54, 0x27, 0x8f, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Purples",
			Name:       "Purples",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xf2, 0xf0, 0xf7, 0xff}},
				Color{'D', color.RGBA{0xda, 0xda, 0xeb, 0xff}},
				Color{'F', color.RGBA{0xbc, 0xbd, 0xdc, 0xff}},
				Color{'G', color.RGBA{0x9e, 0x9a, 0xc8, 0xff}},
				Color{'H', color.RGBA{0x80, 0x7d, 0xba, 0xff}},
				Color{'J', color.RGBA{0x6a, 0x51, 0xa3, 0xff}},
				Color{'L', color.RGBA{0x4a, 0x14, 0x86, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Purples",
			Name:       "Purples",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xfc, 0xfb, 0xfd, 0xff}},
				Color{'C', color.RGBA{0xef, 0xed, 0xf5, 0xff}},
				Color{'D', color.RGBA{0xda, 0xda, 0xeb, 0xff}},
				Color{'F', color.RGBA{0xbc, 0xbd, 0xdc, 0xff}},
				Color{'G', color.RGBA{0x9e, 0x9a, 0xc8, 0xff}},
				Color{'H', color.RGBA{0x80, 0x7d, 0xba, 0xff}},
				Color{'J', color.RGBA{0x6a, 0x51, 0xa3, 0xff}},
				Color{'L', color.RGBA{0x4a, 0x14, 0x86, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "Purples",
			Name:       "Purples",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xfc, 0xfb, 0xfd, 0xff}},
				Color{'C', color.RGBA{0xef, 0xed, 0xf5, 0xff}},
				Color{'D', color.RGBA{0xda, 0xda, 0xeb, 0xff}},
				Color{'F', color.RGBA{0xbc, 0xbd, 0xdc, 0xff}},
				Color{'G', color.RGBA{0x9e, 0x9a, 0xc8, 0xff}},
				Color{'H', color.RGBA{0x80, 0x7d, 0xba, 0xff}},
				Color{'J', color.RGBA{0x6a, 0x51, 0xa3, 0xff}},
				Color{'K', color.RGBA{0x54, 0x27, 0x8f, 0xff}},
				Color{'M', color.RGBA{0x3f, 0x00, 0x7d, 0xff}},
			},
		},
	}
	RdPu = Sequential{
		3: NonDivergingPalette{
			ID:         "RdPu",
			Name:       "Red-Purple",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xfd, 0xe0, 0xdd, 0xff}},
				Color{'F', color.RGBA{0xfa, 0x9f, 0xb5, 0xff}},
				Color{'I', color.RGBA{0xc5, 0x1b, 0x8a, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "RdPu",
			Name:       "Red-Purple",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xeb, 0xe2, 0xff}},
				Color{'E', color.RGBA{0xfb, 0xb4, 0xb9, 0xff}},
				Color{'G', color.RGBA{0xf7, 0x68, 0xa1, 0xff}},
				Color{'J', color.RGBA{0xae, 0x01, 0x7e, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "RdPu",
			Name:       "Red-Purple",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xeb, 0xe2, 0xff}},
				Color{'E', color.RGBA{0xfb, 0xb4, 0xb9, 0xff}},
				Color{'G', color.RGBA{0xf7, 0x68, 0xa1, 0xff}},
				Color{'I', color.RGBA{0xc5, 0x1b, 0x8a, 0xff}},
				Color{'K', color.RGBA{0x7a, 0x01, 0x77, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "RdPu",
			Name:       "Red-Purple",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xeb, 0xe2, 0xff}},
				Color{'D', color.RGBA{0xfc, 0xc5, 0xc0, 0xff}},
				Color{'F', color.RGBA{0xfa, 0x9f, 0xb5, 0xff}},
				Color{'G', color.RGBA{0xf7, 0x68, 0xa1, 0xff}},
				Color{'I', color.RGBA{0xc5, 0x1b, 0x8a, 0xff}},
				Color{'K', color.RGBA{0x7a, 0x01, 0x77, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "RdPu",
			Name:       "Red-Purple",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xeb, 0xe2, 0xff}},
				Color{'D', color.RGBA{0xfc, 0xc5, 0xc0, 0xff}},
				Color{'F', color.RGBA{0xfa, 0x9f, 0xb5, 0xff}},
				Color{'G', color.RGBA{0xf7, 0x68, 0xa1, 0xff}},
				Color{'H', color.RGBA{0xdd, 0x34, 0x97, 0xff}},
				Color{'J', color.RGBA{0xae, 0x01, 0x7e, 0xff}},
				Color{'L', color.RGBA{0x7a, 0x01, 0x77, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "RdPu",
			Name:       "Red-Purple",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf7, 0xf3, 0xff}},
				Color{'C', color.RGBA{0xfd, 0xe0, 0xdd, 0xff}},
				Color{'D', color.RGBA{0xfc, 0xc5, 0xc0, 0xff}},
				Color{'F', color.RGBA{0xfa, 0x9f, 0xb5, 0xff}},
				Color{'G', color.RGBA{0xf7, 0x68, 0xa1, 0xff}},
				Color{'H', color.RGBA{0xdd, 0x34, 0x97, 0xff}},
				Color{'J', color.RGBA{0xae, 0x01, 0x7e, 0xff}},
				Color{'L', color.RGBA{0x7a, 0x01, 0x77, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "RdPu",
			Name:       "Red-Purple",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf7, 0xf3, 0xff}},
				Color{'C', color.RGBA{0xfd, 0xe0, 0xdd, 0xff}},
				Color{'D', color.RGBA{0xfc, 0xc5, 0xc0, 0xff}},
				Color{'F', color.RGBA{0xfa, 0x9f, 0xb5, 0xff}},
				Color{'G', color.RGBA{0xf7, 0x68, 0xa1, 0xff}},
				Color{'H', color.RGBA{0xdd, 0x34, 0x97, 0xff}},
				Color{'J', color.RGBA{0xae, 0x01, 0x7e, 0xff}},
				Color{'K', color.RGBA{0x7a, 0x01, 0x77, 0xff}},
				Color{'M', color.RGBA{0x49, 0x00, 0x6a, 0xff}},
			},
		},
	}
	Reds = Sequential{
		3: NonDivergingPalette{
			ID:         "Reds",
			Name:       "Reds",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xfe, 0xe0, 0xd2, 0xff}},
				Color{'F', color.RGBA{0xfc, 0x92, 0x72, 0xff}},
				Color{'I', color.RGBA{0xde, 0x2d, 0x26, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "Reds",
			Name:       "Reds",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Good,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xe5, 0xd9, 0xff}},
				Color{'E', color.RGBA{0xfc, 0xae, 0x91, 0xff}},
				Color{'G', color.RGBA{0xfb, 0x6a, 0x4a, 0xff}},
				Color{'J', color.RGBA{0xcb, 0x18, 0x1d, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "Reds",
			Name:       "Reds",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xe5, 0xd9, 0xff}},
				Color{'E', color.RGBA{0xfc, 0xae, 0x91, 0xff}},
				Color{'G', color.RGBA{0xfb, 0x6a, 0x4a, 0xff}},
				Color{'I', color.RGBA{0xde, 0x2d, 0x26, 0xff}},
				Color{'K', color.RGBA{0xa5, 0x0f, 0x15, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "Reds",
			Name:       "Reds",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xe5, 0xd9, 0xff}},
				Color{'D', color.RGBA{0xfc, 0xbb, 0xa1, 0xff}},
				Color{'F', color.RGBA{0xfc, 0x92, 0x72, 0xff}},
				Color{'G', color.RGBA{0xfb, 0x6a, 0x4a, 0xff}},
				Color{'I', color.RGBA{0xde, 0x2d, 0x26, 0xff}},
				Color{'K', color.RGBA{0xa5, 0x0f, 0x15, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "Reds",
			Name:       "Reds",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xfe, 0xe5, 0xd9, 0xff}},
				Color{'D', color.RGBA{0xfc, 0xbb, 0xa1, 0xff}},
				Color{'F', color.RGBA{0xfc, 0x92, 0x72, 0xff}},
				Color{'G', color.RGBA{0xfb, 0x6a, 0x4a, 0xff}},
				Color{'H', color.RGBA{0xef, 0x3b, 0x2c, 0xff}},
				Color{'J', color.RGBA{0xcb, 0x18, 0x1d, 0xff}},
				Color{'L', color.RGBA{0x99, 0x00, 0x0d, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "Reds",
			Name:       "Reds",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf5, 0xf0, 0xff}},
				Color{'C', color.RGBA{0xfe, 0xe0, 0xd2, 0xff}},
				Color{'D', color.RGBA{0xfc, 0xbb, 0xa1, 0xff}},
				Color{'F', color.RGBA{0xfc, 0x92, 0x72, 0xff}},
				Color{'G', color.RGBA{0xfb, 0x6a, 0x4a, 0xff}},
				Color{'H', color.RGBA{0xef, 0x3b, 0x2c, 0xff}},
				Color{'J', color.RGBA{0xcb, 0x18, 0x1d, 0xff}},
				Color{'L', color.RGBA{0x99, 0x00, 0x0d, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "Reds",
			Name:       "Reds",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xf5, 0xf0, 0xff}},
				Color{'C', color.RGBA{0xfe, 0xe0, 0xd2, 0xff}},
				Color{'D', color.RGBA{0xfc, 0xbb, 0xa1, 0xff}},
				Color{'F', color.RGBA{0xfc, 0x92, 0x72, 0xff}},
				Color{'G', color.RGBA{0xfb, 0x6a, 0x4a, 0xff}},
				Color{'H', color.RGBA{0xef, 0x3b, 0x2c, 0xff}},
				Color{'J', color.RGBA{0xcb, 0x18, 0x1d, 0xff}},
				Color{'K', color.RGBA{0xa5, 0x0f, 0x15, 0xff}},
				Color{'M', color.RGBA{0x67, 0x00, 0x0d, 0xff}},
			},
		},
	}
	YlGn = Sequential{
		3: NonDivergingPalette{
			ID:         "YlGn",
			Name:       "Yellow-Green",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'C', color.RGBA{0xf7, 0xfc, 0xb9, 0xff}},
				Color{'F', color.RGBA{0xad, 0xdd, 0x8e, 0xff}},
				Color{'I', color.RGBA{0x31, 0xa3, 0x54, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "YlGn",
			Name:       "Yellow-Green",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'E', color.RGBA{0xc2, 0xe6, 0x99, 0xff}},
				Color{'G', color.RGBA{0x78, 0xc6, 0x79, 0xff}},
				Color{'J', color.RGBA{0x23, 0x84, 0x43, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "YlGn",
			Name:       "Yellow-Green",
			Laptop:     Bad,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'E', color.RGBA{0xc2, 0xe6, 0x99, 0xff}},
				Color{'G', color.RGBA{0x78, 0xc6, 0x79, 0xff}},
				Color{'I', color.RGBA{0x31, 0xa3, 0x54, 0xff}},
				Color{'K', color.RGBA{0x00, 0x68, 0x37, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "YlGn",
			Name:       "Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'D', color.RGBA{0xd9, 0xf0, 0xa3, 0xff}},
				Color{'F', color.RGBA{0xad, 0xdd, 0x8e, 0xff}},
				Color{'G', color.RGBA{0x78, 0xc6, 0x79, 0xff}},
				Color{'I', color.RGBA{0x31, 0xa3, 0x54, 0xff}},
				Color{'K', color.RGBA{0x00, 0x68, 0x37, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "YlGn",
			Name:       "Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'D', color.RGBA{0xd9, 0xf0, 0xa3, 0xff}},
				Color{'F', color.RGBA{0xad, 0xdd, 0x8e, 0xff}},
				Color{'G', color.RGBA{0x78, 0xc6, 0x79, 0xff}},
				Color{'H', color.RGBA{0x41, 0xab, 0x5d, 0xff}},
				Color{'J', color.RGBA{0x23, 0x84, 0x43, 0xff}},
				Color{'L', color.RGBA{0x00, 0x5a, 0x32, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "YlGn",
			Name:       "Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xff, 0xe5, 0xff}},
				Color{'C', color.RGBA{0xf7, 0xfc, 0xb9, 0xff}},
				Color{'D', color.RGBA{0xd9, 0xf0, 0xa3, 0xff}},
				Color{'F', color.RGBA{0xad, 0xdd, 0x8e, 0xff}},
				Color{'G', color.RGBA{0x78, 0xc6, 0x79, 0xff}},
				Color{'H', color.RGBA{0x41, 0xab, 0x5d, 0xff}},
				Color{'J', color.RGBA{0x23, 0x84, 0x43, 0xff}},
				Color{'L', color.RGBA{0x00, 0x5a, 0x32, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "YlGn",
			Name:       "Yellow-Green",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xff, 0xe5, 0xff}},
				Color{'C', color.RGBA{0xf7, 0xfc, 0xb9, 0xff}},
				Color{'D', color.RGBA{0xd9, 0xf0, 0xa3, 0xff}},
				Color{'F', color.RGBA{0xad, 0xdd, 0x8e, 0xff}},
				Color{'G', color.RGBA{0x78, 0xc6, 0x79, 0xff}},
				Color{'H', color.RGBA{0x41, 0xab, 0x5d, 0xff}},
				Color{'J', color.RGBA{0x23, 0x84, 0x43, 0xff}},
				Color{'K', color.RGBA{0x00, 0x68, 0x37, 0xff}},
				Color{'M', color.RGBA{0x00, 0x45, 0x29, 0xff}},
			},
		},
	}
	YlGnBu = Sequential{
		3: NonDivergingPalette{
			ID:         "YlGnBu",
			Name:       "Yellow-Green-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xed, 0xf8, 0xb1, 0xff}},
				Color{'F', color.RGBA{0x7f, 0xcd, 0xbb, 0xff}},
				Color{'I', color.RGBA{0x2c, 0x7f, 0xb8, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "YlGnBu",
			Name:       "Yellow-Green-Blue",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Good,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'E', color.RGBA{0xa1, 0xda, 0xb4, 0xff}},
				Color{'G', color.RGBA{0x41, 0xb6, 0xc4, 0xff}},
				Color{'J', color.RGBA{0x22, 0x5e, 0xa8, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "YlGnBu",
			Name:       "Yellow-Green-Blue",
			Laptop:     Unsure,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'E', color.RGBA{0xa1, 0xda, 0xb4, 0xff}},
				Color{'G', color.RGBA{0x41, 0xb6, 0xc4, 0xff}},
				Color{'I', color.RGBA{0x2c, 0x7f, 0xb8, 0xff}},
				Color{'K', color.RGBA{0x25, 0x34, 0x94, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "YlGnBu",
			Name:       "Yellow-Green-Blue",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'D', color.RGBA{0xc7, 0xe9, 0xb4, 0xff}},
				Color{'F', color.RGBA{0x7f, 0xcd, 0xbb, 0xff}},
				Color{'G', color.RGBA{0x41, 0xb6, 0xc4, 0xff}},
				Color{'I', color.RGBA{0x2c, 0x7f, 0xb8, 0xff}},
				Color{'K', color.RGBA{0x25, 0x34, 0x94, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "YlGnBu",
			Name:       "Yellow-Green-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'D', color.RGBA{0xc7, 0xe9, 0xb4, 0xff}},
				Color{'F', color.RGBA{0x7f, 0xcd, 0xbb, 0xff}},
				Color{'G', color.RGBA{0x41, 0xb6, 0xc4, 0xff}},
				Color{'H', color.RGBA{0x1d, 0x91, 0xc0, 0xff}},
				Color{'J', color.RGBA{0x22, 0x5e, 0xa8, 0xff}},
				Color{'L', color.RGBA{0x0c, 0x2c, 0x84, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "YlGnBu",
			Name:       "Yellow-Green-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xff, 0xd9, 0xff}},
				Color{'C', color.RGBA{0xed, 0xf8, 0xb1, 0xff}},
				Color{'D', color.RGBA{0xc7, 0xe9, 0xb4, 0xff}},
				Color{'F', color.RGBA{0x7f, 0xcd, 0xbb, 0xff}},
				Color{'G', color.RGBA{0x41, 0xb6, 0xc4, 0xff}},
				Color{'H', color.RGBA{0x1d, 0x91, 0xc0, 0xff}},
				Color{'J', color.RGBA{0x22, 0x5e, 0xa8, 0xff}},
				Color{'L', color.RGBA{0x0c, 0x2c, 0x84, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "YlGnBu",
			Name:       "Yellow-Green-Blue",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xff, 0xd9, 0xff}},
				Color{'C', color.RGBA{0xed, 0xf8, 0xb1, 0xff}},
				Color{'D', color.RGBA{0xc7, 0xe9, 0xb4, 0xff}},
				Color{'F', color.RGBA{0x7f, 0xcd, 0xbb, 0xff}},
				Color{'G', color.RGBA{0x41, 0xb6, 0xc4, 0xff}},
				Color{'H', color.RGBA{0x1d, 0x91, 0xc0, 0xff}},
				Color{'J', color.RGBA{0x22, 0x5e, 0xa8, 0xff}},
				Color{'K', color.RGBA{0x25, 0x34, 0x94, 0xff}},
				Color{'M', color.RGBA{0x08, 0x1d, 0x58, 0xff}},
			},
		},
	}
	YlOrBr = Sequential{
		3: NonDivergingPalette{
			ID:         "YlOrBr",
			Name:       "Yellow-Orange-Brown",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xff, 0xf7, 0xbc, 0xff}},
				Color{'F', color.RGBA{0xfe, 0xc4, 0x4f, 0xff}},
				Color{'I', color.RGBA{0xd9, 0x5f, 0x0e, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "YlOrBr",
			Name:       "Yellow-Orange-Brown",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Good,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xd4, 0xff}},
				Color{'E', color.RGBA{0xfe, 0xd9, 0x8e, 0xff}},
				Color{'G', color.RGBA{0xfe, 0x99, 0x29, 0xff}},
				Color{'J', color.RGBA{0xcc, 0x4c, 0x02, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "YlOrBr",
			Name:       "Yellow-Orange-Brown",
			Laptop:     Bad,
			CRT:        Unsure,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Good,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xd4, 0xff}},
				Color{'E', color.RGBA{0xfe, 0xd9, 0x8e, 0xff}},
				Color{'G', color.RGBA{0xfe, 0x99, 0x29, 0xff}},
				Color{'I', color.RGBA{0xd9, 0x5f, 0x0e, 0xff}},
				Color{'K', color.RGBA{0x99, 0x34, 0x04, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "YlOrBr",
			Name:       "Yellow-Orange-Brown",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xd4, 0xff}},
				Color{'D', color.RGBA{0xfe, 0xe3, 0x91, 0xff}},
				Color{'F', color.RGBA{0xfe, 0xc4, 0x4f, 0xff}},
				Color{'G', color.RGBA{0xfe, 0x99, 0x29, 0xff}},
				Color{'I', color.RGBA{0xd9, 0x5f, 0x0e, 0xff}},
				Color{'K', color.RGBA{0x99, 0x34, 0x04, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "YlOrBr",
			Name:       "Yellow-Orange-Brown",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xd4, 0xff}},
				Color{'D', color.RGBA{0xfe, 0xe3, 0x91, 0xff}},
				Color{'F', color.RGBA{0xfe, 0xc4, 0x4f, 0xff}},
				Color{'G', color.RGBA{0xfe, 0x99, 0x29, 0xff}},
				Color{'H', color.RGBA{0xec, 0x70, 0x14, 0xff}},
				Color{'J', color.RGBA{0xcc, 0x4c, 0x02, 0xff}},
				Color{'L', color.RGBA{0x8c, 0x2d, 0x04, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "YlOrBr",
			Name:       "Yellow-Orange-Brown",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xff, 0xe5, 0xff}},
				Color{'C', color.RGBA{0xff, 0xf7, 0xbc, 0xff}},
				Color{'D', color.RGBA{0xfe, 0xe3, 0x91, 0xff}},
				Color{'F', color.RGBA{0xfe, 0xc4, 0x4f, 0xff}},
				Color{'G', color.RGBA{0xfe, 0x99, 0x29, 0xff}},
				Color{'H', color.RGBA{0xec, 0x70, 0x14, 0xff}},
				Color{'J', color.RGBA{0xcc, 0x4c, 0x02, 0xff}},
				Color{'L', color.RGBA{0x8c, 0x2d, 0x04, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "YlOrBr",
			Name:       "Yellow-Orange-Brown",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xff, 0xe5, 0xff}},
				Color{'C', color.RGBA{0xff, 0xf7, 0xbc, 0xff}},
				Color{'D', color.RGBA{0xfe, 0xe3, 0x91, 0xff}},
				Color{'F', color.RGBA{0xfe, 0xc4, 0x4f, 0xff}},
				Color{'G', color.RGBA{0xfe, 0x99, 0x29, 0xff}},
				Color{'H', color.RGBA{0xec, 0x70, 0x14, 0xff}},
				Color{'J', color.RGBA{0xcc, 0x4c, 0x02, 0xff}},
				Color{'K', color.RGBA{0x99, 0x34, 0x04, 0xff}},
				Color{'M', color.RGBA{0x66, 0x25, 0x06, 0xff}},
			},
		},
	}
	YlOrRd = Sequential{
		3: NonDivergingPalette{
			ID:         "YlOrRd",
			Name:       "Yellow-Orange-Red",
			Laptop:     Good,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Good,
			Projector:  Good,
			Color: []color.Color{
				Color{'C', color.RGBA{0xff, 0xed, 0xa0, 0xff}},
				Color{'F', color.RGBA{0xfe, 0xb2, 0x4c, 0xff}},
				Color{'I', color.RGBA{0xf0, 0x3b, 0x20, 0xff}},
			},
		},
		4: NonDivergingPalette{
			ID:         "YlOrRd",
			Name:       "Yellow-Orange-Red",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Good,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xb2, 0xff}},
				Color{'E', color.RGBA{0xfe, 0xcc, 0x5c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'J', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
			},
		},
		5: NonDivergingPalette{
			ID:         "YlOrRd",
			Name:       "Yellow-Orange-Red",
			Laptop:     Unsure,
			CRT:        Good,
			ColorBlind: Good,
			Copy:       Unsure,
			Projector:  Good,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xb2, 0xff}},
				Color{'E', color.RGBA{0xfe, 0xcc, 0x5c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'I', color.RGBA{0xf0, 0x3b, 0x20, 0xff}},
				Color{'K', color.RGBA{0xbd, 0x00, 0x26, 0xff}},
			},
		},
		6: NonDivergingPalette{
			ID:         "YlOrRd",
			Name:       "Yellow-Orange-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Unsure,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xb2, 0xff}},
				Color{'D', color.RGBA{0xfe, 0xd9, 0x76, 0xff}},
				Color{'F', color.RGBA{0xfe, 0xb2, 0x4c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'I', color.RGBA{0xf0, 0x3b, 0x20, 0xff}},
				Color{'K', color.RGBA{0xbd, 0x00, 0x26, 0xff}},
			},
		},
		7: NonDivergingPalette{
			ID:         "YlOrRd",
			Name:       "Yellow-Orange-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'B', color.RGBA{0xff, 0xff, 0xb2, 0xff}},
				Color{'D', color.RGBA{0xfe, 0xd9, 0x76, 0xff}},
				Color{'F', color.RGBA{0xfe, 0xb2, 0x4c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'H', color.RGBA{0xfc, 0x4e, 0x2a, 0xff}},
				Color{'J', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
				Color{'L', color.RGBA{0xb1, 0x00, 0x26, 0xff}},
			},
		},
		8: NonDivergingPalette{
			ID:         "YlOrRd",
			Name:       "Yellow-Orange-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'C', color.RGBA{0xff, 0xed, 0xa0, 0xff}},
				Color{'D', color.RGBA{0xfe, 0xd9, 0x76, 0xff}},
				Color{'F', color.RGBA{0xfe, 0xb2, 0x4c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'H', color.RGBA{0xfc, 0x4e, 0x2a, 0xff}},
				Color{'J', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
				Color{'L', color.RGBA{0xb1, 0x00, 0x26, 0xff}},
			},
		},
		9: NonDivergingPalette{
			ID:         "YlOrRd",
			Name:       "Yellow-Orange-Red",
			Laptop:     Bad,
			CRT:        Bad,
			ColorBlind: Good,
			Copy:       Bad,
			Projector:  Bad,
			Color: []color.Color{
				Color{'A', color.RGBA{0xff, 0xff, 0xcc, 0xff}},
				Color{'C', color.RGBA{0xff, 0xed, 0xa0, 0xff}},
				Color{'D', color.RGBA{0xfe, 0xd9, 0x76, 0xff}},
				Color{'F', color.RGBA{0xfe, 0xb2, 0x4c, 0xff}},
				Color{'G', color.RGBA{0xfd, 0x8d, 0x3c, 0xff}},
				Color{'H', color.RGBA{0xfc, 0x4e, 0x2a, 0xff}},
				Color{'J', color.RGBA{0xe3, 0x1a, 0x1c, 0xff}},
				Color{'K', color.RGBA{0xbd, 0x00, 0x26, 0xff}},
				Color{'M', color.RGBA{0x80, 0x00, 0x26, 0xff}},
			},
		},
	}
)

var (
	diverging = map[string]Diverging{
		"BrBG":     BrBG,
		"PiYG":     PiYG,
		"PRGn":     PRGn,
		"PuOr":     PuOr,
		"RdBu":     RdBu,
		"RdGy":     RdGy,
		"RdYlBu":   RdYlBu,
		"RdYlGn":   RdYlGn,
		"Spectral": Spectral,
	}
	qualitative = map[string]Qualitative{
		"Accent":  Accent,
		"Dark2":   Dark2,
		"Paired":  Paired,
		"Pastel1": Pastel1,
		"Pastel2": Pastel2,
		"Set1":    Set1,
		"Set2":    Set2,
		"Set3":    Set3,
	}
	sequential = map[string]Sequential{
		"Blues":   Blues,
		"BuGn":    BuGn,
		"BuPu":    BuPu,
		"GnBu":    GnBu,
		"Greens":  Greens,
		"Greys":   Greys,
		"Oranges": Oranges,
		"OrRd":    OrRd,
		"PuBu":    PuBu,
		"PuBuGn":  PuBuGn,
		"PuRd":    PuRd,
		"Purples": Purples,
		"RdPu":    RdPu,
		"Reds":    Reds,
		"YlGn":    YlGn,
		"YlGnBu":  YlGnBu,
		"YlOrBr":  YlOrBr,
		"YlOrRd":  YlOrRd,
	}
	all = map[string]interface{}{
		"BrBG":     BrBG,
		"PiYG":     PiYG,
		"PRGn":     PRGn,
		"PuOr":     PuOr,
		"RdBu":     RdBu,
		"RdGy":     RdGy,
		"RdYlBu":   RdYlBu,
		"RdYlGn":   RdYlGn,
		"Spectral": Spectral,
		"Accent":   Accent,
		"Dark2":    Dark2,
		"Paired":   Paired,
		"Pastel1":  Pastel1,
		"Pastel2":  Pastel2,
		"Set1":     Set1,
		"Set2":     Set2,
		"Set3":     Set3,
		"Blues":    Blues,
		"BuGn":     BuGn,
		"BuPu":     BuPu,
		"GnBu":     GnBu,
		"Greens":   Greens,
		"Greys":    Greys,
		"Oranges":  Oranges,
		"OrRd":     OrRd,
		"PuBu":     PuBu,
		"PuBuGn":   PuBuGn,
		"PuRd":     PuRd,
		"Purples":  Purples,
		"RdPu":     RdPu,
		"Reds":     Reds,
		"YlGn":     YlGn,
		"YlGnBu":   YlGnBu,
		"YlOrBr":   YlOrBr,
		"YlOrRd":   YlOrRd,
	}
)
