// Code generated by go-swagger; DO NOT EDIT.

package dashboard_permissions

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new dashboard permissions API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for dashboard permissions API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	GetDashboardPermissionsListByID(dashboardID int64, opts ...ClientOption) (*GetDashboardPermissionsListByIDOK, error)
	GetDashboardPermissionsListByIDWithParams(params *GetDashboardPermissionsListByIDParams, opts ...ClientOption) (*GetDashboardPermissionsListByIDOK, error)

	GetDashboardPermissionsListByUID(uid string, opts ...ClientOption) (*GetDashboardPermissionsListByUIDOK, error)
	GetDashboardPermissionsListByUIDWithParams(params *GetDashboardPermissionsListByUIDParams, opts ...ClientOption) (*GetDashboardPermissionsListByUIDOK, error)

	UpdateDashboardPermissionsByID(dashboardID int64, body *models.UpdateDashboardACLCommand, opts ...ClientOption) (*UpdateDashboardPermissionsByIDOK, error)
	UpdateDashboardPermissionsByIDWithParams(params *UpdateDashboardPermissionsByIDParams, opts ...ClientOption) (*UpdateDashboardPermissionsByIDOK, error)

	UpdateDashboardPermissionsByUID(uid string, body *models.UpdateDashboardACLCommand, opts ...ClientOption) (*UpdateDashboardPermissionsByUIDOK, error)
	UpdateDashboardPermissionsByUIDWithParams(params *UpdateDashboardPermissionsByUIDParams, opts ...ClientOption) (*UpdateDashboardPermissionsByUIDOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
GetDashboardPermissionsListByID gets all existing permissions for the given dashboard

Please refer to [updated API](#/dashboard_permissions/getDashboardPermissionsListByUID) instead
*/
func (a *Client) GetDashboardPermissionsListByID(dashboardID int64, opts ...ClientOption) (*GetDashboardPermissionsListByIDOK, error) {
	params := NewGetDashboardPermissionsListByIDParams().WithDashboardID(dashboardID)
	return a.GetDashboardPermissionsListByIDWithParams(params, opts...)
}

func (a *Client) GetDashboardPermissionsListByIDWithParams(params *GetDashboardPermissionsListByIDParams, opts ...ClientOption) (*GetDashboardPermissionsListByIDOK, error) {
	if params == nil {
		params = NewGetDashboardPermissionsListByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getDashboardPermissionsListByID",
		Method:             "GET",
		PathPattern:        "/dashboards/id/{DashboardID}/permissions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDashboardPermissionsListByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetDashboardPermissionsListByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getDashboardPermissionsListByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetDashboardPermissionsListByUID gets all existing permissions for the given dashboard
*/
func (a *Client) GetDashboardPermissionsListByUID(uid string, opts ...ClientOption) (*GetDashboardPermissionsListByUIDOK, error) {
	params := NewGetDashboardPermissionsListByUIDParams().WithUID(uid)
	return a.GetDashboardPermissionsListByUIDWithParams(params, opts...)
}

func (a *Client) GetDashboardPermissionsListByUIDWithParams(params *GetDashboardPermissionsListByUIDParams, opts ...ClientOption) (*GetDashboardPermissionsListByUIDOK, error) {
	if params == nil {
		params = NewGetDashboardPermissionsListByUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getDashboardPermissionsListByUID",
		Method:             "GET",
		PathPattern:        "/dashboards/uid/{uid}/permissions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetDashboardPermissionsListByUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetDashboardPermissionsListByUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getDashboardPermissionsListByUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateDashboardPermissionsByID updates permissions for a dashboard

Please refer to [updated API](#/dashboard_permissions/updateDashboardPermissionsByUID) instead

This operation will remove existing permissions if they’re not included in the request.
*/
func (a *Client) UpdateDashboardPermissionsByID(dashboardID int64, body *models.UpdateDashboardACLCommand, opts ...ClientOption) (*UpdateDashboardPermissionsByIDOK, error) {
	params := NewUpdateDashboardPermissionsByIDParams().WithBody(body).WithDashboardID(dashboardID)
	return a.UpdateDashboardPermissionsByIDWithParams(params, opts...)
}

func (a *Client) UpdateDashboardPermissionsByIDWithParams(params *UpdateDashboardPermissionsByIDParams, opts ...ClientOption) (*UpdateDashboardPermissionsByIDOK, error) {
	if params == nil {
		params = NewUpdateDashboardPermissionsByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateDashboardPermissionsByID",
		Method:             "POST",
		PathPattern:        "/dashboards/id/{DashboardID}/permissions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateDashboardPermissionsByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateDashboardPermissionsByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateDashboardPermissionsByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateDashboardPermissionsByUID updates permissions for a dashboard

This operation will remove existing permissions if they’re not included in the request.
*/
func (a *Client) UpdateDashboardPermissionsByUID(uid string, body *models.UpdateDashboardACLCommand, opts ...ClientOption) (*UpdateDashboardPermissionsByUIDOK, error) {
	params := NewUpdateDashboardPermissionsByUIDParams().WithBody(body).WithUID(uid)
	return a.UpdateDashboardPermissionsByUIDWithParams(params, opts...)
}

func (a *Client) UpdateDashboardPermissionsByUIDWithParams(params *UpdateDashboardPermissionsByUIDParams, opts ...ClientOption) (*UpdateDashboardPermissionsByUIDOK, error) {
	if params == nil {
		params = NewUpdateDashboardPermissionsByUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateDashboardPermissionsByUID",
		Method:             "POST",
		PathPattern:        "/dashboards/uid/{uid}/permissions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateDashboardPermissionsByUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateDashboardPermissionsByUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateDashboardPermissionsByUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
