// Code generated by go-swagger; DO NOT EDIT.

package dashboard_public

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new dashboard public API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for dashboard public API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreatePublicDashboard(dashboardUID string, body *models.PublicDashboardDTO, opts ...ClientOption) (*CreatePublicDashboardOK, error)
	CreatePublicDashboardWithParams(params *CreatePublicDashboardParams, opts ...ClientOption) (*CreatePublicDashboardOK, error)

	DeletePublicDashboard(uid string, dashboardUID string, opts ...ClientOption) (*DeletePublicDashboardOK, error)
	DeletePublicDashboardWithParams(params *DeletePublicDashboardParams, opts ...ClientOption) (*DeletePublicDashboardOK, error)

	GetPublicAnnotations(accessToken string, opts ...ClientOption) (*GetPublicAnnotationsOK, error)
	GetPublicAnnotationsWithParams(params *GetPublicAnnotationsParams, opts ...ClientOption) (*GetPublicAnnotationsOK, error)

	GetPublicDashboard(dashboardUID string, opts ...ClientOption) (*GetPublicDashboardOK, error)
	GetPublicDashboardWithParams(params *GetPublicDashboardParams, opts ...ClientOption) (*GetPublicDashboardOK, error)

	ListPublicDashboards(opts ...ClientOption) (*ListPublicDashboardsOK, error)
	ListPublicDashboardsWithParams(params *ListPublicDashboardsParams, opts ...ClientOption) (*ListPublicDashboardsOK, error)

	QueryPublicDashboard(panelID int64, accessToken string, opts ...ClientOption) (*QueryPublicDashboardOK, error)
	QueryPublicDashboardWithParams(params *QueryPublicDashboardParams, opts ...ClientOption) (*QueryPublicDashboardOK, error)

	UpdatePublicDashboard(params *UpdatePublicDashboardParams, opts ...ClientOption) (*UpdatePublicDashboardOK, error)

	ViewPublicDashboard(accessToken string, opts ...ClientOption) (*ViewPublicDashboardOK, error)
	ViewPublicDashboardWithParams(params *ViewPublicDashboardParams, opts ...ClientOption) (*ViewPublicDashboardOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreatePublicDashboard Create public dashboard for a dashboard
*/
func (a *Client) CreatePublicDashboard(dashboardUID string, body *models.PublicDashboardDTO, opts ...ClientOption) (*CreatePublicDashboardOK, error) {
	params := NewCreatePublicDashboardParams().WithBody(body).WithDashboardUID(dashboardUID)
	return a.CreatePublicDashboardWithParams(params, opts...)
}

func (a *Client) CreatePublicDashboardWithParams(params *CreatePublicDashboardParams, opts ...ClientOption) (*CreatePublicDashboardOK, error) {
	if params == nil {
		params = NewCreatePublicDashboardParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createPublicDashboard",
		Method:             "POST",
		PathPattern:        "/dashboards/uid/{dashboardUid}/public-dashboards",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreatePublicDashboardReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreatePublicDashboardOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createPublicDashboard: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeletePublicDashboard Delete public dashboard for a dashboard
*/
func (a *Client) DeletePublicDashboard(uid string, dashboardUID string, opts ...ClientOption) (*DeletePublicDashboardOK, error) {
	params := NewDeletePublicDashboardParams().WithDashboardUID(dashboardUID).WithUID(uid)
	return a.DeletePublicDashboardWithParams(params, opts...)
}

func (a *Client) DeletePublicDashboardWithParams(params *DeletePublicDashboardParams, opts ...ClientOption) (*DeletePublicDashboardOK, error) {
	if params == nil {
		params = NewDeletePublicDashboardParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deletePublicDashboard",
		Method:             "DELETE",
		PathPattern:        "/dashboards/uid/{dashboardUid}/public-dashboards/{uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeletePublicDashboardReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeletePublicDashboardOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deletePublicDashboard: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetPublicAnnotations Get annotations for a public dashboard
*/
func (a *Client) GetPublicAnnotations(accessToken string, opts ...ClientOption) (*GetPublicAnnotationsOK, error) {
	params := NewGetPublicAnnotationsParams().WithAccessToken(accessToken)
	return a.GetPublicAnnotationsWithParams(params, opts...)
}

func (a *Client) GetPublicAnnotationsWithParams(params *GetPublicAnnotationsParams, opts ...ClientOption) (*GetPublicAnnotationsOK, error) {
	if params == nil {
		params = NewGetPublicAnnotationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getPublicAnnotations",
		Method:             "GET",
		PathPattern:        "/public/dashboards/{accessToken}/annotations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPublicAnnotationsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPublicAnnotationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getPublicAnnotations: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetPublicDashboard Get public dashboard by dashboardUid
*/
func (a *Client) GetPublicDashboard(dashboardUID string, opts ...ClientOption) (*GetPublicDashboardOK, error) {
	params := NewGetPublicDashboardParams().WithDashboardUID(dashboardUID)
	return a.GetPublicDashboardWithParams(params, opts...)
}

func (a *Client) GetPublicDashboardWithParams(params *GetPublicDashboardParams, opts ...ClientOption) (*GetPublicDashboardOK, error) {
	if params == nil {
		params = NewGetPublicDashboardParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getPublicDashboard",
		Method:             "GET",
		PathPattern:        "/dashboards/uid/{dashboardUid}/public-dashboards",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetPublicDashboardReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPublicDashboardOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getPublicDashboard: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ListPublicDashboards Get list of public dashboards
*/
func (a *Client) ListPublicDashboards(opts ...ClientOption) (*ListPublicDashboardsOK, error) {
	params := NewListPublicDashboardsParams()
	return a.ListPublicDashboardsWithParams(params, opts...)
}

func (a *Client) ListPublicDashboardsWithParams(params *ListPublicDashboardsParams, opts ...ClientOption) (*ListPublicDashboardsOK, error) {
	if params == nil {
		params = NewListPublicDashboardsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "listPublicDashboards",
		Method:             "GET",
		PathPattern:        "/dashboards/public-dashboards",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListPublicDashboardsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListPublicDashboardsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for listPublicDashboards: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
QueryPublicDashboard Get results for a given panel on a public dashboard
*/
func (a *Client) QueryPublicDashboard(panelID int64, accessToken string, opts ...ClientOption) (*QueryPublicDashboardOK, error) {
	params := NewQueryPublicDashboardParams().WithAccessToken(accessToken).WithPanelID(panelID)
	return a.QueryPublicDashboardWithParams(params, opts...)
}

func (a *Client) QueryPublicDashboardWithParams(params *QueryPublicDashboardParams, opts ...ClientOption) (*QueryPublicDashboardOK, error) {
	if params == nil {
		params = NewQueryPublicDashboardParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "queryPublicDashboard",
		Method:             "POST",
		PathPattern:        "/public/dashboards/{accessToken}/panels/{panelId}/query",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &QueryPublicDashboardReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*QueryPublicDashboardOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for queryPublicDashboard: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdatePublicDashboard Update public dashboard for a dashboard
*/

func (a *Client) UpdatePublicDashboard(params *UpdatePublicDashboardParams, opts ...ClientOption) (*UpdatePublicDashboardOK, error) {
	if params == nil {
		params = NewUpdatePublicDashboardParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updatePublicDashboard",
		Method:             "PATCH",
		PathPattern:        "/dashboards/uid/{dashboardUid}/public-dashboards/{uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdatePublicDashboardReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdatePublicDashboardOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updatePublicDashboard: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
ViewPublicDashboard Get public dashboard for view
*/
func (a *Client) ViewPublicDashboard(accessToken string, opts ...ClientOption) (*ViewPublicDashboardOK, error) {
	params := NewViewPublicDashboardParams().WithAccessToken(accessToken)
	return a.ViewPublicDashboardWithParams(params, opts...)
}

func (a *Client) ViewPublicDashboardWithParams(params *ViewPublicDashboardParams, opts ...ClientOption) (*ViewPublicDashboardOK, error) {
	if params == nil {
		params = NewViewPublicDashboardParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "viewPublicDashboard",
		Method:             "GET",
		PathPattern:        "/public/dashboards/{accessToken}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ViewPublicDashboardReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ViewPublicDashboardOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for viewPublicDashboard: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
