// Code generated by go-swagger; DO NOT EDIT.

package datasources

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteDataSourceByNameReader is a Reader for the DeleteDataSourceByName structure.
type DeleteDataSourceByNameReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteDataSourceByNameReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteDataSourceByNameOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewDeleteDataSourceByNameUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteDataSourceByNameForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteDataSourceByNameNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteDataSourceByNameInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /datasources/name/{name}] deleteDataSourceByName", response, response.Code())
	}
}

// NewDeleteDataSourceByNameOK creates a DeleteDataSourceByNameOK with default headers values
func NewDeleteDataSourceByNameOK() *DeleteDataSourceByNameOK {
	return &DeleteDataSourceByNameOK{}
}

/*
DeleteDataSourceByNameOK describes a response with status code 200, with default header values.

(empty)
*/
type DeleteDataSourceByNameOK struct {
	Payload *models.DeleteDataSourceByNameOKBody
}

// IsSuccess returns true when this delete data source by name Ok response has a 2xx status code
func (o *DeleteDataSourceByNameOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete data source by name Ok response has a 3xx status code
func (o *DeleteDataSourceByNameOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by name Ok response has a 4xx status code
func (o *DeleteDataSourceByNameOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete data source by name Ok response has a 5xx status code
func (o *DeleteDataSourceByNameOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by name Ok response a status code equal to that given
func (o *DeleteDataSourceByNameOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete data source by name Ok response
func (o *DeleteDataSourceByNameOK) Code() int {
	return 200
}

func (o *DeleteDataSourceByNameOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/name/{name}][%d] deleteDataSourceByNameOk %s", 200, payload)
}

func (o *DeleteDataSourceByNameOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/name/{name}][%d] deleteDataSourceByNameOk %s", 200, payload)
}

func (o *DeleteDataSourceByNameOK) GetPayload() *models.DeleteDataSourceByNameOKBody {
	return o.Payload
}

func (o *DeleteDataSourceByNameOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.DeleteDataSourceByNameOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByNameUnauthorized creates a DeleteDataSourceByNameUnauthorized with default headers values
func NewDeleteDataSourceByNameUnauthorized() *DeleteDataSourceByNameUnauthorized {
	return &DeleteDataSourceByNameUnauthorized{}
}

/*
DeleteDataSourceByNameUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteDataSourceByNameUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by name unauthorized response has a 2xx status code
func (o *DeleteDataSourceByNameUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by name unauthorized response has a 3xx status code
func (o *DeleteDataSourceByNameUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by name unauthorized response has a 4xx status code
func (o *DeleteDataSourceByNameUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete data source by name unauthorized response has a 5xx status code
func (o *DeleteDataSourceByNameUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by name unauthorized response a status code equal to that given
func (o *DeleteDataSourceByNameUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete data source by name unauthorized response
func (o *DeleteDataSourceByNameUnauthorized) Code() int {
	return 401
}

func (o *DeleteDataSourceByNameUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/name/{name}][%d] deleteDataSourceByNameUnauthorized %s", 401, payload)
}

func (o *DeleteDataSourceByNameUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/name/{name}][%d] deleteDataSourceByNameUnauthorized %s", 401, payload)
}

func (o *DeleteDataSourceByNameUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByNameUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByNameForbidden creates a DeleteDataSourceByNameForbidden with default headers values
func NewDeleteDataSourceByNameForbidden() *DeleteDataSourceByNameForbidden {
	return &DeleteDataSourceByNameForbidden{}
}

/*
DeleteDataSourceByNameForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteDataSourceByNameForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by name forbidden response has a 2xx status code
func (o *DeleteDataSourceByNameForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by name forbidden response has a 3xx status code
func (o *DeleteDataSourceByNameForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by name forbidden response has a 4xx status code
func (o *DeleteDataSourceByNameForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete data source by name forbidden response has a 5xx status code
func (o *DeleteDataSourceByNameForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by name forbidden response a status code equal to that given
func (o *DeleteDataSourceByNameForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete data source by name forbidden response
func (o *DeleteDataSourceByNameForbidden) Code() int {
	return 403
}

func (o *DeleteDataSourceByNameForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/name/{name}][%d] deleteDataSourceByNameForbidden %s", 403, payload)
}

func (o *DeleteDataSourceByNameForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/name/{name}][%d] deleteDataSourceByNameForbidden %s", 403, payload)
}

func (o *DeleteDataSourceByNameForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByNameForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByNameNotFound creates a DeleteDataSourceByNameNotFound with default headers values
func NewDeleteDataSourceByNameNotFound() *DeleteDataSourceByNameNotFound {
	return &DeleteDataSourceByNameNotFound{}
}

/*
DeleteDataSourceByNameNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DeleteDataSourceByNameNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by name not found response has a 2xx status code
func (o *DeleteDataSourceByNameNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by name not found response has a 3xx status code
func (o *DeleteDataSourceByNameNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by name not found response has a 4xx status code
func (o *DeleteDataSourceByNameNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete data source by name not found response has a 5xx status code
func (o *DeleteDataSourceByNameNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete data source by name not found response a status code equal to that given
func (o *DeleteDataSourceByNameNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete data source by name not found response
func (o *DeleteDataSourceByNameNotFound) Code() int {
	return 404
}

func (o *DeleteDataSourceByNameNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/name/{name}][%d] deleteDataSourceByNameNotFound %s", 404, payload)
}

func (o *DeleteDataSourceByNameNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/name/{name}][%d] deleteDataSourceByNameNotFound %s", 404, payload)
}

func (o *DeleteDataSourceByNameNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByNameNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteDataSourceByNameInternalServerError creates a DeleteDataSourceByNameInternalServerError with default headers values
func NewDeleteDataSourceByNameInternalServerError() *DeleteDataSourceByNameInternalServerError {
	return &DeleteDataSourceByNameInternalServerError{}
}

/*
DeleteDataSourceByNameInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteDataSourceByNameInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete data source by name internal server error response has a 2xx status code
func (o *DeleteDataSourceByNameInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete data source by name internal server error response has a 3xx status code
func (o *DeleteDataSourceByNameInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete data source by name internal server error response has a 4xx status code
func (o *DeleteDataSourceByNameInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete data source by name internal server error response has a 5xx status code
func (o *DeleteDataSourceByNameInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete data source by name internal server error response a status code equal to that given
func (o *DeleteDataSourceByNameInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete data source by name internal server error response
func (o *DeleteDataSourceByNameInternalServerError) Code() int {
	return 500
}

func (o *DeleteDataSourceByNameInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/name/{name}][%d] deleteDataSourceByNameInternalServerError %s", 500, payload)
}

func (o *DeleteDataSourceByNameInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /datasources/name/{name}][%d] deleteDataSourceByNameInternalServerError %s", 500, payload)
}

func (o *DeleteDataSourceByNameInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteDataSourceByNameInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
