// Code generated by go-swagger; DO NOT EDIT.

package library_elements

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewUpdateLibraryElementParams creates a new UpdateLibraryElementParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateLibraryElementParams() *UpdateLibraryElementParams {
	return &UpdateLibraryElementParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateLibraryElementParamsWithTimeout creates a new UpdateLibraryElementParams object
// with the ability to set a timeout on a request.
func NewUpdateLibraryElementParamsWithTimeout(timeout time.Duration) *UpdateLibraryElementParams {
	return &UpdateLibraryElementParams{
		timeout: timeout,
	}
}

// NewUpdateLibraryElementParamsWithContext creates a new UpdateLibraryElementParams object
// with the ability to set a context for a request.
func NewUpdateLibraryElementParamsWithContext(ctx context.Context) *UpdateLibraryElementParams {
	return &UpdateLibraryElementParams{
		Context: ctx,
	}
}

// NewUpdateLibraryElementParamsWithHTTPClient creates a new UpdateLibraryElementParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateLibraryElementParamsWithHTTPClient(client *http.Client) *UpdateLibraryElementParams {
	return &UpdateLibraryElementParams{
		HTTPClient: client,
	}
}

/*
UpdateLibraryElementParams contains all the parameters to send to the API endpoint

	for the update library element operation.

	Typically these are written to a http.Request.
*/
type UpdateLibraryElementParams struct {

	// Body.
	Body *models.PatchLibraryElementCommand

	// LibraryElementUID.
	LibraryElementUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update library element params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateLibraryElementParams) WithDefaults() *UpdateLibraryElementParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update library element params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateLibraryElementParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update library element params
func (o *UpdateLibraryElementParams) WithTimeout(timeout time.Duration) *UpdateLibraryElementParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update library element params
func (o *UpdateLibraryElementParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update library element params
func (o *UpdateLibraryElementParams) WithContext(ctx context.Context) *UpdateLibraryElementParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update library element params
func (o *UpdateLibraryElementParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update library element params
func (o *UpdateLibraryElementParams) WithHTTPClient(client *http.Client) *UpdateLibraryElementParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update library element params
func (o *UpdateLibraryElementParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update library element params
func (o *UpdateLibraryElementParams) WithBody(body *models.PatchLibraryElementCommand) *UpdateLibraryElementParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update library element params
func (o *UpdateLibraryElementParams) SetBody(body *models.PatchLibraryElementCommand) {
	o.Body = body
}

// WithLibraryElementUID adds the libraryElementUID to the update library element params
func (o *UpdateLibraryElementParams) WithLibraryElementUID(libraryElementUID string) *UpdateLibraryElementParams {
	o.SetLibraryElementUID(libraryElementUID)
	return o
}

// SetLibraryElementUID adds the libraryElementUid to the update library element params
func (o *UpdateLibraryElementParams) SetLibraryElementUID(libraryElementUID string) {
	o.LibraryElementUID = libraryElementUID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateLibraryElementParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param library_element_uid
	if err := r.SetPathParam("library_element_uid", o.LibraryElementUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
