// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDeleteOrgByIDParams creates a new DeleteOrgByIDParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteOrgByIDParams() *DeleteOrgByIDParams {
	return &DeleteOrgByIDParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteOrgByIDParamsWithTimeout creates a new DeleteOrgByIDParams object
// with the ability to set a timeout on a request.
func NewDeleteOrgByIDParamsWithTimeout(timeout time.Duration) *DeleteOrgByIDParams {
	return &DeleteOrgByIDParams{
		timeout: timeout,
	}
}

// NewDeleteOrgByIDParamsWithContext creates a new DeleteOrgByIDParams object
// with the ability to set a context for a request.
func NewDeleteOrgByIDParamsWithContext(ctx context.Context) *DeleteOrgByIDParams {
	return &DeleteOrgByIDParams{
		Context: ctx,
	}
}

// NewDeleteOrgByIDParamsWithHTTPClient creates a new DeleteOrgByIDParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteOrgByIDParamsWithHTTPClient(client *http.Client) *DeleteOrgByIDParams {
	return &DeleteOrgByIDParams{
		HTTPClient: client,
	}
}

/*
DeleteOrgByIDParams contains all the parameters to send to the API endpoint

	for the delete org by ID operation.

	Typically these are written to a http.Request.
*/
type DeleteOrgByIDParams struct {

	// OrgID.
	//
	// Format: int64
	OrgID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete org by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteOrgByIDParams) WithDefaults() *DeleteOrgByIDParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete org by ID params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteOrgByIDParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete org by ID params
func (o *DeleteOrgByIDParams) WithTimeout(timeout time.Duration) *DeleteOrgByIDParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete org by ID params
func (o *DeleteOrgByIDParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete org by ID params
func (o *DeleteOrgByIDParams) WithContext(ctx context.Context) *DeleteOrgByIDParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete org by ID params
func (o *DeleteOrgByIDParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete org by ID params
func (o *DeleteOrgByIDParams) WithHTTPClient(client *http.Client) *DeleteOrgByIDParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete org by ID params
func (o *DeleteOrgByIDParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithOrgID adds the orgID to the delete org by ID params
func (o *DeleteOrgByIDParams) WithOrgID(orgID int64) *DeleteOrgByIDParams {
	o.SetOrgID(orgID)
	return o
}

// SetOrgID adds the orgId to the delete org by ID params
func (o *DeleteOrgByIDParams) SetOrgID(orgID int64) {
	o.OrgID = orgID
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteOrgByIDParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param org_id
	if err := r.SetPathParam("org_id", swag.FormatInt64(o.OrgID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
