// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateOrgQuotaReader is a Reader for the UpdateOrgQuota structure.
type UpdateOrgQuotaReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateOrgQuotaReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateOrgQuotaOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewUpdateOrgQuotaUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateOrgQuotaForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateOrgQuotaNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateOrgQuotaInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /orgs/{org_id}/quotas/{quota_target}] updateOrgQuota", response, response.Code())
	}
}

// NewUpdateOrgQuotaOK creates a UpdateOrgQuotaOK with default headers values
func NewUpdateOrgQuotaOK() *UpdateOrgQuotaOK {
	return &UpdateOrgQuotaOK{}
}

/*
UpdateOrgQuotaOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type UpdateOrgQuotaOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this update org quota Ok response has a 2xx status code
func (o *UpdateOrgQuotaOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update org quota Ok response has a 3xx status code
func (o *UpdateOrgQuotaOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org quota Ok response has a 4xx status code
func (o *UpdateOrgQuotaOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update org quota Ok response has a 5xx status code
func (o *UpdateOrgQuotaOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update org quota Ok response a status code equal to that given
func (o *UpdateOrgQuotaOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update org quota Ok response
func (o *UpdateOrgQuotaOK) Code() int {
	return 200
}

func (o *UpdateOrgQuotaOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}/quotas/{quota_target}][%d] updateOrgQuotaOk %s", 200, payload)
}

func (o *UpdateOrgQuotaOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}/quotas/{quota_target}][%d] updateOrgQuotaOk %s", 200, payload)
}

func (o *UpdateOrgQuotaOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *UpdateOrgQuotaOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgQuotaUnauthorized creates a UpdateOrgQuotaUnauthorized with default headers values
func NewUpdateOrgQuotaUnauthorized() *UpdateOrgQuotaUnauthorized {
	return &UpdateOrgQuotaUnauthorized{}
}

/*
UpdateOrgQuotaUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateOrgQuotaUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org quota unauthorized response has a 2xx status code
func (o *UpdateOrgQuotaUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org quota unauthorized response has a 3xx status code
func (o *UpdateOrgQuotaUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org quota unauthorized response has a 4xx status code
func (o *UpdateOrgQuotaUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update org quota unauthorized response has a 5xx status code
func (o *UpdateOrgQuotaUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update org quota unauthorized response a status code equal to that given
func (o *UpdateOrgQuotaUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update org quota unauthorized response
func (o *UpdateOrgQuotaUnauthorized) Code() int {
	return 401
}

func (o *UpdateOrgQuotaUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}/quotas/{quota_target}][%d] updateOrgQuotaUnauthorized %s", 401, payload)
}

func (o *UpdateOrgQuotaUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}/quotas/{quota_target}][%d] updateOrgQuotaUnauthorized %s", 401, payload)
}

func (o *UpdateOrgQuotaUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgQuotaUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgQuotaForbidden creates a UpdateOrgQuotaForbidden with default headers values
func NewUpdateOrgQuotaForbidden() *UpdateOrgQuotaForbidden {
	return &UpdateOrgQuotaForbidden{}
}

/*
UpdateOrgQuotaForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateOrgQuotaForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org quota forbidden response has a 2xx status code
func (o *UpdateOrgQuotaForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org quota forbidden response has a 3xx status code
func (o *UpdateOrgQuotaForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org quota forbidden response has a 4xx status code
func (o *UpdateOrgQuotaForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update org quota forbidden response has a 5xx status code
func (o *UpdateOrgQuotaForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update org quota forbidden response a status code equal to that given
func (o *UpdateOrgQuotaForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update org quota forbidden response
func (o *UpdateOrgQuotaForbidden) Code() int {
	return 403
}

func (o *UpdateOrgQuotaForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}/quotas/{quota_target}][%d] updateOrgQuotaForbidden %s", 403, payload)
}

func (o *UpdateOrgQuotaForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}/quotas/{quota_target}][%d] updateOrgQuotaForbidden %s", 403, payload)
}

func (o *UpdateOrgQuotaForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgQuotaForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgQuotaNotFound creates a UpdateOrgQuotaNotFound with default headers values
func NewUpdateOrgQuotaNotFound() *UpdateOrgQuotaNotFound {
	return &UpdateOrgQuotaNotFound{}
}

/*
UpdateOrgQuotaNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type UpdateOrgQuotaNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org quota not found response has a 2xx status code
func (o *UpdateOrgQuotaNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org quota not found response has a 3xx status code
func (o *UpdateOrgQuotaNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org quota not found response has a 4xx status code
func (o *UpdateOrgQuotaNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update org quota not found response has a 5xx status code
func (o *UpdateOrgQuotaNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update org quota not found response a status code equal to that given
func (o *UpdateOrgQuotaNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update org quota not found response
func (o *UpdateOrgQuotaNotFound) Code() int {
	return 404
}

func (o *UpdateOrgQuotaNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}/quotas/{quota_target}][%d] updateOrgQuotaNotFound %s", 404, payload)
}

func (o *UpdateOrgQuotaNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}/quotas/{quota_target}][%d] updateOrgQuotaNotFound %s", 404, payload)
}

func (o *UpdateOrgQuotaNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgQuotaNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgQuotaInternalServerError creates a UpdateOrgQuotaInternalServerError with default headers values
func NewUpdateOrgQuotaInternalServerError() *UpdateOrgQuotaInternalServerError {
	return &UpdateOrgQuotaInternalServerError{}
}

/*
UpdateOrgQuotaInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateOrgQuotaInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org quota internal server error response has a 2xx status code
func (o *UpdateOrgQuotaInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org quota internal server error response has a 3xx status code
func (o *UpdateOrgQuotaInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org quota internal server error response has a 4xx status code
func (o *UpdateOrgQuotaInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update org quota internal server error response has a 5xx status code
func (o *UpdateOrgQuotaInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update org quota internal server error response a status code equal to that given
func (o *UpdateOrgQuotaInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update org quota internal server error response
func (o *UpdateOrgQuotaInternalServerError) Code() int {
	return 500
}

func (o *UpdateOrgQuotaInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}/quotas/{quota_target}][%d] updateOrgQuotaInternalServerError %s", 500, payload)
}

func (o *UpdateOrgQuotaInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}/quotas/{quota_target}][%d] updateOrgQuotaInternalServerError %s", 500, payload)
}

func (o *UpdateOrgQuotaInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgQuotaInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
