// Code generated by go-swagger; DO NOT EDIT.

package playlists

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetPlaylistItemsReader is a Reader for the GetPlaylistItems structure.
type GetPlaylistItemsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetPlaylistItemsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetPlaylistItemsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetPlaylistItemsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetPlaylistItemsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetPlaylistItemsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetPlaylistItemsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /playlists/{uid}/items] getPlaylistItems", response, response.Code())
	}
}

// NewGetPlaylistItemsOK creates a GetPlaylistItemsOK with default headers values
func NewGetPlaylistItemsOK() *GetPlaylistItemsOK {
	return &GetPlaylistItemsOK{}
}

/*
GetPlaylistItemsOK describes a response with status code 200, with default header values.

(empty)
*/
type GetPlaylistItemsOK struct {
	Payload []*models.PlaylistItem
}

// IsSuccess returns true when this get playlist items Ok response has a 2xx status code
func (o *GetPlaylistItemsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get playlist items Ok response has a 3xx status code
func (o *GetPlaylistItemsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get playlist items Ok response has a 4xx status code
func (o *GetPlaylistItemsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get playlist items Ok response has a 5xx status code
func (o *GetPlaylistItemsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get playlist items Ok response a status code equal to that given
func (o *GetPlaylistItemsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get playlist items Ok response
func (o *GetPlaylistItemsOK) Code() int {
	return 200
}

func (o *GetPlaylistItemsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}/items][%d] getPlaylistItemsOk %s", 200, payload)
}

func (o *GetPlaylistItemsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}/items][%d] getPlaylistItemsOk %s", 200, payload)
}

func (o *GetPlaylistItemsOK) GetPayload() []*models.PlaylistItem {
	return o.Payload
}

func (o *GetPlaylistItemsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPlaylistItemsUnauthorized creates a GetPlaylistItemsUnauthorized with default headers values
func NewGetPlaylistItemsUnauthorized() *GetPlaylistItemsUnauthorized {
	return &GetPlaylistItemsUnauthorized{}
}

/*
GetPlaylistItemsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetPlaylistItemsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get playlist items unauthorized response has a 2xx status code
func (o *GetPlaylistItemsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get playlist items unauthorized response has a 3xx status code
func (o *GetPlaylistItemsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get playlist items unauthorized response has a 4xx status code
func (o *GetPlaylistItemsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get playlist items unauthorized response has a 5xx status code
func (o *GetPlaylistItemsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get playlist items unauthorized response a status code equal to that given
func (o *GetPlaylistItemsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get playlist items unauthorized response
func (o *GetPlaylistItemsUnauthorized) Code() int {
	return 401
}

func (o *GetPlaylistItemsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}/items][%d] getPlaylistItemsUnauthorized %s", 401, payload)
}

func (o *GetPlaylistItemsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}/items][%d] getPlaylistItemsUnauthorized %s", 401, payload)
}

func (o *GetPlaylistItemsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetPlaylistItemsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPlaylistItemsForbidden creates a GetPlaylistItemsForbidden with default headers values
func NewGetPlaylistItemsForbidden() *GetPlaylistItemsForbidden {
	return &GetPlaylistItemsForbidden{}
}

/*
GetPlaylistItemsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetPlaylistItemsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get playlist items forbidden response has a 2xx status code
func (o *GetPlaylistItemsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get playlist items forbidden response has a 3xx status code
func (o *GetPlaylistItemsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get playlist items forbidden response has a 4xx status code
func (o *GetPlaylistItemsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get playlist items forbidden response has a 5xx status code
func (o *GetPlaylistItemsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get playlist items forbidden response a status code equal to that given
func (o *GetPlaylistItemsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get playlist items forbidden response
func (o *GetPlaylistItemsForbidden) Code() int {
	return 403
}

func (o *GetPlaylistItemsForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}/items][%d] getPlaylistItemsForbidden %s", 403, payload)
}

func (o *GetPlaylistItemsForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}/items][%d] getPlaylistItemsForbidden %s", 403, payload)
}

func (o *GetPlaylistItemsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetPlaylistItemsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPlaylistItemsNotFound creates a GetPlaylistItemsNotFound with default headers values
func NewGetPlaylistItemsNotFound() *GetPlaylistItemsNotFound {
	return &GetPlaylistItemsNotFound{}
}

/*
GetPlaylistItemsNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetPlaylistItemsNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get playlist items not found response has a 2xx status code
func (o *GetPlaylistItemsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get playlist items not found response has a 3xx status code
func (o *GetPlaylistItemsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get playlist items not found response has a 4xx status code
func (o *GetPlaylistItemsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get playlist items not found response has a 5xx status code
func (o *GetPlaylistItemsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get playlist items not found response a status code equal to that given
func (o *GetPlaylistItemsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get playlist items not found response
func (o *GetPlaylistItemsNotFound) Code() int {
	return 404
}

func (o *GetPlaylistItemsNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}/items][%d] getPlaylistItemsNotFound %s", 404, payload)
}

func (o *GetPlaylistItemsNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}/items][%d] getPlaylistItemsNotFound %s", 404, payload)
}

func (o *GetPlaylistItemsNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetPlaylistItemsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetPlaylistItemsInternalServerError creates a GetPlaylistItemsInternalServerError with default headers values
func NewGetPlaylistItemsInternalServerError() *GetPlaylistItemsInternalServerError {
	return &GetPlaylistItemsInternalServerError{}
}

/*
GetPlaylistItemsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetPlaylistItemsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get playlist items internal server error response has a 2xx status code
func (o *GetPlaylistItemsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get playlist items internal server error response has a 3xx status code
func (o *GetPlaylistItemsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get playlist items internal server error response has a 4xx status code
func (o *GetPlaylistItemsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get playlist items internal server error response has a 5xx status code
func (o *GetPlaylistItemsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get playlist items internal server error response a status code equal to that given
func (o *GetPlaylistItemsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get playlist items internal server error response
func (o *GetPlaylistItemsInternalServerError) Code() int {
	return 500
}

func (o *GetPlaylistItemsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}/items][%d] getPlaylistItemsInternalServerError %s", 500, payload)
}

func (o *GetPlaylistItemsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists/{uid}/items][%d] getPlaylistItemsInternalServerError %s", 500, payload)
}

func (o *GetPlaylistItemsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetPlaylistItemsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
