// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteAlertRuleGroupReader is a Reader for the DeleteAlertRuleGroup structure.
type DeleteAlertRuleGroupReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteAlertRuleGroupReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewDeleteAlertRuleGroupNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewDeleteAlertRuleGroupForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteAlertRuleGroupNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /v1/provisioning/folder/{FolderUID}/rule-groups/{Group}] DeleteAlertRuleGroup", response, response.Code())
	}
}

// NewDeleteAlertRuleGroupNoContent creates a DeleteAlertRuleGroupNoContent with default headers values
func NewDeleteAlertRuleGroupNoContent() *DeleteAlertRuleGroupNoContent {
	return &DeleteAlertRuleGroupNoContent{}
}

/*
DeleteAlertRuleGroupNoContent describes a response with status code 204, with default header values.

	The alert rule group was deleted successfully.
*/
type DeleteAlertRuleGroupNoContent struct {
}

// IsSuccess returns true when this delete alert rule group no content response has a 2xx status code
func (o *DeleteAlertRuleGroupNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete alert rule group no content response has a 3xx status code
func (o *DeleteAlertRuleGroupNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete alert rule group no content response has a 4xx status code
func (o *DeleteAlertRuleGroupNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete alert rule group no content response has a 5xx status code
func (o *DeleteAlertRuleGroupNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this delete alert rule group no content response a status code equal to that given
func (o *DeleteAlertRuleGroupNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the delete alert rule group no content response
func (o *DeleteAlertRuleGroupNoContent) Code() int {
	return 204
}

func (o *DeleteAlertRuleGroupNoContent) Error() string {
	return fmt.Sprintf("[DELETE /v1/provisioning/folder/{FolderUID}/rule-groups/{Group}][%d] deleteAlertRuleGroupNoContent", 204)
}

func (o *DeleteAlertRuleGroupNoContent) String() string {
	return fmt.Sprintf("[DELETE /v1/provisioning/folder/{FolderUID}/rule-groups/{Group}][%d] deleteAlertRuleGroupNoContent", 204)
}

func (o *DeleteAlertRuleGroupNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteAlertRuleGroupForbidden creates a DeleteAlertRuleGroupForbidden with default headers values
func NewDeleteAlertRuleGroupForbidden() *DeleteAlertRuleGroupForbidden {
	return &DeleteAlertRuleGroupForbidden{}
}

/*
DeleteAlertRuleGroupForbidden describes a response with status code 403, with default header values.

ForbiddenError
*/
type DeleteAlertRuleGroupForbidden struct {
	Payload *models.ForbiddenError
}

// IsSuccess returns true when this delete alert rule group forbidden response has a 2xx status code
func (o *DeleteAlertRuleGroupForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete alert rule group forbidden response has a 3xx status code
func (o *DeleteAlertRuleGroupForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete alert rule group forbidden response has a 4xx status code
func (o *DeleteAlertRuleGroupForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete alert rule group forbidden response has a 5xx status code
func (o *DeleteAlertRuleGroupForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete alert rule group forbidden response a status code equal to that given
func (o *DeleteAlertRuleGroupForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete alert rule group forbidden response
func (o *DeleteAlertRuleGroupForbidden) Code() int {
	return 403
}

func (o *DeleteAlertRuleGroupForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /v1/provisioning/folder/{FolderUID}/rule-groups/{Group}][%d] deleteAlertRuleGroupForbidden %s", 403, payload)
}

func (o *DeleteAlertRuleGroupForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /v1/provisioning/folder/{FolderUID}/rule-groups/{Group}][%d] deleteAlertRuleGroupForbidden %s", 403, payload)
}

func (o *DeleteAlertRuleGroupForbidden) GetPayload() *models.ForbiddenError {
	return o.Payload
}

func (o *DeleteAlertRuleGroupForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ForbiddenError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAlertRuleGroupNotFound creates a DeleteAlertRuleGroupNotFound with default headers values
func NewDeleteAlertRuleGroupNotFound() *DeleteAlertRuleGroupNotFound {
	return &DeleteAlertRuleGroupNotFound{}
}

/*
DeleteAlertRuleGroupNotFound describes a response with status code 404, with default header values.

NotFound
*/
type DeleteAlertRuleGroupNotFound struct {
	Payload models.NotFound
}

// IsSuccess returns true when this delete alert rule group not found response has a 2xx status code
func (o *DeleteAlertRuleGroupNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete alert rule group not found response has a 3xx status code
func (o *DeleteAlertRuleGroupNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete alert rule group not found response has a 4xx status code
func (o *DeleteAlertRuleGroupNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete alert rule group not found response has a 5xx status code
func (o *DeleteAlertRuleGroupNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete alert rule group not found response a status code equal to that given
func (o *DeleteAlertRuleGroupNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete alert rule group not found response
func (o *DeleteAlertRuleGroupNotFound) Code() int {
	return 404
}

func (o *DeleteAlertRuleGroupNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /v1/provisioning/folder/{FolderUID}/rule-groups/{Group}][%d] deleteAlertRuleGroupNotFound %s", 404, payload)
}

func (o *DeleteAlertRuleGroupNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /v1/provisioning/folder/{FolderUID}/rule-groups/{Group}][%d] deleteAlertRuleGroupNotFound %s", 404, payload)
}

func (o *DeleteAlertRuleGroupNotFound) GetPayload() models.NotFound {
	return o.Payload
}

func (o *DeleteAlertRuleGroupNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
