// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDeleteMuteTimingParams creates a new DeleteMuteTimingParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDeleteMuteTimingParams() *DeleteMuteTimingParams {
	return &DeleteMuteTimingParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDeleteMuteTimingParamsWithTimeout creates a new DeleteMuteTimingParams object
// with the ability to set a timeout on a request.
func NewDeleteMuteTimingParamsWithTimeout(timeout time.Duration) *DeleteMuteTimingParams {
	return &DeleteMuteTimingParams{
		timeout: timeout,
	}
}

// NewDeleteMuteTimingParamsWithContext creates a new DeleteMuteTimingParams object
// with the ability to set a context for a request.
func NewDeleteMuteTimingParamsWithContext(ctx context.Context) *DeleteMuteTimingParams {
	return &DeleteMuteTimingParams{
		Context: ctx,
	}
}

// NewDeleteMuteTimingParamsWithHTTPClient creates a new DeleteMuteTimingParams object
// with the ability to set a custom HTTPClient for a request.
func NewDeleteMuteTimingParamsWithHTTPClient(client *http.Client) *DeleteMuteTimingParams {
	return &DeleteMuteTimingParams{
		HTTPClient: client,
	}
}

/*
DeleteMuteTimingParams contains all the parameters to send to the API endpoint

	for the delete mute timing operation.

	Typically these are written to a http.Request.
*/
type DeleteMuteTimingParams struct {

	// XDisableProvenance.
	XDisableProvenance *string

	/* Name.

	   Mute timing name
	*/
	Name string

	/* Version.

	   Version of mute timing to use for optimistic concurrency. Leave empty to disable validation
	*/
	Version *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the delete mute timing params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteMuteTimingParams) WithDefaults() *DeleteMuteTimingParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the delete mute timing params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DeleteMuteTimingParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the delete mute timing params
func (o *DeleteMuteTimingParams) WithTimeout(timeout time.Duration) *DeleteMuteTimingParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the delete mute timing params
func (o *DeleteMuteTimingParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the delete mute timing params
func (o *DeleteMuteTimingParams) WithContext(ctx context.Context) *DeleteMuteTimingParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the delete mute timing params
func (o *DeleteMuteTimingParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the delete mute timing params
func (o *DeleteMuteTimingParams) WithHTTPClient(client *http.Client) *DeleteMuteTimingParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the delete mute timing params
func (o *DeleteMuteTimingParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithXDisableProvenance adds the xDisableProvenance to the delete mute timing params
func (o *DeleteMuteTimingParams) WithXDisableProvenance(xDisableProvenance *string) *DeleteMuteTimingParams {
	o.SetXDisableProvenance(xDisableProvenance)
	return o
}

// SetXDisableProvenance adds the xDisableProvenance to the delete mute timing params
func (o *DeleteMuteTimingParams) SetXDisableProvenance(xDisableProvenance *string) {
	o.XDisableProvenance = xDisableProvenance
}

// WithName adds the name to the delete mute timing params
func (o *DeleteMuteTimingParams) WithName(name string) *DeleteMuteTimingParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the delete mute timing params
func (o *DeleteMuteTimingParams) SetName(name string) {
	o.Name = name
}

// WithVersion adds the version to the delete mute timing params
func (o *DeleteMuteTimingParams) WithVersion(version *string) *DeleteMuteTimingParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the delete mute timing params
func (o *DeleteMuteTimingParams) SetVersion(version *string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *DeleteMuteTimingParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.XDisableProvenance != nil {

		// header param X-Disable-Provenance
		if err := r.SetHeaderParam("X-Disable-Provenance", *o.XDisableProvenance); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Version != nil {

		// query param version
		var qrVersion string

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := qrVersion
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
