// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteMuteTimingReader is a Reader for the DeleteMuteTiming structure.
type DeleteMuteTimingReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteMuteTimingReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewDeleteMuteTimingNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 409:
		result := NewDeleteMuteTimingConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /v1/provisioning/mute-timings/{name}] DeleteMuteTiming", response, response.Code())
	}
}

// NewDeleteMuteTimingNoContent creates a DeleteMuteTimingNoContent with default headers values
func NewDeleteMuteTimingNoContent() *DeleteMuteTimingNoContent {
	return &DeleteMuteTimingNoContent{}
}

/*
DeleteMuteTimingNoContent describes a response with status code 204, with default header values.

	The mute timing was deleted successfully.
*/
type DeleteMuteTimingNoContent struct {
}

// IsSuccess returns true when this delete mute timing no content response has a 2xx status code
func (o *DeleteMuteTimingNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete mute timing no content response has a 3xx status code
func (o *DeleteMuteTimingNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete mute timing no content response has a 4xx status code
func (o *DeleteMuteTimingNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete mute timing no content response has a 5xx status code
func (o *DeleteMuteTimingNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this delete mute timing no content response a status code equal to that given
func (o *DeleteMuteTimingNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the delete mute timing no content response
func (o *DeleteMuteTimingNoContent) Code() int {
	return 204
}

func (o *DeleteMuteTimingNoContent) Error() string {
	return fmt.Sprintf("[DELETE /v1/provisioning/mute-timings/{name}][%d] deleteMuteTimingNoContent", 204)
}

func (o *DeleteMuteTimingNoContent) String() string {
	return fmt.Sprintf("[DELETE /v1/provisioning/mute-timings/{name}][%d] deleteMuteTimingNoContent", 204)
}

func (o *DeleteMuteTimingNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteMuteTimingConflict creates a DeleteMuteTimingConflict with default headers values
func NewDeleteMuteTimingConflict() *DeleteMuteTimingConflict {
	return &DeleteMuteTimingConflict{}
}

/*
DeleteMuteTimingConflict describes a response with status code 409, with default header values.

PublicError
*/
type DeleteMuteTimingConflict struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this delete mute timing conflict response has a 2xx status code
func (o *DeleteMuteTimingConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete mute timing conflict response has a 3xx status code
func (o *DeleteMuteTimingConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete mute timing conflict response has a 4xx status code
func (o *DeleteMuteTimingConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete mute timing conflict response has a 5xx status code
func (o *DeleteMuteTimingConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this delete mute timing conflict response a status code equal to that given
func (o *DeleteMuteTimingConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the delete mute timing conflict response
func (o *DeleteMuteTimingConflict) Code() int {
	return 409
}

func (o *DeleteMuteTimingConflict) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /v1/provisioning/mute-timings/{name}][%d] deleteMuteTimingConflict %s", 409, payload)
}

func (o *DeleteMuteTimingConflict) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /v1/provisioning/mute-timings/{name}][%d] deleteMuteTimingConflict %s", 409, payload)
}

func (o *DeleteMuteTimingConflict) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *DeleteMuteTimingConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
