// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewExportMuteTimingParams creates a new ExportMuteTimingParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewExportMuteTimingParams() *ExportMuteTimingParams {
	return &ExportMuteTimingParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewExportMuteTimingParamsWithTimeout creates a new ExportMuteTimingParams object
// with the ability to set a timeout on a request.
func NewExportMuteTimingParamsWithTimeout(timeout time.Duration) *ExportMuteTimingParams {
	return &ExportMuteTimingParams{
		timeout: timeout,
	}
}

// NewExportMuteTimingParamsWithContext creates a new ExportMuteTimingParams object
// with the ability to set a context for a request.
func NewExportMuteTimingParamsWithContext(ctx context.Context) *ExportMuteTimingParams {
	return &ExportMuteTimingParams{
		Context: ctx,
	}
}

// NewExportMuteTimingParamsWithHTTPClient creates a new ExportMuteTimingParams object
// with the ability to set a custom HTTPClient for a request.
func NewExportMuteTimingParamsWithHTTPClient(client *http.Client) *ExportMuteTimingParams {
	return &ExportMuteTimingParams{
		HTTPClient: client,
	}
}

/*
ExportMuteTimingParams contains all the parameters to send to the API endpoint

	for the export mute timing operation.

	Typically these are written to a http.Request.
*/
type ExportMuteTimingParams struct {

	/* Download.

	   Whether to initiate a download of the file or not.
	*/
	Download *bool

	/* Format.

	   Format of the downloaded file. Supported yaml, json or hcl. Accept header can also be used, but the query parameter will take precedence.

	   Default: "yaml"
	*/
	Format *string

	/* Name.

	   Mute timing name
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the export mute timing params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExportMuteTimingParams) WithDefaults() *ExportMuteTimingParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the export mute timing params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ExportMuteTimingParams) SetDefaults() {
	var (
		downloadDefault = bool(false)

		formatDefault = string("yaml")
	)

	val := ExportMuteTimingParams{
		Download: &downloadDefault,
		Format:   &formatDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the export mute timing params
func (o *ExportMuteTimingParams) WithTimeout(timeout time.Duration) *ExportMuteTimingParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the export mute timing params
func (o *ExportMuteTimingParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the export mute timing params
func (o *ExportMuteTimingParams) WithContext(ctx context.Context) *ExportMuteTimingParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the export mute timing params
func (o *ExportMuteTimingParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the export mute timing params
func (o *ExportMuteTimingParams) WithHTTPClient(client *http.Client) *ExportMuteTimingParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the export mute timing params
func (o *ExportMuteTimingParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDownload adds the download to the export mute timing params
func (o *ExportMuteTimingParams) WithDownload(download *bool) *ExportMuteTimingParams {
	o.SetDownload(download)
	return o
}

// SetDownload adds the download to the export mute timing params
func (o *ExportMuteTimingParams) SetDownload(download *bool) {
	o.Download = download
}

// WithFormat adds the format to the export mute timing params
func (o *ExportMuteTimingParams) WithFormat(format *string) *ExportMuteTimingParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the export mute timing params
func (o *ExportMuteTimingParams) SetFormat(format *string) {
	o.Format = format
}

// WithName adds the name to the export mute timing params
func (o *ExportMuteTimingParams) WithName(name string) *ExportMuteTimingParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the export mute timing params
func (o *ExportMuteTimingParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *ExportMuteTimingParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Download != nil {

		// query param download
		var qrDownload bool

		if o.Download != nil {
			qrDownload = *o.Download
		}
		qDownload := swag.FormatBool(qrDownload)
		if qDownload != "" {

			if err := r.SetQueryParam("download", qDownload); err != nil {
				return err
			}
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
