// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetContactpointsExportParams creates a new GetContactpointsExportParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetContactpointsExportParams() *GetContactpointsExportParams {
	return &GetContactpointsExportParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetContactpointsExportParamsWithTimeout creates a new GetContactpointsExportParams object
// with the ability to set a timeout on a request.
func NewGetContactpointsExportParamsWithTimeout(timeout time.Duration) *GetContactpointsExportParams {
	return &GetContactpointsExportParams{
		timeout: timeout,
	}
}

// NewGetContactpointsExportParamsWithContext creates a new GetContactpointsExportParams object
// with the ability to set a context for a request.
func NewGetContactpointsExportParamsWithContext(ctx context.Context) *GetContactpointsExportParams {
	return &GetContactpointsExportParams{
		Context: ctx,
	}
}

// NewGetContactpointsExportParamsWithHTTPClient creates a new GetContactpointsExportParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetContactpointsExportParamsWithHTTPClient(client *http.Client) *GetContactpointsExportParams {
	return &GetContactpointsExportParams{
		HTTPClient: client,
	}
}

/*
GetContactpointsExportParams contains all the parameters to send to the API endpoint

	for the get contactpoints export operation.

	Typically these are written to a http.Request.
*/
type GetContactpointsExportParams struct {

	/* Decrypt.

	   Whether any contained secure settings should be decrypted or left redacted. Redacted settings will contain RedactedValue instead. Currently, only org admin can view decrypted secure settings.
	*/
	Decrypt *bool

	/* Download.

	   Whether to initiate a download of the file or not.
	*/
	Download *bool

	/* Format.

	   Format of the downloaded file. Supported yaml, json or hcl. Accept header can also be used, but the query parameter will take precedence.

	   Default: "yaml"
	*/
	Format *string

	/* Name.

	   Filter by name
	*/
	Name *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get contactpoints export params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetContactpointsExportParams) WithDefaults() *GetContactpointsExportParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get contactpoints export params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetContactpointsExportParams) SetDefaults() {
	var (
		decryptDefault = bool(false)

		downloadDefault = bool(false)

		formatDefault = string("yaml")
	)

	val := GetContactpointsExportParams{
		Decrypt:  &decryptDefault,
		Download: &downloadDefault,
		Format:   &formatDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get contactpoints export params
func (o *GetContactpointsExportParams) WithTimeout(timeout time.Duration) *GetContactpointsExportParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get contactpoints export params
func (o *GetContactpointsExportParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get contactpoints export params
func (o *GetContactpointsExportParams) WithContext(ctx context.Context) *GetContactpointsExportParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get contactpoints export params
func (o *GetContactpointsExportParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get contactpoints export params
func (o *GetContactpointsExportParams) WithHTTPClient(client *http.Client) *GetContactpointsExportParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get contactpoints export params
func (o *GetContactpointsExportParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDecrypt adds the decrypt to the get contactpoints export params
func (o *GetContactpointsExportParams) WithDecrypt(decrypt *bool) *GetContactpointsExportParams {
	o.SetDecrypt(decrypt)
	return o
}

// SetDecrypt adds the decrypt to the get contactpoints export params
func (o *GetContactpointsExportParams) SetDecrypt(decrypt *bool) {
	o.Decrypt = decrypt
}

// WithDownload adds the download to the get contactpoints export params
func (o *GetContactpointsExportParams) WithDownload(download *bool) *GetContactpointsExportParams {
	o.SetDownload(download)
	return o
}

// SetDownload adds the download to the get contactpoints export params
func (o *GetContactpointsExportParams) SetDownload(download *bool) {
	o.Download = download
}

// WithFormat adds the format to the get contactpoints export params
func (o *GetContactpointsExportParams) WithFormat(format *string) *GetContactpointsExportParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the get contactpoints export params
func (o *GetContactpointsExportParams) SetFormat(format *string) {
	o.Format = format
}

// WithName adds the name to the get contactpoints export params
func (o *GetContactpointsExportParams) WithName(name *string) *GetContactpointsExportParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the get contactpoints export params
func (o *GetContactpointsExportParams) SetName(name *string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *GetContactpointsExportParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Decrypt != nil {

		// query param decrypt
		var qrDecrypt bool

		if o.Decrypt != nil {
			qrDecrypt = *o.Decrypt
		}
		qDecrypt := swag.FormatBool(qrDecrypt)
		if qDecrypt != "" {

			if err := r.SetQueryParam("decrypt", qDecrypt); err != nil {
				return err
			}
		}
	}

	if o.Download != nil {

		// query param download
		var qrDownload bool

		if o.Download != nil {
			qrDownload = *o.Download
		}
		qDownload := swag.FormatBool(qrDownload)
		if qDownload != "" {

			if err := r.SetQueryParam("download", qDownload); err != nil {
				return err
			}
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
