// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// PutAlertRuleReader is a Reader for the PutAlertRule structure.
type PutAlertRuleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PutAlertRuleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPutAlertRuleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPutAlertRuleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /v1/provisioning/alert-rules/{UID}] PutAlertRule", response, response.Code())
	}
}

// NewPutAlertRuleOK creates a PutAlertRuleOK with default headers values
func NewPutAlertRuleOK() *PutAlertRuleOK {
	return &PutAlertRuleOK{}
}

/*
PutAlertRuleOK describes a response with status code 200, with default header values.

ProvisionedAlertRule
*/
type PutAlertRuleOK struct {
	Payload *models.ProvisionedAlertRule
}

// IsSuccess returns true when this put alert rule Ok response has a 2xx status code
func (o *PutAlertRuleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this put alert rule Ok response has a 3xx status code
func (o *PutAlertRuleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put alert rule Ok response has a 4xx status code
func (o *PutAlertRuleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this put alert rule Ok response has a 5xx status code
func (o *PutAlertRuleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this put alert rule Ok response a status code equal to that given
func (o *PutAlertRuleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the put alert rule Ok response
func (o *PutAlertRuleOK) Code() int {
	return 200
}

func (o *PutAlertRuleOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/alert-rules/{UID}][%d] putAlertRuleOk %s", 200, payload)
}

func (o *PutAlertRuleOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/alert-rules/{UID}][%d] putAlertRuleOk %s", 200, payload)
}

func (o *PutAlertRuleOK) GetPayload() *models.ProvisionedAlertRule {
	return o.Payload
}

func (o *PutAlertRuleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ProvisionedAlertRule)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPutAlertRuleBadRequest creates a PutAlertRuleBadRequest with default headers values
func NewPutAlertRuleBadRequest() *PutAlertRuleBadRequest {
	return &PutAlertRuleBadRequest{}
}

/*
PutAlertRuleBadRequest describes a response with status code 400, with default header values.

ValidationError
*/
type PutAlertRuleBadRequest struct {
	Payload *models.ValidationError
}

// IsSuccess returns true when this put alert rule bad request response has a 2xx status code
func (o *PutAlertRuleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put alert rule bad request response has a 3xx status code
func (o *PutAlertRuleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put alert rule bad request response has a 4xx status code
func (o *PutAlertRuleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this put alert rule bad request response has a 5xx status code
func (o *PutAlertRuleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this put alert rule bad request response a status code equal to that given
func (o *PutAlertRuleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the put alert rule bad request response
func (o *PutAlertRuleBadRequest) Code() int {
	return 400
}

func (o *PutAlertRuleBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/alert-rules/{UID}][%d] putAlertRuleBadRequest %s", 400, payload)
}

func (o *PutAlertRuleBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/alert-rules/{UID}][%d] putAlertRuleBadRequest %s", 400, payload)
}

func (o *PutAlertRuleBadRequest) GetPayload() *models.ValidationError {
	return o.Payload
}

func (o *PutAlertRuleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ValidationError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
