// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// PutTemplateReader is a Reader for the PutTemplate structure.
type PutTemplateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PutTemplateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 202:
		result := NewPutTemplateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPutTemplateBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewPutTemplateConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /v1/provisioning/templates/{name}] PutTemplate", response, response.Code())
	}
}

// NewPutTemplateAccepted creates a PutTemplateAccepted with default headers values
func NewPutTemplateAccepted() *PutTemplateAccepted {
	return &PutTemplateAccepted{}
}

/*
PutTemplateAccepted describes a response with status code 202, with default header values.

NotificationTemplate
*/
type PutTemplateAccepted struct {
	Payload *models.NotificationTemplate
}

// IsSuccess returns true when this put template accepted response has a 2xx status code
func (o *PutTemplateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this put template accepted response has a 3xx status code
func (o *PutTemplateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put template accepted response has a 4xx status code
func (o *PutTemplateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this put template accepted response has a 5xx status code
func (o *PutTemplateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this put template accepted response a status code equal to that given
func (o *PutTemplateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the put template accepted response
func (o *PutTemplateAccepted) Code() int {
	return 202
}

func (o *PutTemplateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/templates/{name}][%d] putTemplateAccepted %s", 202, payload)
}

func (o *PutTemplateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/templates/{name}][%d] putTemplateAccepted %s", 202, payload)
}

func (o *PutTemplateAccepted) GetPayload() *models.NotificationTemplate {
	return o.Payload
}

func (o *PutTemplateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.NotificationTemplate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPutTemplateBadRequest creates a PutTemplateBadRequest with default headers values
func NewPutTemplateBadRequest() *PutTemplateBadRequest {
	return &PutTemplateBadRequest{}
}

/*
PutTemplateBadRequest describes a response with status code 400, with default header values.

PublicError
*/
type PutTemplateBadRequest struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this put template bad request response has a 2xx status code
func (o *PutTemplateBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put template bad request response has a 3xx status code
func (o *PutTemplateBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put template bad request response has a 4xx status code
func (o *PutTemplateBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this put template bad request response has a 5xx status code
func (o *PutTemplateBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this put template bad request response a status code equal to that given
func (o *PutTemplateBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the put template bad request response
func (o *PutTemplateBadRequest) Code() int {
	return 400
}

func (o *PutTemplateBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/templates/{name}][%d] putTemplateBadRequest %s", 400, payload)
}

func (o *PutTemplateBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/templates/{name}][%d] putTemplateBadRequest %s", 400, payload)
}

func (o *PutTemplateBadRequest) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *PutTemplateBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPutTemplateConflict creates a PutTemplateConflict with default headers values
func NewPutTemplateConflict() *PutTemplateConflict {
	return &PutTemplateConflict{}
}

/*
PutTemplateConflict describes a response with status code 409, with default header values.

PublicError
*/
type PutTemplateConflict struct {
	Payload *models.PublicError
}

// IsSuccess returns true when this put template conflict response has a 2xx status code
func (o *PutTemplateConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put template conflict response has a 3xx status code
func (o *PutTemplateConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put template conflict response has a 4xx status code
func (o *PutTemplateConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this put template conflict response has a 5xx status code
func (o *PutTemplateConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this put template conflict response a status code equal to that given
func (o *PutTemplateConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the put template conflict response
func (o *PutTemplateConflict) Code() int {
	return 409
}

func (o *PutTemplateConflict) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/templates/{name}][%d] putTemplateConflict %s", 409, payload)
}

func (o *PutTemplateConflict) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/templates/{name}][%d] putTemplateConflict %s", 409, payload)
}

func (o *PutTemplateConflict) GetPayload() *models.PublicError {
	return o.Payload
}

func (o *PutTemplateConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PublicError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
