// Code generated by go-swagger; DO NOT EDIT.

package query_history

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SearchQueriesReader is a Reader for the SearchQueries structure.
type SearchQueriesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SearchQueriesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSearchQueriesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewSearchQueriesUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSearchQueriesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /query-history] searchQueries", response, response.Code())
	}
}

// NewSearchQueriesOK creates a SearchQueriesOK with default headers values
func NewSearchQueriesOK() *SearchQueriesOK {
	return &SearchQueriesOK{}
}

/*
SearchQueriesOK describes a response with status code 200, with default header values.

(empty)
*/
type SearchQueriesOK struct {
	Payload *models.QueryHistorySearchResponse
}

// IsSuccess returns true when this search queries Ok response has a 2xx status code
func (o *SearchQueriesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this search queries Ok response has a 3xx status code
func (o *SearchQueriesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search queries Ok response has a 4xx status code
func (o *SearchQueriesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this search queries Ok response has a 5xx status code
func (o *SearchQueriesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this search queries Ok response a status code equal to that given
func (o *SearchQueriesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the search queries Ok response
func (o *SearchQueriesOK) Code() int {
	return 200
}

func (o *SearchQueriesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /query-history][%d] searchQueriesOk %s", 200, payload)
}

func (o *SearchQueriesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /query-history][%d] searchQueriesOk %s", 200, payload)
}

func (o *SearchQueriesOK) GetPayload() *models.QueryHistorySearchResponse {
	return o.Payload
}

func (o *SearchQueriesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QueryHistorySearchResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchQueriesUnauthorized creates a SearchQueriesUnauthorized with default headers values
func NewSearchQueriesUnauthorized() *SearchQueriesUnauthorized {
	return &SearchQueriesUnauthorized{}
}

/*
SearchQueriesUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type SearchQueriesUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search queries unauthorized response has a 2xx status code
func (o *SearchQueriesUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search queries unauthorized response has a 3xx status code
func (o *SearchQueriesUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search queries unauthorized response has a 4xx status code
func (o *SearchQueriesUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this search queries unauthorized response has a 5xx status code
func (o *SearchQueriesUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this search queries unauthorized response a status code equal to that given
func (o *SearchQueriesUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the search queries unauthorized response
func (o *SearchQueriesUnauthorized) Code() int {
	return 401
}

func (o *SearchQueriesUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /query-history][%d] searchQueriesUnauthorized %s", 401, payload)
}

func (o *SearchQueriesUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /query-history][%d] searchQueriesUnauthorized %s", 401, payload)
}

func (o *SearchQueriesUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchQueriesUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchQueriesInternalServerError creates a SearchQueriesInternalServerError with default headers values
func NewSearchQueriesInternalServerError() *SearchQueriesInternalServerError {
	return &SearchQueriesInternalServerError{}
}

/*
SearchQueriesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SearchQueriesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search queries internal server error response has a 2xx status code
func (o *SearchQueriesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search queries internal server error response has a 3xx status code
func (o *SearchQueriesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search queries internal server error response has a 4xx status code
func (o *SearchQueriesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this search queries internal server error response has a 5xx status code
func (o *SearchQueriesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this search queries internal server error response a status code equal to that given
func (o *SearchQueriesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the search queries internal server error response
func (o *SearchQueriesInternalServerError) Code() int {
	return 500
}

func (o *SearchQueriesInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /query-history][%d] searchQueriesInternalServerError %s", 500, payload)
}

func (o *SearchQueriesInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /query-history][%d] searchQueriesInternalServerError %s", 500, payload)
}

func (o *SearchQueriesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchQueriesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
