// Code generated by go-swagger; DO NOT EDIT.

package signed_in_user

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewUserSetUsingOrgParams creates a new UserSetUsingOrgParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUserSetUsingOrgParams() *UserSetUsingOrgParams {
	return &UserSetUsingOrgParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUserSetUsingOrgParamsWithTimeout creates a new UserSetUsingOrgParams object
// with the ability to set a timeout on a request.
func NewUserSetUsingOrgParamsWithTimeout(timeout time.Duration) *UserSetUsingOrgParams {
	return &UserSetUsingOrgParams{
		timeout: timeout,
	}
}

// NewUserSetUsingOrgParamsWithContext creates a new UserSetUsingOrgParams object
// with the ability to set a context for a request.
func NewUserSetUsingOrgParamsWithContext(ctx context.Context) *UserSetUsingOrgParams {
	return &UserSetUsingOrgParams{
		Context: ctx,
	}
}

// NewUserSetUsingOrgParamsWithHTTPClient creates a new UserSetUsingOrgParams object
// with the ability to set a custom HTTPClient for a request.
func NewUserSetUsingOrgParamsWithHTTPClient(client *http.Client) *UserSetUsingOrgParams {
	return &UserSetUsingOrgParams{
		HTTPClient: client,
	}
}

/*
UserSetUsingOrgParams contains all the parameters to send to the API endpoint

	for the user set using org operation.

	Typically these are written to a http.Request.
*/
type UserSetUsingOrgParams struct {

	// OrgID.
	//
	// Format: int64
	OrgID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the user set using org params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UserSetUsingOrgParams) WithDefaults() *UserSetUsingOrgParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the user set using org params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UserSetUsingOrgParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the user set using org params
func (o *UserSetUsingOrgParams) WithTimeout(timeout time.Duration) *UserSetUsingOrgParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the user set using org params
func (o *UserSetUsingOrgParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the user set using org params
func (o *UserSetUsingOrgParams) WithContext(ctx context.Context) *UserSetUsingOrgParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the user set using org params
func (o *UserSetUsingOrgParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the user set using org params
func (o *UserSetUsingOrgParams) WithHTTPClient(client *http.Client) *UserSetUsingOrgParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the user set using org params
func (o *UserSetUsingOrgParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithOrgID adds the orgID to the user set using org params
func (o *UserSetUsingOrgParams) WithOrgID(orgID int64) *UserSetUsingOrgParams {
	o.SetOrgID(orgID)
	return o
}

// SetOrgID adds the orgId to the user set using org params
func (o *UserSetUsingOrgParams) SetOrgID(orgID int64) {
	o.OrgID = orgID
}

// WriteToRequest writes these params to a swagger request
func (o *UserSetUsingOrgParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param org_id
	if err := r.SetPathParam("org_id", swag.FormatInt64(o.OrgID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
