// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// AddOrgUserCommand add org user command
//
// swagger:model AddOrgUserCommand
type AddOrgUserCommand struct {

	// login or email
	LoginOrEmail string `json:"loginOrEmail,omitempty"`

	// role
	// Enum: [None Viewer Editor Admin]
	Role string `json:"role,omitempty"`
}

// Validate validates this add org user command
func (m *AddOrgUserCommand) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var addOrgUserCommandTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["None","Viewer","Editor","Admin"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		addOrgUserCommandTypeRolePropEnum = append(addOrgUserCommandTypeRolePropEnum, v)
	}
}

const (

	// AddOrgUserCommandRoleNone captures enum value "None"
	AddOrgUserCommandRoleNone string = "None"

	// AddOrgUserCommandRoleViewer captures enum value "Viewer"
	AddOrgUserCommandRoleViewer string = "Viewer"

	// AddOrgUserCommandRoleEditor captures enum value "Editor"
	AddOrgUserCommandRoleEditor string = "Editor"

	// AddOrgUserCommandRoleAdmin captures enum value "Admin"
	AddOrgUserCommandRoleAdmin string = "Admin"
)

// prop value enum
func (m *AddOrgUserCommand) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, addOrgUserCommandTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *AddOrgUserCommand) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(m.Role) { // not required
		return nil
	}

	// value enum
	if err := m.validateRoleEnum("role", "body", m.Role); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this add org user command based on context it is used
func (m *AddOrgUserCommand) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *AddOrgUserCommand) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *AddOrgUserCommand) UnmarshalBinary(b []byte) error {
	var res AddOrgUserCommand
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
