// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// InternalDataLink InternalDataLink definition to allow Explore links to be constructed in the backend
//
// swagger:model InternalDataLink
type InternalDataLink struct {

	// datasource name
	DatasourceName string `json:"datasourceName,omitempty"`

	// datasource Uid
	DatasourceUID string `json:"datasourceUid,omitempty"`

	// panels state
	PanelsState ExplorePanelsState `json:"panelsState,omitempty"`

	// query
	Query interface{} `json:"query,omitempty"`

	// time range
	TimeRange *TimeRange `json:"timeRange,omitempty"`

	// transformations
	Transformations []*LinkTransformationConfig `json:"transformations"`
}

// Validate validates this internal data link
func (m *InternalDataLink) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTimeRange(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTransformations(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *InternalDataLink) validateTimeRange(formats strfmt.Registry) error {
	if swag.IsZero(m.TimeRange) { // not required
		return nil
	}

	if m.TimeRange != nil {
		if err := m.TimeRange.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("timeRange")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("timeRange")
			}
			return err
		}
	}

	return nil
}

func (m *InternalDataLink) validateTransformations(formats strfmt.Registry) error {
	if swag.IsZero(m.Transformations) { // not required
		return nil
	}

	for i := 0; i < len(m.Transformations); i++ {
		if swag.IsZero(m.Transformations[i]) { // not required
			continue
		}

		if m.Transformations[i] != nil {
			if err := m.Transformations[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("transformations" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("transformations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this internal data link based on the context it is used
func (m *InternalDataLink) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateTimeRange(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTransformations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *InternalDataLink) contextValidateTimeRange(ctx context.Context, formats strfmt.Registry) error {

	if m.TimeRange != nil {

		if swag.IsZero(m.TimeRange) { // not required
			return nil
		}

		if err := m.TimeRange.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("timeRange")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("timeRange")
			}
			return err
		}
	}

	return nil
}

func (m *InternalDataLink) contextValidateTransformations(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Transformations); i++ {

		if m.Transformations[i] != nil {

			if swag.IsZero(m.Transformations[i]) { // not required
				return nil
			}

			if err := m.Transformations[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("transformations" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("transformations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *InternalDataLink) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *InternalDataLink) UnmarshalBinary(b []byte) error {
	var res InternalDataLink
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
