// Copyright 2019 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: grafeas/v1/vulnerability.proto

package grafeas

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A security vulnerability that can be found in resources.
type VulnerabilityNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10
	// where 0 indicates low severity and 10 indicates high severity.
	CvssScore float32 `protobuf:"fixed32,1,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// The note provider assigned severity of this vulnerability.
	Severity Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1.Severity" json:"severity,omitempty"`
	// Details of all known distros and packages affected by this vulnerability.
	Details []*VulnerabilityNote_Detail `protobuf:"bytes,3,rep,name=details,proto3" json:"details,omitempty"`
	// The full description of the CVSSv3 for this vulnerability.
	CvssV3 *CVSSv3 `protobuf:"bytes,4,opt,name=cvss_v3,json=cvssV3,proto3" json:"cvss_v3,omitempty"`
	// Windows details get their own format because the information format and
	// model don't match a normal detail. Specifically Windows updates are done as
	// patches, thus Windows vulnerabilities really are a missing package, rather
	// than a package being at an incorrect version.
	WindowsDetails []*VulnerabilityNote_WindowsDetail `protobuf:"bytes,5,rep,name=windows_details,json=windowsDetails,proto3" json:"windows_details,omitempty"`
	// The time this information was last changed at the source. This is an
	// upstream timestamp from the underlying information source - e.g. Ubuntu
	// security tracker.
	SourceUpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=source_update_time,json=sourceUpdateTime,proto3" json:"source_update_time,omitempty"`
	// CVSS version used to populate cvss_score and severity.
	CvssVersion CVSSVersion `protobuf:"varint,7,opt,name=cvss_version,json=cvssVersion,proto3,enum=grafeas.v1.CVSSVersion" json:"cvss_version,omitempty"`
	// The full description of the v2 CVSS for this vulnerability.
	CvssV2 *CVSS `protobuf:"bytes,8,opt,name=cvss_v2,json=cvssV2,proto3" json:"cvss_v2,omitempty"`
}

func (x *VulnerabilityNote) Reset() {
	*x = VulnerabilityNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_vulnerability_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityNote) ProtoMessage() {}

func (x *VulnerabilityNote) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_vulnerability_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityNote.ProtoReflect.Descriptor instead.
func (*VulnerabilityNote) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_vulnerability_proto_rawDescGZIP(), []int{0}
}

func (x *VulnerabilityNote) GetCvssScore() float32 {
	if x != nil {
		return x.CvssScore
	}
	return 0
}

func (x *VulnerabilityNote) GetSeverity() Severity {
	if x != nil {
		return x.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (x *VulnerabilityNote) GetDetails() []*VulnerabilityNote_Detail {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *VulnerabilityNote) GetCvssV3() *CVSSv3 {
	if x != nil {
		return x.CvssV3
	}
	return nil
}

func (x *VulnerabilityNote) GetWindowsDetails() []*VulnerabilityNote_WindowsDetail {
	if x != nil {
		return x.WindowsDetails
	}
	return nil
}

func (x *VulnerabilityNote) GetSourceUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SourceUpdateTime
	}
	return nil
}

func (x *VulnerabilityNote) GetCvssVersion() CVSSVersion {
	if x != nil {
		return x.CvssVersion
	}
	return CVSSVersion_CVSS_VERSION_UNSPECIFIED
}

func (x *VulnerabilityNote) GetCvssV2() *CVSS {
	if x != nil {
		return x.CvssV2
	}
	return nil
}

// An occurrence of a severity vulnerability on a resource.
type VulnerabilityOccurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of package; whether native or non native (e.g., ruby gems, node.js
	// packages, etc.).
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Output only. The note provider assigned severity of this vulnerability.
	Severity Severity `protobuf:"varint,2,opt,name=severity,proto3,enum=grafeas.v1.Severity" json:"severity,omitempty"`
	// Output only. The CVSS score of this vulnerability. CVSS score is on a
	// scale of 0 - 10 where 0 indicates low severity and 10 indicates high
	// severity.
	CvssScore float32 `protobuf:"fixed32,3,opt,name=cvss_score,json=cvssScore,proto3" json:"cvss_score,omitempty"`
	// The cvss v3 score for the vulnerability.
	Cvssv3 *CVSS `protobuf:"bytes,10,opt,name=cvssv3,proto3" json:"cvssv3,omitempty"`
	// Required. The set of affected locations and their fixes (if available)
	// within the associated resource.
	PackageIssue []*VulnerabilityOccurrence_PackageIssue `protobuf:"bytes,4,rep,name=package_issue,json=packageIssue,proto3" json:"package_issue,omitempty"`
	// Output only. A one sentence description of this vulnerability.
	ShortDescription string `protobuf:"bytes,5,opt,name=short_description,json=shortDescription,proto3" json:"short_description,omitempty"`
	// Output only. A detailed description of this vulnerability.
	LongDescription string `protobuf:"bytes,6,opt,name=long_description,json=longDescription,proto3" json:"long_description,omitempty"`
	// Output only. URLs related to this vulnerability.
	RelatedUrls []*RelatedUrl `protobuf:"bytes,7,rep,name=related_urls,json=relatedUrls,proto3" json:"related_urls,omitempty"`
	// The distro assigned severity for this vulnerability when it is available,
	// otherwise this is the note provider assigned severity.
	//
	// When there are multiple PackageIssues for this vulnerability, they can have
	// different effective severities because some might be provided by the distro
	// while others are provided by the language ecosystem for a language pack.
	// For this reason, it is advised to use the effective severity on the
	// PackageIssue level. In the case where multiple PackageIssues have differing
	// effective severities, this field should be the highest severity for any of
	// the PackageIssues.
	EffectiveSeverity Severity `protobuf:"varint,8,opt,name=effective_severity,json=effectiveSeverity,proto3,enum=grafeas.v1.Severity" json:"effective_severity,omitempty"`
	// Output only. Whether at least one of the affected packages has a fix
	// available.
	FixAvailable bool `protobuf:"varint,9,opt,name=fix_available,json=fixAvailable,proto3" json:"fix_available,omitempty"`
	// Output only. CVSS version used to populate cvss_score and severity.
	CvssVersion CVSSVersion `protobuf:"varint,11,opt,name=cvss_version,json=cvssVersion,proto3,enum=grafeas.v1.CVSSVersion" json:"cvss_version,omitempty"`
	// The cvss v2 score for the vulnerability.
	CvssV2        *CVSS                                  `protobuf:"bytes,12,opt,name=cvss_v2,json=cvssV2,proto3" json:"cvss_v2,omitempty"`
	VexAssessment *VulnerabilityOccurrence_VexAssessment `protobuf:"bytes,13,opt,name=vex_assessment,json=vexAssessment,proto3" json:"vex_assessment,omitempty"`
	// Occurrence-specific extra details about the vulnerability.
	ExtraDetails string `protobuf:"bytes,14,opt,name=extra_details,json=extraDetails,proto3" json:"extra_details,omitempty"`
}

func (x *VulnerabilityOccurrence) Reset() {
	*x = VulnerabilityOccurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_vulnerability_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityOccurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityOccurrence) ProtoMessage() {}

func (x *VulnerabilityOccurrence) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_vulnerability_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityOccurrence.ProtoReflect.Descriptor instead.
func (*VulnerabilityOccurrence) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_vulnerability_proto_rawDescGZIP(), []int{1}
}

func (x *VulnerabilityOccurrence) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *VulnerabilityOccurrence) GetSeverity() Severity {
	if x != nil {
		return x.Severity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (x *VulnerabilityOccurrence) GetCvssScore() float32 {
	if x != nil {
		return x.CvssScore
	}
	return 0
}

func (x *VulnerabilityOccurrence) GetCvssv3() *CVSS {
	if x != nil {
		return x.Cvssv3
	}
	return nil
}

func (x *VulnerabilityOccurrence) GetPackageIssue() []*VulnerabilityOccurrence_PackageIssue {
	if x != nil {
		return x.PackageIssue
	}
	return nil
}

func (x *VulnerabilityOccurrence) GetShortDescription() string {
	if x != nil {
		return x.ShortDescription
	}
	return ""
}

func (x *VulnerabilityOccurrence) GetLongDescription() string {
	if x != nil {
		return x.LongDescription
	}
	return ""
}

func (x *VulnerabilityOccurrence) GetRelatedUrls() []*RelatedUrl {
	if x != nil {
		return x.RelatedUrls
	}
	return nil
}

func (x *VulnerabilityOccurrence) GetEffectiveSeverity() Severity {
	if x != nil {
		return x.EffectiveSeverity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (x *VulnerabilityOccurrence) GetFixAvailable() bool {
	if x != nil {
		return x.FixAvailable
	}
	return false
}

func (x *VulnerabilityOccurrence) GetCvssVersion() CVSSVersion {
	if x != nil {
		return x.CvssVersion
	}
	return CVSSVersion_CVSS_VERSION_UNSPECIFIED
}

func (x *VulnerabilityOccurrence) GetCvssV2() *CVSS {
	if x != nil {
		return x.CvssV2
	}
	return nil
}

func (x *VulnerabilityOccurrence) GetVexAssessment() *VulnerabilityOccurrence_VexAssessment {
	if x != nil {
		return x.VexAssessment
	}
	return nil
}

func (x *VulnerabilityOccurrence) GetExtraDetails() string {
	if x != nil {
		return x.ExtraDetails
	}
	return ""
}

// A detail for a distro and package affected by this vulnerability and its
// associated fix (if one is available).
type VulnerabilityNote_Detail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The distro assigned severity of this vulnerability.
	SeverityName string `protobuf:"bytes,1,opt,name=severity_name,json=severityName,proto3" json:"severity_name,omitempty"`
	// A vendor-specific description of this vulnerability.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// The type of package; whether native or non native (e.g., ruby gems,
	// node.js packages, etc.).
	PackageType string `protobuf:"bytes,3,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	// Required. The [CPE URI](https://cpe.mitre.org/specification/) this
	// vulnerability affects.
	AffectedCpeUri string `protobuf:"bytes,4,opt,name=affected_cpe_uri,json=affectedCpeUri,proto3" json:"affected_cpe_uri,omitempty"`
	// Required. The package this vulnerability affects.
	AffectedPackage string `protobuf:"bytes,5,opt,name=affected_package,json=affectedPackage,proto3" json:"affected_package,omitempty"`
	// The version number at the start of an interval in which this
	// vulnerability exists. A vulnerability can affect a package between
	// version numbers that are disjoint sets of intervals (example:
	// [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be
	// represented in its own Detail. If a specific affected version is provided
	// by a vulnerability database, affected_version_start and
	// affected_version_end will be the same in that Detail.
	AffectedVersionStart *Version `protobuf:"bytes,6,opt,name=affected_version_start,json=affectedVersionStart,proto3" json:"affected_version_start,omitempty"`
	// The version number at the end of an interval in which this vulnerability
	// exists. A vulnerability can affect a package between version numbers
	// that are disjoint sets of intervals (example: [1.0.0-1.1.0],
	// [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be represented in its
	// own Detail. If a specific affected version is provided by a vulnerability
	// database, affected_version_start and affected_version_end will be the
	// same in that Detail.
	AffectedVersionEnd *Version `protobuf:"bytes,7,opt,name=affected_version_end,json=affectedVersionEnd,proto3" json:"affected_version_end,omitempty"`
	// The distro recommended [CPE URI](https://cpe.mitre.org/specification/)
	// to update to that contains a fix for this vulnerability. It is possible
	// for this to be different from the affected_cpe_uri.
	FixedCpeUri string `protobuf:"bytes,8,opt,name=fixed_cpe_uri,json=fixedCpeUri,proto3" json:"fixed_cpe_uri,omitempty"`
	// The distro recommended package to update to that contains a fix for this
	// vulnerability. It is possible for this to be different from the
	// affected_package.
	FixedPackage string `protobuf:"bytes,9,opt,name=fixed_package,json=fixedPackage,proto3" json:"fixed_package,omitempty"`
	// The distro recommended version to update to that contains a
	// fix for this vulnerability. Setting this to VersionKind.MAXIMUM means no
	// such version is yet available.
	FixedVersion *Version `protobuf:"bytes,10,opt,name=fixed_version,json=fixedVersion,proto3" json:"fixed_version,omitempty"`
	// Whether this detail is obsolete. Occurrences are expected not to point to
	// obsolete details.
	IsObsolete bool `protobuf:"varint,11,opt,name=is_obsolete,json=isObsolete,proto3" json:"is_obsolete,omitempty"`
	// The time this information was last changed at the source. This is an
	// upstream timestamp from the underlying information source - e.g. Ubuntu
	// security tracker.
	SourceUpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=source_update_time,json=sourceUpdateTime,proto3" json:"source_update_time,omitempty"`
	// The source from which the information in this Detail was obtained.
	Source string `protobuf:"bytes,13,opt,name=source,proto3" json:"source,omitempty"`
	// The name of the vendor of the product.
	Vendor string `protobuf:"bytes,14,opt,name=vendor,proto3" json:"vendor,omitempty"`
}

func (x *VulnerabilityNote_Detail) Reset() {
	*x = VulnerabilityNote_Detail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_vulnerability_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityNote_Detail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityNote_Detail) ProtoMessage() {}

func (x *VulnerabilityNote_Detail) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_vulnerability_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityNote_Detail.ProtoReflect.Descriptor instead.
func (*VulnerabilityNote_Detail) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_vulnerability_proto_rawDescGZIP(), []int{0, 0}
}

func (x *VulnerabilityNote_Detail) GetSeverityName() string {
	if x != nil {
		return x.SeverityName
	}
	return ""
}

func (x *VulnerabilityNote_Detail) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *VulnerabilityNote_Detail) GetPackageType() string {
	if x != nil {
		return x.PackageType
	}
	return ""
}

func (x *VulnerabilityNote_Detail) GetAffectedCpeUri() string {
	if x != nil {
		return x.AffectedCpeUri
	}
	return ""
}

func (x *VulnerabilityNote_Detail) GetAffectedPackage() string {
	if x != nil {
		return x.AffectedPackage
	}
	return ""
}

func (x *VulnerabilityNote_Detail) GetAffectedVersionStart() *Version {
	if x != nil {
		return x.AffectedVersionStart
	}
	return nil
}

func (x *VulnerabilityNote_Detail) GetAffectedVersionEnd() *Version {
	if x != nil {
		return x.AffectedVersionEnd
	}
	return nil
}

func (x *VulnerabilityNote_Detail) GetFixedCpeUri() string {
	if x != nil {
		return x.FixedCpeUri
	}
	return ""
}

func (x *VulnerabilityNote_Detail) GetFixedPackage() string {
	if x != nil {
		return x.FixedPackage
	}
	return ""
}

func (x *VulnerabilityNote_Detail) GetFixedVersion() *Version {
	if x != nil {
		return x.FixedVersion
	}
	return nil
}

func (x *VulnerabilityNote_Detail) GetIsObsolete() bool {
	if x != nil {
		return x.IsObsolete
	}
	return false
}

func (x *VulnerabilityNote_Detail) GetSourceUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SourceUpdateTime
	}
	return nil
}

func (x *VulnerabilityNote_Detail) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *VulnerabilityNote_Detail) GetVendor() string {
	if x != nil {
		return x.Vendor
	}
	return ""
}

type VulnerabilityNote_WindowsDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [CPE URI](https://cpe.mitre.org/specification/) this
	// vulnerability affects.
	CpeUri string `protobuf:"bytes,1,opt,name=cpe_uri,json=cpeUri,proto3" json:"cpe_uri,omitempty"`
	// Required. The name of this vulnerability.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The description of this vulnerability.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The names of the KBs which have hotfixes to mitigate this
	// vulnerability. Note that there may be multiple hotfixes (and thus
	// multiple KBs) that mitigate a given vulnerability. Currently any listed
	// KBs presence is considered a fix.
	FixingKbs []*VulnerabilityNote_WindowsDetail_KnowledgeBase `protobuf:"bytes,4,rep,name=fixing_kbs,json=fixingKbs,proto3" json:"fixing_kbs,omitempty"`
}

func (x *VulnerabilityNote_WindowsDetail) Reset() {
	*x = VulnerabilityNote_WindowsDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_vulnerability_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityNote_WindowsDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityNote_WindowsDetail) ProtoMessage() {}

func (x *VulnerabilityNote_WindowsDetail) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_vulnerability_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityNote_WindowsDetail.ProtoReflect.Descriptor instead.
func (*VulnerabilityNote_WindowsDetail) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_vulnerability_proto_rawDescGZIP(), []int{0, 1}
}

func (x *VulnerabilityNote_WindowsDetail) GetCpeUri() string {
	if x != nil {
		return x.CpeUri
	}
	return ""
}

func (x *VulnerabilityNote_WindowsDetail) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VulnerabilityNote_WindowsDetail) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *VulnerabilityNote_WindowsDetail) GetFixingKbs() []*VulnerabilityNote_WindowsDetail_KnowledgeBase {
	if x != nil {
		return x.FixingKbs
	}
	return nil
}

type VulnerabilityNote_WindowsDetail_KnowledgeBase struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The KB name (generally of the form KB[0-9]+ (e.g., KB123456)).
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A link to the KB in the [Windows update catalog]
	// (https://www.catalog.update.microsoft.com/).
	Url string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
}

func (x *VulnerabilityNote_WindowsDetail_KnowledgeBase) Reset() {
	*x = VulnerabilityNote_WindowsDetail_KnowledgeBase{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_vulnerability_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityNote_WindowsDetail_KnowledgeBase) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityNote_WindowsDetail_KnowledgeBase) ProtoMessage() {}

func (x *VulnerabilityNote_WindowsDetail_KnowledgeBase) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_vulnerability_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityNote_WindowsDetail_KnowledgeBase.ProtoReflect.Descriptor instead.
func (*VulnerabilityNote_WindowsDetail_KnowledgeBase) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_vulnerability_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *VulnerabilityNote_WindowsDetail_KnowledgeBase) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VulnerabilityNote_WindowsDetail_KnowledgeBase) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

// A detail for a distro and package this vulnerability occurrence was found
// in and its associated fix (if one is available).
type VulnerabilityOccurrence_PackageIssue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [CPE URI](https://cpe.mitre.org/specification/) this
	// vulnerability was found in.
	AffectedCpeUri string `protobuf:"bytes,1,opt,name=affected_cpe_uri,json=affectedCpeUri,proto3" json:"affected_cpe_uri,omitempty"`
	// Required. The package this vulnerability was found in.
	AffectedPackage string `protobuf:"bytes,2,opt,name=affected_package,json=affectedPackage,proto3" json:"affected_package,omitempty"`
	// Required. The version of the package that is installed on the resource
	// affected by this vulnerability.
	AffectedVersion *Version `protobuf:"bytes,3,opt,name=affected_version,json=affectedVersion,proto3" json:"affected_version,omitempty"`
	// The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability
	// was fixed in. It is possible for this to be different from the
	// affected_cpe_uri.
	FixedCpeUri string `protobuf:"bytes,4,opt,name=fixed_cpe_uri,json=fixedCpeUri,proto3" json:"fixed_cpe_uri,omitempty"`
	// The package this vulnerability was fixed in. It is possible for this to
	// be different from the affected_package.
	FixedPackage string `protobuf:"bytes,5,opt,name=fixed_package,json=fixedPackage,proto3" json:"fixed_package,omitempty"`
	// Required. The version of the package this vulnerability was fixed in.
	// Setting this to VersionKind.MAXIMUM means no fix is yet available.
	FixedVersion *Version `protobuf:"bytes,6,opt,name=fixed_version,json=fixedVersion,proto3" json:"fixed_version,omitempty"`
	// Output only. Whether a fix is available for this package.
	FixAvailable bool `protobuf:"varint,7,opt,name=fix_available,json=fixAvailable,proto3" json:"fix_available,omitempty"`
	// The type of package (e.g. OS, MAVEN, GO).
	PackageType string `protobuf:"bytes,8,opt,name=package_type,json=packageType,proto3" json:"package_type,omitempty"`
	// The distro or language system assigned severity for this vulnerability
	// when that is available and note provider assigned severity when it is not
	// available.
	EffectiveSeverity Severity `protobuf:"varint,9,opt,name=effective_severity,json=effectiveSeverity,proto3,enum=grafeas.v1.Severity" json:"effective_severity,omitempty"`
	// The location at which this package was found.
	FileLocation []*FileLocation `protobuf:"bytes,10,rep,name=file_location,json=fileLocation,proto3" json:"file_location,omitempty"`
}

func (x *VulnerabilityOccurrence_PackageIssue) Reset() {
	*x = VulnerabilityOccurrence_PackageIssue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_vulnerability_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityOccurrence_PackageIssue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityOccurrence_PackageIssue) ProtoMessage() {}

func (x *VulnerabilityOccurrence_PackageIssue) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_vulnerability_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityOccurrence_PackageIssue.ProtoReflect.Descriptor instead.
func (*VulnerabilityOccurrence_PackageIssue) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_vulnerability_proto_rawDescGZIP(), []int{1, 0}
}

func (x *VulnerabilityOccurrence_PackageIssue) GetAffectedCpeUri() string {
	if x != nil {
		return x.AffectedCpeUri
	}
	return ""
}

func (x *VulnerabilityOccurrence_PackageIssue) GetAffectedPackage() string {
	if x != nil {
		return x.AffectedPackage
	}
	return ""
}

func (x *VulnerabilityOccurrence_PackageIssue) GetAffectedVersion() *Version {
	if x != nil {
		return x.AffectedVersion
	}
	return nil
}

func (x *VulnerabilityOccurrence_PackageIssue) GetFixedCpeUri() string {
	if x != nil {
		return x.FixedCpeUri
	}
	return ""
}

func (x *VulnerabilityOccurrence_PackageIssue) GetFixedPackage() string {
	if x != nil {
		return x.FixedPackage
	}
	return ""
}

func (x *VulnerabilityOccurrence_PackageIssue) GetFixedVersion() *Version {
	if x != nil {
		return x.FixedVersion
	}
	return nil
}

func (x *VulnerabilityOccurrence_PackageIssue) GetFixAvailable() bool {
	if x != nil {
		return x.FixAvailable
	}
	return false
}

func (x *VulnerabilityOccurrence_PackageIssue) GetPackageType() string {
	if x != nil {
		return x.PackageType
	}
	return ""
}

func (x *VulnerabilityOccurrence_PackageIssue) GetEffectiveSeverity() Severity {
	if x != nil {
		return x.EffectiveSeverity
	}
	return Severity_SEVERITY_UNSPECIFIED
}

func (x *VulnerabilityOccurrence_PackageIssue) GetFileLocation() []*FileLocation {
	if x != nil {
		return x.FileLocation
	}
	return nil
}

// VexAssessment provides all publisher provided Vex information that is
// related to this vulnerability.
type VulnerabilityOccurrence_VexAssessment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Holds the MITRE standard Common Vulnerabilities and Exposures (CVE)
	// tracking number for the vulnerability.
	// Deprecated: Use vulnerability_id instead to denote CVEs.
	//
	// Deprecated: Do not use.
	Cve string `protobuf:"bytes,1,opt,name=cve,proto3" json:"cve,omitempty"`
	// The vulnerability identifier for this Assessment. Will hold one of
	// common identifiers e.g. CVE, GHSA etc.
	VulnerabilityId string `protobuf:"bytes,8,opt,name=vulnerability_id,json=vulnerabilityId,proto3" json:"vulnerability_id,omitempty"`
	// Holds a list of references associated with this vulnerability item and
	// assessment.
	RelatedUris []*RelatedUrl `protobuf:"bytes,2,rep,name=related_uris,json=relatedUris,proto3" json:"related_uris,omitempty"`
	// The VulnerabilityAssessment note from which this VexAssessment was
	// generated.
	// This will be of the form: `projects/[PROJECT_ID]/notes/[NOTE_ID]`.
	// (-- api-linter: core::0122::name-suffix=disabled
	//
	//	aip.dev/not-precedent: The suffix is kept for consistency. --)
	NoteName string `protobuf:"bytes,3,opt,name=note_name,json=noteName,proto3" json:"note_name,omitempty"`
	// Provides the state of this Vulnerability assessment.
	State VulnerabilityAssessmentNote_Assessment_State `protobuf:"varint,4,opt,name=state,proto3,enum=grafeas.v1.VulnerabilityAssessmentNote_Assessment_State" json:"state,omitempty"`
	// Contains information about the impact of this vulnerability,
	// this will change with time.
	Impacts []string `protobuf:"bytes,5,rep,name=impacts,proto3" json:"impacts,omitempty"`
	// Specifies details on how to handle (and presumably, fix) a vulnerability.
	Remediations []*VulnerabilityAssessmentNote_Assessment_Remediation `protobuf:"bytes,6,rep,name=remediations,proto3" json:"remediations,omitempty"`
	// Justification provides the justification when the state of the
	// assessment if NOT_AFFECTED.
	Justification *VulnerabilityAssessmentNote_Assessment_Justification `protobuf:"bytes,7,opt,name=justification,proto3" json:"justification,omitempty"`
}

func (x *VulnerabilityOccurrence_VexAssessment) Reset() {
	*x = VulnerabilityOccurrence_VexAssessment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_grafeas_v1_vulnerability_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VulnerabilityOccurrence_VexAssessment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VulnerabilityOccurrence_VexAssessment) ProtoMessage() {}

func (x *VulnerabilityOccurrence_VexAssessment) ProtoReflect() protoreflect.Message {
	mi := &file_grafeas_v1_vulnerability_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VulnerabilityOccurrence_VexAssessment.ProtoReflect.Descriptor instead.
func (*VulnerabilityOccurrence_VexAssessment) Descriptor() ([]byte, []int) {
	return file_grafeas_v1_vulnerability_proto_rawDescGZIP(), []int{1, 1}
}

// Deprecated: Do not use.
func (x *VulnerabilityOccurrence_VexAssessment) GetCve() string {
	if x != nil {
		return x.Cve
	}
	return ""
}

func (x *VulnerabilityOccurrence_VexAssessment) GetVulnerabilityId() string {
	if x != nil {
		return x.VulnerabilityId
	}
	return ""
}

func (x *VulnerabilityOccurrence_VexAssessment) GetRelatedUris() []*RelatedUrl {
	if x != nil {
		return x.RelatedUris
	}
	return nil
}

func (x *VulnerabilityOccurrence_VexAssessment) GetNoteName() string {
	if x != nil {
		return x.NoteName
	}
	return ""
}

func (x *VulnerabilityOccurrence_VexAssessment) GetState() VulnerabilityAssessmentNote_Assessment_State {
	if x != nil {
		return x.State
	}
	return VulnerabilityAssessmentNote_Assessment_STATE_UNSPECIFIED
}

func (x *VulnerabilityOccurrence_VexAssessment) GetImpacts() []string {
	if x != nil {
		return x.Impacts
	}
	return nil
}

func (x *VulnerabilityOccurrence_VexAssessment) GetRemediations() []*VulnerabilityAssessmentNote_Assessment_Remediation {
	if x != nil {
		return x.Remediations
	}
	return nil
}

func (x *VulnerabilityOccurrence_VexAssessment) GetJustification() *VulnerabilityAssessmentNote_Assessment_Justification {
	if x != nil {
		return x.Justification
	}
	return nil
}

var File_grafeas_v1_vulnerability_proto protoreflect.FileDescriptor

var file_grafeas_v1_vulnerability_proto_rawDesc = []byte{
	0x0a, 0x1e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x75, 0x6c,
	0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x0a, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x15, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x76, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x14, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x76, 0x31, 0x2f,
	0x76, 0x65, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc4, 0x0a, 0x0a, 0x11, 0x56, 0x75,
	0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4e, 0x6f, 0x74, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x63, 0x76, 0x73, 0x73, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x09, 0x63, 0x76, 0x73, 0x73, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x30,
	0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x14, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x12, 0x3e, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x24, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4e, 0x6f, 0x74, 0x65,
	0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x2b, 0x0a, 0x07, 0x63, 0x76, 0x73, 0x73, 0x5f, 0x76, 0x33, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x56, 0x53, 0x53, 0x76, 0x33, 0x52, 0x06, 0x63, 0x76, 0x73, 0x73, 0x56, 0x33, 0x12, 0x54, 0x0a,
	0x0f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x4e, 0x6f, 0x74, 0x65, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x52, 0x0e, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x48, 0x0a, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x0c, 0x63, 0x76, 0x73, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x56, 0x53, 0x53, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x63, 0x76,
	0x73, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x07, 0x63, 0x76, 0x73,
	0x73, 0x5f, 0x76, 0x32, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53, 0x52, 0x06, 0x63, 0x76,
	0x73, 0x73, 0x56, 0x32, 0x1a, 0xf7, 0x04, 0x0a, 0x06, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12,
	0x23, 0x0a, 0x0d, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x43, 0x70, 0x65,
	0x55, 0x72, 0x69, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x49,
	0x0a, 0x16, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x14, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x12, 0x45, 0x0a, 0x14, 0x61, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e,
	0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x61, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x64,
	0x12, 0x22, 0x0a, 0x0d, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x63, 0x70, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x66, 0x69, 0x78, 0x65, 0x64, 0x43, 0x70,
	0x65, 0x55, 0x72, 0x69, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x70, 0x61,
	0x63, 0x6b, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x38, 0x0a, 0x0d, 0x66, 0x69, 0x78,
	0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x66, 0x69, 0x78, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x6f, 0x62, 0x73, 0x6f, 0x6c, 0x65,
	0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x4f, 0x62, 0x73, 0x6f,
	0x6c, 0x65, 0x74, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x65, 0x6e, 0x64, 0x6f, 0x72, 0x1a, 0xef,
	0x01, 0x0a, 0x0d, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x12, 0x17, 0x0a, 0x07, 0x63, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x63, 0x70, 0x65, 0x55, 0x72, 0x69, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x58, 0x0a, 0x0a, 0x66, 0x69, 0x78, 0x69, 0x6e, 0x67, 0x5f, 0x6b, 0x62, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4e, 0x6f,
	0x74, 0x65, 0x2e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x52, 0x09,
	0x66, 0x69, 0x78, 0x69, 0x6e, 0x67, 0x4b, 0x62, 0x73, 0x1a, 0x35, 0x0a, 0x0d, 0x4b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x42, 0x61, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10,
	0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c,
	0x22, 0xbd, 0x0d, 0x0a, 0x17, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x30, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x14, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69,
	0x74, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x63, 0x76, 0x73, 0x73, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x63, 0x76, 0x73, 0x73, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x12, 0x28, 0x0a, 0x06, 0x63, 0x76, 0x73, 0x73, 0x76, 0x33, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x10, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x56, 0x53, 0x53, 0x52, 0x06, 0x63, 0x76, 0x73, 0x73, 0x76, 0x33, 0x12, 0x55, 0x0a, 0x0d, 0x70,
	0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x65, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4f, 0x63, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49,
	0x73, 0x73, 0x75, 0x65, 0x52, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x49, 0x73, 0x73,
	0x75, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x73,
	0x68, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x29, 0x0a, 0x10, 0x6c, 0x6f, 0x6e, 0x67, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x6c, 0x6f, 0x6e, 0x67, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0c, 0x72, 0x65,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x52, 0x0b, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65,
	0x64, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x43, 0x0a, 0x12, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x14, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x11, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x69,
	0x78, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0c, 0x66, 0x69, 0x78, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x12,
	0x3a, 0x0a, 0x0c, 0x63, 0x76, 0x73, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x17, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x63, 0x76, 0x73, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x07, 0x63,
	0x76, 0x73, 0x73, 0x5f, 0x76, 0x32, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x56, 0x53, 0x53, 0x52, 0x06,
	0x63, 0x76, 0x73, 0x73, 0x56, 0x32, 0x12, 0x58, 0x0a, 0x0e, 0x76, 0x65, 0x78, 0x5f, 0x61, 0x73,
	0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e,
	0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x2e, 0x56, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x0d, 0x76, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x23, 0x0a, 0x0d, 0x65, 0x78, 0x74, 0x72, 0x61, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x78, 0x74, 0x72, 0x61, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0xf7, 0x03, 0x0a, 0x0c, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67,
	0x65, 0x49, 0x73, 0x73, 0x75, 0x65, 0x12, 0x28, 0x0a, 0x10, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x63, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x43, 0x70, 0x65, 0x55, 0x72, 0x69,
	0x12, 0x29, 0x0a, 0x10, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x50, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x12, 0x3e, 0x0a, 0x10, 0x61,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x61, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x22, 0x0a, 0x0d, 0x66,
	0x69, 0x78, 0x65, 0x64, 0x5f, 0x63, 0x70, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x66, 0x69, 0x78, 0x65, 0x64, 0x43, 0x70, 0x65, 0x55, 0x72, 0x69, 0x12,
	0x23, 0x0a, 0x0d, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x66, 0x69, 0x78, 0x65, 0x64, 0x50, 0x61, 0x63,
	0x6b, 0x61, 0x67, 0x65, 0x12, 0x38, 0x0a, 0x0d, 0x66, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x0c, 0x66, 0x69, 0x78, 0x65, 0x64, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x23,
	0x0a, 0x0d, 0x66, 0x69, 0x78, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x66, 0x69, 0x78, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61,
	0x62, 0x6c, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x63, 0x6b, 0x61,
	0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x48, 0x0a, 0x12, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x14, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x65,
	0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79,
	0x12, 0x3d, 0x0a, 0x0d, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0c, 0x66, 0x69, 0x6c, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0xde, 0x03, 0x0a, 0x0d, 0x56, 0x65, 0x78, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x14, 0x0a, 0x03, 0x63, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x03, 0x63, 0x76, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x76, 0x75, 0x6c, 0x6e, 0x65,
	0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x49, 0x64, 0x12, 0x39, 0x0a, 0x0c, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x75, 0x72,
	0x69, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x55, 0x72, 0x6c,
	0x52, 0x0b, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x55, 0x72, 0x69, 0x73, 0x12, 0x1b, 0x0a,
	0x09, 0x6e, 0x6f, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x6e, 0x6f, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f,
	0x74, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x69, 0x6d,
	0x70, 0x61, 0x63, 0x74, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x69, 0x6d, 0x70,
	0x61, 0x63, 0x74, 0x73, 0x12, 0x62, 0x0a, 0x0c, 0x72, 0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x4e,
	0x6f, 0x74, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52,
	0x65, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x6d, 0x65,
	0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x66, 0x0a, 0x0d, 0x6a, 0x75, 0x73, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x40, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x75, 0x6c,
	0x6e, 0x65, 0x72, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73,
	0x6d, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x74, 0x65, 0x2e, 0x41, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x51, 0x0a, 0x0d, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x50, 0x01, 0x5a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61,
	0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0xa2, 0x02, 0x03,
	0x47, 0x52, 0x41, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_grafeas_v1_vulnerability_proto_rawDescOnce sync.Once
	file_grafeas_v1_vulnerability_proto_rawDescData = file_grafeas_v1_vulnerability_proto_rawDesc
)

func file_grafeas_v1_vulnerability_proto_rawDescGZIP() []byte {
	file_grafeas_v1_vulnerability_proto_rawDescOnce.Do(func() {
		file_grafeas_v1_vulnerability_proto_rawDescData = protoimpl.X.CompressGZIP(file_grafeas_v1_vulnerability_proto_rawDescData)
	})
	return file_grafeas_v1_vulnerability_proto_rawDescData
}

var file_grafeas_v1_vulnerability_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_grafeas_v1_vulnerability_proto_goTypes = []interface{}{
	(*VulnerabilityNote)(nil),                             // 0: grafeas.v1.VulnerabilityNote
	(*VulnerabilityOccurrence)(nil),                       // 1: grafeas.v1.VulnerabilityOccurrence
	(*VulnerabilityNote_Detail)(nil),                      // 2: grafeas.v1.VulnerabilityNote.Detail
	(*VulnerabilityNote_WindowsDetail)(nil),               // 3: grafeas.v1.VulnerabilityNote.WindowsDetail
	(*VulnerabilityNote_WindowsDetail_KnowledgeBase)(nil), // 4: grafeas.v1.VulnerabilityNote.WindowsDetail.KnowledgeBase
	(*VulnerabilityOccurrence_PackageIssue)(nil),          // 5: grafeas.v1.VulnerabilityOccurrence.PackageIssue
	(*VulnerabilityOccurrence_VexAssessment)(nil),         // 6: grafeas.v1.VulnerabilityOccurrence.VexAssessment
	(Severity)(0),                 // 7: grafeas.v1.Severity
	(*CVSSv3)(nil),                // 8: grafeas.v1.CVSSv3
	(*timestamppb.Timestamp)(nil), // 9: google.protobuf.Timestamp
	(CVSSVersion)(0),              // 10: grafeas.v1.CVSSVersion
	(*CVSS)(nil),                  // 11: grafeas.v1.CVSS
	(*RelatedUrl)(nil),            // 12: grafeas.v1.RelatedUrl
	(*Version)(nil),               // 13: grafeas.v1.Version
	(*FileLocation)(nil),          // 14: grafeas.v1.FileLocation
	(VulnerabilityAssessmentNote_Assessment_State)(0),            // 15: grafeas.v1.VulnerabilityAssessmentNote.Assessment.State
	(*VulnerabilityAssessmentNote_Assessment_Remediation)(nil),   // 16: grafeas.v1.VulnerabilityAssessmentNote.Assessment.Remediation
	(*VulnerabilityAssessmentNote_Assessment_Justification)(nil), // 17: grafeas.v1.VulnerabilityAssessmentNote.Assessment.Justification
}
var file_grafeas_v1_vulnerability_proto_depIdxs = []int32{
	7,  // 0: grafeas.v1.VulnerabilityNote.severity:type_name -> grafeas.v1.Severity
	2,  // 1: grafeas.v1.VulnerabilityNote.details:type_name -> grafeas.v1.VulnerabilityNote.Detail
	8,  // 2: grafeas.v1.VulnerabilityNote.cvss_v3:type_name -> grafeas.v1.CVSSv3
	3,  // 3: grafeas.v1.VulnerabilityNote.windows_details:type_name -> grafeas.v1.VulnerabilityNote.WindowsDetail
	9,  // 4: grafeas.v1.VulnerabilityNote.source_update_time:type_name -> google.protobuf.Timestamp
	10, // 5: grafeas.v1.VulnerabilityNote.cvss_version:type_name -> grafeas.v1.CVSSVersion
	11, // 6: grafeas.v1.VulnerabilityNote.cvss_v2:type_name -> grafeas.v1.CVSS
	7,  // 7: grafeas.v1.VulnerabilityOccurrence.severity:type_name -> grafeas.v1.Severity
	11, // 8: grafeas.v1.VulnerabilityOccurrence.cvssv3:type_name -> grafeas.v1.CVSS
	5,  // 9: grafeas.v1.VulnerabilityOccurrence.package_issue:type_name -> grafeas.v1.VulnerabilityOccurrence.PackageIssue
	12, // 10: grafeas.v1.VulnerabilityOccurrence.related_urls:type_name -> grafeas.v1.RelatedUrl
	7,  // 11: grafeas.v1.VulnerabilityOccurrence.effective_severity:type_name -> grafeas.v1.Severity
	10, // 12: grafeas.v1.VulnerabilityOccurrence.cvss_version:type_name -> grafeas.v1.CVSSVersion
	11, // 13: grafeas.v1.VulnerabilityOccurrence.cvss_v2:type_name -> grafeas.v1.CVSS
	6,  // 14: grafeas.v1.VulnerabilityOccurrence.vex_assessment:type_name -> grafeas.v1.VulnerabilityOccurrence.VexAssessment
	13, // 15: grafeas.v1.VulnerabilityNote.Detail.affected_version_start:type_name -> grafeas.v1.Version
	13, // 16: grafeas.v1.VulnerabilityNote.Detail.affected_version_end:type_name -> grafeas.v1.Version
	13, // 17: grafeas.v1.VulnerabilityNote.Detail.fixed_version:type_name -> grafeas.v1.Version
	9,  // 18: grafeas.v1.VulnerabilityNote.Detail.source_update_time:type_name -> google.protobuf.Timestamp
	4,  // 19: grafeas.v1.VulnerabilityNote.WindowsDetail.fixing_kbs:type_name -> grafeas.v1.VulnerabilityNote.WindowsDetail.KnowledgeBase
	13, // 20: grafeas.v1.VulnerabilityOccurrence.PackageIssue.affected_version:type_name -> grafeas.v1.Version
	13, // 21: grafeas.v1.VulnerabilityOccurrence.PackageIssue.fixed_version:type_name -> grafeas.v1.Version
	7,  // 22: grafeas.v1.VulnerabilityOccurrence.PackageIssue.effective_severity:type_name -> grafeas.v1.Severity
	14, // 23: grafeas.v1.VulnerabilityOccurrence.PackageIssue.file_location:type_name -> grafeas.v1.FileLocation
	12, // 24: grafeas.v1.VulnerabilityOccurrence.VexAssessment.related_uris:type_name -> grafeas.v1.RelatedUrl
	15, // 25: grafeas.v1.VulnerabilityOccurrence.VexAssessment.state:type_name -> grafeas.v1.VulnerabilityAssessmentNote.Assessment.State
	16, // 26: grafeas.v1.VulnerabilityOccurrence.VexAssessment.remediations:type_name -> grafeas.v1.VulnerabilityAssessmentNote.Assessment.Remediation
	17, // 27: grafeas.v1.VulnerabilityOccurrence.VexAssessment.justification:type_name -> grafeas.v1.VulnerabilityAssessmentNote.Assessment.Justification
	28, // [28:28] is the sub-list for method output_type
	28, // [28:28] is the sub-list for method input_type
	28, // [28:28] is the sub-list for extension type_name
	28, // [28:28] is the sub-list for extension extendee
	0,  // [0:28] is the sub-list for field type_name
}

func init() { file_grafeas_v1_vulnerability_proto_init() }
func file_grafeas_v1_vulnerability_proto_init() {
	if File_grafeas_v1_vulnerability_proto != nil {
		return
	}
	file_grafeas_v1_common_proto_init()
	file_grafeas_v1_cvss_proto_init()
	file_grafeas_v1_package_proto_init()
	file_grafeas_v1_severity_proto_init()
	file_grafeas_v1_vex_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_grafeas_v1_vulnerability_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_vulnerability_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityOccurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_vulnerability_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityNote_Detail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_vulnerability_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityNote_WindowsDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_vulnerability_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityNote_WindowsDetail_KnowledgeBase); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_vulnerability_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityOccurrence_PackageIssue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_grafeas_v1_vulnerability_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VulnerabilityOccurrence_VexAssessment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_grafeas_v1_vulnerability_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_grafeas_v1_vulnerability_proto_goTypes,
		DependencyIndexes: file_grafeas_v1_vulnerability_proto_depIdxs,
		MessageInfos:      file_grafeas_v1_vulnerability_proto_msgTypes,
	}.Build()
	File_grafeas_v1_vulnerability_proto = out.File
	file_grafeas_v1_vulnerability_proto_rawDesc = nil
	file_grafeas_v1_vulnerability_proto_goTypes = nil
	file_grafeas_v1_vulnerability_proto_depIdxs = nil
}
