// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: xds/core/v3/resource_locator.proto

package v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on ResourceLocator with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ResourceLocator) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ResourceLocator with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ResourceLocatorMultiError, or nil if none found.
func (m *ResourceLocator) ValidateAll() error {
	return m.validate(true)
}

func (m *ResourceLocator) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := ResourceLocator_Scheme_name[int32(m.GetScheme())]; !ok {
		err := ResourceLocatorValidationError{
			field:  "Scheme",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Id

	// no validation rules for Authority

	if utf8.RuneCountInString(m.GetResourceType()) < 1 {
		err := ResourceLocatorValidationError{
			field:  "ResourceType",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetDirectives() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ResourceLocatorValidationError{
						field:  fmt.Sprintf("Directives[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ResourceLocatorValidationError{
						field:  fmt.Sprintf("Directives[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ResourceLocatorValidationError{
					field:  fmt.Sprintf("Directives[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	switch v := m.ContextParamSpecifier.(type) {
	case *ResourceLocator_ExactContext:
		if v == nil {
			err := ResourceLocatorValidationError{
				field:  "ContextParamSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetExactContext()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ResourceLocatorValidationError{
						field:  "ExactContext",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ResourceLocatorValidationError{
						field:  "ExactContext",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetExactContext()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ResourceLocatorValidationError{
					field:  "ExactContext",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return ResourceLocatorMultiError(errors)
	}

	return nil
}

// ResourceLocatorMultiError is an error wrapping multiple validation errors
// returned by ResourceLocator.ValidateAll() if the designated constraints
// aren't met.
type ResourceLocatorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ResourceLocatorMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ResourceLocatorMultiError) AllErrors() []error { return m }

// ResourceLocatorValidationError is the validation error returned by
// ResourceLocator.Validate if the designated constraints aren't met.
type ResourceLocatorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ResourceLocatorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ResourceLocatorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ResourceLocatorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ResourceLocatorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ResourceLocatorValidationError) ErrorName() string { return "ResourceLocatorValidationError" }

// Error satisfies the builtin error interface
func (e ResourceLocatorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResourceLocator.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ResourceLocatorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ResourceLocatorValidationError{}

// Validate checks the field values on ResourceLocator_Directive with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ResourceLocator_Directive) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ResourceLocator_Directive with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ResourceLocator_DirectiveMultiError, or nil if none found.
func (m *ResourceLocator_Directive) ValidateAll() error {
	return m.validate(true)
}

func (m *ResourceLocator_Directive) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofDirectivePresent := false
	switch v := m.Directive.(type) {
	case *ResourceLocator_Directive_Alt:
		if v == nil {
			err := ResourceLocator_DirectiveValidationError{
				field:  "Directive",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofDirectivePresent = true

		if all {
			switch v := interface{}(m.GetAlt()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ResourceLocator_DirectiveValidationError{
						field:  "Alt",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ResourceLocator_DirectiveValidationError{
						field:  "Alt",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAlt()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ResourceLocator_DirectiveValidationError{
					field:  "Alt",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *ResourceLocator_Directive_Entry:
		if v == nil {
			err := ResourceLocator_DirectiveValidationError{
				field:  "Directive",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofDirectivePresent = true

		if utf8.RuneCountInString(m.GetEntry()) < 1 {
			err := ResourceLocator_DirectiveValidationError{
				field:  "Entry",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_ResourceLocator_Directive_Entry_Pattern.MatchString(m.GetEntry()) {
			err := ResourceLocator_DirectiveValidationError{
				field:  "Entry",
				reason: "value does not match regex pattern \"^[0-9a-zA-Z_\\\\-\\\\./~:]+$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofDirectivePresent {
		err := ResourceLocator_DirectiveValidationError{
			field:  "Directive",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ResourceLocator_DirectiveMultiError(errors)
	}

	return nil
}

// ResourceLocator_DirectiveMultiError is an error wrapping multiple validation
// errors returned by ResourceLocator_Directive.ValidateAll() if the
// designated constraints aren't met.
type ResourceLocator_DirectiveMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ResourceLocator_DirectiveMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ResourceLocator_DirectiveMultiError) AllErrors() []error { return m }

// ResourceLocator_DirectiveValidationError is the validation error returned by
// ResourceLocator_Directive.Validate if the designated constraints aren't met.
type ResourceLocator_DirectiveValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ResourceLocator_DirectiveValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ResourceLocator_DirectiveValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ResourceLocator_DirectiveValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ResourceLocator_DirectiveValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ResourceLocator_DirectiveValidationError) ErrorName() string {
	return "ResourceLocator_DirectiveValidationError"
}

// Error satisfies the builtin error interface
func (e ResourceLocator_DirectiveValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResourceLocator_Directive.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ResourceLocator_DirectiveValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ResourceLocator_DirectiveValidationError{}

var _ResourceLocator_Directive_Entry_Pattern = regexp.MustCompile("^[0-9a-zA-Z_\\-\\./~:]+$")
