// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/devtools/cloudtrace/v1/trace.proto

package tracepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Type of span. Can be used to specify additional relationships between spans
// in addition to a parent/child relationship.
type TraceSpan_SpanKind int32

const (
	// Unspecified.
	TraceSpan_SPAN_KIND_UNSPECIFIED TraceSpan_SpanKind = 0
	// Indicates that the span covers server-side handling of an RPC or other
	// remote network request.
	TraceSpan_RPC_SERVER TraceSpan_SpanKind = 1
	// Indicates that the span covers the client-side wrapper around an RPC or
	// other remote request.
	TraceSpan_RPC_CLIENT TraceSpan_SpanKind = 2
)

// Enum value maps for TraceSpan_SpanKind.
var (
	TraceSpan_SpanKind_name = map[int32]string{
		0: "SPAN_KIND_UNSPECIFIED",
		1: "RPC_SERVER",
		2: "RPC_CLIENT",
	}
	TraceSpan_SpanKind_value = map[string]int32{
		"SPAN_KIND_UNSPECIFIED": 0,
		"RPC_SERVER":            1,
		"RPC_CLIENT":            2,
	}
)

func (x TraceSpan_SpanKind) Enum() *TraceSpan_SpanKind {
	p := new(TraceSpan_SpanKind)
	*p = x
	return p
}

func (x TraceSpan_SpanKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TraceSpan_SpanKind) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudtrace_v1_trace_proto_enumTypes[0].Descriptor()
}

func (TraceSpan_SpanKind) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudtrace_v1_trace_proto_enumTypes[0]
}

func (x TraceSpan_SpanKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TraceSpan_SpanKind.Descriptor instead.
func (TraceSpan_SpanKind) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v1_trace_proto_rawDescGZIP(), []int{2, 0}
}

// Type of data returned for traces in the list.
type ListTracesRequest_ViewType int32

const (
	// Default is `MINIMAL` if unspecified.
	ListTracesRequest_VIEW_TYPE_UNSPECIFIED ListTracesRequest_ViewType = 0
	// Minimal view of the trace record that contains only the project
	// and trace IDs.
	ListTracesRequest_MINIMAL ListTracesRequest_ViewType = 1
	// Root span view of the trace record that returns the root spans along
	// with the minimal trace data.
	ListTracesRequest_ROOTSPAN ListTracesRequest_ViewType = 2
	// Complete view of the trace record that contains the actual trace data.
	// This is equivalent to calling the REST `get` or RPC `GetTrace` method
	// using the ID of each listed trace.
	ListTracesRequest_COMPLETE ListTracesRequest_ViewType = 3
)

// Enum value maps for ListTracesRequest_ViewType.
var (
	ListTracesRequest_ViewType_name = map[int32]string{
		0: "VIEW_TYPE_UNSPECIFIED",
		1: "MINIMAL",
		2: "ROOTSPAN",
		3: "COMPLETE",
	}
	ListTracesRequest_ViewType_value = map[string]int32{
		"VIEW_TYPE_UNSPECIFIED": 0,
		"MINIMAL":               1,
		"ROOTSPAN":              2,
		"COMPLETE":              3,
	}
)

func (x ListTracesRequest_ViewType) Enum() *ListTracesRequest_ViewType {
	p := new(ListTracesRequest_ViewType)
	*p = x
	return p
}

func (x ListTracesRequest_ViewType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ListTracesRequest_ViewType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_cloudtrace_v1_trace_proto_enumTypes[1].Descriptor()
}

func (ListTracesRequest_ViewType) Type() protoreflect.EnumType {
	return &file_google_devtools_cloudtrace_v1_trace_proto_enumTypes[1]
}

func (x ListTracesRequest_ViewType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ListTracesRequest_ViewType.Descriptor instead.
func (ListTracesRequest_ViewType) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v1_trace_proto_rawDescGZIP(), []int{3, 0}
}

// A trace describes how long it takes for an application to perform an
// operation. It consists of a set of spans, each of which represent a single
// timed event within the operation.
type Trace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Project ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Globally unique identifier for the trace. This identifier is a 128-bit
	// numeric value formatted as a 32-byte hex string. For example,
	// `382d4f4c6b7bb2f4a972559d9085001d`.
	TraceId string `protobuf:"bytes,2,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Collection of spans in the trace.
	Spans []*TraceSpan `protobuf:"bytes,3,rep,name=spans,proto3" json:"spans,omitempty"`
}

func (x *Trace) Reset() {
	*x = Trace{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trace) ProtoMessage() {}

func (x *Trace) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trace.ProtoReflect.Descriptor instead.
func (*Trace) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v1_trace_proto_rawDescGZIP(), []int{0}
}

func (x *Trace) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *Trace) GetTraceId() string {
	if x != nil {
		return x.TraceId
	}
	return ""
}

func (x *Trace) GetSpans() []*TraceSpan {
	if x != nil {
		return x.Spans
	}
	return nil
}

// List of new or updated traces.
type Traces struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of traces.
	Traces []*Trace `protobuf:"bytes,1,rep,name=traces,proto3" json:"traces,omitempty"`
}

func (x *Traces) Reset() {
	*x = Traces{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Traces) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Traces) ProtoMessage() {}

func (x *Traces) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Traces.ProtoReflect.Descriptor instead.
func (*Traces) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v1_trace_proto_rawDescGZIP(), []int{1}
}

func (x *Traces) GetTraces() []*Trace {
	if x != nil {
		return x.Traces
	}
	return nil
}

// A span represents a single timed event within a trace. Spans can be nested
// and form a trace tree. Often, a trace contains a root span that describes the
// end-to-end latency of an operation and, optionally, one or more subspans for
// its suboperations. Spans do not need to be contiguous. There may be gaps
// between spans in a trace.
type TraceSpan struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for the span. Must be a 64-bit integer other than 0 and
	// unique within a trace. For example, `2205310701640571284`.
	SpanId uint64 `protobuf:"fixed64,1,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// Distinguishes between spans generated in a particular context. For example,
	// two spans with the same name may be distinguished using `RPC_CLIENT`
	// and `RPC_SERVER` to identify queueing latency associated with the span.
	Kind TraceSpan_SpanKind `protobuf:"varint,2,opt,name=kind,proto3,enum=google.devtools.cloudtrace.v1.TraceSpan_SpanKind" json:"kind,omitempty"`
	// Name of the span. Must be less than 128 bytes. The span name is sanitized
	// and displayed in the Stackdriver Trace tool in the
	// Google Cloud Platform Console.
	// The name may be a method name or some other per-call site name.
	// For the same executable and the same call point, a best practice is
	// to use a consistent name, which makes it easier to correlate
	// cross-trace spans.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Start time of the span in nanoseconds from the UNIX epoch.
	StartTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the span in nanoseconds from the UNIX epoch.
	EndTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Optional. ID of the parent span, if any.
	ParentSpanId uint64 `protobuf:"fixed64,6,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// Collection of labels associated with the span. Label keys must be less than
	// 128 bytes. Label values must be less than 16 kilobytes (10MB for
	// `/stacktrace` values).
	//
	// Some predefined label keys exist, or you may create your own. When creating
	// your own, we recommend the following formats:
	//
	//   - `/category/product/key` for agents of well-known products (e.g.
	//     `/db/mongodb/read_size`).
	//   - `short_host/path/key` for domain-specific keys (e.g.
	//     `foo.com/myproduct/bar`)
	//
	// Predefined labels include:
	//
	// *   `/agent`
	// *   `/component`
	// *   `/error/message`
	// *   `/error/name`
	// *   `/http/client_city`
	// *   `/http/client_country`
	// *   `/http/client_protocol`
	// *   `/http/client_region`
	// *   `/http/host`
	// *   `/http/method`
	// *   `/http/path`
	// *   `/http/redirected_url`
	// *   `/http/request/size`
	// *   `/http/response/size`
	// *   `/http/route`
	// *   `/http/status_code`
	// *   `/http/url`
	// *   `/http/user_agent`
	// *   `/pid`
	// *   `/stacktrace`
	// *   `/tid`
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TraceSpan) Reset() {
	*x = TraceSpan{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TraceSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TraceSpan) ProtoMessage() {}

func (x *TraceSpan) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TraceSpan.ProtoReflect.Descriptor instead.
func (*TraceSpan) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v1_trace_proto_rawDescGZIP(), []int{2}
}

func (x *TraceSpan) GetSpanId() uint64 {
	if x != nil {
		return x.SpanId
	}
	return 0
}

func (x *TraceSpan) GetKind() TraceSpan_SpanKind {
	if x != nil {
		return x.Kind
	}
	return TraceSpan_SPAN_KIND_UNSPECIFIED
}

func (x *TraceSpan) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TraceSpan) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TraceSpan) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *TraceSpan) GetParentSpanId() uint64 {
	if x != nil {
		return x.ParentSpanId
	}
	return 0
}

func (x *TraceSpan) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// The request message for the `ListTraces` method. All fields are required
// unless specified.
type ListTracesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Optional. Type of data returned for traces in the list. Default is
	// `MINIMAL`.
	View ListTracesRequest_ViewType `protobuf:"varint,2,opt,name=view,proto3,enum=google.devtools.cloudtrace.v1.ListTracesRequest_ViewType" json:"view,omitempty"`
	// Optional. Maximum number of traces to return. If not specified or <= 0, the
	// implementation selects a reasonable value.  The implementation may
	// return fewer traces than the requested page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token identifying the page of results to return. If provided, use the
	// value of the `next_page_token` field from a previous request.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Start of the time interval (inclusive) during which the trace data was
	// collected from the application.
	StartTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End of the time interval (inclusive) during which the trace data was
	// collected from the application.
	EndTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Optional. A filter against labels for the request.
	//
	// By default, searches use prefix matching. To specify exact match, prepend
	// a plus symbol (`+`) to the search term.
	// Multiple terms are ANDed. Syntax:
	//
	//   - `root:NAME_PREFIX` or `NAME_PREFIX`: Return traces where any root
	//     span starts with `NAME_PREFIX`.
	//   - `+root:NAME` or `+NAME`: Return traces where any root span's name is
	//     exactly `NAME`.
	//   - `span:NAME_PREFIX`: Return traces where any span starts with
	//     `NAME_PREFIX`.
	//   - `+span:NAME`: Return traces where any span's name is exactly
	//     `NAME`.
	//   - `latency:DURATION`: Return traces whose overall latency is
	//     greater or equal to than `DURATION`. Accepted units are nanoseconds
	//     (`ns`), milliseconds (`ms`), and seconds (`s`). Default is `ms`. For
	//     example, `latency:24ms` returns traces whose overall latency
	//     is greater than or equal to 24 milliseconds.
	//   - `label:LABEL_KEY`: Return all traces containing the specified
	//     label key (exact match, case-sensitive) regardless of the key:value
	//     pair's value (including empty values).
	//   - `LABEL_KEY:VALUE_PREFIX`: Return all traces containing the specified
	//     label key (exact match, case-sensitive) whose value starts with
	//     `VALUE_PREFIX`. Both a key and a value must be specified.
	//   - `+LABEL_KEY:VALUE`: Return all traces containing a key:value pair
	//     exactly matching the specified text. Both a key and a value must be
	//     specified.
	//   - `method:VALUE`: Equivalent to `/http/method:VALUE`.
	//   - `url:VALUE`: Equivalent to `/http/url:VALUE`.
	Filter string `protobuf:"bytes,7,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field used to sort the returned traces.
	// Can be one of the following:
	//
	//   - `trace_id`
	//   - `name` (`name` field of root span in the trace)
	//   - `duration` (difference between `end_time` and `start_time` fields of
	//     the root span)
	//   - `start` (`start_time` field of the root span)
	//
	// Descending order can be specified by appending `desc` to the sort field
	// (for example, `name desc`).
	//
	// Only one sort field is permitted.
	OrderBy string `protobuf:"bytes,8,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListTracesRequest) Reset() {
	*x = ListTracesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTracesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTracesRequest) ProtoMessage() {}

func (x *ListTracesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTracesRequest.ProtoReflect.Descriptor instead.
func (*ListTracesRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v1_trace_proto_rawDescGZIP(), []int{3}
}

func (x *ListTracesRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ListTracesRequest) GetView() ListTracesRequest_ViewType {
	if x != nil {
		return x.View
	}
	return ListTracesRequest_VIEW_TYPE_UNSPECIFIED
}

func (x *ListTracesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTracesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTracesRequest) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ListTracesRequest) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ListTracesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTracesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response message for the `ListTraces` method.
type ListTracesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of trace records as specified by the view parameter.
	Traces []*Trace `protobuf:"bytes,1,rep,name=traces,proto3" json:"traces,omitempty"`
	// If defined, indicates that there are more traces that match the request
	// and that this value should be passed to the next request to continue
	// retrieving additional traces.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTracesResponse) Reset() {
	*x = ListTracesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTracesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTracesResponse) ProtoMessage() {}

func (x *ListTracesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTracesResponse.ProtoReflect.Descriptor instead.
func (*ListTracesResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v1_trace_proto_rawDescGZIP(), []int{4}
}

func (x *ListTracesResponse) GetTraces() []*Trace {
	if x != nil {
		return x.Traces
	}
	return nil
}

func (x *ListTracesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for the `GetTrace` method.
type GetTraceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. ID of the trace to return.
	TraceId string `protobuf:"bytes,2,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
}

func (x *GetTraceRequest) Reset() {
	*x = GetTraceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTraceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTraceRequest) ProtoMessage() {}

func (x *GetTraceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTraceRequest.ProtoReflect.Descriptor instead.
func (*GetTraceRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v1_trace_proto_rawDescGZIP(), []int{5}
}

func (x *GetTraceRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *GetTraceRequest) GetTraceId() string {
	if x != nil {
		return x.TraceId
	}
	return ""
}

// The request message for the `PatchTraces` method.
type PatchTracesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the Cloud project where the trace data is stored.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The body of the message.
	Traces *Traces `protobuf:"bytes,2,opt,name=traces,proto3" json:"traces,omitempty"`
}

func (x *PatchTracesRequest) Reset() {
	*x = PatchTracesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PatchTracesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PatchTracesRequest) ProtoMessage() {}

func (x *PatchTracesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PatchTracesRequest.ProtoReflect.Descriptor instead.
func (*PatchTracesRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_cloudtrace_v1_trace_proto_rawDescGZIP(), []int{6}
}

func (x *PatchTracesRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *PatchTracesRequest) GetTraces() *Traces {
	if x != nil {
		return x.Traces
	}
	return nil
}

var File_google_devtools_cloudtrace_v1_trace_proto protoreflect.FileDescriptor

var file_google_devtools_cloudtrace_v1_trace_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x81, 0x01, 0x0a, 0x05, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x08, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x05, 0x73, 0x70, 0x61, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x52, 0x05, 0x73,
	0x70, 0x61, 0x6e, 0x73, 0x22, 0x46, 0x0a, 0x06, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x12, 0x3c,
	0x0a, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x61, 0x63, 0x65, 0x52, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0x22, 0xec, 0x03, 0x0a,
	0x09, 0x54, 0x72, 0x61, 0x63, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x70,
	0x61, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x06, 0x52, 0x06, 0x73, 0x70, 0x61,
	0x6e, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x53, 0x70, 0x61, 0x6e,
	0x4b, 0x69, 0x6e, 0x64, 0x52, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x29, 0x0a, 0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x06, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x49, 0x64, 0x12, 0x4c, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x63,
	0x65, 0x53, 0x70, 0x61, 0x6e, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x45, 0x0a, 0x08, 0x53, 0x70, 0x61, 0x6e, 0x4b, 0x69, 0x6e, 0x64,
	0x12, 0x19, 0x0a, 0x15, 0x53, 0x50, 0x41, 0x4e, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x52,
	0x50, 0x43, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52,
	0x50, 0x43, 0x5f, 0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x22, 0xcb, 0x03, 0x0a, 0x11,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x56, 0x69, 0x65, 0x77, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x4e, 0x0a, 0x08, 0x56, 0x69, 0x65,
	0x77, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0b, 0x0a, 0x07, 0x4d, 0x49, 0x4e, 0x49, 0x4d, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x52, 0x4f, 0x4f, 0x54, 0x53, 0x50, 0x41, 0x4e, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x22, 0x7a, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3c, 0x0a, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x61, 0x63, 0x65, 0x52, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x55, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x74, 0x72, 0x61, 0x63, 0x65, 0x49, 0x64, 0x22, 0x7c, 0x0a, 0x12,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x42, 0x0a, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72,
	0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0x32, 0xb5, 0x05, 0x0a, 0x0c, 0x54,
	0x72, 0x61, 0x63, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xa8, 0x01, 0x0a, 0x0a,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x72, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0xda, 0x41, 0x0a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x12, 0xab, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x54, 0x72,
	0x61, 0x63, 0x65, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x61, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x63, 0x65, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x74, 0x72, 0x61,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x72, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0xda, 0x41,
	0x13, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x74, 0x72, 0x61, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x12, 0x9e, 0x01, 0x0a, 0x0b, 0x50, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72,
	0x61, 0x63, 0x65, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x61, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x44, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2a, 0x32, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69,
	0x64, 0x7d, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x73, 0x3a, 0x06, 0x74, 0x72, 0x61, 0x63, 0x65,
	0x73, 0xda, 0x41, 0x11, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x2c, 0x74,
	0x72, 0x61, 0x63, 0x65, 0x73, 0x1a, 0xaa, 0x01, 0xca, 0x41, 0x19, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x8a, 0x01, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x61, 0x70, 0x70,
	0x65, 0x6e, 0x64, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e,
	0x6c, 0x79, 0x42, 0xc5, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0a, 0x54, 0x72, 0x61, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63,
	0x65, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x74, 0x72, 0x61, 0x63, 0x65, 0xaa,
	0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x54,
	0x72, 0x61, 0x63, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x54, 0x72, 0x61, 0x63, 0x65, 0x5c, 0x56, 0x31, 0xea,
	0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a,
	0x3a, 0x54, 0x72, 0x61, 0x63, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_devtools_cloudtrace_v1_trace_proto_rawDescOnce sync.Once
	file_google_devtools_cloudtrace_v1_trace_proto_rawDescData = file_google_devtools_cloudtrace_v1_trace_proto_rawDesc
)

func file_google_devtools_cloudtrace_v1_trace_proto_rawDescGZIP() []byte {
	file_google_devtools_cloudtrace_v1_trace_proto_rawDescOnce.Do(func() {
		file_google_devtools_cloudtrace_v1_trace_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_cloudtrace_v1_trace_proto_rawDescData)
	})
	return file_google_devtools_cloudtrace_v1_trace_proto_rawDescData
}

var file_google_devtools_cloudtrace_v1_trace_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_devtools_cloudtrace_v1_trace_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_devtools_cloudtrace_v1_trace_proto_goTypes = []interface{}{
	(TraceSpan_SpanKind)(0),         // 0: google.devtools.cloudtrace.v1.TraceSpan.SpanKind
	(ListTracesRequest_ViewType)(0), // 1: google.devtools.cloudtrace.v1.ListTracesRequest.ViewType
	(*Trace)(nil),                   // 2: google.devtools.cloudtrace.v1.Trace
	(*Traces)(nil),                  // 3: google.devtools.cloudtrace.v1.Traces
	(*TraceSpan)(nil),               // 4: google.devtools.cloudtrace.v1.TraceSpan
	(*ListTracesRequest)(nil),       // 5: google.devtools.cloudtrace.v1.ListTracesRequest
	(*ListTracesResponse)(nil),      // 6: google.devtools.cloudtrace.v1.ListTracesResponse
	(*GetTraceRequest)(nil),         // 7: google.devtools.cloudtrace.v1.GetTraceRequest
	(*PatchTracesRequest)(nil),      // 8: google.devtools.cloudtrace.v1.PatchTracesRequest
	nil,                             // 9: google.devtools.cloudtrace.v1.TraceSpan.LabelsEntry
	(*timestamp.Timestamp)(nil),     // 10: google.protobuf.Timestamp
	(*empty.Empty)(nil),             // 11: google.protobuf.Empty
}
var file_google_devtools_cloudtrace_v1_trace_proto_depIdxs = []int32{
	4,  // 0: google.devtools.cloudtrace.v1.Trace.spans:type_name -> google.devtools.cloudtrace.v1.TraceSpan
	2,  // 1: google.devtools.cloudtrace.v1.Traces.traces:type_name -> google.devtools.cloudtrace.v1.Trace
	0,  // 2: google.devtools.cloudtrace.v1.TraceSpan.kind:type_name -> google.devtools.cloudtrace.v1.TraceSpan.SpanKind
	10, // 3: google.devtools.cloudtrace.v1.TraceSpan.start_time:type_name -> google.protobuf.Timestamp
	10, // 4: google.devtools.cloudtrace.v1.TraceSpan.end_time:type_name -> google.protobuf.Timestamp
	9,  // 5: google.devtools.cloudtrace.v1.TraceSpan.labels:type_name -> google.devtools.cloudtrace.v1.TraceSpan.LabelsEntry
	1,  // 6: google.devtools.cloudtrace.v1.ListTracesRequest.view:type_name -> google.devtools.cloudtrace.v1.ListTracesRequest.ViewType
	10, // 7: google.devtools.cloudtrace.v1.ListTracesRequest.start_time:type_name -> google.protobuf.Timestamp
	10, // 8: google.devtools.cloudtrace.v1.ListTracesRequest.end_time:type_name -> google.protobuf.Timestamp
	2,  // 9: google.devtools.cloudtrace.v1.ListTracesResponse.traces:type_name -> google.devtools.cloudtrace.v1.Trace
	3,  // 10: google.devtools.cloudtrace.v1.PatchTracesRequest.traces:type_name -> google.devtools.cloudtrace.v1.Traces
	5,  // 11: google.devtools.cloudtrace.v1.TraceService.ListTraces:input_type -> google.devtools.cloudtrace.v1.ListTracesRequest
	7,  // 12: google.devtools.cloudtrace.v1.TraceService.GetTrace:input_type -> google.devtools.cloudtrace.v1.GetTraceRequest
	8,  // 13: google.devtools.cloudtrace.v1.TraceService.PatchTraces:input_type -> google.devtools.cloudtrace.v1.PatchTracesRequest
	6,  // 14: google.devtools.cloudtrace.v1.TraceService.ListTraces:output_type -> google.devtools.cloudtrace.v1.ListTracesResponse
	2,  // 15: google.devtools.cloudtrace.v1.TraceService.GetTrace:output_type -> google.devtools.cloudtrace.v1.Trace
	11, // 16: google.devtools.cloudtrace.v1.TraceService.PatchTraces:output_type -> google.protobuf.Empty
	14, // [14:17] is the sub-list for method output_type
	11, // [11:14] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_devtools_cloudtrace_v1_trace_proto_init() }
func file_google_devtools_cloudtrace_v1_trace_proto_init() {
	if File_google_devtools_cloudtrace_v1_trace_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trace); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Traces); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TraceSpan); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTracesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTracesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTraceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_cloudtrace_v1_trace_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PatchTracesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_cloudtrace_v1_trace_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_cloudtrace_v1_trace_proto_goTypes,
		DependencyIndexes: file_google_devtools_cloudtrace_v1_trace_proto_depIdxs,
		EnumInfos:         file_google_devtools_cloudtrace_v1_trace_proto_enumTypes,
		MessageInfos:      file_google_devtools_cloudtrace_v1_trace_proto_msgTypes,
	}.Build()
	File_google_devtools_cloudtrace_v1_trace_proto = out.File
	file_google_devtools_cloudtrace_v1_trace_proto_rawDesc = nil
	file_google_devtools_cloudtrace_v1_trace_proto_goTypes = nil
	file_google_devtools_cloudtrace_v1_trace_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// TraceServiceClient is the client API for TraceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type TraceServiceClient interface {
	// Returns of a list of traces that match the specified filter conditions.
	ListTraces(ctx context.Context, in *ListTracesRequest, opts ...grpc.CallOption) (*ListTracesResponse, error)
	// Gets a single trace by its ID.
	GetTrace(ctx context.Context, in *GetTraceRequest, opts ...grpc.CallOption) (*Trace, error)
	// Sends new traces to Stackdriver Trace or updates existing traces. If the ID
	// of a trace that you send matches that of an existing trace, any fields
	// in the existing trace and its spans are overwritten by the provided values,
	// and any new fields provided are merged with the existing trace data. If the
	// ID does not match, a new trace is created.
	PatchTraces(ctx context.Context, in *PatchTracesRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type traceServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewTraceServiceClient(cc grpc.ClientConnInterface) TraceServiceClient {
	return &traceServiceClient{cc}
}

func (c *traceServiceClient) ListTraces(ctx context.Context, in *ListTracesRequest, opts ...grpc.CallOption) (*ListTracesResponse, error) {
	out := new(ListTracesResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudtrace.v1.TraceService/ListTraces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *traceServiceClient) GetTrace(ctx context.Context, in *GetTraceRequest, opts ...grpc.CallOption) (*Trace, error) {
	out := new(Trace)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudtrace.v1.TraceService/GetTrace", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *traceServiceClient) PatchTraces(ctx context.Context, in *PatchTracesRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.cloudtrace.v1.TraceService/PatchTraces", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// TraceServiceServer is the server API for TraceService service.
type TraceServiceServer interface {
	// Returns of a list of traces that match the specified filter conditions.
	ListTraces(context.Context, *ListTracesRequest) (*ListTracesResponse, error)
	// Gets a single trace by its ID.
	GetTrace(context.Context, *GetTraceRequest) (*Trace, error)
	// Sends new traces to Stackdriver Trace or updates existing traces. If the ID
	// of a trace that you send matches that of an existing trace, any fields
	// in the existing trace and its spans are overwritten by the provided values,
	// and any new fields provided are merged with the existing trace data. If the
	// ID does not match, a new trace is created.
	PatchTraces(context.Context, *PatchTracesRequest) (*empty.Empty, error)
}

// UnimplementedTraceServiceServer can be embedded to have forward compatible implementations.
type UnimplementedTraceServiceServer struct {
}

func (*UnimplementedTraceServiceServer) ListTraces(context.Context, *ListTracesRequest) (*ListTracesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTraces not implemented")
}
func (*UnimplementedTraceServiceServer) GetTrace(context.Context, *GetTraceRequest) (*Trace, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTrace not implemented")
}
func (*UnimplementedTraceServiceServer) PatchTraces(context.Context, *PatchTracesRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchTraces not implemented")
}

func RegisterTraceServiceServer(s *grpc.Server, srv TraceServiceServer) {
	s.RegisterService(&_TraceService_serviceDesc, srv)
}

func _TraceService_ListTraces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTracesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TraceServiceServer).ListTraces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudtrace.v1.TraceService/ListTraces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TraceServiceServer).ListTraces(ctx, req.(*ListTracesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TraceService_GetTrace_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTraceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TraceServiceServer).GetTrace(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudtrace.v1.TraceService/GetTrace",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TraceServiceServer).GetTrace(ctx, req.(*GetTraceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _TraceService_PatchTraces_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchTracesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(TraceServiceServer).PatchTraces(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.cloudtrace.v1.TraceService/PatchTraces",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(TraceServiceServer).PatchTraces(ctx, req.(*PatchTracesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _TraceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.cloudtrace.v1.TraceService",
	HandlerType: (*TraceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListTraces",
			Handler:    _TraceService_ListTraces_Handler,
		},
		{
			MethodName: "GetTrace",
			Handler:    _TraceService_GetTrace_Handler,
		},
		{
			MethodName: "PatchTraces",
			Handler:    _TraceService_PatchTraces_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/cloudtrace/v1/trace.proto",
}
