package gofuzzheaders

import (
	"fmt"
	//"os"
	//"path/filepath"
	//"reflect"
	"testing"
)

type TestStruct1 struct {
	Field1 string
	Field2 string
	Field3 []byte
}

func TestStruct_fuzzing1(t *testing.T) {
	data := []byte{0x00, 0x00, 0x00, 0x03, // Length field 1 (= 3)
		0x41, 0x42, 0x43,
		0x00, 0x00, 0x00, 0x03, // Length field 2 (= 3)
		0x41, 0x42, 0x43,
		0x01, 0x01, 0x01, 0x03, // Length slice (= 1)
		0x02, // endian bool (I think)
		0x41} // Field3

	ts1 := TestStruct1{}
	fuzz1 := NewConsumer(data)
	err := fuzz1.GenerateStruct(&ts1)
	if err != nil {
		t.Errorf("%v", err)
	}
	if ts1.Field1 != "ABC" {
		t.Errorf("ts1.Field1 was %v but should be 'AB'", ts1.Field1)
	}
	if ts1.Field2 != "ABC" {
		t.Errorf("ts1.Field2 was %v but should be 'ABC'", ts1.Field2)
	}
	if string(ts1.Field3) != "A" {
		t.Errorf("ts1.Field3 was %v but should be 'A'", ts1.Field3)
	}
}

// Tests that we can create long byte slices in structs
func TestStruct_fuzzing2(t *testing.T) {
	data := []byte{0x00, 0x00, 0x00, 0x03, // Length field 1 (= 3)
		0x41, 0x42, 0x43, // Content of Field3
		0x00, 0x00, 0x00, 0x03, // Length field 2 (= 3)
		0x41, 0x42, 0x43, // Content of Field2
		0x22, 0x22, 0x22, 0x22, // Length slice
		0x02,                                                       // endian bool (I think)
		0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, // All of this
		0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, // should go
		0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, // into Field3
		0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
		0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
		0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
		0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
		0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41,
	}

	ts1 := TestStruct1{}
	fuzz1 := NewConsumer(data)
	err := fuzz1.GenerateStruct(&ts1)
	if err != nil {
		t.Errorf("%v", err)
	}
	fmt.Println("Here")
	if ts1.Field1 != "ABC" {
		t.Errorf("ts1.Field1 was %v but should be 'AB'", ts1.Field1)
	}
	if ts1.Field2 != "ABC" {
		t.Errorf("ts1.Field2 was %v but should be 'ABC'", ts1.Field2)
	}
	if len(ts1.Field3) != 80 {
		t.Errorf("ts1.Field3 was %v but should be 'ABCD'", ts1.Field3)
	}
}
