// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/gkehub/v1/membership.proto

package gkehub

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Code describes the state of a Membership resource.
type MembershipState_Code int32

const (
	// The code is not set.
	MembershipState_CODE_UNSPECIFIED MembershipState_Code = 0
	// The cluster is being registered.
	MembershipState_CREATING MembershipState_Code = 1
	// The cluster is registered.
	MembershipState_READY MembershipState_Code = 2
	// The cluster is being unregistered.
	MembershipState_DELETING MembershipState_Code = 3
	// The Membership is being updated.
	MembershipState_UPDATING MembershipState_Code = 4
	// The Membership is being updated by the Hub Service.
	MembershipState_SERVICE_UPDATING MembershipState_Code = 5
)

// Enum value maps for MembershipState_Code.
var (
	MembershipState_Code_name = map[int32]string{
		0: "CODE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
		3: "DELETING",
		4: "UPDATING",
		5: "SERVICE_UPDATING",
	}
	MembershipState_Code_value = map[string]int32{
		"CODE_UNSPECIFIED": 0,
		"CREATING":         1,
		"READY":            2,
		"DELETING":         3,
		"UPDATING":         4,
		"SERVICE_UPDATING": 5,
	}
)

func (x MembershipState_Code) Enum() *MembershipState_Code {
	p := new(MembershipState_Code)
	*p = x
	return p
}

func (x MembershipState_Code) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MembershipState_Code) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkehub_v1_membership_proto_enumTypes[0].Descriptor()
}

func (MembershipState_Code) Type() protoreflect.EnumType {
	return &file_google_cloud_gkehub_v1_membership_proto_enumTypes[0]
}

func (x MembershipState_Code) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MembershipState_Code.Descriptor instead.
func (MembershipState_Code) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP(), []int{7, 0}
}

// Membership contains information about a member cluster.
type Membership struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of resource represented by this Membership
	//
	// Types that are assignable to Type:
	//	*Membership_Endpoint
	Type isMembership_Type `protobuf_oneof:"type"`
	// Output only. The full, unique name of this Membership resource in the format
	// `projects/*/locations/*/memberships/{membership_id}`, set during creation.
	//
	// `membership_id` must be a valid RFC 1123 compliant DNS label:
	//
	//   1. At most 63 characters in length
	//   2. It must consist of lower case alphanumeric characters or `-`
	//   3. It must start and end with an alphanumeric character
	//
	// Which can be expressed as the regex: `[a-z0-9]([-a-z0-9]*[a-z0-9])?`,
	// with a maximum length of 63 characters.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. GCP labels for this membership.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Description of this membership, limited to 63 characters.
	// Must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_\-\.\ ]*`
	//
	// This field is present for legacy purposes.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. State of the Membership resource.
	State *MembershipState `protobuf:"bytes,5,opt,name=state,proto3" json:"state,omitempty"`
	// Output only. When the Membership was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. When the Membership was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. When the Membership was deleted.
	DeleteTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=delete_time,json=deleteTime,proto3" json:"delete_time,omitempty"`
	// Optional. An externally-generated and managed ID for this Membership. This ID may
	// be modified after creation, but this is not recommended.
	//
	// The ID must match the regex: `[a-zA-Z0-9][a-zA-Z0-9_\-\.]*`
	//
	// If this Membership represents a Kubernetes cluster, this value should be
	// set to the UID of the `kube-system` namespace object.
	ExternalId string `protobuf:"bytes,9,opt,name=external_id,json=externalId,proto3" json:"external_id,omitempty"`
	// Output only. For clusters using Connect, the timestamp of the most recent connection
	// established with Google Cloud. This time is updated every several minutes,
	// not continuously. For clusters that do not use GKE Connect, or that have
	// never connected successfully, this field will be unset.
	LastConnectionTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=last_connection_time,json=lastConnectionTime,proto3" json:"last_connection_time,omitempty"`
	// Output only. Google-generated UUID for this resource. This is unique across all
	// Membership resources. If a Membership resource is deleted and another
	// resource with the same name is created, it gets a different unique_id.
	UniqueId string `protobuf:"bytes,11,opt,name=unique_id,json=uniqueId,proto3" json:"unique_id,omitempty"`
	// Optional. How to identify workloads from this Membership.
	// See the documentation on Workload Identity for more details:
	// https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
	Authority *Authority `protobuf:"bytes,12,opt,name=authority,proto3" json:"authority,omitempty"`
}

func (x *Membership) Reset() {
	*x = Membership{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Membership) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Membership) ProtoMessage() {}

func (x *Membership) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Membership.ProtoReflect.Descriptor instead.
func (*Membership) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP(), []int{0}
}

func (m *Membership) GetType() isMembership_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Membership) GetEndpoint() *MembershipEndpoint {
	if x, ok := x.GetType().(*Membership_Endpoint); ok {
		return x.Endpoint
	}
	return nil
}

func (x *Membership) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Membership) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Membership) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Membership) GetState() *MembershipState {
	if x != nil {
		return x.State
	}
	return nil
}

func (x *Membership) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Membership) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Membership) GetDeleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeleteTime
	}
	return nil
}

func (x *Membership) GetExternalId() string {
	if x != nil {
		return x.ExternalId
	}
	return ""
}

func (x *Membership) GetLastConnectionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastConnectionTime
	}
	return nil
}

func (x *Membership) GetUniqueId() string {
	if x != nil {
		return x.UniqueId
	}
	return ""
}

func (x *Membership) GetAuthority() *Authority {
	if x != nil {
		return x.Authority
	}
	return nil
}

type isMembership_Type interface {
	isMembership_Type()
}

type Membership_Endpoint struct {
	// Optional. Endpoint information to reach this member.
	Endpoint *MembershipEndpoint `protobuf:"bytes,4,opt,name=endpoint,proto3,oneof"`
}

func (*Membership_Endpoint) isMembership_Type() {}

// MembershipEndpoint contains information needed to contact a Kubernetes API,
// endpoint and any additional Kubernetes metadata.
type MembershipEndpoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. GKE-specific information. Only present if this Membership is a GKE cluster.
	GkeCluster *GkeCluster `protobuf:"bytes,1,opt,name=gke_cluster,json=gkeCluster,proto3" json:"gke_cluster,omitempty"`
	// Output only. Useful Kubernetes-specific metadata.
	KubernetesMetadata *KubernetesMetadata `protobuf:"bytes,2,opt,name=kubernetes_metadata,json=kubernetesMetadata,proto3" json:"kubernetes_metadata,omitempty"`
	// Optional. The in-cluster Kubernetes Resources that should be applied for a correctly
	// registered cluster, in the steady state. These resources:
	//
	//   * Ensure that the cluster is exclusively registered to one and only one
	//     Hub Membership.
	//   * Propagate Workload Pool Information available in the Membership
	//     Authority field.
	//   * Ensure proper initial configuration of default Hub Features.
	KubernetesResource *KubernetesResource `protobuf:"bytes,3,opt,name=kubernetes_resource,json=kubernetesResource,proto3" json:"kubernetes_resource,omitempty"`
}

func (x *MembershipEndpoint) Reset() {
	*x = MembershipEndpoint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipEndpoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipEndpoint) ProtoMessage() {}

func (x *MembershipEndpoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipEndpoint.ProtoReflect.Descriptor instead.
func (*MembershipEndpoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP(), []int{1}
}

func (x *MembershipEndpoint) GetGkeCluster() *GkeCluster {
	if x != nil {
		return x.GkeCluster
	}
	return nil
}

func (x *MembershipEndpoint) GetKubernetesMetadata() *KubernetesMetadata {
	if x != nil {
		return x.KubernetesMetadata
	}
	return nil
}

func (x *MembershipEndpoint) GetKubernetesResource() *KubernetesResource {
	if x != nil {
		return x.KubernetesResource
	}
	return nil
}

// KubernetesResource contains the YAML manifests and configuration for
// Membership Kubernetes resources in the cluster. After CreateMembership or
// UpdateMembership, these resources should be re-applied in the cluster.
type KubernetesResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input only. The YAML representation of the Membership CR. This field is ignored for GKE
	// clusters where Hub can read the CR directly.
	//
	// Callers should provide the CR that is currently present in the cluster
	// during CreateMembership or UpdateMembership, or leave this field empty if
	// none exists. The CR manifest is used to validate the cluster has not been
	// registered with another Membership.
	MembershipCrManifest string `protobuf:"bytes,1,opt,name=membership_cr_manifest,json=membershipCrManifest,proto3" json:"membership_cr_manifest,omitempty"`
	// Output only. Additional Kubernetes resources that need to be applied to the cluster
	// after Membership creation, and after every update.
	//
	// This field is only populated in the Membership returned from a successful
	// long-running operation from CreateMembership or UpdateMembership. It is not
	// populated during normal GetMembership or ListMemberships requests. To get
	// the resource manifest after the initial registration, the caller should
	// make a UpdateMembership call with an empty field mask.
	MembershipResources []*ResourceManifest `protobuf:"bytes,2,rep,name=membership_resources,json=membershipResources,proto3" json:"membership_resources,omitempty"`
	// Output only. The Kubernetes resources for installing the GKE Connect agent
	//
	// This field is only populated in the Membership returned from a successful
	// long-running operation from CreateMembership or UpdateMembership. It is not
	// populated during normal GetMembership or ListMemberships requests. To get
	// the resource manifest after the initial registration, the caller should
	// make a UpdateMembership call with an empty field mask.
	ConnectResources []*ResourceManifest `protobuf:"bytes,3,rep,name=connect_resources,json=connectResources,proto3" json:"connect_resources,omitempty"`
	// Optional. Options for Kubernetes resource generation.
	ResourceOptions *ResourceOptions `protobuf:"bytes,4,opt,name=resource_options,json=resourceOptions,proto3" json:"resource_options,omitempty"`
}

func (x *KubernetesResource) Reset() {
	*x = KubernetesResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesResource) ProtoMessage() {}

func (x *KubernetesResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesResource.ProtoReflect.Descriptor instead.
func (*KubernetesResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP(), []int{2}
}

func (x *KubernetesResource) GetMembershipCrManifest() string {
	if x != nil {
		return x.MembershipCrManifest
	}
	return ""
}

func (x *KubernetesResource) GetMembershipResources() []*ResourceManifest {
	if x != nil {
		return x.MembershipResources
	}
	return nil
}

func (x *KubernetesResource) GetConnectResources() []*ResourceManifest {
	if x != nil {
		return x.ConnectResources
	}
	return nil
}

func (x *KubernetesResource) GetResourceOptions() *ResourceOptions {
	if x != nil {
		return x.ResourceOptions
	}
	return nil
}

// ResourceOptions represent options for Kubernetes resource generation.
type ResourceOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The Connect agent version to use for connect_resources. Defaults to the
	// latest GKE Connect version. The version must be a currently supported
	// version, obsolete versions will be rejected.
	ConnectVersion string `protobuf:"bytes,1,opt,name=connect_version,json=connectVersion,proto3" json:"connect_version,omitempty"`
	// Optional. Use `apiextensions/v1beta1` instead of `apiextensions/v1` for
	// CustomResourceDefinition resources.
	// This option should be set for clusters with Kubernetes apiserver versions
	// <1.16.
	V1Beta1Crd bool `protobuf:"varint,2,opt,name=v1beta1_crd,json=v1beta1Crd,proto3" json:"v1beta1_crd,omitempty"`
	// Optional. Major version of the Kubernetes cluster. This is only used to determine
	// which version to use for the CustomResourceDefinition resources,
	// `apiextensions/v1beta1` or`apiextensions/v1`.
	K8SVersion string `protobuf:"bytes,3,opt,name=k8s_version,json=k8sVersion,proto3" json:"k8s_version,omitempty"`
}

func (x *ResourceOptions) Reset() {
	*x = ResourceOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceOptions) ProtoMessage() {}

func (x *ResourceOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceOptions.ProtoReflect.Descriptor instead.
func (*ResourceOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP(), []int{3}
}

func (x *ResourceOptions) GetConnectVersion() string {
	if x != nil {
		return x.ConnectVersion
	}
	return ""
}

func (x *ResourceOptions) GetV1Beta1Crd() bool {
	if x != nil {
		return x.V1Beta1Crd
	}
	return false
}

func (x *ResourceOptions) GetK8SVersion() string {
	if x != nil {
		return x.K8SVersion
	}
	return ""
}

// ResourceManifest represents a single Kubernetes resource to be applied to
// the cluster.
type ResourceManifest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// YAML manifest of the resource.
	Manifest string `protobuf:"bytes,1,opt,name=manifest,proto3" json:"manifest,omitempty"`
	// Whether the resource provided in the manifest is `cluster_scoped`.
	// If unset, the manifest is assumed to be namespace scoped.
	//
	// This field is used for REST mapping when applying the resource in a
	// cluster.
	ClusterScoped bool `protobuf:"varint,2,opt,name=cluster_scoped,json=clusterScoped,proto3" json:"cluster_scoped,omitempty"`
}

func (x *ResourceManifest) Reset() {
	*x = ResourceManifest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceManifest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceManifest) ProtoMessage() {}

func (x *ResourceManifest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceManifest.ProtoReflect.Descriptor instead.
func (*ResourceManifest) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP(), []int{4}
}

func (x *ResourceManifest) GetManifest() string {
	if x != nil {
		return x.Manifest
	}
	return ""
}

func (x *ResourceManifest) GetClusterScoped() bool {
	if x != nil {
		return x.ClusterScoped
	}
	return false
}

// GkeCluster contains information specific to GKE clusters.
type GkeCluster struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Immutable. Self-link of the GCP resource for the GKE cluster. For example:
	//
	// //container.googleapis.com/projects/my-project/locations/us-west1-a/clusters/my-cluster
	//
	// Zonal clusters are also supported.
	ResourceLink string `protobuf:"bytes,1,opt,name=resource_link,json=resourceLink,proto3" json:"resource_link,omitempty"`
}

func (x *GkeCluster) Reset() {
	*x = GkeCluster{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GkeCluster) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GkeCluster) ProtoMessage() {}

func (x *GkeCluster) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GkeCluster.ProtoReflect.Descriptor instead.
func (*GkeCluster) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP(), []int{5}
}

func (x *GkeCluster) GetResourceLink() string {
	if x != nil {
		return x.ResourceLink
	}
	return ""
}

// KubernetesMetadata provides informational metadata for Memberships
// representing Kubernetes clusters.
type KubernetesMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Kubernetes API server version string as reported by `/version`.
	KubernetesApiServerVersion string `protobuf:"bytes,1,opt,name=kubernetes_api_server_version,json=kubernetesApiServerVersion,proto3" json:"kubernetes_api_server_version,omitempty"`
	// Output only. Node providerID as reported by the first node in the list of nodes on
	// the Kubernetes endpoint. On Kubernetes platforms that support zero-node
	// clusters (like GKE-on-GCP), the node_count will be zero and the
	// node_provider_id will be empty.
	NodeProviderId string `protobuf:"bytes,2,opt,name=node_provider_id,json=nodeProviderId,proto3" json:"node_provider_id,omitempty"`
	// Output only. Node count as reported by Kubernetes nodes resources.
	NodeCount int32 `protobuf:"varint,3,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// Output only. vCPU count as reported by Kubernetes nodes resources.
	VcpuCount int32 `protobuf:"varint,4,opt,name=vcpu_count,json=vcpuCount,proto3" json:"vcpu_count,omitempty"`
	// Output only. The total memory capacity as reported by the sum of all Kubernetes nodes
	// resources, defined in MB.
	MemoryMb int32 `protobuf:"varint,5,opt,name=memory_mb,json=memoryMb,proto3" json:"memory_mb,omitempty"`
	// Output only. The time at which these details were last updated. This update_time is
	// different from the Membership-level update_time since EndpointDetails are
	// updated internally for API consumers.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,100,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *KubernetesMetadata) Reset() {
	*x = KubernetesMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *KubernetesMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KubernetesMetadata) ProtoMessage() {}

func (x *KubernetesMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KubernetesMetadata.ProtoReflect.Descriptor instead.
func (*KubernetesMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP(), []int{6}
}

func (x *KubernetesMetadata) GetKubernetesApiServerVersion() string {
	if x != nil {
		return x.KubernetesApiServerVersion
	}
	return ""
}

func (x *KubernetesMetadata) GetNodeProviderId() string {
	if x != nil {
		return x.NodeProviderId
	}
	return ""
}

func (x *KubernetesMetadata) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *KubernetesMetadata) GetVcpuCount() int32 {
	if x != nil {
		return x.VcpuCount
	}
	return 0
}

func (x *KubernetesMetadata) GetMemoryMb() int32 {
	if x != nil {
		return x.MemoryMb
	}
	return 0
}

func (x *KubernetesMetadata) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// MembershipState describes the state of a Membership resource.
type MembershipState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The current state of the Membership resource.
	Code MembershipState_Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.gkehub.v1.MembershipState_Code" json:"code,omitempty"`
}

func (x *MembershipState) Reset() {
	*x = MembershipState{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MembershipState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MembershipState) ProtoMessage() {}

func (x *MembershipState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MembershipState.ProtoReflect.Descriptor instead.
func (*MembershipState) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP(), []int{7}
}

func (x *MembershipState) GetCode() MembershipState_Code {
	if x != nil {
		return x.Code
	}
	return MembershipState_CODE_UNSPECIFIED
}

// Authority encodes how Google will recognize identities from this Membership.
// See the workload identity documentation for more details:
// https://cloud.google.com/kubernetes-engine/docs/how-to/workload-identity
type Authority struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A JSON Web Token (JWT) issuer URI. `issuer` must start with `https://` and
	// be a valid URL with length <2000 characters.
	//
	// If set, then Google will allow valid OIDC tokens from this issuer to
	// authenticate within the workload_identity_pool. OIDC discovery will be
	// performed on this URI to validate tokens from the issuer.
	//
	// Clearing `issuer` disables Workload Identity. `issuer` cannot be directly
	// modified; it must be cleared (and Workload Identity disabled) before using
	// a new issuer (and re-enabling Workload Identity).
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// Output only. The name of the workload identity pool in which `issuer` will be
	// recognized.
	//
	// There is a single Workload Identity Pool per Hub that is shared
	// between all Memberships that belong to that Hub. For a Hub hosted in
	// {PROJECT_ID}, the workload pool format is `{PROJECT_ID}.hub.id.goog`,
	// although this is subject to change in newer versions of this API.
	WorkloadIdentityPool string `protobuf:"bytes,2,opt,name=workload_identity_pool,json=workloadIdentityPool,proto3" json:"workload_identity_pool,omitempty"`
	// Output only. An identity provider that reflects the `issuer` in the workload identity
	// pool.
	IdentityProvider string `protobuf:"bytes,3,opt,name=identity_provider,json=identityProvider,proto3" json:"identity_provider,omitempty"`
	// Optional. OIDC verification keys for this Membership in JWKS format (RFC 7517).
	//
	// When this field is set, OIDC discovery will NOT be performed on `issuer`,
	// and instead OIDC tokens will be validated using this field.
	OidcJwks []byte `protobuf:"bytes,4,opt,name=oidc_jwks,json=oidcJwks,proto3" json:"oidc_jwks,omitempty"`
}

func (x *Authority) Reset() {
	*x = Authority{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Authority) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Authority) ProtoMessage() {}

func (x *Authority) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkehub_v1_membership_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Authority.ProtoReflect.Descriptor instead.
func (*Authority) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP(), []int{8}
}

func (x *Authority) GetIssuer() string {
	if x != nil {
		return x.Issuer
	}
	return ""
}

func (x *Authority) GetWorkloadIdentityPool() string {
	if x != nil {
		return x.WorkloadIdentityPool
	}
	return ""
}

func (x *Authority) GetIdentityProvider() string {
	if x != nil {
		return x.IdentityProvider
	}
	return ""
}

func (x *Authority) GetOidcJwks() []byte {
	if x != nil {
		return x.OidcJwks
	}
	return nil
}

var File_google_cloud_gkehub_v1_membership_proto protoreflect.FileDescriptor

var file_google_cloud_gkehub_v1_membership_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xff,
	0x06, 0x0a, 0x0a, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x4d, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f,
	0x69, 0x64, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x64, 0x12, 0x51, 0x0a, 0x14, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x6c, 0x61, 0x73, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09,
	0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x49, 0x64, 0x12, 0x44,
	0x0a, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x61, 0x75, 0x74, 0x68, 0x6f,
	0x72, 0x69, 0x74, 0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x67, 0xea, 0x41, 0x64, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x7d, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x22, 0xa2, 0x02, 0x0a, 0x12, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x0b, 0x67, 0x6b, 0x65, 0x5f, 0x63,
	0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68,
	0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x67, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x60, 0x0a, 0x13, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74,
	0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x12, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x60, 0x0a, 0x13, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65,
	0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xe6, 0x02, 0x0a, 0x12, 0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e,
	0x65, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x16,
	0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x63, 0x72, 0x5f, 0x6d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x04, 0x52, 0x14, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x43, 0x72, 0x4d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x14, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x11, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x8b,
	0x01, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x0b, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x5f, 0x63, 0x72, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x43, 0x72, 0x64, 0x12, 0x24, 0x0a, 0x0b, 0x6b, 0x38, 0x73, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x6b, 0x38, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x55, 0x0a, 0x10,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74,
	0x12, 0x1a, 0x0a, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x12, 0x25, 0x0a, 0x0e,
	0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x53, 0x63, 0x6f,
	0x70, 0x65, 0x64, 0x22, 0x36, 0x0a, 0x0a, 0x47, 0x6b, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65,
	0x72, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x69,
	0x6e, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0c, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x22, 0xb7, 0x02, 0x0a, 0x12,
	0x4b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x46, 0x0a, 0x1d, 0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73,
	0x5f, 0x61, 0x70, 0x69, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x1a,
	0x6b, 0x75, 0x62, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x65, 0x73, 0x41, 0x70, 0x69, 0x53, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x10, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6e, 0x6f, 0x64, 0x65, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x6e, 0x6f, 0x64,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x22, 0x0a,
	0x0a, 0x76, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x76, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x62, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x4d, 0x62, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xc1, 0x01, 0x0a, 0x0f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x45, 0x0a, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65,
	0x22, 0x67, 0x0a, 0x04, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x44, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f, 0x55,
	0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x22, 0xb7, 0x01, 0x0a, 0x09, 0x41, 0x75,
	0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x69, 0x73, 0x73, 0x75, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x69, 0x73,
	0x73, 0x75, 0x65, 0x72, 0x12, 0x39, 0x0a, 0x16, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x5f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x30, 0x0a, 0x11, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
	0x72, 0x12, 0x20, 0x0a, 0x09, 0x6f, 0x69, 0x64, 0x63, 0x5f, 0x6a, 0x77, 0x6b, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6f, 0x69, 0x64, 0x63, 0x4a,
	0x77, 0x6b, 0x73, 0x42, 0xbb, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2e,
	0x76, 0x31, 0x42, 0x0f, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x67, 0x6b, 0x65, 0x68, 0x75, 0x62, 0x2f, 0x76, 0x31, 0x3b, 0x67, 0x6b, 0x65,
	0x68, 0x75, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b, 0x65, 0x48,
	0x75, 0x62, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x48, 0x75, 0x62, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_gkehub_v1_membership_proto_rawDescOnce sync.Once
	file_google_cloud_gkehub_v1_membership_proto_rawDescData = file_google_cloud_gkehub_v1_membership_proto_rawDesc
)

func file_google_cloud_gkehub_v1_membership_proto_rawDescGZIP() []byte {
	file_google_cloud_gkehub_v1_membership_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkehub_v1_membership_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkehub_v1_membership_proto_rawDescData)
	})
	return file_google_cloud_gkehub_v1_membership_proto_rawDescData
}

var file_google_cloud_gkehub_v1_membership_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_gkehub_v1_membership_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_gkehub_v1_membership_proto_goTypes = []interface{}{
	(MembershipState_Code)(0),     // 0: google.cloud.gkehub.v1.MembershipState.Code
	(*Membership)(nil),            // 1: google.cloud.gkehub.v1.Membership
	(*MembershipEndpoint)(nil),    // 2: google.cloud.gkehub.v1.MembershipEndpoint
	(*KubernetesResource)(nil),    // 3: google.cloud.gkehub.v1.KubernetesResource
	(*ResourceOptions)(nil),       // 4: google.cloud.gkehub.v1.ResourceOptions
	(*ResourceManifest)(nil),      // 5: google.cloud.gkehub.v1.ResourceManifest
	(*GkeCluster)(nil),            // 6: google.cloud.gkehub.v1.GkeCluster
	(*KubernetesMetadata)(nil),    // 7: google.cloud.gkehub.v1.KubernetesMetadata
	(*MembershipState)(nil),       // 8: google.cloud.gkehub.v1.MembershipState
	(*Authority)(nil),             // 9: google.cloud.gkehub.v1.Authority
	nil,                           // 10: google.cloud.gkehub.v1.Membership.LabelsEntry
	(*timestamppb.Timestamp)(nil), // 11: google.protobuf.Timestamp
}
var file_google_cloud_gkehub_v1_membership_proto_depIdxs = []int32{
	2,  // 0: google.cloud.gkehub.v1.Membership.endpoint:type_name -> google.cloud.gkehub.v1.MembershipEndpoint
	10, // 1: google.cloud.gkehub.v1.Membership.labels:type_name -> google.cloud.gkehub.v1.Membership.LabelsEntry
	8,  // 2: google.cloud.gkehub.v1.Membership.state:type_name -> google.cloud.gkehub.v1.MembershipState
	11, // 3: google.cloud.gkehub.v1.Membership.create_time:type_name -> google.protobuf.Timestamp
	11, // 4: google.cloud.gkehub.v1.Membership.update_time:type_name -> google.protobuf.Timestamp
	11, // 5: google.cloud.gkehub.v1.Membership.delete_time:type_name -> google.protobuf.Timestamp
	11, // 6: google.cloud.gkehub.v1.Membership.last_connection_time:type_name -> google.protobuf.Timestamp
	9,  // 7: google.cloud.gkehub.v1.Membership.authority:type_name -> google.cloud.gkehub.v1.Authority
	6,  // 8: google.cloud.gkehub.v1.MembershipEndpoint.gke_cluster:type_name -> google.cloud.gkehub.v1.GkeCluster
	7,  // 9: google.cloud.gkehub.v1.MembershipEndpoint.kubernetes_metadata:type_name -> google.cloud.gkehub.v1.KubernetesMetadata
	3,  // 10: google.cloud.gkehub.v1.MembershipEndpoint.kubernetes_resource:type_name -> google.cloud.gkehub.v1.KubernetesResource
	5,  // 11: google.cloud.gkehub.v1.KubernetesResource.membership_resources:type_name -> google.cloud.gkehub.v1.ResourceManifest
	5,  // 12: google.cloud.gkehub.v1.KubernetesResource.connect_resources:type_name -> google.cloud.gkehub.v1.ResourceManifest
	4,  // 13: google.cloud.gkehub.v1.KubernetesResource.resource_options:type_name -> google.cloud.gkehub.v1.ResourceOptions
	11, // 14: google.cloud.gkehub.v1.KubernetesMetadata.update_time:type_name -> google.protobuf.Timestamp
	0,  // 15: google.cloud.gkehub.v1.MembershipState.code:type_name -> google.cloud.gkehub.v1.MembershipState.Code
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_gkehub_v1_membership_proto_init() }
func file_google_cloud_gkehub_v1_membership_proto_init() {
	if File_google_cloud_gkehub_v1_membership_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkehub_v1_membership_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Membership); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1_membership_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipEndpoint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1_membership_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1_membership_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1_membership_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceManifest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1_membership_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GkeCluster); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1_membership_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*KubernetesMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1_membership_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MembershipState); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkehub_v1_membership_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Authority); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_gkehub_v1_membership_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Membership_Endpoint)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkehub_v1_membership_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkehub_v1_membership_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkehub_v1_membership_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkehub_v1_membership_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkehub_v1_membership_proto_msgTypes,
	}.Build()
	File_google_cloud_gkehub_v1_membership_proto = out.File
	file_google_cloud_gkehub_v1_membership_proto_rawDesc = nil
	file_google_cloud_gkehub_v1_membership_proto_goTypes = nil
	file_google_cloud_gkehub_v1_membership_proto_depIdxs = nil
}
