// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/asset/v1/asset_service.proto

package assetpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	expr "google.golang.org/genproto/googleapis/type/expr"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Asset content type.
type ContentType int32

const (
	// Unspecified content type.
	ContentType_CONTENT_TYPE_UNSPECIFIED ContentType = 0
	// Resource metadata.
	ContentType_RESOURCE ContentType = 1
	// The actual IAM policy set on a resource.
	ContentType_IAM_POLICY ContentType = 2
	// The organization policy set on an asset.
	ContentType_ORG_POLICY ContentType = 4
	// The Access Context Manager policy set on an asset.
	ContentType_ACCESS_POLICY ContentType = 5
	// The runtime OS Inventory information.
	ContentType_OS_INVENTORY ContentType = 6
	// The related resources.
	ContentType_RELATIONSHIP ContentType = 7
)

// Enum value maps for ContentType.
var (
	ContentType_name = map[int32]string{
		0: "CONTENT_TYPE_UNSPECIFIED",
		1: "RESOURCE",
		2: "IAM_POLICY",
		4: "ORG_POLICY",
		5: "ACCESS_POLICY",
		6: "OS_INVENTORY",
		7: "RELATIONSHIP",
	}
	ContentType_value = map[string]int32{
		"CONTENT_TYPE_UNSPECIFIED": 0,
		"RESOURCE":                 1,
		"IAM_POLICY":               2,
		"ORG_POLICY":               4,
		"ACCESS_POLICY":            5,
		"OS_INVENTORY":             6,
		"RELATIONSHIP":             7,
	}
)

func (x ContentType) Enum() *ContentType {
	p := new(ContentType)
	*p = x
	return p
}

func (x ContentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ContentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[0].Descriptor()
}

func (ContentType) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[0]
}

func (x ContentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ContentType.Descriptor instead.
func (ContentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{0}
}

// This enum is used to determine the partition key column when exporting
// assets to BigQuery partitioned table(s). Note that, if the partition key is
// a timestamp column, the actual partition is based on its date value
// (expressed in UTC. see details in
// https://cloud.google.com/bigquery/docs/partitioned-tables#date_timestamp_partitioned_tables).
type PartitionSpec_PartitionKey int32

const (
	// Unspecified partition key. If used, it means using non-partitioned table.
	PartitionSpec_PARTITION_KEY_UNSPECIFIED PartitionSpec_PartitionKey = 0
	// The time when the snapshot is taken. If specified as partition key, the
	// result table(s) is partitoned by the additional timestamp column,
	// readTime. If [read_time] in ExportAssetsRequest is specified, the
	// readTime column's value will be the same as it. Otherwise, its value will
	// be the current time that is used to take the snapshot.
	PartitionSpec_READ_TIME PartitionSpec_PartitionKey = 1
	// The time when the request is received and started to be processed. If
	// specified as partition key, the result table(s) is partitoned by the
	// requestTime column, an additional timestamp column representing when the
	// request was received.
	PartitionSpec_REQUEST_TIME PartitionSpec_PartitionKey = 2
)

// Enum value maps for PartitionSpec_PartitionKey.
var (
	PartitionSpec_PartitionKey_name = map[int32]string{
		0: "PARTITION_KEY_UNSPECIFIED",
		1: "READ_TIME",
		2: "REQUEST_TIME",
	}
	PartitionSpec_PartitionKey_value = map[string]int32{
		"PARTITION_KEY_UNSPECIFIED": 0,
		"READ_TIME":                 1,
		"REQUEST_TIME":              2,
	}
)

func (x PartitionSpec_PartitionKey) Enum() *PartitionSpec_PartitionKey {
	p := new(PartitionSpec_PartitionKey)
	*p = x
	return p
}

func (x PartitionSpec_PartitionKey) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PartitionSpec_PartitionKey) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[1].Descriptor()
}

func (PartitionSpec_PartitionKey) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[1]
}

func (x PartitionSpec_PartitionKey) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PartitionSpec_PartitionKey.Descriptor instead.
func (PartitionSpec_PartitionKey) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{18, 0}
}

// This enum determines the partition key column for the bigquery tables.
// Partitioning can improve query performance and reduce query cost by
// filtering partitions. Refer to
// https://cloud.google.com/bigquery/docs/partitioned-tables for details.
type IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey int32

const (
	// Unspecified partition key. Tables won't be partitioned using this
	// option.
	IamPolicyAnalysisOutputConfig_BigQueryDestination_PARTITION_KEY_UNSPECIFIED IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey = 0
	// The time when the request is received. If specified as partition key,
	// the result table(s) is partitoned by the RequestTime column, an
	// additional timestamp column representing when the request was received.
	IamPolicyAnalysisOutputConfig_BigQueryDestination_REQUEST_TIME IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey = 1
)

// Enum value maps for IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey.
var (
	IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey_name = map[int32]string{
		0: "PARTITION_KEY_UNSPECIFIED",
		1: "REQUEST_TIME",
	}
	IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey_value = map[string]int32{
		"PARTITION_KEY_UNSPECIFIED": 0,
		"REQUEST_TIME":              1,
	}
)

func (x IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) Enum() *IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey {
	p := new(IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey)
	*p = x
	return p
}

func (x IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[2].Descriptor()
}

func (IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[2]
}

func (x IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey.Descriptor instead.
func (IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{29, 1, 0}
}

// View enum for supporting partial analysis responses.
type AnalyzeMoveRequest_AnalysisView int32

const (
	// The default/unset value.
	// The API will default to the FULL view.
	AnalyzeMoveRequest_ANALYSIS_VIEW_UNSPECIFIED AnalyzeMoveRequest_AnalysisView = 0
	// Full analysis including all level of impacts of the specified resource
	// move.
	AnalyzeMoveRequest_FULL AnalyzeMoveRequest_AnalysisView = 1
	// Basic analysis only including blockers which will prevent the specified
	// resource move at runtime.
	AnalyzeMoveRequest_BASIC AnalyzeMoveRequest_AnalysisView = 2
)

// Enum value maps for AnalyzeMoveRequest_AnalysisView.
var (
	AnalyzeMoveRequest_AnalysisView_name = map[int32]string{
		0: "ANALYSIS_VIEW_UNSPECIFIED",
		1: "FULL",
		2: "BASIC",
	}
	AnalyzeMoveRequest_AnalysisView_value = map[string]int32{
		"ANALYSIS_VIEW_UNSPECIFIED": 0,
		"FULL":                      1,
		"BASIC":                     2,
	}
)

func (x AnalyzeMoveRequest_AnalysisView) Enum() *AnalyzeMoveRequest_AnalysisView {
	p := new(AnalyzeMoveRequest_AnalysisView)
	*p = x
	return p
}

func (x AnalyzeMoveRequest_AnalysisView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnalyzeMoveRequest_AnalysisView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[3].Descriptor()
}

func (AnalyzeMoveRequest_AnalysisView) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[3]
}

func (x AnalyzeMoveRequest_AnalysisView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnalyzeMoveRequest_AnalysisView.Descriptor instead.
func (AnalyzeMoveRequest_AnalysisView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{39, 0}
}

// Specifies the default behavior in the absence of any `Policy` for the
// `Constraint`. This must not be `CONSTRAINT_DEFAULT_UNSPECIFIED`.
type AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault int32

const (
	// This is only used for distinguishing unset values and should never be
	// used.
	AnalyzerOrgPolicyConstraint_Constraint_CONSTRAINT_DEFAULT_UNSPECIFIED AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault = 0
	// Indicate that all values are allowed for list constraints.
	// Indicate that enforcement is off for boolean constraints.
	AnalyzerOrgPolicyConstraint_Constraint_ALLOW AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault = 1
	// Indicate that all values are denied for list constraints.
	// Indicate that enforcement is on for boolean constraints.
	AnalyzerOrgPolicyConstraint_Constraint_DENY AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault = 2
)

// Enum value maps for AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault.
var (
	AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault_name = map[int32]string{
		0: "CONSTRAINT_DEFAULT_UNSPECIFIED",
		1: "ALLOW",
		2: "DENY",
	}
	AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault_value = map[string]int32{
		"CONSTRAINT_DEFAULT_UNSPECIFIED": 0,
		"ALLOW":                          1,
		"DENY":                           2,
	}
)

func (x AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault) Enum() *AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault {
	p := new(AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault)
	*p = x
	return p
}

func (x AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[4].Descriptor()
}

func (AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[4]
}

func (x AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault.Descriptor instead.
func (AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{53, 0, 0}
}

// The operation in which this constraint will be applied. For example:
// If the constraint applies only when create VMs, the method_types will be
// "CREATE" only. If the constraint applied when create or delete VMs, the
// method_types will be "CREATE" and "DELETE".
type AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType int32

const (
	// Unspecified. Will results in user error.
	AnalyzerOrgPolicyConstraint_CustomConstraint_METHOD_TYPE_UNSPECIFIED AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType = 0
	// Constraint applied when creating the resource.
	AnalyzerOrgPolicyConstraint_CustomConstraint_CREATE AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType = 1
	// Constraint applied when updating the resource.
	AnalyzerOrgPolicyConstraint_CustomConstraint_UPDATE AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType = 2
	// Constraint applied when deleting the resource.
	AnalyzerOrgPolicyConstraint_CustomConstraint_DELETE AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType = 3
)

// Enum value maps for AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType.
var (
	AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType_name = map[int32]string{
		0: "METHOD_TYPE_UNSPECIFIED",
		1: "CREATE",
		2: "UPDATE",
		3: "DELETE",
	}
	AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType_value = map[string]int32{
		"METHOD_TYPE_UNSPECIFIED": 0,
		"CREATE":                  1,
		"UPDATE":                  2,
		"DELETE":                  3,
	}
)

func (x AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType) Enum() *AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType {
	p := new(AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType)
	*p = x
	return p
}

func (x AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[5].Descriptor()
}

func (AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[5]
}

func (x AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType.Descriptor instead.
func (AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{53, 1, 0}
}

// Allow or deny type.
type AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType int32

const (
	// Unspecified. Will results in user error.
	AnalyzerOrgPolicyConstraint_CustomConstraint_ACTION_TYPE_UNSPECIFIED AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType = 0
	// Allowed action type.
	AnalyzerOrgPolicyConstraint_CustomConstraint_ALLOW AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType = 1
	// Deny action type.
	AnalyzerOrgPolicyConstraint_CustomConstraint_DENY AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType = 2
)

// Enum value maps for AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType.
var (
	AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType_name = map[int32]string{
		0: "ACTION_TYPE_UNSPECIFIED",
		1: "ALLOW",
		2: "DENY",
	}
	AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType_value = map[string]int32{
		"ACTION_TYPE_UNSPECIFIED": 0,
		"ALLOW":                   1,
		"DENY":                    2,
	}
)

func (x AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType) Enum() *AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType {
	p := new(AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType)
	*p = x
	return p
}

func (x AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_asset_v1_asset_service_proto_enumTypes[6].Descriptor()
}

func (AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType) Type() protoreflect.EnumType {
	return &file_google_cloud_asset_v1_asset_service_proto_enumTypes[6]
}

func (x AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType.Descriptor instead.
func (AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{53, 1, 1}
}

// Represents the metadata of the longrunning operation for the
// AnalyzeIamPolicyLongrunning RPC.
type AnalyzeIamPolicyLongrunningMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *AnalyzeIamPolicyLongrunningMetadata) Reset() {
	*x = AnalyzeIamPolicyLongrunningMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyLongrunningMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyLongrunningMetadata) ProtoMessage() {}

func (x *AnalyzeIamPolicyLongrunningMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyLongrunningMetadata.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyLongrunningMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{0}
}

func (x *AnalyzeIamPolicyLongrunningMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// Export asset request.
type ExportAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. This can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345"),
	// or a folder number (such as "folders/123").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Timestamp to take an asset snapshot. This can only be set to a timestamp
	// between the current time and the current time minus 35 days (inclusive).
	// If not specified, the current time will be used. Due to delays in resource
	// data collection and indexing, there is a volatile window during which
	// running the same query may get different results.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// A list of asset types to take a snapshot for. For example:
	// "compute.googleapis.com/Disk".
	//
	// Regular expressions are also supported. For example:
	//
	// * "compute.googleapis.com.*" snapshots resources whose asset type starts
	// with "compute.googleapis.com".
	// * ".*Instance" snapshots resources whose asset type ends with "Instance".
	// * ".*Instance.*" snapshots resources whose asset type contains "Instance".
	//
	// See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
	// regular expression syntax. If the regular expression does not match any
	// supported asset type, an INVALID_ARGUMENT error will be returned.
	//
	// If specified, only matching assets will be returned, otherwise, it will
	// snapshot all asset types. See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name will be
	// returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Required. Output configuration indicating where the results will be output
	// to.
	OutputConfig *OutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// A list of relationship types to export, for example:
	// `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
	// content_type=RELATIONSHIP.
	// * If specified:
	// it snapshots specified relationships. It returns an error if
	// any of the [relationship_types] doesn't belong to the supported
	// relationship types of the [asset_types] or if any of the [asset_types]
	// doesn't belong to the source types of the [relationship_types].
	// * Otherwise:
	// it snapshots the supported relationships for all [asset_types] or returns
	// an error if any of the [asset_types] has no relationship support.
	// An unspecified asset types field means all supported asset_types.
	// See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
	// supported asset types and relationship types.
	RelationshipTypes []string `protobuf:"bytes,6,rep,name=relationship_types,json=relationshipTypes,proto3" json:"relationship_types,omitempty"`
}

func (x *ExportAssetsRequest) Reset() {
	*x = ExportAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAssetsRequest) ProtoMessage() {}

func (x *ExportAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAssetsRequest.ProtoReflect.Descriptor instead.
func (*ExportAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{1}
}

func (x *ExportAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportAssetsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ExportAssetsRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *ExportAssetsRequest) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *ExportAssetsRequest) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ExportAssetsRequest) GetRelationshipTypes() []string {
	if x != nil {
		return x.RelationshipTypes
	}
	return nil
}

// The export asset response. This message is returned by the
// [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation]
// method in the returned
// [google.longrunning.Operation.response][google.longrunning.Operation.response]
// field.
type ExportAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time the snapshot was taken.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Output configuration indicating where the results were output to.
	OutputConfig *OutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Output result indicating where the assets were exported to. For example, a
	// set of actual Cloud Storage object URIs where the assets are exported to.
	// The URIs can be different from what [output_config] has specified, as the
	// service will split the output object into multiple ones once it exceeds a
	// single Cloud Storage object limit.
	OutputResult *OutputResult `protobuf:"bytes,3,opt,name=output_result,json=outputResult,proto3" json:"output_result,omitempty"`
}

func (x *ExportAssetsResponse) Reset() {
	*x = ExportAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportAssetsResponse) ProtoMessage() {}

func (x *ExportAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportAssetsResponse.ProtoReflect.Descriptor instead.
func (*ExportAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{2}
}

func (x *ExportAssetsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ExportAssetsResponse) GetOutputConfig() *OutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

func (x *ExportAssetsResponse) GetOutputResult() *OutputResult {
	if x != nil {
		return x.OutputResult
	}
	return nil
}

// ListAssets request.
type ListAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the organization, folder, or project the assets belong
	// to. Format: "organizations/[organization-number]" (such as
	// "organizations/123"), "projects/[project-id]" (such as
	// "projects/my-project-id"), "projects/[project-number]" (such as
	// "projects/12345"), or "folders/[folder-number]" (such as "folders/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Timestamp to take an asset snapshot. This can only be set to a timestamp
	// between the current time and the current time minus 35 days (inclusive).
	// If not specified, the current time will be used. Due to delays in resource
	// data collection and indexing, there is a volatile window during which
	// running the same query may get different results.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// A list of asset types to take a snapshot for. For example:
	// "compute.googleapis.com/Disk".
	//
	// Regular expression is also supported. For example:
	//
	// * "compute.googleapis.com.*" snapshots resources whose asset type starts
	// with "compute.googleapis.com".
	// * ".*Instance" snapshots resources whose asset type ends with "Instance".
	// * ".*Instance.*" snapshots resources whose asset type contains "Instance".
	//
	// See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
	// regular expression syntax. If the regular expression does not match any
	// supported asset type, an INVALID_ARGUMENT error will be returned.
	//
	// If specified, only matching assets will be returned, otherwise, it will
	// snapshot all asset types. See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name will
	// be returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// The maximum number of assets to be returned in a single response. Default
	// is 100, minimum is 1, and maximum is 1000.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The `next_page_token` returned from the previous `ListAssetsResponse`, or
	// unspecified for the first `ListAssetsRequest`. It is a continuation of a
	// prior `ListAssets` call, and the API should return the next page of assets.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A list of relationship types to output, for example:
	// `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
	// content_type=RELATIONSHIP.
	// * If specified:
	// it snapshots specified relationships. It returns an error if
	// any of the [relationship_types] doesn't belong to the supported
	// relationship types of the [asset_types] or if any of the [asset_types]
	// doesn't belong to the source types of the [relationship_types].
	// * Otherwise:
	// it snapshots the supported relationships for all [asset_types] or returns
	// an error if any of the [asset_types] has no relationship support.
	// An unspecified asset types field means all supported asset_types.
	// See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types and relationship types.
	RelationshipTypes []string `protobuf:"bytes,7,rep,name=relationship_types,json=relationshipTypes,proto3" json:"relationship_types,omitempty"`
}

func (x *ListAssetsRequest) Reset() {
	*x = ListAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsRequest) ProtoMessage() {}

func (x *ListAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsRequest.ProtoReflect.Descriptor instead.
func (*ListAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAssetsRequest) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListAssetsRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *ListAssetsRequest) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *ListAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListAssetsRequest) GetRelationshipTypes() []string {
	if x != nil {
		return x.RelationshipTypes
	}
	return nil
}

// ListAssets response.
type ListAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time the snapshot was taken.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Assets.
	Assets []*Asset `protobuf:"bytes,2,rep,name=assets,proto3" json:"assets,omitempty"`
	// Token to retrieve the next page of results. It expires 72 hours after the
	// page token for the first page is generated. Set to empty if there are no
	// remaining results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAssetsResponse) Reset() {
	*x = ListAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAssetsResponse) ProtoMessage() {}

func (x *ListAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAssetsResponse.ProtoReflect.Descriptor instead.
func (*ListAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListAssetsResponse) GetReadTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ReadTime
	}
	return nil
}

func (x *ListAssetsResponse) GetAssets() []*Asset {
	if x != nil {
		return x.Assets
	}
	return nil
}

func (x *ListAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Batch get assets history request.
type BatchGetAssetsHistoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. It can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id")", or a project number (such as "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// A list of the full names of the assets.
	// See: https://cloud.google.com/asset-inventory/docs/resource-name-format
	// Example:
	//
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	//
	// The request becomes a no-op if the asset name list is empty, and the max
	// size of the asset name list is 100 in one request.
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// Optional. The content type.
	ContentType ContentType `protobuf:"varint,3,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Optional. The time window for the asset history. Both start_time and
	// end_time are optional and if set, it must be after the current time minus
	// 35 days. If end_time is not set, it is default to current timestamp.
	// If start_time is not set, the snapshot of the assets at end_time will be
	// returned. The returned results contain all temporal assets whose time
	// window overlap with read_time_window.
	ReadTimeWindow *TimeWindow `protobuf:"bytes,4,opt,name=read_time_window,json=readTimeWindow,proto3" json:"read_time_window,omitempty"`
	// Optional. A list of relationship types to output, for example:
	// `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
	// content_type=RELATIONSHIP.
	// * If specified:
	// it outputs specified relationships' history on the [asset_names]. It
	// returns an error if any of the [relationship_types] doesn't belong to the
	// supported relationship types of the [asset_names] or if any of the
	// [asset_names]'s types doesn't belong to the source types of the
	// [relationship_types].
	// * Otherwise:
	// it outputs the supported relationships' history on the [asset_names] or
	// returns an error if any of the [asset_names]'s types has no relationship
	// support.
	// See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview) for all
	// supported asset types and relationship types.
	RelationshipTypes []string `protobuf:"bytes,5,rep,name=relationship_types,json=relationshipTypes,proto3" json:"relationship_types,omitempty"`
}

func (x *BatchGetAssetsHistoryRequest) Reset() {
	*x = BatchGetAssetsHistoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetAssetsHistoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetAssetsHistoryRequest) ProtoMessage() {}

func (x *BatchGetAssetsHistoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetAssetsHistoryRequest.ProtoReflect.Descriptor instead.
func (*BatchGetAssetsHistoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{5}
}

func (x *BatchGetAssetsHistoryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *BatchGetAssetsHistoryRequest) GetAssetNames() []string {
	if x != nil {
		return x.AssetNames
	}
	return nil
}

func (x *BatchGetAssetsHistoryRequest) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *BatchGetAssetsHistoryRequest) GetReadTimeWindow() *TimeWindow {
	if x != nil {
		return x.ReadTimeWindow
	}
	return nil
}

func (x *BatchGetAssetsHistoryRequest) GetRelationshipTypes() []string {
	if x != nil {
		return x.RelationshipTypes
	}
	return nil
}

// Batch get assets history response.
type BatchGetAssetsHistoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of assets with valid time windows.
	Assets []*TemporalAsset `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets,omitempty"`
}

func (x *BatchGetAssetsHistoryResponse) Reset() {
	*x = BatchGetAssetsHistoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetAssetsHistoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetAssetsHistoryResponse) ProtoMessage() {}

func (x *BatchGetAssetsHistoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetAssetsHistoryResponse.ProtoReflect.Descriptor instead.
func (*BatchGetAssetsHistoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{6}
}

func (x *BatchGetAssetsHistoryResponse) GetAssets() []*TemporalAsset {
	if x != nil {
		return x.Assets
	}
	return nil
}

// Create asset feed request.
type CreateFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project/folder/organization where this feed
	// should be created in. It can only be an organization number (such as
	// "organizations/123"), a folder number (such as "folders/123"), a project ID
	// (such as "projects/my-project-id"), or a project number (such as
	// "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. This is the client-assigned asset feed identifier and it needs to
	// be unique under a specific parent project/folder/organization.
	FeedId string `protobuf:"bytes,2,opt,name=feed_id,json=feedId,proto3" json:"feed_id,omitempty"`
	// Required. The feed details. The field `name` must be empty and it will be
	// generated in the format of: projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Feed *Feed `protobuf:"bytes,3,opt,name=feed,proto3" json:"feed,omitempty"`
}

func (x *CreateFeedRequest) Reset() {
	*x = CreateFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateFeedRequest) ProtoMessage() {}

func (x *CreateFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateFeedRequest.ProtoReflect.Descriptor instead.
func (*CreateFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{7}
}

func (x *CreateFeedRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateFeedRequest) GetFeedId() string {
	if x != nil {
		return x.FeedId
	}
	return ""
}

func (x *CreateFeedRequest) GetFeed() *Feed {
	if x != nil {
		return x.Feed
	}
	return nil
}

// Get asset feed request.
type GetFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetFeedRequest) Reset() {
	*x = GetFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetFeedRequest) ProtoMessage() {}

func (x *GetFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetFeedRequest.ProtoReflect.Descriptor instead.
func (*GetFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{8}
}

func (x *GetFeedRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// List asset feeds request.
type ListFeedsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent project/folder/organization whose feeds are to be
	// listed. It can only be using project/folder/organization number (such as
	// "folders/12345")", or a project ID (such as "projects/my-project-id").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListFeedsRequest) Reset() {
	*x = ListFeedsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFeedsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeedsRequest) ProtoMessage() {}

func (x *ListFeedsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeedsRequest.ProtoReflect.Descriptor instead.
func (*ListFeedsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{9}
}

func (x *ListFeedsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

type ListFeedsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of feeds.
	Feeds []*Feed `protobuf:"bytes,1,rep,name=feeds,proto3" json:"feeds,omitempty"`
}

func (x *ListFeedsResponse) Reset() {
	*x = ListFeedsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListFeedsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListFeedsResponse) ProtoMessage() {}

func (x *ListFeedsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListFeedsResponse.ProtoReflect.Descriptor instead.
func (*ListFeedsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListFeedsResponse) GetFeeds() []*Feed {
	if x != nil {
		return x.Feeds
	}
	return nil
}

// Update asset feed request.
type UpdateFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The new values of feed details. It must match an existing feed
	// and the field `name` must be in the format of:
	// projects/project_number/feeds/feed_id or
	// folders/folder_number/feeds/feed_id or
	// organizations/organization_number/feeds/feed_id.
	Feed *Feed `protobuf:"bytes,1,opt,name=feed,proto3" json:"feed,omitempty"`
	// Required. Only updates the `feed` fields indicated by this mask.
	// The field mask must not be empty, and it must not contain fields that
	// are immutable or only set by the server.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateFeedRequest) Reset() {
	*x = UpdateFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateFeedRequest) ProtoMessage() {}

func (x *UpdateFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateFeedRequest.ProtoReflect.Descriptor instead.
func (*UpdateFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{11}
}

func (x *UpdateFeedRequest) GetFeed() *Feed {
	if x != nil {
		return x.Feed
	}
	return nil
}

func (x *UpdateFeedRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

type DeleteFeedRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the feed and it must be in the format of:
	// projects/project_number/feeds/feed_id
	// folders/folder_number/feeds/feed_id
	// organizations/organization_number/feeds/feed_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteFeedRequest) Reset() {
	*x = DeleteFeedRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteFeedRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteFeedRequest) ProtoMessage() {}

func (x *DeleteFeedRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteFeedRequest.ProtoReflect.Descriptor instead.
func (*DeleteFeedRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{12}
}

func (x *DeleteFeedRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Output configuration for export assets destination.
type OutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset export destination.
	//
	// Types that are assignable to Destination:
	//
	//	*OutputConfig_GcsDestination
	//	*OutputConfig_BigqueryDestination
	Destination isOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *OutputConfig) Reset() {
	*x = OutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputConfig) ProtoMessage() {}

func (x *OutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputConfig.ProtoReflect.Descriptor instead.
func (*OutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{13}
}

func (m *OutputConfig) GetDestination() isOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *OutputConfig) GetGcsDestination() *GcsDestination {
	if x, ok := x.GetDestination().(*OutputConfig_GcsDestination); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *OutputConfig) GetBigqueryDestination() *BigQueryDestination {
	if x, ok := x.GetDestination().(*OutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

type isOutputConfig_Destination interface {
	isOutputConfig_Destination()
}

type OutputConfig_GcsDestination struct {
	// Destination on Cloud Storage.
	GcsDestination *GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type OutputConfig_BigqueryDestination struct {
	// Destination on BigQuery. The output table stores the fields in asset
	// Protobuf as columns in BigQuery.
	BigqueryDestination *BigQueryDestination `protobuf:"bytes,2,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*OutputConfig_GcsDestination) isOutputConfig_Destination() {}

func (*OutputConfig_BigqueryDestination) isOutputConfig_Destination() {}

// Output result of export assets.
type OutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset export result.
	//
	// Types that are assignable to Result:
	//
	//	*OutputResult_GcsResult
	Result isOutputResult_Result `protobuf_oneof:"result"`
}

func (x *OutputResult) Reset() {
	*x = OutputResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputResult) ProtoMessage() {}

func (x *OutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputResult.ProtoReflect.Descriptor instead.
func (*OutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{14}
}

func (m *OutputResult) GetResult() isOutputResult_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *OutputResult) GetGcsResult() *GcsOutputResult {
	if x, ok := x.GetResult().(*OutputResult_GcsResult); ok {
		return x.GcsResult
	}
	return nil
}

type isOutputResult_Result interface {
	isOutputResult_Result()
}

type OutputResult_GcsResult struct {
	// Export result on Cloud Storage.
	GcsResult *GcsOutputResult `protobuf:"bytes,1,opt,name=gcs_result,json=gcsResult,proto3,oneof"`
}

func (*OutputResult_GcsResult) isOutputResult_Result() {}

// A Cloud Storage output result.
type GcsOutputResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of URIs of the Cloud Storage objects. Example:
	// "gs://bucket_name/object_name".
	Uris []string `protobuf:"bytes,1,rep,name=uris,proto3" json:"uris,omitempty"`
}

func (x *GcsOutputResult) Reset() {
	*x = GcsOutputResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsOutputResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsOutputResult) ProtoMessage() {}

func (x *GcsOutputResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsOutputResult.ProtoReflect.Descriptor instead.
func (*GcsOutputResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{15}
}

func (x *GcsOutputResult) GetUris() []string {
	if x != nil {
		return x.Uris
	}
	return nil
}

// A Cloud Storage location.
type GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to ObjectUri:
	//
	//	*GcsDestination_Uri
	//	*GcsDestination_UriPrefix
	ObjectUri isGcsDestination_ObjectUri `protobuf_oneof:"object_uri"`
}

func (x *GcsDestination) Reset() {
	*x = GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GcsDestination) ProtoMessage() {}

func (x *GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GcsDestination.ProtoReflect.Descriptor instead.
func (*GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{16}
}

func (m *GcsDestination) GetObjectUri() isGcsDestination_ObjectUri {
	if m != nil {
		return m.ObjectUri
	}
	return nil
}

func (x *GcsDestination) GetUri() string {
	if x, ok := x.GetObjectUri().(*GcsDestination_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *GcsDestination) GetUriPrefix() string {
	if x, ok := x.GetObjectUri().(*GcsDestination_UriPrefix); ok {
		return x.UriPrefix
	}
	return ""
}

type isGcsDestination_ObjectUri interface {
	isGcsDestination_ObjectUri()
}

type GcsDestination_Uri struct {
	// The URI of the Cloud Storage object. It's the same URI that is used by
	// gsutil. Example: "gs://bucket_name/object_name". See [Viewing and
	// Editing Object
	// Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
	// for more information.
	//
	// If the specified Cloud Storage object already exists and there is no
	// [hold](https://cloud.google.com/storage/docs/object-holds), it will be
	// overwritten with the exported result.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type GcsDestination_UriPrefix struct {
	// The URI prefix of all generated Cloud Storage objects. Example:
	// "gs://bucket_name/object_name_prefix". Each object URI is in format:
	// "gs://bucket_name/object_name_prefix/<asset type>/<shard number> and only
	// contains assets for that type. <shard number> starts from 0. Example:
	// "gs://bucket_name/object_name_prefix/compute.googleapis.com/Disk/0" is
	// the first shard of output objects containing all
	// compute.googleapis.com/Disk assets. An INVALID_ARGUMENT error will be
	// returned if file with the same name "gs://bucket_name/object_name_prefix"
	// already exists.
	UriPrefix string `protobuf:"bytes,2,opt,name=uri_prefix,json=uriPrefix,proto3,oneof"`
}

func (*GcsDestination_Uri) isGcsDestination_ObjectUri() {}

func (*GcsDestination_UriPrefix) isGcsDestination_ObjectUri() {}

// A BigQuery destination for exporting assets to.
type BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery dataset in format
	// "projects/projectId/datasets/datasetId", to which the snapshot result
	// should be exported. If this dataset does not exist, the export call returns
	// an INVALID_ARGUMENT error. Setting the `contentType` for `exportAssets`
	// determines the
	// [schema](/asset-inventory/docs/exporting-to-bigquery#bigquery-schema)
	// of the BigQuery table. Setting `separateTablesPerAssetType` to `TRUE` also
	// influences the schema.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The BigQuery table to which the snapshot result should be
	// written. If this table does not exist, a new table with the given name
	// will be created.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
	// If the destination table already exists and this flag is `TRUE`, the
	// table will be overwritten by the contents of assets snapshot. If the flag
	// is `FALSE` or unset and the destination table already exists, the export
	// call returns an INVALID_ARGUMEMT error.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// [partition_spec] determines whether to export to partitioned table(s) and
	// how to partition the data.
	//
	// If [partition_spec] is unset or [partition_spec.partition_key] is unset or
	// `PARTITION_KEY_UNSPECIFIED`, the snapshot results will be exported to
	// non-partitioned table(s). [force] will decide whether to overwrite existing
	// table(s).
	//
	// If [partition_spec] is specified. First, the snapshot results will be
	// written to partitioned table(s) with two additional timestamp columns,
	// readTime and requestTime, one of which will be the partition key. Secondly,
	// in the case when any destination table already exists, it will first try to
	// update existing table's schema as necessary by appending additional
	// columns. Then, if [force] is `TRUE`, the corresponding partition will be
	// overwritten by the snapshot results (data in different partitions will
	// remain intact); if [force] is unset or `FALSE`, it will append the data. An
	// error will be returned if the schema update or data appension fails.
	PartitionSpec *PartitionSpec `protobuf:"bytes,4,opt,name=partition_spec,json=partitionSpec,proto3" json:"partition_spec,omitempty"`
	// If this flag is `TRUE`, the snapshot results will be written to one or
	// multiple tables, each of which contains results of one asset type. The
	// [force] and [partition_spec] fields will apply to each of them.
	//
	// Field [table] will be concatenated with "_" and the asset type names (see
	// https://cloud.google.com/asset-inventory/docs/supported-asset-types for
	// supported asset types) to construct per-asset-type table names, in which
	// all non-alphanumeric characters like "." and "/" will be substituted by
	// "_". Example: if field [table] is "mytable" and snapshot results
	// contain "storage.googleapis.com/Bucket" assets, the corresponding table
	// name will be "mytable_storage_googleapis_com_Bucket". If any of these
	// tables does not exist, a new table with the concatenated name will be
	// created.
	//
	// When [content_type] in the ExportAssetsRequest is `RESOURCE`, the schema of
	// each table will include RECORD-type columns mapped to the nested fields in
	// the Asset.resource.data field of that asset type (up to the 15 nested level
	// BigQuery supports
	// (https://cloud.google.com/bigquery/docs/nested-repeated#limitations)). The
	// fields in >15 nested levels will be stored in JSON format string as a child
	// column of its parent RECORD column.
	//
	// If error occurs when exporting to any table, the whole export call will
	// return an error but the export results that already succeed will persist.
	// Example: if exporting to table_type_A succeeds when exporting to
	// table_type_B fails during one export call, the results in table_type_A will
	// persist and there will not be partial results persisting in a table.
	SeparateTablesPerAssetType bool `protobuf:"varint,5,opt,name=separate_tables_per_asset_type,json=separateTablesPerAssetType,proto3" json:"separate_tables_per_asset_type,omitempty"`
}

func (x *BigQueryDestination) Reset() {
	*x = BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BigQueryDestination) ProtoMessage() {}

func (x *BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BigQueryDestination.ProtoReflect.Descriptor instead.
func (*BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{17}
}

func (x *BigQueryDestination) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *BigQueryDestination) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *BigQueryDestination) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *BigQueryDestination) GetPartitionSpec() *PartitionSpec {
	if x != nil {
		return x.PartitionSpec
	}
	return nil
}

func (x *BigQueryDestination) GetSeparateTablesPerAssetType() bool {
	if x != nil {
		return x.SeparateTablesPerAssetType
	}
	return false
}

// Specifications of BigQuery partitioned table as export destination.
type PartitionSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The partition key for BigQuery partitioned table.
	PartitionKey PartitionSpec_PartitionKey `protobuf:"varint,1,opt,name=partition_key,json=partitionKey,proto3,enum=google.cloud.asset.v1.PartitionSpec_PartitionKey" json:"partition_key,omitempty"`
}

func (x *PartitionSpec) Reset() {
	*x = PartitionSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PartitionSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PartitionSpec) ProtoMessage() {}

func (x *PartitionSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PartitionSpec.ProtoReflect.Descriptor instead.
func (*PartitionSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{18}
}

func (x *PartitionSpec) GetPartitionKey() PartitionSpec_PartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return PartitionSpec_PARTITION_KEY_UNSPECIFIED
}

// A Pub/Sub destination.
type PubsubDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Pub/Sub topic to publish to.
	// Example: `projects/PROJECT_ID/topics/TOPIC_ID`.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
}

func (x *PubsubDestination) Reset() {
	*x = PubsubDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PubsubDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PubsubDestination) ProtoMessage() {}

func (x *PubsubDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PubsubDestination.ProtoReflect.Descriptor instead.
func (*PubsubDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{19}
}

func (x *PubsubDestination) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

// Output configuration for asset feed destination.
type FeedOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Asset feed destination.
	//
	// Types that are assignable to Destination:
	//
	//	*FeedOutputConfig_PubsubDestination
	Destination isFeedOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *FeedOutputConfig) Reset() {
	*x = FeedOutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeedOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeedOutputConfig) ProtoMessage() {}

func (x *FeedOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeedOutputConfig.ProtoReflect.Descriptor instead.
func (*FeedOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{20}
}

func (m *FeedOutputConfig) GetDestination() isFeedOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *FeedOutputConfig) GetPubsubDestination() *PubsubDestination {
	if x, ok := x.GetDestination().(*FeedOutputConfig_PubsubDestination); ok {
		return x.PubsubDestination
	}
	return nil
}

type isFeedOutputConfig_Destination interface {
	isFeedOutputConfig_Destination()
}

type FeedOutputConfig_PubsubDestination struct {
	// Destination on Pub/Sub.
	PubsubDestination *PubsubDestination `protobuf:"bytes,1,opt,name=pubsub_destination,json=pubsubDestination,proto3,oneof"`
}

func (*FeedOutputConfig_PubsubDestination) isFeedOutputConfig_Destination() {}

// An asset feed used to export asset updates to a destinations.
// An asset feed filter controls what updates are exported.
// The asset feed must be created within a project, organization, or
// folder. Supported destinations are:
// Pub/Sub topics.
type Feed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The format will be
	// projects/{project_number}/feeds/{client-assigned_feed_identifier} or
	// folders/{folder_number}/feeds/{client-assigned_feed_identifier} or
	// organizations/{organization_number}/feeds/{client-assigned_feed_identifier}
	//
	// The client-assigned feed identifier must be unique within the parent
	// project/folder/organization.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A list of the full names of the assets to receive updates. You must specify
	// either or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names or asset_types are exported to the feed.
	// Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// For a list of the full names for supported asset types, see [Resource
	// name format](/asset-inventory/docs/resource-name-format).
	AssetNames []string `protobuf:"bytes,2,rep,name=asset_names,json=assetNames,proto3" json:"asset_names,omitempty"`
	// A list of types of the assets to receive updates. You must specify either
	// or both of asset_names and asset_types. Only asset updates matching
	// specified asset_names or asset_types are exported to the feed.
	// Example: `"compute.googleapis.com/Disk"`
	//
	// For a list of all supported asset types, see
	// [Supported asset types](/asset-inventory/docs/supported-asset-types).
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Asset content type. If not specified, no content but the asset name and
	// type will be returned.
	ContentType ContentType `protobuf:"varint,4,opt,name=content_type,json=contentType,proto3,enum=google.cloud.asset.v1.ContentType" json:"content_type,omitempty"`
	// Required. Feed output configuration defining where the asset updates are
	// published to.
	FeedOutputConfig *FeedOutputConfig `protobuf:"bytes,5,opt,name=feed_output_config,json=feedOutputConfig,proto3" json:"feed_output_config,omitempty"`
	// A condition which determines whether an asset update should be published.
	// If specified, an asset will be returned only when the expression evaluates
	// to true.
	// When set, `expression` field in the `Expr` must be a valid [CEL expression]
	// (https://github.com/google/cel-spec) on a TemporalAsset with name
	// `temporal_asset`. Example: a Feed with expression ("temporal_asset.deleted
	// == true") will only publish Asset deletions. Other fields of `Expr` are
	// optional.
	//
	// See our [user
	// guide](https://cloud.google.com/asset-inventory/docs/monitoring-asset-changes-with-condition)
	// for detailed instructions.
	Condition *expr.Expr `protobuf:"bytes,6,opt,name=condition,proto3" json:"condition,omitempty"`
	// A list of relationship types to output, for example:
	// `INSTANCE_TO_INSTANCEGROUP`. This field should only be specified if
	// content_type=RELATIONSHIP.
	// * If specified:
	// it outputs specified relationship updates on the [asset_names] or the
	// [asset_types]. It returns an error if any of the [relationship_types]
	// doesn't belong to the supported relationship types of the [asset_names] or
	// [asset_types], or any of the [asset_names] or the [asset_types] doesn't
	// belong to the source types of the [relationship_types].
	// * Otherwise:
	// it outputs the supported relationships of the types of [asset_names] and
	// [asset_types] or returns an error if any of the [asset_names] or the
	// [asset_types] has no replationship support.
	// See [Introduction to Cloud Asset
	// Inventory](https://cloud.google.com/asset-inventory/docs/overview)
	// for all supported asset types and relationship types.
	RelationshipTypes []string `protobuf:"bytes,7,rep,name=relationship_types,json=relationshipTypes,proto3" json:"relationship_types,omitempty"`
}

func (x *Feed) Reset() {
	*x = Feed{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Feed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Feed) ProtoMessage() {}

func (x *Feed) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Feed.ProtoReflect.Descriptor instead.
func (*Feed) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{21}
}

func (x *Feed) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Feed) GetAssetNames() []string {
	if x != nil {
		return x.AssetNames
	}
	return nil
}

func (x *Feed) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *Feed) GetContentType() ContentType {
	if x != nil {
		return x.ContentType
	}
	return ContentType_CONTENT_TYPE_UNSPECIFIED
}

func (x *Feed) GetFeedOutputConfig() *FeedOutputConfig {
	if x != nil {
		return x.FeedOutputConfig
	}
	return nil
}

func (x *Feed) GetCondition() *expr.Expr {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *Feed) GetRelationshipTypes() []string {
	if x != nil {
		return x.RelationshipTypes
	}
	return nil
}

// Search all resources request.
type SearchAllResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A scope can be a project, a folder, or an organization. The
	// search is limited to the resources within the `scope`. The caller must be
	// granted the
	// [`cloudasset.assets.searchAllResources`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
	// permission on the desired scope.
	//
	// The allowed values are:
	//
	// * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
	// * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
	// * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
	// * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query statement. See [how to construct a
	// query](https://cloud.google.com/asset-inventory/docs/searching-resources#how_to_construct_a_query)
	// for more information. If not specified or empty, it will search all the
	// resources within the specified `scope`.
	//
	// Examples:
	//
	//   - `name:Important` to find Google Cloud resources whose name contains
	//     `Important` as a word.
	//   - `name=Important` to find the Google Cloud resource whose name is exactly
	//     `Important`.
	//   - `displayName:Impor*` to find Google Cloud resources whose display name
	//     contains `Impor` as a prefix of any word in the field.
	//   - `location:us-west*` to find Google Cloud resources whose location
	//     contains both `us` and `west` as prefixes.
	//   - `labels:prod` to find Google Cloud resources whose labels contain `prod`
	//     as a key or value.
	//   - `labels.env:prod` to find Google Cloud resources that have a label `env`
	//     and its value is `prod`.
	//   - `labels.env:*` to find Google Cloud resources that have a label `env`.
	//   - `tagKeys:env` to find Google Cloud resources that have directly
	//     attached tags where the
	//     [`TagKey.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagKeys#resource:-tagkey)
	//     contains `env`.
	//   - `tagValues:prod*` to find Google Cloud resources that have directly
	//     attached tags where the
	//     [`TagValue.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
	//     contains a word prefixed by `prod`.
	//   - `tagValueIds=tagValues/123` to find Google Cloud resources that have
	//     directly attached tags where the
	//     [`TagValue.name`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
	//     is exactly `tagValues/123`.
	//   - `effectiveTagKeys:env` to find Google Cloud resources that have
	//     directly attached or inherited tags where the
	//     [`TagKey.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagKeys#resource:-tagkey)
	//     contains `env`.
	//   - `effectiveTagValues:prod*` to find Google Cloud resources that have
	//     directly attached or inherited tags where the
	//     [`TagValue.namespacedName`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
	//     contains a word prefixed by `prod`.
	//   - `effectiveTagValueIds=tagValues/123` to find Google Cloud resources that
	//     have directly attached or inherited tags where the
	//     [`TagValue.name`](https://cloud.google.com/resource-manager/reference/rest/v3/tagValues#resource:-tagvalue)
	//     is exactly `tagValues/123`.
	//   - `kmsKey:key` to find Google Cloud resources encrypted with a
	//     customer-managed encryption key whose name contains `key` as a word. This
	//     field is deprecated. Use the `kmsKeys` field to retrieve Cloud KMS
	//     key information.
	//   - `kmsKeys:key` to find Google Cloud resources encrypted with
	//     customer-managed encryption keys whose name contains the word `key`.
	//   - `relationships:instance-group-1` to find Google Cloud resources that have
	//     relationships with `instance-group-1` in the related resource name.
	//   - `relationships:INSTANCE_TO_INSTANCEGROUP` to find Compute Engine
	//     instances that have relationships of type `INSTANCE_TO_INSTANCEGROUP`.
	//   - `relationships.INSTANCE_TO_INSTANCEGROUP:instance-group-1` to find
	//     Compute Engine instances that have relationships with `instance-group-1`
	//     in the Compute Engine instance group resource name, for relationship type
	//     `INSTANCE_TO_INSTANCEGROUP`.
	//   - `sccSecurityMarks.key=value` to find Cloud resources that are attached
	//     with security marks whose key is `key` and value is `value`.
	//   - `sccSecurityMarks.key:*` to find Cloud resources that are attached with
	//     security marks whose key is `key`.
	//   - `state:ACTIVE` to find Google Cloud resources whose state contains
	//     `ACTIVE` as a word.
	//   - `NOT state:ACTIVE` to find Google Cloud resources whose state doesn't
	//     contain `ACTIVE` as a word.
	//   - `createTime<1609459200` to find Google Cloud resources that were created
	//     before `2021-01-01 00:00:00 UTC`. `1609459200` is the epoch timestamp of
	//     `2021-01-01 00:00:00 UTC` in seconds.
	//   - `updateTime>1609459200` to find Google Cloud resources that were updated
	//     after `2021-01-01 00:00:00 UTC`. `1609459200` is the epoch timestamp of
	//     `2021-01-01 00:00:00 UTC` in seconds.
	//   - `Important` to find Google Cloud resources that contain `Important` as a
	//     word in any of the searchable fields.
	//   - `Impor*` to find Google Cloud resources that contain `Impor` as a prefix
	//     of any word in any of the searchable fields.
	//   - `Important location:(us-west1 OR global)` to find Google Cloud
	//     resources that contain `Important` as a word in any of the searchable
	//     fields and are also located in the `us-west1` region or the `global`
	//     location.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. A list of asset types that this request searches for. If empty,
	// it will search all the asset types [supported by search
	// APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types).
	//
	// Regular expressions are also supported. For example:
	//
	// * "compute.googleapis.com.*" snapshots resources whose asset type starts
	// with "compute.googleapis.com".
	// * ".*Instance" snapshots resources whose asset type ends with "Instance".
	// * ".*Instance.*" snapshots resources whose asset type contains "Instance".
	//
	// See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
	// regular expression syntax. If the regular expression does not match any
	// supported asset type, an INVALID_ARGUMENT error will be returned.
	AssetTypes []string `protobuf:"bytes,3,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Optional. The page size for search result pagination. Page size is capped
	// at 500 even if a larger value is given. If set to zero or a negative value,
	// server will pick an appropriate default. Returned results may be fewer than
	// requested. When this happens, there could be more results as long as
	// `next_page_token` is returned.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, then retrieve the next batch of results from the
	// preceding call to this method. `page_token` must be the value of
	// `next_page_token` from the previous response. The values of all other
	// method parameters, must be identical to those in the previous call.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A comma-separated list of fields specifying the sorting order of
	// the results. The default order is ascending. Add " DESC" after the field
	// name to indicate descending order. Redundant space characters are ignored.
	// Example: "location DESC, name".
	// Only the following fields in the response are sortable:
	//
	//   - name
	//   - assetType
	//   - project
	//   - displayName
	//   - description
	//   - location
	//   - createTime
	//   - updateTime
	//   - state
	//   - parentFullResourceName
	//   - parentAssetType
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. A comma-separated list of fields that you want returned in the
	// results. The following fields are returned by default if not specified:
	//
	//   - `name`
	//   - `assetType`
	//   - `project`
	//   - `folders`
	//   - `organization`
	//   - `displayName`
	//   - `description`
	//   - `location`
	//   - `labels`
	//   - `tags`
	//   - `effectiveTags`
	//   - `networkTags`
	//   - `kmsKeys`
	//   - `createTime`
	//   - `updateTime`
	//   - `state`
	//   - `additionalAttributes`
	//   - `parentFullResourceName`
	//   - `parentAssetType`
	//
	// Some fields of large size, such as `versionedResources`,
	// `attachedResources`, `effectiveTags` etc., are not returned by default, but
	// you can specify them in the `read_mask` parameter if you want to include
	// them. If `"*"` is specified, all [available
	// fields](https://cloud.google.com/asset-inventory/docs/reference/rest/v1/TopLevel/searchAllResources#resourcesearchresult)
	// are returned.
	// Examples: `"name,location"`, `"name,versionedResources"`, `"*"`.
	// Any invalid field path will trigger INVALID_ARGUMENT error.
	ReadMask *fieldmaskpb.FieldMask `protobuf:"bytes,8,opt,name=read_mask,json=readMask,proto3" json:"read_mask,omitempty"`
}

func (x *SearchAllResourcesRequest) Reset() {
	*x = SearchAllResourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllResourcesRequest) ProtoMessage() {}

func (x *SearchAllResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllResourcesRequest.ProtoReflect.Descriptor instead.
func (*SearchAllResourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{22}
}

func (x *SearchAllResourcesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *SearchAllResourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAllResourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *SearchAllResourcesRequest) GetReadMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.ReadMask
	}
	return nil
}

// Search all resources response.
type SearchAllResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Resources that match the search query. It contains the resource
	// standard metadata information.
	Results []*ResourceSearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// If there are more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAllResourcesResponse) Reset() {
	*x = SearchAllResourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllResourcesResponse) ProtoMessage() {}

func (x *SearchAllResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllResourcesResponse.ProtoReflect.Descriptor instead.
func (*SearchAllResourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{23}
}

func (x *SearchAllResourcesResponse) GetResults() []*ResourceSearchResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchAllResourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Search all IAM policies request.
type SearchAllIamPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A scope can be a project, a folder, or an organization. The
	// search is limited to the IAM policies within the `scope`. The caller must
	// be granted the
	// [`cloudasset.assets.searchAllIamPolicies`](https://cloud.google.com/asset-inventory/docs/access-control#required_permissions)
	// permission on the desired scope.
	//
	// The allowed values are:
	//
	// * projects/{PROJECT_ID} (e.g., "projects/foo-bar")
	// * projects/{PROJECT_NUMBER} (e.g., "projects/12345678")
	// * folders/{FOLDER_NUMBER} (e.g., "folders/1234567")
	// * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. The query statement. See [how to construct a
	// query](https://cloud.google.com/asset-inventory/docs/searching-iam-policies#how_to_construct_a_query)
	// for more information. If not specified or empty, it will search all the
	// IAM policies within the specified `scope`. Note that the query string is
	// compared against each IAM policy binding, including its principals,
	// roles, and IAM conditions. The returned IAM policies will only
	// contain the bindings that match your query. To learn more about the IAM
	// policy structure, see the [IAM policy
	// documentation](https://cloud.google.com/iam/help/allow-policies/structure).
	//
	// Examples:
	//
	//   - `policy:amy@gmail.com` to find IAM policy bindings that specify user
	//     "amy@gmail.com".
	//   - `policy:roles/compute.admin` to find IAM policy bindings that specify
	//     the Compute Admin role.
	//   - `policy:comp*` to find IAM policy bindings that contain "comp" as a
	//     prefix of any word in the binding.
	//   - `policy.role.permissions:storage.buckets.update` to find IAM policy
	//     bindings that specify a role containing "storage.buckets.update"
	//     permission. Note that if callers don't have `iam.roles.get` access to a
	//     role's included permissions, policy bindings that specify this role will
	//     be dropped from the search results.
	//   - `policy.role.permissions:upd*` to find IAM policy bindings that specify a
	//     role containing "upd" as a prefix of any word in the role permission.
	//     Note that if callers don't have `iam.roles.get` access to a role's
	//     included permissions, policy bindings that specify this role will be
	//     dropped from the search results.
	//   - `resource:organizations/123456` to find IAM policy bindings
	//     that are set on "organizations/123456".
	//   - `resource=//cloudresourcemanager.googleapis.com/projects/myproject` to
	//     find IAM policy bindings that are set on the project named "myproject".
	//   - `Important` to find IAM policy bindings that contain "Important" as a
	//     word in any of the searchable fields (except for the included
	//     permissions).
	//   - `resource:(instance1 OR instance2) policy:amy` to find
	//     IAM policy bindings that are set on resources "instance1" or
	//     "instance2" and also specify user "amy".
	//   - `roles:roles/compute.admin` to find IAM policy bindings that specify the
	//     Compute Admin role.
	//   - `memberTypes:user` to find IAM policy bindings that contain the
	//     principal type "user".
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Optional. The page size for search result pagination. Page size is capped
	// at 500 even if a larger value is given. If set to zero or a negative value,
	// server will pick an appropriate default. Returned results may be fewer than
	// requested. When this happens, there could be more results as long as
	// `next_page_token` is returned.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If present, retrieve the next batch of results from the preceding
	// call to this method. `page_token` must be the value of `next_page_token`
	// from the previous response. The values of all other method parameters must
	// be identical to those in the previous call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. A list of asset types that the IAM policies are attached to. If
	// empty, it will search the IAM policies that are attached to all the asset
	// types [supported by search
	// APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	//
	// Regular expressions are also supported. For example:
	//
	// * "compute.googleapis.com.*" snapshots IAM policies attached to asset type
	// starts with "compute.googleapis.com".
	// * ".*Instance" snapshots IAM policies attached to asset type ends with
	// "Instance".
	// * ".*Instance.*" snapshots IAM policies attached to asset type contains
	// "Instance".
	//
	// See [RE2](https://github.com/google/re2/wiki/Syntax) for all supported
	// regular expression syntax. If the regular expression does not match any
	// supported asset type, an INVALID_ARGUMENT error will be returned.
	AssetTypes []string `protobuf:"bytes,5,rep,name=asset_types,json=assetTypes,proto3" json:"asset_types,omitempty"`
	// Optional. A comma-separated list of fields specifying the sorting order of
	// the results. The default order is ascending. Add " DESC" after the field
	// name to indicate descending order. Redundant space characters are ignored.
	// Example: "assetType DESC, resource".
	// Only singular primitive fields in the response are sortable:
	//   - resource
	//   - assetType
	//   - project
	//
	// All the other fields such as repeated fields (e.g., `folders`) and
	// non-primitive fields (e.g., `policy`) are not supported.
	OrderBy string `protobuf:"bytes,7,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *SearchAllIamPoliciesRequest) Reset() {
	*x = SearchAllIamPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllIamPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllIamPoliciesRequest) ProtoMessage() {}

func (x *SearchAllIamPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllIamPoliciesRequest.ProtoReflect.Descriptor instead.
func (*SearchAllIamPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{24}
}

func (x *SearchAllIamPoliciesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *SearchAllIamPoliciesRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *SearchAllIamPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchAllIamPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchAllIamPoliciesRequest) GetAssetTypes() []string {
	if x != nil {
		return x.AssetTypes
	}
	return nil
}

func (x *SearchAllIamPoliciesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Search all IAM policies response.
type SearchAllIamPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of IAM policies that match the search query. Related information
	// such as the associated resource is returned along with the policy.
	Results []*IamPolicySearchResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
	// Set if there are more results than those appearing in this response; to get
	// the next set of results, call this method again, using this value as the
	// `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchAllIamPoliciesResponse) Reset() {
	*x = SearchAllIamPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchAllIamPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchAllIamPoliciesResponse) ProtoMessage() {}

func (x *SearchAllIamPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchAllIamPoliciesResponse.ProtoReflect.Descriptor instead.
func (*SearchAllIamPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{25}
}

func (x *SearchAllIamPoliciesResponse) GetResults() []*IamPolicySearchResult {
	if x != nil {
		return x.Results
	}
	return nil
}

func (x *SearchAllIamPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// IAM policy analysis query message.
type IamPolicyAnalysisQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. Only resources and IAM
	// policies within the scope will be analyzed.
	//
	// This can only be an organization number (such as "organizations/123"), a
	// folder number (such as "folders/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345").
	//
	// To know how to get organization ID, visit [here
	// ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
	//
	// To know how to get folder or project ID, visit [here
	// ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Optional. Specifies a resource for analysis.
	ResourceSelector *IamPolicyAnalysisQuery_ResourceSelector `protobuf:"bytes,2,opt,name=resource_selector,json=resourceSelector,proto3" json:"resource_selector,omitempty"`
	// Optional. Specifies an identity for analysis.
	IdentitySelector *IamPolicyAnalysisQuery_IdentitySelector `protobuf:"bytes,3,opt,name=identity_selector,json=identitySelector,proto3" json:"identity_selector,omitempty"`
	// Optional. Specifies roles or permissions for analysis. This is optional.
	AccessSelector *IamPolicyAnalysisQuery_AccessSelector `protobuf:"bytes,4,opt,name=access_selector,json=accessSelector,proto3" json:"access_selector,omitempty"`
	// Optional. The query options.
	Options *IamPolicyAnalysisQuery_Options `protobuf:"bytes,5,opt,name=options,proto3" json:"options,omitempty"`
	// Optional. The hypothetical context for IAM conditions evaluation.
	ConditionContext *IamPolicyAnalysisQuery_ConditionContext `protobuf:"bytes,6,opt,name=condition_context,json=conditionContext,proto3" json:"condition_context,omitempty"`
}

func (x *IamPolicyAnalysisQuery) Reset() {
	*x = IamPolicyAnalysisQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26}
}

func (x *IamPolicyAnalysisQuery) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *IamPolicyAnalysisQuery) GetResourceSelector() *IamPolicyAnalysisQuery_ResourceSelector {
	if x != nil {
		return x.ResourceSelector
	}
	return nil
}

func (x *IamPolicyAnalysisQuery) GetIdentitySelector() *IamPolicyAnalysisQuery_IdentitySelector {
	if x != nil {
		return x.IdentitySelector
	}
	return nil
}

func (x *IamPolicyAnalysisQuery) GetAccessSelector() *IamPolicyAnalysisQuery_AccessSelector {
	if x != nil {
		return x.AccessSelector
	}
	return nil
}

func (x *IamPolicyAnalysisQuery) GetOptions() *IamPolicyAnalysisQuery_Options {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *IamPolicyAnalysisQuery) GetConditionContext() *IamPolicyAnalysisQuery_ConditionContext {
	if x != nil {
		return x.ConditionContext
	}
	return nil
}

// A request message for
// [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1.AssetService.AnalyzeIamPolicy].
type AnalyzeIamPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// Optional. The name of a saved query, which must be in the format of:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	//
	// If both `analysis_query` and `saved_analysis_query` are provided, they
	// will be merged together with the `saved_analysis_query` as base and
	// the `analysis_query` as overrides. For more details of the merge behavior,
	// refer to the
	// [MergeFrom](https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.details)
	// page.
	//
	// Note that you cannot override primitive fields with default value, such as
	// 0 or empty string, etc., because we use proto3, which doesn't support field
	// presence yet.
	SavedAnalysisQuery string `protobuf:"bytes,3,opt,name=saved_analysis_query,json=savedAnalysisQuery,proto3" json:"saved_analysis_query,omitempty"`
	// Optional. Amount of time executable has to complete.  See JSON
	// representation of
	// [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json).
	//
	// If this field is set with a value less than the RPC deadline, and the
	// execution of your query hasn't finished in the specified
	// execution timeout,  you will get a response with partial result.
	// Otherwise, your query's execution will continue until the RPC deadline.
	// If it's not finished until then, you will get a  DEADLINE_EXCEEDED error.
	//
	// Default is empty.
	ExecutionTimeout *durationpb.Duration `protobuf:"bytes,2,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
}

func (x *AnalyzeIamPolicyRequest) Reset() {
	*x = AnalyzeIamPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyRequest) ProtoMessage() {}

func (x *AnalyzeIamPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{27}
}

func (x *AnalyzeIamPolicyRequest) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if x != nil {
		return x.AnalysisQuery
	}
	return nil
}

func (x *AnalyzeIamPolicyRequest) GetSavedAnalysisQuery() string {
	if x != nil {
		return x.SavedAnalysisQuery
	}
	return ""
}

func (x *AnalyzeIamPolicyRequest) GetExecutionTimeout() *durationpb.Duration {
	if x != nil {
		return x.ExecutionTimeout
	}
	return nil
}

// A response message for
// [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1.AssetService.AnalyzeIamPolicy].
type AnalyzeIamPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The main analysis that matches the original request.
	MainAnalysis *AnalyzeIamPolicyResponse_IamPolicyAnalysis `protobuf:"bytes,1,opt,name=main_analysis,json=mainAnalysis,proto3" json:"main_analysis,omitempty"`
	// The service account impersonation analysis if
	// [AnalyzeIamPolicyRequest.analyze_service_account_impersonation][] is
	// enabled.
	ServiceAccountImpersonationAnalysis []*AnalyzeIamPolicyResponse_IamPolicyAnalysis `protobuf:"bytes,2,rep,name=service_account_impersonation_analysis,json=serviceAccountImpersonationAnalysis,proto3" json:"service_account_impersonation_analysis,omitempty"`
	// Represents whether all entries in the
	// [main_analysis][google.cloud.asset.v1.AnalyzeIamPolicyResponse.main_analysis]
	// and
	// [service_account_impersonation_analysis][google.cloud.asset.v1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis]
	// have been fully explored to answer the query in the request.
	FullyExplored bool `protobuf:"varint,3,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
}

func (x *AnalyzeIamPolicyResponse) Reset() {
	*x = AnalyzeIamPolicyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyResponse) ProtoMessage() {}

func (x *AnalyzeIamPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{28}
}

func (x *AnalyzeIamPolicyResponse) GetMainAnalysis() *AnalyzeIamPolicyResponse_IamPolicyAnalysis {
	if x != nil {
		return x.MainAnalysis
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse) GetServiceAccountImpersonationAnalysis() []*AnalyzeIamPolicyResponse_IamPolicyAnalysis {
	if x != nil {
		return x.ServiceAccountImpersonationAnalysis
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse) GetFullyExplored() bool {
	if x != nil {
		return x.FullyExplored
	}
	return false
}

// Output configuration for export IAM policy analysis destination.
type IamPolicyAnalysisOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IAM policy analysis export destination.
	//
	// Types that are assignable to Destination:
	//
	//	*IamPolicyAnalysisOutputConfig_GcsDestination_
	//	*IamPolicyAnalysisOutputConfig_BigqueryDestination
	Destination isIamPolicyAnalysisOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *IamPolicyAnalysisOutputConfig) Reset() {
	*x = IamPolicyAnalysisOutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisOutputConfig) ProtoMessage() {}

func (x *IamPolicyAnalysisOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisOutputConfig.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{29}
}

func (m *IamPolicyAnalysisOutputConfig) GetDestination() isIamPolicyAnalysisOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *IamPolicyAnalysisOutputConfig) GetGcsDestination() *IamPolicyAnalysisOutputConfig_GcsDestination {
	if x, ok := x.GetDestination().(*IamPolicyAnalysisOutputConfig_GcsDestination_); ok {
		return x.GcsDestination
	}
	return nil
}

func (x *IamPolicyAnalysisOutputConfig) GetBigqueryDestination() *IamPolicyAnalysisOutputConfig_BigQueryDestination {
	if x, ok := x.GetDestination().(*IamPolicyAnalysisOutputConfig_BigqueryDestination); ok {
		return x.BigqueryDestination
	}
	return nil
}

type isIamPolicyAnalysisOutputConfig_Destination interface {
	isIamPolicyAnalysisOutputConfig_Destination()
}

type IamPolicyAnalysisOutputConfig_GcsDestination_ struct {
	// Destination on Cloud Storage.
	GcsDestination *IamPolicyAnalysisOutputConfig_GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

type IamPolicyAnalysisOutputConfig_BigqueryDestination struct {
	// Destination on BigQuery.
	BigqueryDestination *IamPolicyAnalysisOutputConfig_BigQueryDestination `protobuf:"bytes,2,opt,name=bigquery_destination,json=bigqueryDestination,proto3,oneof"`
}

func (*IamPolicyAnalysisOutputConfig_GcsDestination_) isIamPolicyAnalysisOutputConfig_Destination() {}

func (*IamPolicyAnalysisOutputConfig_BigqueryDestination) isIamPolicyAnalysisOutputConfig_Destination() {
}

// A request message for
// [AssetService.AnalyzeIamPolicyLongrunning][google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning].
type AnalyzeIamPolicyLongrunningRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// Optional. The name of a saved query, which must be in the format of:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	//
	// If both `analysis_query` and `saved_analysis_query` are provided, they
	// will be merged together with the `saved_analysis_query` as base and
	// the `analysis_query` as overrides. For more details of the merge behavior,
	// refer to the
	// [MergeFrom](https://developers.google.com/protocol-buffers/docs/reference/cpp/google.protobuf.message#Message.MergeFrom.details)
	// doc.
	//
	// Note that you cannot override primitive fields with default value, such as
	// 0 or empty string, etc., because we use proto3, which doesn't support field
	// presence yet.
	SavedAnalysisQuery string `protobuf:"bytes,3,opt,name=saved_analysis_query,json=savedAnalysisQuery,proto3" json:"saved_analysis_query,omitempty"`
	// Required. Output configuration indicating where the results will be output
	// to.
	OutputConfig *IamPolicyAnalysisOutputConfig `protobuf:"bytes,2,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *AnalyzeIamPolicyLongrunningRequest) Reset() {
	*x = AnalyzeIamPolicyLongrunningRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyLongrunningRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyLongrunningRequest) ProtoMessage() {}

func (x *AnalyzeIamPolicyLongrunningRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyLongrunningRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyLongrunningRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{30}
}

func (x *AnalyzeIamPolicyLongrunningRequest) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if x != nil {
		return x.AnalysisQuery
	}
	return nil
}

func (x *AnalyzeIamPolicyLongrunningRequest) GetSavedAnalysisQuery() string {
	if x != nil {
		return x.SavedAnalysisQuery
	}
	return ""
}

func (x *AnalyzeIamPolicyLongrunningRequest) GetOutputConfig() *IamPolicyAnalysisOutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// A response message for
// [AssetService.AnalyzeIamPolicyLongrunning][google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning].
type AnalyzeIamPolicyLongrunningResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AnalyzeIamPolicyLongrunningResponse) Reset() {
	*x = AnalyzeIamPolicyLongrunningResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyLongrunningResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyLongrunningResponse) ProtoMessage() {}

func (x *AnalyzeIamPolicyLongrunningResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyLongrunningResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyLongrunningResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{31}
}

// A saved query which can be shared with others or used later.
type SavedQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the saved query. The format must be:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The description of this saved query. This value should be fewer than 255
	// characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The create time of this saved query.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The account's email address who has created this saved query.
	Creator string `protobuf:"bytes,4,opt,name=creator,proto3" json:"creator,omitempty"`
	// Output only. The last update time of this saved query.
	LastUpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	// Output only. The account's email address who has updated this saved query
	// most recently.
	LastUpdater string `protobuf:"bytes,6,opt,name=last_updater,json=lastUpdater,proto3" json:"last_updater,omitempty"`
	// Labels applied on the resource.
	// This value should not contain more than 10 entries. The key and value of
	// each entry must be non-empty and fewer than 64 characters.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The query content.
	Content *SavedQuery_QueryContent `protobuf:"bytes,8,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *SavedQuery) Reset() {
	*x = SavedQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SavedQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SavedQuery) ProtoMessage() {}

func (x *SavedQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SavedQuery.ProtoReflect.Descriptor instead.
func (*SavedQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{32}
}

func (x *SavedQuery) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SavedQuery) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *SavedQuery) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *SavedQuery) GetCreator() string {
	if x != nil {
		return x.Creator
	}
	return ""
}

func (x *SavedQuery) GetLastUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastUpdateTime
	}
	return nil
}

func (x *SavedQuery) GetLastUpdater() string {
	if x != nil {
		return x.LastUpdater
	}
	return ""
}

func (x *SavedQuery) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *SavedQuery) GetContent() *SavedQuery_QueryContent {
	if x != nil {
		return x.Content
	}
	return nil
}

// Request to create a saved query.
type CreateSavedQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project/folder/organization where this
	// saved_query should be created in. It can only be an organization number
	// (such as "organizations/123"), a folder number (such as "folders/123"), a
	// project ID (such as "projects/my-project-id"), or a project number (such as
	// "projects/12345").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The saved_query details. The `name` field must be empty as it
	// will be generated based on the parent and saved_query_id.
	SavedQuery *SavedQuery `protobuf:"bytes,2,opt,name=saved_query,json=savedQuery,proto3" json:"saved_query,omitempty"`
	// Required. The ID to use for the saved query, which must be unique in the
	// specified parent. It will become the final component of the saved query's
	// resource name.
	//
	// This value should be 4-63 characters, and valid characters
	// are `[a-z][0-9]-`.
	//
	// Notice that this field is required in the saved query creation, and the
	// `name` field of the `saved_query` will be ignored.
	SavedQueryId string `protobuf:"bytes,3,opt,name=saved_query_id,json=savedQueryId,proto3" json:"saved_query_id,omitempty"`
}

func (x *CreateSavedQueryRequest) Reset() {
	*x = CreateSavedQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSavedQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSavedQueryRequest) ProtoMessage() {}

func (x *CreateSavedQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSavedQueryRequest.ProtoReflect.Descriptor instead.
func (*CreateSavedQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{33}
}

func (x *CreateSavedQueryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSavedQueryRequest) GetSavedQuery() *SavedQuery {
	if x != nil {
		return x.SavedQuery
	}
	return nil
}

func (x *CreateSavedQueryRequest) GetSavedQueryId() string {
	if x != nil {
		return x.SavedQueryId
	}
	return ""
}

// Request to get a saved query.
type GetSavedQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the saved query and it must be in the format of:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSavedQueryRequest) Reset() {
	*x = GetSavedQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSavedQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSavedQueryRequest) ProtoMessage() {}

func (x *GetSavedQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSavedQueryRequest.ProtoReflect.Descriptor instead.
func (*GetSavedQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{34}
}

func (x *GetSavedQueryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to list saved queries.
type ListSavedQueriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent project/folder/organization whose savedQueries are to
	// be listed. It can only be using project/folder/organization number (such as
	// "folders/12345")", or a project ID (such as "projects/my-project-id").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The expression to filter resources.
	// The expression is a list of zero or more restrictions combined via logical
	// operators `AND` and `OR`. When `AND` and `OR` are both used in the
	// expression, parentheses must be appropriately used to group the
	// combinations. The expression may also contain regular expressions.
	//
	// See https://google.aip.dev/160 for more information on the grammar.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The maximum number of saved queries to return per page. The
	// service may return fewer than this value. If unspecified, at most 50 will
	// be returned. The maximum value is 1000; values above 1000 will be coerced
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListSavedQueries` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListSavedQueries` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSavedQueriesRequest) Reset() {
	*x = ListSavedQueriesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSavedQueriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSavedQueriesRequest) ProtoMessage() {}

func (x *ListSavedQueriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSavedQueriesRequest.ProtoReflect.Descriptor instead.
func (*ListSavedQueriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{35}
}

func (x *ListSavedQueriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSavedQueriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSavedQueriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSavedQueriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response of listing saved queries.
type ListSavedQueriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of savedQueries.
	SavedQueries []*SavedQuery `protobuf:"bytes,1,rep,name=saved_queries,json=savedQueries,proto3" json:"saved_queries,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSavedQueriesResponse) Reset() {
	*x = ListSavedQueriesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSavedQueriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSavedQueriesResponse) ProtoMessage() {}

func (x *ListSavedQueriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSavedQueriesResponse.ProtoReflect.Descriptor instead.
func (*ListSavedQueriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{36}
}

func (x *ListSavedQueriesResponse) GetSavedQueries() []*SavedQuery {
	if x != nil {
		return x.SavedQueries
	}
	return nil
}

func (x *ListSavedQueriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request to update a saved query.
type UpdateSavedQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The saved query to update.
	//
	// The saved query's `name` field is used to identify the one to update,
	// which has format as below:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	SavedQuery *SavedQuery `protobuf:"bytes,1,opt,name=saved_query,json=savedQuery,proto3" json:"saved_query,omitempty"`
	// Required. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateSavedQueryRequest) Reset() {
	*x = UpdateSavedQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSavedQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSavedQueryRequest) ProtoMessage() {}

func (x *UpdateSavedQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSavedQueryRequest.ProtoReflect.Descriptor instead.
func (*UpdateSavedQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{37}
}

func (x *UpdateSavedQueryRequest) GetSavedQuery() *SavedQuery {
	if x != nil {
		return x.SavedQuery
	}
	return nil
}

func (x *UpdateSavedQueryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to delete a saved query.
type DeleteSavedQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the saved query to delete. It must be in the format
	// of:
	//
	// * projects/project_number/savedQueries/saved_query_id
	// * folders/folder_number/savedQueries/saved_query_id
	// * organizations/organization_number/savedQueries/saved_query_id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSavedQueryRequest) Reset() {
	*x = DeleteSavedQueryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSavedQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSavedQueryRequest) ProtoMessage() {}

func (x *DeleteSavedQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSavedQueryRequest.ProtoReflect.Descriptor instead.
func (*DeleteSavedQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{38}
}

func (x *DeleteSavedQueryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for performing resource move analysis.
type AnalyzeMoveRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource to perform the analysis against.
	// Only Google Cloud projects are supported as of today. Hence, this can only
	// be a project ID (such as "projects/my-project-id") or a project number
	// (such as "projects/12345").
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// Required. Name of the Google Cloud folder or organization to reparent the
	// target resource. The analysis will be performed against hypothetically
	// moving the resource to this specified desitination parent. This can only be
	// a folder number (such as "folders/123") or an organization number (such as
	// "organizations/123").
	DestinationParent string `protobuf:"bytes,2,opt,name=destination_parent,json=destinationParent,proto3" json:"destination_parent,omitempty"`
	// Analysis view indicating what information should be included in the
	// analysis response. If unspecified, the default view is FULL.
	View AnalyzeMoveRequest_AnalysisView `protobuf:"varint,3,opt,name=view,proto3,enum=google.cloud.asset.v1.AnalyzeMoveRequest_AnalysisView" json:"view,omitempty"`
}

func (x *AnalyzeMoveRequest) Reset() {
	*x = AnalyzeMoveRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeMoveRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeMoveRequest) ProtoMessage() {}

func (x *AnalyzeMoveRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeMoveRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeMoveRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{39}
}

func (x *AnalyzeMoveRequest) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *AnalyzeMoveRequest) GetDestinationParent() string {
	if x != nil {
		return x.DestinationParent
	}
	return ""
}

func (x *AnalyzeMoveRequest) GetView() AnalyzeMoveRequest_AnalysisView {
	if x != nil {
		return x.View
	}
	return AnalyzeMoveRequest_ANALYSIS_VIEW_UNSPECIFIED
}

// The response message for resource move analysis.
type AnalyzeMoveResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of analyses returned from performing the intended resource move
	// analysis. The analysis is grouped by different Google Cloud services.
	MoveAnalysis []*MoveAnalysis `protobuf:"bytes,1,rep,name=move_analysis,json=moveAnalysis,proto3" json:"move_analysis,omitempty"`
}

func (x *AnalyzeMoveResponse) Reset() {
	*x = AnalyzeMoveResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeMoveResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeMoveResponse) ProtoMessage() {}

func (x *AnalyzeMoveResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeMoveResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeMoveResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{40}
}

func (x *AnalyzeMoveResponse) GetMoveAnalysis() []*MoveAnalysis {
	if x != nil {
		return x.MoveAnalysis
	}
	return nil
}

// A message to group the analysis information.
type MoveAnalysis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The user friendly display name of the analysis. E.g. IAM, organization
	// policy etc.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Types that are assignable to Result:
	//
	//	*MoveAnalysis_Analysis
	//	*MoveAnalysis_Error
	Result isMoveAnalysis_Result `protobuf_oneof:"result"`
}

func (x *MoveAnalysis) Reset() {
	*x = MoveAnalysis{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveAnalysis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveAnalysis) ProtoMessage() {}

func (x *MoveAnalysis) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveAnalysis.ProtoReflect.Descriptor instead.
func (*MoveAnalysis) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{41}
}

func (x *MoveAnalysis) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *MoveAnalysis) GetResult() isMoveAnalysis_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *MoveAnalysis) GetAnalysis() *MoveAnalysisResult {
	if x, ok := x.GetResult().(*MoveAnalysis_Analysis); ok {
		return x.Analysis
	}
	return nil
}

func (x *MoveAnalysis) GetError() *status.Status {
	if x, ok := x.GetResult().(*MoveAnalysis_Error); ok {
		return x.Error
	}
	return nil
}

type isMoveAnalysis_Result interface {
	isMoveAnalysis_Result()
}

type MoveAnalysis_Analysis struct {
	// Analysis result of moving the target resource.
	Analysis *MoveAnalysisResult `protobuf:"bytes,2,opt,name=analysis,proto3,oneof"`
}

type MoveAnalysis_Error struct {
	// Description of error encountered when performing the analysis.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

func (*MoveAnalysis_Analysis) isMoveAnalysis_Result() {}

func (*MoveAnalysis_Error) isMoveAnalysis_Result() {}

// An analysis result including blockers and warnings.
type MoveAnalysisResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Blocking information that would prevent the target resource from moving
	// to the specified destination at runtime.
	Blockers []*MoveImpact `protobuf:"bytes,1,rep,name=blockers,proto3" json:"blockers,omitempty"`
	// Warning information indicating that moving the target resource to the
	// specified destination might be unsafe. This can include important policy
	// information and configuration changes, but will not block moves at runtime.
	Warnings []*MoveImpact `protobuf:"bytes,2,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (x *MoveAnalysisResult) Reset() {
	*x = MoveAnalysisResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveAnalysisResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveAnalysisResult) ProtoMessage() {}

func (x *MoveAnalysisResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveAnalysisResult.ProtoReflect.Descriptor instead.
func (*MoveAnalysisResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{42}
}

func (x *MoveAnalysisResult) GetBlockers() []*MoveImpact {
	if x != nil {
		return x.Blockers
	}
	return nil
}

func (x *MoveAnalysisResult) GetWarnings() []*MoveImpact {
	if x != nil {
		return x.Warnings
	}
	return nil
}

// A message to group impacts of moving the target resource.
type MoveImpact struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User friendly impact detail in a free form message.
	Detail string `protobuf:"bytes,1,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (x *MoveImpact) Reset() {
	*x = MoveImpact{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MoveImpact) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MoveImpact) ProtoMessage() {}

func (x *MoveImpact) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MoveImpact.ProtoReflect.Descriptor instead.
func (*MoveImpact) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{43}
}

func (x *MoveImpact) GetDetail() string {
	if x != nil {
		return x.Detail
	}
	return ""
}

// Output configuration query assets.
type QueryAssetsOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// BigQuery destination where the query results will be saved.
	BigqueryDestination *QueryAssetsOutputConfig_BigQueryDestination `protobuf:"bytes,1,opt,name=bigquery_destination,json=bigqueryDestination,proto3" json:"bigquery_destination,omitempty"`
}

func (x *QueryAssetsOutputConfig) Reset() {
	*x = QueryAssetsOutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryAssetsOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryAssetsOutputConfig) ProtoMessage() {}

func (x *QueryAssetsOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryAssetsOutputConfig.ProtoReflect.Descriptor instead.
func (*QueryAssetsOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{44}
}

func (x *QueryAssetsOutputConfig) GetBigqueryDestination() *QueryAssetsOutputConfig_BigQueryDestination {
	if x != nil {
		return x.BigqueryDestination
	}
	return nil
}

// QueryAssets request.
type QueryAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. This can only be an
	// organization number (such as "organizations/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345"),
	// or a folder number (such as "folders/123").
	//
	// Only assets belonging to the `parent` will be returned.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Types that are assignable to Query:
	//
	//	*QueryAssetsRequest_Statement
	//	*QueryAssetsRequest_JobReference
	Query isQueryAssetsRequest_Query `protobuf_oneof:"query"`
	// Optional. The maximum number of rows to return in the results. Responses
	// are limited to 10 MB and 1000 rows.
	//
	// By default, the maximum row count is 1000. When the byte or row count limit
	// is reached, the rest of the query results will be paginated.
	//
	// The field will be ignored when [output_config] is specified.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token received from previous `QueryAssets`.
	//
	// The field will be ignored when [output_config] is specified.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Specifies the maximum amount of time that the client is willing
	// to wait for the query to complete. By default, this limit is 5 min for the
	// first query, and 1 minute for the following queries. If the query is
	// complete, the `done` field in the `QueryAssetsResponse` is true, otherwise
	// false.
	//
	// Like BigQuery [jobs.query
	// API](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/query#queryrequest)
	// The call is not guaranteed to wait for the specified timeout; it typically
	// returns after around 200 seconds (200,000 milliseconds), even if the query
	// is not complete.
	//
	// The field will be ignored when [output_config] is specified.
	Timeout *durationpb.Duration `protobuf:"bytes,6,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Specifies what time period or point in time to query asset metadata at.
	// * unset - query asset metadata as it is right now
	// * [read_time_window] - query asset metadata as it was at any point in time
	// between [start_time] and [end_time].
	// * [read_time] - query asset metadata as it was at that point in time.
	// If data for the timestamp/date range selected does not exist,
	// it will simply return a valid response with no rows.
	//
	// Types that are assignable to Time:
	//
	//	*QueryAssetsRequest_ReadTimeWindow
	//	*QueryAssetsRequest_ReadTime
	Time isQueryAssetsRequest_Time `protobuf_oneof:"time"`
	// Optional. Destination where the query results will be saved.
	//
	// When this field is specified, the query results won't be saved in the
	// [QueryAssetsResponse.query_result]. Instead
	// [QueryAssetsResponse.output_config] will be set.
	//
	// Meanwhile, [QueryAssetsResponse.job_reference] will be set and can be used
	// to check the status of the query job when passed to a following
	// [QueryAssets] API call.
	OutputConfig *QueryAssetsOutputConfig `protobuf:"bytes,9,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *QueryAssetsRequest) Reset() {
	*x = QueryAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryAssetsRequest) ProtoMessage() {}

func (x *QueryAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryAssetsRequest.ProtoReflect.Descriptor instead.
func (*QueryAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{45}
}

func (x *QueryAssetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (m *QueryAssetsRequest) GetQuery() isQueryAssetsRequest_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (x *QueryAssetsRequest) GetStatement() string {
	if x, ok := x.GetQuery().(*QueryAssetsRequest_Statement); ok {
		return x.Statement
	}
	return ""
}

func (x *QueryAssetsRequest) GetJobReference() string {
	if x, ok := x.GetQuery().(*QueryAssetsRequest_JobReference); ok {
		return x.JobReference
	}
	return ""
}

func (x *QueryAssetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *QueryAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *QueryAssetsRequest) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (m *QueryAssetsRequest) GetTime() isQueryAssetsRequest_Time {
	if m != nil {
		return m.Time
	}
	return nil
}

func (x *QueryAssetsRequest) GetReadTimeWindow() *TimeWindow {
	if x, ok := x.GetTime().(*QueryAssetsRequest_ReadTimeWindow); ok {
		return x.ReadTimeWindow
	}
	return nil
}

func (x *QueryAssetsRequest) GetReadTime() *timestamppb.Timestamp {
	if x, ok := x.GetTime().(*QueryAssetsRequest_ReadTime); ok {
		return x.ReadTime
	}
	return nil
}

func (x *QueryAssetsRequest) GetOutputConfig() *QueryAssetsOutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

type isQueryAssetsRequest_Query interface {
	isQueryAssetsRequest_Query()
}

type QueryAssetsRequest_Statement struct {
	// Optional. A SQL statement that's compatible with [BigQuery
	// SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
	Statement string `protobuf:"bytes,2,opt,name=statement,proto3,oneof"`
}

type QueryAssetsRequest_JobReference struct {
	// Optional. Reference to the query job, which is from the
	// `QueryAssetsResponse` of previous `QueryAssets` call.
	JobReference string `protobuf:"bytes,3,opt,name=job_reference,json=jobReference,proto3,oneof"`
}

func (*QueryAssetsRequest_Statement) isQueryAssetsRequest_Query() {}

func (*QueryAssetsRequest_JobReference) isQueryAssetsRequest_Query() {}

type isQueryAssetsRequest_Time interface {
	isQueryAssetsRequest_Time()
}

type QueryAssetsRequest_ReadTimeWindow struct {
	// Optional. [start_time] is required. [start_time] must be less than
	// [end_time] Defaults [end_time] to now if [start_time] is set and
	// [end_time] isn't. Maximum permitted time range is 7 days.
	ReadTimeWindow *TimeWindow `protobuf:"bytes,7,opt,name=read_time_window,json=readTimeWindow,proto3,oneof"`
}

type QueryAssetsRequest_ReadTime struct {
	// Optional. Queries cloud assets as they appeared at the specified point in
	// time.
	ReadTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=read_time,json=readTime,proto3,oneof"`
}

func (*QueryAssetsRequest_ReadTimeWindow) isQueryAssetsRequest_Time() {}

func (*QueryAssetsRequest_ReadTime) isQueryAssetsRequest_Time() {}

// QueryAssets response.
type QueryAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Reference to a query job.
	JobReference string `protobuf:"bytes,1,opt,name=job_reference,json=jobReference,proto3" json:"job_reference,omitempty"`
	// The query response, which can be either an `error` or a valid `response`.
	//
	// If `done` == `false` and the query result is being saved in a output, the
	// output_config field will be set.
	// If `done` == `true`, exactly one of
	// `error`, `query_result` or `output_config` will be set.
	Done bool `protobuf:"varint,2,opt,name=done,proto3" json:"done,omitempty"`
	// Types that are assignable to Response:
	//
	//	*QueryAssetsResponse_Error
	//	*QueryAssetsResponse_QueryResult
	//	*QueryAssetsResponse_OutputConfig
	Response isQueryAssetsResponse_Response `protobuf_oneof:"response"`
}

func (x *QueryAssetsResponse) Reset() {
	*x = QueryAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryAssetsResponse) ProtoMessage() {}

func (x *QueryAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryAssetsResponse.ProtoReflect.Descriptor instead.
func (*QueryAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{46}
}

func (x *QueryAssetsResponse) GetJobReference() string {
	if x != nil {
		return x.JobReference
	}
	return ""
}

func (x *QueryAssetsResponse) GetDone() bool {
	if x != nil {
		return x.Done
	}
	return false
}

func (m *QueryAssetsResponse) GetResponse() isQueryAssetsResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *QueryAssetsResponse) GetError() *status.Status {
	if x, ok := x.GetResponse().(*QueryAssetsResponse_Error); ok {
		return x.Error
	}
	return nil
}

func (x *QueryAssetsResponse) GetQueryResult() *QueryResult {
	if x, ok := x.GetResponse().(*QueryAssetsResponse_QueryResult); ok {
		return x.QueryResult
	}
	return nil
}

func (x *QueryAssetsResponse) GetOutputConfig() *QueryAssetsOutputConfig {
	if x, ok := x.GetResponse().(*QueryAssetsResponse_OutputConfig); ok {
		return x.OutputConfig
	}
	return nil
}

type isQueryAssetsResponse_Response interface {
	isQueryAssetsResponse_Response()
}

type QueryAssetsResponse_Error struct {
	// Error status.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3,oneof"`
}

type QueryAssetsResponse_QueryResult struct {
	// Result of the query.
	QueryResult *QueryResult `protobuf:"bytes,4,opt,name=query_result,json=queryResult,proto3,oneof"`
}

type QueryAssetsResponse_OutputConfig struct {
	// Output configuration which indicates instead of being returned in API
	// response on the fly, the query result will be saved in a specific output.
	OutputConfig *QueryAssetsOutputConfig `protobuf:"bytes,5,opt,name=output_config,json=outputConfig,proto3,oneof"`
}

func (*QueryAssetsResponse_Error) isQueryAssetsResponse_Response() {}

func (*QueryAssetsResponse_QueryResult) isQueryAssetsResponse_Response() {}

func (*QueryAssetsResponse_OutputConfig) isQueryAssetsResponse_Response() {}

// Execution results of the query.
//
// The result is formatted as rows represented by BigQuery compatible [schema].
// When pagination is necessary, it will contains the page token to retrieve
// the results of following pages.
type QueryResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Each row hold a query result in the format of `Struct`.
	Rows []*structpb.Struct `protobuf:"bytes,1,rep,name=rows,proto3" json:"rows,omitempty"`
	// Describes the format of the [rows].
	Schema *TableSchema `protobuf:"bytes,2,opt,name=schema,proto3" json:"schema,omitempty"`
	// Token to retrieve the next page of the results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Total rows of the whole query results.
	TotalRows int64 `protobuf:"varint,4,opt,name=total_rows,json=totalRows,proto3" json:"total_rows,omitempty"`
}

func (x *QueryResult) Reset() {
	*x = QueryResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryResult) ProtoMessage() {}

func (x *QueryResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryResult.ProtoReflect.Descriptor instead.
func (*QueryResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{47}
}

func (x *QueryResult) GetRows() []*structpb.Struct {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *QueryResult) GetSchema() *TableSchema {
	if x != nil {
		return x.Schema
	}
	return nil
}

func (x *QueryResult) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *QueryResult) GetTotalRows() int64 {
	if x != nil {
		return x.TotalRows
	}
	return 0
}

// BigQuery Compatible table schema.
type TableSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes the fields in a table.
	Fields []*TableFieldSchema `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *TableSchema) Reset() {
	*x = TableSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableSchema) ProtoMessage() {}

func (x *TableSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableSchema.ProtoReflect.Descriptor instead.
func (*TableSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{48}
}

func (x *TableSchema) GetFields() []*TableFieldSchema {
	if x != nil {
		return x.Fields
	}
	return nil
}

// A field in TableSchema.
type TableFieldSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The field name. The name must contain only letters (a-z, A-Z),
	// numbers (0-9), or underscores (_), and must start with a letter or
	// underscore. The maximum length is 128 characters.
	Field string `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// The field data type. Possible values include
	// * STRING
	// * BYTES
	// * INTEGER
	// * FLOAT
	// * BOOLEAN
	// * TIMESTAMP
	// * DATE
	// * TIME
	// * DATETIME
	// * GEOGRAPHY,
	// * NUMERIC,
	// * BIGNUMERIC,
	// * RECORD
	// (where RECORD indicates that the field contains a nested schema).
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// The field mode. Possible values include NULLABLE, REQUIRED and
	// REPEATED. The default value is NULLABLE.
	Mode string `protobuf:"bytes,3,opt,name=mode,proto3" json:"mode,omitempty"`
	// Describes the nested schema fields if the type property is set
	// to RECORD.
	Fields []*TableFieldSchema `protobuf:"bytes,4,rep,name=fields,proto3" json:"fields,omitempty"`
}

func (x *TableFieldSchema) Reset() {
	*x = TableFieldSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[49]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TableFieldSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TableFieldSchema) ProtoMessage() {}

func (x *TableFieldSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[49]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TableFieldSchema.ProtoReflect.Descriptor instead.
func (*TableFieldSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{49}
}

func (x *TableFieldSchema) GetField() string {
	if x != nil {
		return x.Field
	}
	return ""
}

func (x *TableFieldSchema) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *TableFieldSchema) GetMode() string {
	if x != nil {
		return x.Mode
	}
	return ""
}

func (x *TableFieldSchema) GetFields() []*TableFieldSchema {
	if x != nil {
		return x.Fields
	}
	return nil
}

// A request message for
// [AssetService.BatchGetEffectiveIamPolicies][google.cloud.asset.v1.AssetService.BatchGetEffectiveIamPolicies].
type BatchGetEffectiveIamPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Only IAM policies on or below the scope will be returned.
	//
	// This can only be an organization number (such as "organizations/123"), a
	// folder number (such as "folders/123"), a project ID (such as
	// "projects/my-project-id"), or a project number (such as "projects/12345").
	//
	// To know how to get organization ID, visit [here
	// ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id).
	//
	// To know how to get folder or project ID, visit [here
	// ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The names refer to the [full_resource_names]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// of the asset types [supported by search
	// APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types).
	// A maximum of 20 resources' effective policies can be retrieved in a batch.
	Names []string `protobuf:"bytes,3,rep,name=names,proto3" json:"names,omitempty"`
}

func (x *BatchGetEffectiveIamPoliciesRequest) Reset() {
	*x = BatchGetEffectiveIamPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[50]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetEffectiveIamPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetEffectiveIamPoliciesRequest) ProtoMessage() {}

func (x *BatchGetEffectiveIamPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[50]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetEffectiveIamPoliciesRequest.ProtoReflect.Descriptor instead.
func (*BatchGetEffectiveIamPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{50}
}

func (x *BatchGetEffectiveIamPoliciesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *BatchGetEffectiveIamPoliciesRequest) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

// A response message for
// [AssetService.BatchGetEffectiveIamPolicies][google.cloud.asset.v1.AssetService.BatchGetEffectiveIamPolicies].
type BatchGetEffectiveIamPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The effective policies for a batch of resources. Note that the results
	// order is the same as the order of
	// [BatchGetEffectiveIamPoliciesRequest.names][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest.names].
	// When a resource does not have any effective IAM policies, its corresponding
	// policy_result will contain empty
	// [EffectiveIamPolicy.policies][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.policies].
	PolicyResults []*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy `protobuf:"bytes,2,rep,name=policy_results,json=policyResults,proto3" json:"policy_results,omitempty"`
}

func (x *BatchGetEffectiveIamPoliciesResponse) Reset() {
	*x = BatchGetEffectiveIamPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[51]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetEffectiveIamPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetEffectiveIamPoliciesResponse) ProtoMessage() {}

func (x *BatchGetEffectiveIamPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[51]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetEffectiveIamPoliciesResponse.ProtoReflect.Descriptor instead.
func (*BatchGetEffectiveIamPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{51}
}

func (x *BatchGetEffectiveIamPoliciesResponse) GetPolicyResults() []*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy {
	if x != nil {
		return x.PolicyResults
	}
	return nil
}

// This organization policy message is a modified version of the one defined in
// the Organization Policy system. This message contains several fields defined
// in the original organization policy with some new fields for analysis
// purpose.
type AnalyzerOrgPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [full resource name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
	// an organization/folder/project resource where this organization policy is
	// set.
	//
	// Notice that some type of constraints are defined with default policy. This
	// field will be empty for them.
	AttachedResource string `protobuf:"bytes,1,opt,name=attached_resource,json=attachedResource,proto3" json:"attached_resource,omitempty"`
	// The [full resource name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
	// an organization/folder/project resource where this organization policy
	// applies to.
	//
	// For any user defined org policies, this field has the same value as
	// the [attached_resource] field. Only for default policy, this field has
	// the different value.
	AppliedResource string `protobuf:"bytes,5,opt,name=applied_resource,json=appliedResource,proto3" json:"applied_resource,omitempty"`
	// List of rules for this organization policy.
	Rules []*AnalyzerOrgPolicy_Rule `protobuf:"bytes,2,rep,name=rules,proto3" json:"rules,omitempty"`
	// If `inherit_from_parent` is true, Rules set higher up in the
	// hierarchy (up to the closest root) are inherited and present in the
	// effective policy. If it is false, then no rules are inherited, and this
	// policy becomes the effective root for evaluation.
	InheritFromParent bool `protobuf:"varint,3,opt,name=inherit_from_parent,json=inheritFromParent,proto3" json:"inherit_from_parent,omitempty"`
	// Ignores policies set above this resource and restores the default behavior
	// of the constraint at this resource.
	// This field can be set in policies for either list or boolean
	// constraints. If set, `rules` must be empty and `inherit_from_parent`
	// must be set to false.
	Reset_ bool `protobuf:"varint,4,opt,name=reset,proto3" json:"reset,omitempty"`
}

func (x *AnalyzerOrgPolicy) Reset() {
	*x = AnalyzerOrgPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[52]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerOrgPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerOrgPolicy) ProtoMessage() {}

func (x *AnalyzerOrgPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[52]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerOrgPolicy.ProtoReflect.Descriptor instead.
func (*AnalyzerOrgPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{52}
}

func (x *AnalyzerOrgPolicy) GetAttachedResource() string {
	if x != nil {
		return x.AttachedResource
	}
	return ""
}

func (x *AnalyzerOrgPolicy) GetAppliedResource() string {
	if x != nil {
		return x.AppliedResource
	}
	return ""
}

func (x *AnalyzerOrgPolicy) GetRules() []*AnalyzerOrgPolicy_Rule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *AnalyzerOrgPolicy) GetInheritFromParent() bool {
	if x != nil {
		return x.InheritFromParent
	}
	return false
}

func (x *AnalyzerOrgPolicy) GetReset_() bool {
	if x != nil {
		return x.Reset_
	}
	return false
}

// The organization policy constraint definition.
type AnalyzerOrgPolicyConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ConstraintDefinition:
	//
	//	*AnalyzerOrgPolicyConstraint_GoogleDefinedConstraint
	//	*AnalyzerOrgPolicyConstraint_CustomConstraint_
	ConstraintDefinition isAnalyzerOrgPolicyConstraint_ConstraintDefinition `protobuf_oneof:"constraint_definition"`
}

func (x *AnalyzerOrgPolicyConstraint) Reset() {
	*x = AnalyzerOrgPolicyConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[53]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerOrgPolicyConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerOrgPolicyConstraint) ProtoMessage() {}

func (x *AnalyzerOrgPolicyConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[53]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerOrgPolicyConstraint.ProtoReflect.Descriptor instead.
func (*AnalyzerOrgPolicyConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{53}
}

func (m *AnalyzerOrgPolicyConstraint) GetConstraintDefinition() isAnalyzerOrgPolicyConstraint_ConstraintDefinition {
	if m != nil {
		return m.ConstraintDefinition
	}
	return nil
}

func (x *AnalyzerOrgPolicyConstraint) GetGoogleDefinedConstraint() *AnalyzerOrgPolicyConstraint_Constraint {
	if x, ok := x.GetConstraintDefinition().(*AnalyzerOrgPolicyConstraint_GoogleDefinedConstraint); ok {
		return x.GoogleDefinedConstraint
	}
	return nil
}

func (x *AnalyzerOrgPolicyConstraint) GetCustomConstraint() *AnalyzerOrgPolicyConstraint_CustomConstraint {
	if x, ok := x.GetConstraintDefinition().(*AnalyzerOrgPolicyConstraint_CustomConstraint_); ok {
		return x.CustomConstraint
	}
	return nil
}

type isAnalyzerOrgPolicyConstraint_ConstraintDefinition interface {
	isAnalyzerOrgPolicyConstraint_ConstraintDefinition()
}

type AnalyzerOrgPolicyConstraint_GoogleDefinedConstraint struct {
	// The definition of the canned constraint defined by Google.
	GoogleDefinedConstraint *AnalyzerOrgPolicyConstraint_Constraint `protobuf:"bytes,1,opt,name=google_defined_constraint,json=googleDefinedConstraint,proto3,oneof"`
}

type AnalyzerOrgPolicyConstraint_CustomConstraint_ struct {
	// The definition of the custom constraint.
	CustomConstraint *AnalyzerOrgPolicyConstraint_CustomConstraint `protobuf:"bytes,2,opt,name=custom_constraint,json=customConstraint,proto3,oneof"`
}

func (*AnalyzerOrgPolicyConstraint_GoogleDefinedConstraint) isAnalyzerOrgPolicyConstraint_ConstraintDefinition() {
}

func (*AnalyzerOrgPolicyConstraint_CustomConstraint_) isAnalyzerOrgPolicyConstraint_ConstraintDefinition() {
}

// A request message for
// [AssetService.AnalyzeOrgPolicies][google.cloud.asset.v1.AssetService.AnalyzeOrgPolicies].
type AnalyzeOrgPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The organization to scope the request. Only organization
	// policies within the scope will be analyzed.
	//
	// * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The name of the constraint to analyze organization policies for.
	// The response only contains analyzed organization policies for the provided
	// constraint.
	Constraint string `protobuf:"bytes,2,opt,name=constraint,proto3" json:"constraint,omitempty"`
	// The expression to filter
	// [AnalyzeOrgPoliciesResponse.org_policy_results][google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.org_policy_results].
	// Filtering is currently available for bare literal values and the following
	// fields:
	// * consolidated_policy.attached_resource
	// * consolidated_policy.rules.enforce
	//
	// When filtering by a specific field, the only supported operator is `=`.
	// For example, filtering by
	// consolidated_policy.attached_resource="//cloudresourcemanager.googleapis.com/folders/001"
	// will return all the Organization Policy results attached to "folders/001".
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of items to return per page. If unspecified,
	// [AnalyzeOrgPoliciesResponse.org_policy_results][google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.org_policy_results]
	// will contain 20 items with a maximum of 200.
	PageSize *int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3,oneof" json:"page_size,omitempty"`
	// The pagination token to retrieve the next page.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *AnalyzeOrgPoliciesRequest) Reset() {
	*x = AnalyzeOrgPoliciesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[54]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPoliciesRequest) ProtoMessage() {}

func (x *AnalyzeOrgPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[54]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPoliciesRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{54}
}

func (x *AnalyzeOrgPoliciesRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *AnalyzeOrgPoliciesRequest) GetConstraint() string {
	if x != nil {
		return x.Constraint
	}
	return ""
}

func (x *AnalyzeOrgPoliciesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *AnalyzeOrgPoliciesRequest) GetPageSize() int32 {
	if x != nil && x.PageSize != nil {
		return *x.PageSize
	}
	return 0
}

func (x *AnalyzeOrgPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [AssetService.AnalyzeOrgPolicies][google.cloud.asset.v1.AssetService.AnalyzeOrgPolicies].
type AnalyzeOrgPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The organization policies under the
	// [AnalyzeOrgPoliciesRequest.scope][google.cloud.asset.v1.AnalyzeOrgPoliciesRequest.scope]
	// with the
	// [AnalyzeOrgPoliciesRequest.constraint][google.cloud.asset.v1.AnalyzeOrgPoliciesRequest.constraint].
	OrgPolicyResults []*AnalyzeOrgPoliciesResponse_OrgPolicyResult `protobuf:"bytes,1,rep,name=org_policy_results,json=orgPolicyResults,proto3" json:"org_policy_results,omitempty"`
	// The definition of the constraint in the request.
	Constraint *AnalyzerOrgPolicyConstraint `protobuf:"bytes,2,opt,name=constraint,proto3" json:"constraint,omitempty"`
	// The page token to fetch the next page for
	// [AnalyzeOrgPoliciesResponse.org_policy_results][google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.org_policy_results].
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *AnalyzeOrgPoliciesResponse) Reset() {
	*x = AnalyzeOrgPoliciesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[55]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPoliciesResponse) ProtoMessage() {}

func (x *AnalyzeOrgPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[55]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPoliciesResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{55}
}

func (x *AnalyzeOrgPoliciesResponse) GetOrgPolicyResults() []*AnalyzeOrgPoliciesResponse_OrgPolicyResult {
	if x != nil {
		return x.OrgPolicyResults
	}
	return nil
}

func (x *AnalyzeOrgPoliciesResponse) GetConstraint() *AnalyzerOrgPolicyConstraint {
	if x != nil {
		return x.Constraint
	}
	return nil
}

func (x *AnalyzeOrgPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request message for
// [AssetService.AnalyzeOrgPolicyGovernedContainers][google.cloud.asset.v1.AssetService.AnalyzeOrgPolicyGovernedContainers].
type AnalyzeOrgPolicyGovernedContainersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The organization to scope the request. Only organization
	// policies within the scope will be analyzed. The output containers will
	// also be limited to the ones governed by those in-scope organization
	// policies.
	//
	// * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The name of the constraint to analyze governed containers for.
	// The analysis only contains organization policies for the provided
	// constraint.
	Constraint string `protobuf:"bytes,2,opt,name=constraint,proto3" json:"constraint,omitempty"`
	// The expression to filter
	// [AnalyzeOrgPolicyGovernedContainersResponse.governed_containers][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.governed_containers].
	// Filtering is currently available for bare literal values and the following
	// fields:
	// * parent
	// * consolidated_policy.rules.enforce
	//
	// When filtering by a specific field, the only supported operator is `=`.
	// For example, filtering by
	// parent="//cloudresourcemanager.googleapis.com/folders/001"
	// will return all the containers under "folders/001".
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of items to return per page. If unspecified,
	// [AnalyzeOrgPolicyGovernedContainersResponse.governed_containers][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.governed_containers]
	// will contain 100 items with a maximum of 200.
	PageSize *int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3,oneof" json:"page_size,omitempty"`
	// The pagination token to retrieve the next page.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *AnalyzeOrgPolicyGovernedContainersRequest) Reset() {
	*x = AnalyzeOrgPolicyGovernedContainersRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[56]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPolicyGovernedContainersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPolicyGovernedContainersRequest) ProtoMessage() {}

func (x *AnalyzeOrgPolicyGovernedContainersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[56]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPolicyGovernedContainersRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPolicyGovernedContainersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{56}
}

func (x *AnalyzeOrgPolicyGovernedContainersRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedContainersRequest) GetConstraint() string {
	if x != nil {
		return x.Constraint
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedContainersRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedContainersRequest) GetPageSize() int32 {
	if x != nil && x.PageSize != nil {
		return *x.PageSize
	}
	return 0
}

func (x *AnalyzeOrgPolicyGovernedContainersRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [AssetService.AnalyzeOrgPolicyGovernedContainers][google.cloud.asset.v1.AssetService.AnalyzeOrgPolicyGovernedContainers].
type AnalyzeOrgPolicyGovernedContainersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of the analyzed governed containers.
	GovernedContainers []*AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer `protobuf:"bytes,1,rep,name=governed_containers,json=governedContainers,proto3" json:"governed_containers,omitempty"`
	// The definition of the constraint in the request.
	Constraint *AnalyzerOrgPolicyConstraint `protobuf:"bytes,2,opt,name=constraint,proto3" json:"constraint,omitempty"`
	// The page token to fetch the next page for
	// [AnalyzeOrgPolicyGovernedContainersResponse.governed_containers][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.governed_containers].
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse) Reset() {
	*x = AnalyzeOrgPolicyGovernedContainersResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[57]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPolicyGovernedContainersResponse) ProtoMessage() {}

func (x *AnalyzeOrgPolicyGovernedContainersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[57]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPolicyGovernedContainersResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPolicyGovernedContainersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{57}
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse) GetGovernedContainers() []*AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer {
	if x != nil {
		return x.GovernedContainers
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse) GetConstraint() *AnalyzerOrgPolicyConstraint {
	if x != nil {
		return x.Constraint
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A request message for
// [AssetService.AnalyzeOrgPolicyGovernedAssets][google.cloud.asset.v1.AssetService.AnalyzeOrgPolicyGovernedAssets].
type AnalyzeOrgPolicyGovernedAssetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The organization to scope the request. Only organization
	// policies within the scope will be analyzed. The output assets will
	// also be limited to the ones governed by those in-scope organization
	// policies.
	//
	// * organizations/{ORGANIZATION_NUMBER} (e.g., "organizations/123456")
	Scope string `protobuf:"bytes,1,opt,name=scope,proto3" json:"scope,omitempty"`
	// Required. The name of the constraint to analyze governed assets for. The
	// analysis only contains analyzed organization policies for the provided
	// constraint.
	Constraint string `protobuf:"bytes,2,opt,name=constraint,proto3" json:"constraint,omitempty"`
	// The expression to filter
	// [AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets].
	//
	// For governed resources, filtering is currently available for bare literal
	// values and the following fields:
	// * governed_resource.project
	// * governed_resource.folders
	// * consolidated_policy.rules.enforce
	// When filtering by `governed_resource.project` or
	// `consolidated_policy.rules.enforce`, the only supported operator is `=`.
	// When filtering by `governed_resource.folders`, the supported operators
	// are `=` and `:`.
	// For example, filtering by `governed_resource.project="projects/12345678"`
	// will return all the governed resources under "projects/12345678",
	// including the project itself if applicable.
	//
	// For governed IAM policies, filtering is currently available for bare
	// literal values and the following fields:
	// * governed_iam_policy.project
	// * governed_iam_policy.folders
	// * consolidated_policy.rules.enforce
	// When filtering by `governed_iam_policy.project` or
	// `consolidated_policy.rules.enforce`, the only supported operator is `=`.
	// When filtering by `governed_iam_policy.folders`, the supported operators
	// are `=` and `:`.
	// For example, filtering by `governed_iam_policy.folders:"folders/12345678"`
	// will return all the governed IAM policies under "folders/001".
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of items to return per page. If unspecified,
	// [AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets]
	// will contain 100 items with a maximum of 200.
	PageSize *int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3,oneof" json:"page_size,omitempty"`
	// The pagination token to retrieve the next page.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *AnalyzeOrgPolicyGovernedAssetsRequest) Reset() {
	*x = AnalyzeOrgPolicyGovernedAssetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[58]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPolicyGovernedAssetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPolicyGovernedAssetsRequest) ProtoMessage() {}

func (x *AnalyzeOrgPolicyGovernedAssetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[58]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPolicyGovernedAssetsRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPolicyGovernedAssetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{58}
}

func (x *AnalyzeOrgPolicyGovernedAssetsRequest) GetScope() string {
	if x != nil {
		return x.Scope
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsRequest) GetConstraint() string {
	if x != nil {
		return x.Constraint
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsRequest) GetPageSize() int32 {
	if x != nil && x.PageSize != nil {
		return *x.PageSize
	}
	return 0
}

func (x *AnalyzeOrgPolicyGovernedAssetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [AssetService.AnalyzeOrgPolicyGovernedAssets][google.cloud.asset.v1.AssetService.AnalyzeOrgPolicyGovernedAssets].
type AnalyzeOrgPolicyGovernedAssetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of the analyzed governed assets.
	GovernedAssets []*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset `protobuf:"bytes,1,rep,name=governed_assets,json=governedAssets,proto3" json:"governed_assets,omitempty"`
	// The definition of the constraint in the request.
	Constraint *AnalyzerOrgPolicyConstraint `protobuf:"bytes,2,opt,name=constraint,proto3" json:"constraint,omitempty"`
	// The page token to fetch the next page for
	// [AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets].
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse) Reset() {
	*x = AnalyzeOrgPolicyGovernedAssetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[59]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPolicyGovernedAssetsResponse) ProtoMessage() {}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[59]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPolicyGovernedAssetsResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPolicyGovernedAssetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{59}
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse) GetGovernedAssets() []*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset {
	if x != nil {
		return x.GovernedAssets
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse) GetConstraint() *AnalyzerOrgPolicyConstraint {
	if x != nil {
		return x.Constraint
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Specifies the resource to analyze for access policies, which may be set
// directly on the resource, or on ancestors such as organizations, folders or
// projects.
type IamPolicyAnalysisQuery_ResourceSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [full resource name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// of a resource of [supported resource
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#analyzable_asset_types).
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
}

func (x *IamPolicyAnalysisQuery_ResourceSelector) Reset() {
	*x = IamPolicyAnalysisQuery_ResourceSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[60]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_ResourceSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_ResourceSelector) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_ResourceSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[60]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_ResourceSelector.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_ResourceSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26, 0}
}

func (x *IamPolicyAnalysisQuery_ResourceSelector) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

// Specifies an identity for which to determine resource access, based on
// roles assigned either directly to them or to the groups they belong to,
// directly or indirectly.
type IamPolicyAnalysisQuery_IdentitySelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The identity appear in the form of principals in
	// [IAM policy
	// binding](https://cloud.google.com/iam/reference/rest/v1/Binding).
	//
	// The examples of supported forms are:
	// "user:mike@example.com",
	// "group:admins@example.com",
	// "domain:google.com",
	// "serviceAccount:my-project-id@appspot.gserviceaccount.com".
	//
	// Notice that wildcard characters (such as * and ?) are not supported.
	// You must give a specific identity.
	Identity string `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (x *IamPolicyAnalysisQuery_IdentitySelector) Reset() {
	*x = IamPolicyAnalysisQuery_IdentitySelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[61]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_IdentitySelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_IdentitySelector) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_IdentitySelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[61]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_IdentitySelector.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_IdentitySelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26, 1}
}

func (x *IamPolicyAnalysisQuery_IdentitySelector) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

// Specifies roles and/or permissions to analyze, to determine both the
// identities possessing them and the resources they control. If multiple
// values are specified, results will include roles or permissions matching
// any of them. The total number of roles and permissions should be equal or
// less than 10.
type IamPolicyAnalysisQuery_AccessSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The roles to appear in result.
	Roles []string `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	// Optional. The permissions to appear in result.
	Permissions []string `protobuf:"bytes,2,rep,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *IamPolicyAnalysisQuery_AccessSelector) Reset() {
	*x = IamPolicyAnalysisQuery_AccessSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[62]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_AccessSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_AccessSelector) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_AccessSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[62]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_AccessSelector.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_AccessSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26, 2}
}

func (x *IamPolicyAnalysisQuery_AccessSelector) GetRoles() []string {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *IamPolicyAnalysisQuery_AccessSelector) GetPermissions() []string {
	if x != nil {
		return x.Permissions
	}
	return nil
}

// Contains query options.
type IamPolicyAnalysisQuery_Options struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If true, the identities section of the result will expand any
	// Google groups appearing in an IAM policy binding.
	//
	// If
	// [IamPolicyAnalysisQuery.identity_selector][google.cloud.asset.v1.IamPolicyAnalysisQuery.identity_selector]
	// is specified, the identity in the result will be determined by the
	// selector, and this flag is not allowed to set.
	//
	// If true, the default max expansion per group is 1000 for
	// AssetService.AnalyzeIamPolicy][].
	//
	// Default is false.
	ExpandGroups bool `protobuf:"varint,1,opt,name=expand_groups,json=expandGroups,proto3" json:"expand_groups,omitempty"`
	// Optional. If true, the access section of result will expand any roles
	// appearing in IAM policy bindings to include their permissions.
	//
	// If
	// [IamPolicyAnalysisQuery.access_selector][google.cloud.asset.v1.IamPolicyAnalysisQuery.access_selector]
	// is specified, the access section of the result will be determined by the
	// selector, and this flag is not allowed to set.
	//
	// Default is false.
	ExpandRoles bool `protobuf:"varint,2,opt,name=expand_roles,json=expandRoles,proto3" json:"expand_roles,omitempty"`
	// Optional. If true and
	// [IamPolicyAnalysisQuery.resource_selector][google.cloud.asset.v1.IamPolicyAnalysisQuery.resource_selector]
	// is not specified, the resource section of the result will expand any
	// resource attached to an IAM policy to include resources lower in the
	// resource hierarchy.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and the results include an IAM policy with P on a Google
	// Cloud folder, the results will also include resources in that folder with
	// permission P.
	//
	// If true and
	// [IamPolicyAnalysisQuery.resource_selector][google.cloud.asset.v1.IamPolicyAnalysisQuery.resource_selector]
	// is specified, the resource section of the result will expand the
	// specified resource to include resources lower in the resource hierarchy.
	// Only project or lower resources are supported. Folder and organization
	// resources cannot be used together with this option.
	//
	// For example, if the request analyzes for which users have permission P on
	// a Google Cloud project with this option enabled, the results will include
	// all users who have permission P on that project or any lower resource.
	//
	// If true, the default max expansion per resource is 1000 for
	// AssetService.AnalyzeIamPolicy][] and 100000 for
	// AssetService.AnalyzeIamPolicyLongrunning][].
	//
	// Default is false.
	ExpandResources bool `protobuf:"varint,3,opt,name=expand_resources,json=expandResources,proto3" json:"expand_resources,omitempty"`
	// Optional. If true, the result will output the relevant parent/child
	// relationships between resources. Default is false.
	OutputResourceEdges bool `protobuf:"varint,4,opt,name=output_resource_edges,json=outputResourceEdges,proto3" json:"output_resource_edges,omitempty"`
	// Optional. If true, the result will output the relevant membership
	// relationships between groups and other groups, and between groups and
	// principals. Default is false.
	OutputGroupEdges bool `protobuf:"varint,5,opt,name=output_group_edges,json=outputGroupEdges,proto3" json:"output_group_edges,omitempty"`
	// Optional. If true, the response will include access analysis from
	// identities to resources via service account impersonation. This is a very
	// expensive operation, because many derived queries will be executed. We
	// highly recommend you use
	// [AssetService.AnalyzeIamPolicyLongrunning][google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning]
	// RPC instead.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and there's an IAM policy states user A has
	// iam.serviceAccounts.getAccessToken permission to a service account SA,
	// and there's another IAM policy states service account SA has permission P
	// to a Google Cloud folder F, then user A potentially has access to the
	// Google Cloud folder F. And those advanced analysis results will be
	// included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Another example, if the request analyzes for who has
	// permission P to a Google Cloud folder F, and there's an IAM policy states
	// user A has iam.serviceAccounts.actAs permission to a service account SA,
	// and there's another IAM policy states service account SA has permission P
	// to the Google Cloud folder F, then user A potentially has access to the
	// Google Cloud folder F. And those advanced analysis results will be
	// included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Only the following permissions are considered in this analysis:
	//
	// * `iam.serviceAccounts.actAs`
	// * `iam.serviceAccounts.signBlob`
	// * `iam.serviceAccounts.signJwt`
	// * `iam.serviceAccounts.getAccessToken`
	// * `iam.serviceAccounts.getOpenIdToken`
	// * `iam.serviceAccounts.implicitDelegation`
	//
	// Default is false.
	AnalyzeServiceAccountImpersonation bool `protobuf:"varint,6,opt,name=analyze_service_account_impersonation,json=analyzeServiceAccountImpersonation,proto3" json:"analyze_service_account_impersonation,omitempty"`
}

func (x *IamPolicyAnalysisQuery_Options) Reset() {
	*x = IamPolicyAnalysisQuery_Options{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[63]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_Options) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_Options) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_Options) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[63]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_Options.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_Options) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26, 3}
}

func (x *IamPolicyAnalysisQuery_Options) GetExpandGroups() bool {
	if x != nil {
		return x.ExpandGroups
	}
	return false
}

func (x *IamPolicyAnalysisQuery_Options) GetExpandRoles() bool {
	if x != nil {
		return x.ExpandRoles
	}
	return false
}

func (x *IamPolicyAnalysisQuery_Options) GetExpandResources() bool {
	if x != nil {
		return x.ExpandResources
	}
	return false
}

func (x *IamPolicyAnalysisQuery_Options) GetOutputResourceEdges() bool {
	if x != nil {
		return x.OutputResourceEdges
	}
	return false
}

func (x *IamPolicyAnalysisQuery_Options) GetOutputGroupEdges() bool {
	if x != nil {
		return x.OutputGroupEdges
	}
	return false
}

func (x *IamPolicyAnalysisQuery_Options) GetAnalyzeServiceAccountImpersonation() bool {
	if x != nil {
		return x.AnalyzeServiceAccountImpersonation
	}
	return false
}

// The IAM conditions context.
type IamPolicyAnalysisQuery_ConditionContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IAM conditions time context.
	//
	// Types that are assignable to TimeContext:
	//
	//	*IamPolicyAnalysisQuery_ConditionContext_AccessTime
	TimeContext isIamPolicyAnalysisQuery_ConditionContext_TimeContext `protobuf_oneof:"TimeContext"`
}

func (x *IamPolicyAnalysisQuery_ConditionContext) Reset() {
	*x = IamPolicyAnalysisQuery_ConditionContext{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[64]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_ConditionContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_ConditionContext) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_ConditionContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[64]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_ConditionContext.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_ConditionContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{26, 4}
}

func (m *IamPolicyAnalysisQuery_ConditionContext) GetTimeContext() isIamPolicyAnalysisQuery_ConditionContext_TimeContext {
	if m != nil {
		return m.TimeContext
	}
	return nil
}

func (x *IamPolicyAnalysisQuery_ConditionContext) GetAccessTime() *timestamppb.Timestamp {
	if x, ok := x.GetTimeContext().(*IamPolicyAnalysisQuery_ConditionContext_AccessTime); ok {
		return x.AccessTime
	}
	return nil
}

type isIamPolicyAnalysisQuery_ConditionContext_TimeContext interface {
	isIamPolicyAnalysisQuery_ConditionContext_TimeContext()
}

type IamPolicyAnalysisQuery_ConditionContext_AccessTime struct {
	// The hypothetical access timestamp to evaluate IAM conditions. Note that
	// this value must not be earlier than the current time; otherwise, an
	// INVALID_ARGUMENT error will be returned.
	AccessTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=access_time,json=accessTime,proto3,oneof"`
}

func (*IamPolicyAnalysisQuery_ConditionContext_AccessTime) isIamPolicyAnalysisQuery_ConditionContext_TimeContext() {
}

// An analysis message to group the query and results.
type AnalyzeIamPolicyResponse_IamPolicyAnalysis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The analysis query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// A list of
	// [IamPolicyAnalysisResult][google.cloud.asset.v1.IamPolicyAnalysisResult]
	// that matches the analysis query, or empty if no result is found.
	AnalysisResults []*IamPolicyAnalysisResult `protobuf:"bytes,2,rep,name=analysis_results,json=analysisResults,proto3" json:"analysis_results,omitempty"`
	// Represents whether all entries in the
	// [analysis_results][google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_results]
	// have been fully explored to answer the query.
	FullyExplored bool `protobuf:"varint,3,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
	// A list of non-critical errors happened during the query handling.
	NonCriticalErrors []*IamPolicyAnalysisState `protobuf:"bytes,5,rep,name=non_critical_errors,json=nonCriticalErrors,proto3" json:"non_critical_errors,omitempty"`
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) Reset() {
	*x = AnalyzeIamPolicyResponse_IamPolicyAnalysis{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[65]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyResponse_IamPolicyAnalysis) ProtoMessage() {}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[65]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyResponse_IamPolicyAnalysis.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyResponse_IamPolicyAnalysis) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{28, 0}
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if x != nil {
		return x.AnalysisQuery
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetAnalysisResults() []*IamPolicyAnalysisResult {
	if x != nil {
		return x.AnalysisResults
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetFullyExplored() bool {
	if x != nil {
		return x.FullyExplored
	}
	return false
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetNonCriticalErrors() []*IamPolicyAnalysisState {
	if x != nil {
		return x.NonCriticalErrors
	}
	return nil
}

// A Cloud Storage location.
type IamPolicyAnalysisOutputConfig_GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URI of the Cloud Storage object. It's the same URI that is
	// used by gsutil. Example: "gs://bucket_name/object_name". See [Viewing and
	// Editing Object
	// Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
	// for more information.
	//
	// If the specified Cloud Storage object already exists and there is no
	// [hold](https://cloud.google.com/storage/docs/object-holds), it will be
	// overwritten with the analysis result.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) Reset() {
	*x = IamPolicyAnalysisOutputConfig_GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[66]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisOutputConfig_GcsDestination) ProtoMessage() {}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[66]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisOutputConfig_GcsDestination.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisOutputConfig_GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{29, 0}
}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// A BigQuery destination.
type IamPolicyAnalysisOutputConfig_BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery dataset in format
	// "projects/projectId/datasets/datasetId", to which the analysis results
	// should be exported. If this dataset does not exist, the export call will
	// return an INVALID_ARGUMENT error.
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The prefix of the BigQuery tables to which the analysis results
	// will be written. Tables will be created based on this table_prefix if not
	// exist:
	//   - <table_prefix>_analysis table will contain export operation's metadata.
	//   - <table_prefix>_analysis_result will contain all the
	//     [IamPolicyAnalysisResult][google.cloud.asset.v1.IamPolicyAnalysisResult].
	//
	// When [partition_key] is specified, both tables will be partitioned based
	// on the [partition_key].
	TablePrefix string `protobuf:"bytes,2,opt,name=table_prefix,json=tablePrefix,proto3" json:"table_prefix,omitempty"`
	// The partition key for BigQuery partitioned table.
	PartitionKey IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey `protobuf:"varint,3,opt,name=partition_key,json=partitionKey,proto3,enum=google.cloud.asset.v1.IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey" json:"partition_key,omitempty"`
	// Optional. Specifies the action that occurs if the destination table or
	// partition already exists. The following values are supported:
	//
	// * WRITE_TRUNCATE: If the table or partition already exists, BigQuery
	// overwrites the entire table or all the partitions data.
	// * WRITE_APPEND: If the table or partition already exists, BigQuery
	// appends the data to the table or the latest partition.
	// * WRITE_EMPTY: If the table already exists and contains data, an error is
	// returned.
	//
	// The default value is WRITE_APPEND. Each action is atomic and only occurs
	// if BigQuery is able to complete the job successfully. Details are at
	// https://cloud.google.com/bigquery/docs/loading-data-local#appending_to_or_overwriting_a_table_using_a_local_file.
	WriteDisposition string `protobuf:"bytes,4,opt,name=write_disposition,json=writeDisposition,proto3" json:"write_disposition,omitempty"`
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) Reset() {
	*x = IamPolicyAnalysisOutputConfig_BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[67]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisOutputConfig_BigQueryDestination) ProtoMessage() {}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[67]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisOutputConfig_BigQueryDestination.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisOutputConfig_BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{29, 1}
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) GetTablePrefix() string {
	if x != nil {
		return x.TablePrefix
	}
	return ""
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) GetPartitionKey() IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey {
	if x != nil {
		return x.PartitionKey
	}
	return IamPolicyAnalysisOutputConfig_BigQueryDestination_PARTITION_KEY_UNSPECIFIED
}

func (x *IamPolicyAnalysisOutputConfig_BigQueryDestination) GetWriteDisposition() string {
	if x != nil {
		return x.WriteDisposition
	}
	return ""
}

// The query content.
type SavedQuery_QueryContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to QueryContent:
	//
	//	*SavedQuery_QueryContent_IamPolicyAnalysisQuery
	QueryContent isSavedQuery_QueryContent_QueryContent `protobuf_oneof:"query_content"`
}

func (x *SavedQuery_QueryContent) Reset() {
	*x = SavedQuery_QueryContent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[68]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SavedQuery_QueryContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SavedQuery_QueryContent) ProtoMessage() {}

func (x *SavedQuery_QueryContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[68]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SavedQuery_QueryContent.ProtoReflect.Descriptor instead.
func (*SavedQuery_QueryContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{32, 0}
}

func (m *SavedQuery_QueryContent) GetQueryContent() isSavedQuery_QueryContent_QueryContent {
	if m != nil {
		return m.QueryContent
	}
	return nil
}

func (x *SavedQuery_QueryContent) GetIamPolicyAnalysisQuery() *IamPolicyAnalysisQuery {
	if x, ok := x.GetQueryContent().(*SavedQuery_QueryContent_IamPolicyAnalysisQuery); ok {
		return x.IamPolicyAnalysisQuery
	}
	return nil
}

type isSavedQuery_QueryContent_QueryContent interface {
	isSavedQuery_QueryContent_QueryContent()
}

type SavedQuery_QueryContent_IamPolicyAnalysisQuery struct {
	// An IAM Policy Analysis query, which could be used in
	// the
	// [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1.AssetService.AnalyzeIamPolicy]
	// RPC or the
	// [AssetService.AnalyzeIamPolicyLongrunning][google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning]
	// RPC.
	IamPolicyAnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=iam_policy_analysis_query,json=iamPolicyAnalysisQuery,proto3,oneof"`
}

func (*SavedQuery_QueryContent_IamPolicyAnalysisQuery) isSavedQuery_QueryContent_QueryContent() {}

// BigQuery destination.
type QueryAssetsOutputConfig_BigQueryDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The BigQuery dataset where the query results will be saved. It
	// has the format of "projects/{projectId}/datasets/{datasetId}".
	Dataset string `protobuf:"bytes,1,opt,name=dataset,proto3" json:"dataset,omitempty"`
	// Required. The BigQuery table where the query results will be saved. If
	// this table does not exist, a new table with the given name will be
	// created.
	Table string `protobuf:"bytes,2,opt,name=table,proto3" json:"table,omitempty"`
	// Specifies the action that occurs if the destination table or partition
	// already exists. The following values are supported:
	//
	// * WRITE_TRUNCATE: If the table or partition already exists, BigQuery
	// overwrites the entire table or all the partitions data.
	// * WRITE_APPEND: If the table or partition already exists, BigQuery
	// appends the data to the table or the latest partition.
	// * WRITE_EMPTY: If the table already exists and contains data, a
	// 'duplicate' error is returned in the job result.
	//
	// The default value is WRITE_EMPTY.
	WriteDisposition string `protobuf:"bytes,3,opt,name=write_disposition,json=writeDisposition,proto3" json:"write_disposition,omitempty"`
}

func (x *QueryAssetsOutputConfig_BigQueryDestination) Reset() {
	*x = QueryAssetsOutputConfig_BigQueryDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[70]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *QueryAssetsOutputConfig_BigQueryDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QueryAssetsOutputConfig_BigQueryDestination) ProtoMessage() {}

func (x *QueryAssetsOutputConfig_BigQueryDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[70]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QueryAssetsOutputConfig_BigQueryDestination.ProtoReflect.Descriptor instead.
func (*QueryAssetsOutputConfig_BigQueryDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{44, 0}
}

func (x *QueryAssetsOutputConfig_BigQueryDestination) GetDataset() string {
	if x != nil {
		return x.Dataset
	}
	return ""
}

func (x *QueryAssetsOutputConfig_BigQueryDestination) GetTable() string {
	if x != nil {
		return x.Table
	}
	return ""
}

func (x *QueryAssetsOutputConfig_BigQueryDestination) GetWriteDisposition() string {
	if x != nil {
		return x.WriteDisposition
	}
	return ""
}

// The effective IAM policies on one resource.
type BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [full_resource_name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for which the
	// [policies][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.policies]
	// are computed. This is one of the
	// [BatchGetEffectiveIamPoliciesRequest.names][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest.names]
	// the caller provides in the request.
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// The effective policies for the
	// [full_resource_name][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.full_resource_name].
	//
	// These policies include the policy set on the
	// [full_resource_name][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.full_resource_name]
	// and those set on its parents and ancestors up to the
	// [BatchGetEffectiveIamPoliciesRequest.scope][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest.scope].
	// Note that these policies are not filtered according to the resource type
	// of the
	// [full_resource_name][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.full_resource_name].
	//
	// These policies are hierarchically ordered by
	// [PolicyInfo.attached_resource][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.attached_resource]
	// starting from
	// [full_resource_name][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.full_resource_name]
	// itself to its parents and ancestors, such that policies[i]'s
	// [PolicyInfo.attached_resource][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.attached_resource]
	// is the child of policies[i+1]'s
	// [PolicyInfo.attached_resource][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.attached_resource],
	// if policies[i+1] exists.
	Policies []*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo `protobuf:"bytes,2,rep,name=policies,proto3" json:"policies,omitempty"`
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) Reset() {
	*x = BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[71]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) ProtoMessage() {}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[71]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy.ProtoReflect.Descriptor instead.
func (*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{51, 0}
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy) GetPolicies() []*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo {
	if x != nil {
		return x.Policies
	}
	return nil
}

// The IAM policy and its attached resource.
type BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name the
	// [policy][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.policy]
	// is directly attached to.
	AttachedResource string `protobuf:"bytes,1,opt,name=attached_resource,json=attachedResource,proto3" json:"attached_resource,omitempty"`
	// The IAM policy that's directly attached to the
	// [attached_resource][google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.attached_resource].
	Policy *iampb.Policy `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) Reset() {
	*x = BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[72]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) ProtoMessage() {}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[72]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo.ProtoReflect.Descriptor instead.
func (*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{51, 0, 0}
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) GetAttachedResource() string {
	if x != nil {
		return x.AttachedResource
	}
	return ""
}

func (x *BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo) GetPolicy() *iampb.Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

// This rule message is a customized version of the one defined in the
// Organization Policy system. In addition to the fields defined in the
// original organization policy, it contains additional field(s) under
// specific circumstances to support analysis results.
type AnalyzerOrgPolicy_Rule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Kind:
	//
	//	*AnalyzerOrgPolicy_Rule_Values
	//	*AnalyzerOrgPolicy_Rule_AllowAll
	//	*AnalyzerOrgPolicy_Rule_DenyAll
	//	*AnalyzerOrgPolicy_Rule_Enforce
	Kind isAnalyzerOrgPolicy_Rule_Kind `protobuf_oneof:"kind"`
	// The evaluating condition for this rule.
	Condition *expr.Expr `protobuf:"bytes,7,opt,name=condition,proto3" json:"condition,omitempty"`
	// The condition evaluation result for this rule.
	// Only populated if it meets all the following criteria:
	//
	// * There is a
	// [condition][google.cloud.asset.v1.AnalyzerOrgPolicy.Rule.condition]
	// defined for this rule.
	//   - This rule is within
	//     [AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.consolidated_policy][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.consolidated_policy],
	//     or
	//     [AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.consolidated_policy][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.consolidated_policy]
	//     when the
	//     [AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset]
	//     has
	//     [AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.governed_resource][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.governed_resource].
	ConditionEvaluation *ConditionEvaluation `protobuf:"bytes,8,opt,name=condition_evaluation,json=conditionEvaluation,proto3" json:"condition_evaluation,omitempty"`
}

func (x *AnalyzerOrgPolicy_Rule) Reset() {
	*x = AnalyzerOrgPolicy_Rule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[73]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerOrgPolicy_Rule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerOrgPolicy_Rule) ProtoMessage() {}

func (x *AnalyzerOrgPolicy_Rule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[73]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerOrgPolicy_Rule.ProtoReflect.Descriptor instead.
func (*AnalyzerOrgPolicy_Rule) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{52, 0}
}

func (m *AnalyzerOrgPolicy_Rule) GetKind() isAnalyzerOrgPolicy_Rule_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *AnalyzerOrgPolicy_Rule) GetValues() *AnalyzerOrgPolicy_Rule_StringValues {
	if x, ok := x.GetKind().(*AnalyzerOrgPolicy_Rule_Values); ok {
		return x.Values
	}
	return nil
}

func (x *AnalyzerOrgPolicy_Rule) GetAllowAll() bool {
	if x, ok := x.GetKind().(*AnalyzerOrgPolicy_Rule_AllowAll); ok {
		return x.AllowAll
	}
	return false
}

func (x *AnalyzerOrgPolicy_Rule) GetDenyAll() bool {
	if x, ok := x.GetKind().(*AnalyzerOrgPolicy_Rule_DenyAll); ok {
		return x.DenyAll
	}
	return false
}

func (x *AnalyzerOrgPolicy_Rule) GetEnforce() bool {
	if x, ok := x.GetKind().(*AnalyzerOrgPolicy_Rule_Enforce); ok {
		return x.Enforce
	}
	return false
}

func (x *AnalyzerOrgPolicy_Rule) GetCondition() *expr.Expr {
	if x != nil {
		return x.Condition
	}
	return nil
}

func (x *AnalyzerOrgPolicy_Rule) GetConditionEvaluation() *ConditionEvaluation {
	if x != nil {
		return x.ConditionEvaluation
	}
	return nil
}

type isAnalyzerOrgPolicy_Rule_Kind interface {
	isAnalyzerOrgPolicy_Rule_Kind()
}

type AnalyzerOrgPolicy_Rule_Values struct {
	// List of values to be used for this policy rule. This field can be set
	// only in policies for list constraints.
	Values *AnalyzerOrgPolicy_Rule_StringValues `protobuf:"bytes,3,opt,name=values,proto3,oneof"`
}

type AnalyzerOrgPolicy_Rule_AllowAll struct {
	// Setting this to true means that all values are allowed. This field can
	// be set only in Policies for list constraints.
	AllowAll bool `protobuf:"varint,4,opt,name=allow_all,json=allowAll,proto3,oneof"`
}

type AnalyzerOrgPolicy_Rule_DenyAll struct {
	// Setting this to true means that all values are denied. This field can
	// be set only in Policies for list constraints.
	DenyAll bool `protobuf:"varint,5,opt,name=deny_all,json=denyAll,proto3,oneof"`
}

type AnalyzerOrgPolicy_Rule_Enforce struct {
	// If `true`, then the `Policy` is enforced. If `false`, then any
	// configuration is acceptable.
	// This field can be set only in Policies for boolean constraints.
	Enforce bool `protobuf:"varint,6,opt,name=enforce,proto3,oneof"`
}

func (*AnalyzerOrgPolicy_Rule_Values) isAnalyzerOrgPolicy_Rule_Kind() {}

func (*AnalyzerOrgPolicy_Rule_AllowAll) isAnalyzerOrgPolicy_Rule_Kind() {}

func (*AnalyzerOrgPolicy_Rule_DenyAll) isAnalyzerOrgPolicy_Rule_Kind() {}

func (*AnalyzerOrgPolicy_Rule_Enforce) isAnalyzerOrgPolicy_Rule_Kind() {}

// The string values for the list constraints.
type AnalyzerOrgPolicy_Rule_StringValues struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of values allowed at this resource.
	AllowedValues []string `protobuf:"bytes,1,rep,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
	// List of values denied at this resource.
	DeniedValues []string `protobuf:"bytes,2,rep,name=denied_values,json=deniedValues,proto3" json:"denied_values,omitempty"`
}

func (x *AnalyzerOrgPolicy_Rule_StringValues) Reset() {
	*x = AnalyzerOrgPolicy_Rule_StringValues{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[74]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerOrgPolicy_Rule_StringValues) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerOrgPolicy_Rule_StringValues) ProtoMessage() {}

func (x *AnalyzerOrgPolicy_Rule_StringValues) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[74]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerOrgPolicy_Rule_StringValues.ProtoReflect.Descriptor instead.
func (*AnalyzerOrgPolicy_Rule_StringValues) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{52, 0, 0}
}

func (x *AnalyzerOrgPolicy_Rule_StringValues) GetAllowedValues() []string {
	if x != nil {
		return x.AllowedValues
	}
	return nil
}

func (x *AnalyzerOrgPolicy_Rule_StringValues) GetDeniedValues() []string {
	if x != nil {
		return x.DeniedValues
	}
	return nil
}

// The definition of a constraint.
type AnalyzerOrgPolicyConstraint_Constraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of the constraint. Format of the name should be
	// * `constraints/{constraint_name}`
	//
	// For example, `constraints/compute.disableSerialPortAccess`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The human readable name of the constraint.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Detailed description of what this `Constraint` controls as well as how
	// and where it is enforced.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The evaluation behavior of this constraint in the absence of 'Policy'.
	ConstraintDefault AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault `protobuf:"varint,4,opt,name=constraint_default,json=constraintDefault,proto3,enum=google.cloud.asset.v1.AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault" json:"constraint_default,omitempty"`
	// The type of restrictions for this `Constraint`.
	//
	// Immutable after creation.
	//
	// Types that are assignable to ConstraintType:
	//
	//	*AnalyzerOrgPolicyConstraint_Constraint_ListConstraint_
	//	*AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint_
	ConstraintType isAnalyzerOrgPolicyConstraint_Constraint_ConstraintType `protobuf_oneof:"constraint_type"`
}

func (x *AnalyzerOrgPolicyConstraint_Constraint) Reset() {
	*x = AnalyzerOrgPolicyConstraint_Constraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[75]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerOrgPolicyConstraint_Constraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerOrgPolicyConstraint_Constraint) ProtoMessage() {}

func (x *AnalyzerOrgPolicyConstraint_Constraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[75]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerOrgPolicyConstraint_Constraint.ProtoReflect.Descriptor instead.
func (*AnalyzerOrgPolicyConstraint_Constraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{53, 0}
}

func (x *AnalyzerOrgPolicyConstraint_Constraint) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnalyzerOrgPolicyConstraint_Constraint) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AnalyzerOrgPolicyConstraint_Constraint) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *AnalyzerOrgPolicyConstraint_Constraint) GetConstraintDefault() AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault {
	if x != nil {
		return x.ConstraintDefault
	}
	return AnalyzerOrgPolicyConstraint_Constraint_CONSTRAINT_DEFAULT_UNSPECIFIED
}

func (m *AnalyzerOrgPolicyConstraint_Constraint) GetConstraintType() isAnalyzerOrgPolicyConstraint_Constraint_ConstraintType {
	if m != nil {
		return m.ConstraintType
	}
	return nil
}

func (x *AnalyzerOrgPolicyConstraint_Constraint) GetListConstraint() *AnalyzerOrgPolicyConstraint_Constraint_ListConstraint {
	if x, ok := x.GetConstraintType().(*AnalyzerOrgPolicyConstraint_Constraint_ListConstraint_); ok {
		return x.ListConstraint
	}
	return nil
}

func (x *AnalyzerOrgPolicyConstraint_Constraint) GetBooleanConstraint() *AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint {
	if x, ok := x.GetConstraintType().(*AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint_); ok {
		return x.BooleanConstraint
	}
	return nil
}

type isAnalyzerOrgPolicyConstraint_Constraint_ConstraintType interface {
	isAnalyzerOrgPolicyConstraint_Constraint_ConstraintType()
}

type AnalyzerOrgPolicyConstraint_Constraint_ListConstraint_ struct {
	// Defines this constraint as being a ListConstraint.
	ListConstraint *AnalyzerOrgPolicyConstraint_Constraint_ListConstraint `protobuf:"bytes,5,opt,name=list_constraint,json=listConstraint,proto3,oneof"`
}

type AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint_ struct {
	// Defines this constraint as being a BooleanConstraint.
	BooleanConstraint *AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint `protobuf:"bytes,6,opt,name=boolean_constraint,json=booleanConstraint,proto3,oneof"`
}

func (*AnalyzerOrgPolicyConstraint_Constraint_ListConstraint_) isAnalyzerOrgPolicyConstraint_Constraint_ConstraintType() {
}

func (*AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint_) isAnalyzerOrgPolicyConstraint_Constraint_ConstraintType() {
}

// The definition of a custom constraint.
type AnalyzerOrgPolicyConstraint_CustomConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the constraint. This is unique within the organization. Format of
	// the name should be
	// * `organizations/{organization_id}/customConstraints/{custom_constraint_id}`
	//
	// Example :
	// "organizations/123/customConstraints/custom.createOnlyE2TypeVms"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The Resource Instance type on which this policy applies to. Format will
	// be of the form : "<canonical service name>/<type>" Example:
	//   - `compute.googleapis.com/Instance`.
	ResourceTypes []string `protobuf:"bytes,2,rep,name=resource_types,json=resourceTypes,proto3" json:"resource_types,omitempty"`
	// All the operations being applied for this constraint.
	MethodTypes []AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType `protobuf:"varint,3,rep,packed,name=method_types,json=methodTypes,proto3,enum=google.cloud.asset.v1.AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType" json:"method_types,omitempty"`
	// Organization Policy condition/expression. For example:
	// `resource.instanceName.matches("[production|test]_.*_(\d)+")'` or,
	// `resource.management.auto_upgrade == true`
	Condition string `protobuf:"bytes,4,opt,name=condition,proto3" json:"condition,omitempty"`
	// Allow or deny type.
	ActionType AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType `protobuf:"varint,5,opt,name=action_type,json=actionType,proto3,enum=google.cloud.asset.v1.AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType" json:"action_type,omitempty"`
	// One line display name for the UI.
	DisplayName string `protobuf:"bytes,6,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Detailed information about this custom policy constraint.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *AnalyzerOrgPolicyConstraint_CustomConstraint) Reset() {
	*x = AnalyzerOrgPolicyConstraint_CustomConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[76]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerOrgPolicyConstraint_CustomConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerOrgPolicyConstraint_CustomConstraint) ProtoMessage() {}

func (x *AnalyzerOrgPolicyConstraint_CustomConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[76]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerOrgPolicyConstraint_CustomConstraint.ProtoReflect.Descriptor instead.
func (*AnalyzerOrgPolicyConstraint_CustomConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{53, 1}
}

func (x *AnalyzerOrgPolicyConstraint_CustomConstraint) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AnalyzerOrgPolicyConstraint_CustomConstraint) GetResourceTypes() []string {
	if x != nil {
		return x.ResourceTypes
	}
	return nil
}

func (x *AnalyzerOrgPolicyConstraint_CustomConstraint) GetMethodTypes() []AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType {
	if x != nil {
		return x.MethodTypes
	}
	return nil
}

func (x *AnalyzerOrgPolicyConstraint_CustomConstraint) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *AnalyzerOrgPolicyConstraint_CustomConstraint) GetActionType() AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType {
	if x != nil {
		return x.ActionType
	}
	return AnalyzerOrgPolicyConstraint_CustomConstraint_ACTION_TYPE_UNSPECIFIED
}

func (x *AnalyzerOrgPolicyConstraint_CustomConstraint) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AnalyzerOrgPolicyConstraint_CustomConstraint) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// A `Constraint` that allows or disallows a list of string values, which
// are configured by an organization's policy administrator with a `Policy`.
type AnalyzerOrgPolicyConstraint_Constraint_ListConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether values grouped into categories can be used in
	// `Policy.allowed_values` and `Policy.denied_values`. For example,
	// `"in:Python"` would match any value in the 'Python' group.
	SupportsIn bool `protobuf:"varint,1,opt,name=supports_in,json=supportsIn,proto3" json:"supports_in,omitempty"`
	// Indicates whether subtrees of Cloud Resource Manager resource hierarchy
	// can be used in `Policy.allowed_values` and `Policy.denied_values`. For
	// example, `"under:folders/123"` would match any resource under the
	// 'folders/123' folder.
	SupportsUnder bool `protobuf:"varint,2,opt,name=supports_under,json=supportsUnder,proto3" json:"supports_under,omitempty"`
}

func (x *AnalyzerOrgPolicyConstraint_Constraint_ListConstraint) Reset() {
	*x = AnalyzerOrgPolicyConstraint_Constraint_ListConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[77]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerOrgPolicyConstraint_Constraint_ListConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerOrgPolicyConstraint_Constraint_ListConstraint) ProtoMessage() {}

func (x *AnalyzerOrgPolicyConstraint_Constraint_ListConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[77]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerOrgPolicyConstraint_Constraint_ListConstraint.ProtoReflect.Descriptor instead.
func (*AnalyzerOrgPolicyConstraint_Constraint_ListConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{53, 0, 0}
}

func (x *AnalyzerOrgPolicyConstraint_Constraint_ListConstraint) GetSupportsIn() bool {
	if x != nil {
		return x.SupportsIn
	}
	return false
}

func (x *AnalyzerOrgPolicyConstraint_Constraint_ListConstraint) GetSupportsUnder() bool {
	if x != nil {
		return x.SupportsUnder
	}
	return false
}

// A `Constraint` that is either enforced or not.
//
// For example a constraint `constraints/compute.disableSerialPortAccess`.
// If it is enforced on a VM instance, serial port connections will not be
// opened to that instance.
type AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint) Reset() {
	*x = AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[78]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint) ProtoMessage() {}

func (x *AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[78]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint.ProtoReflect.Descriptor instead.
func (*AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{53, 0, 1}
}

// The organization policy result to the query.
type AnalyzeOrgPoliciesResponse_OrgPolicyResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The consolidated organization policy for the analyzed resource. The
	// consolidated organization policy is computed by merging and evaluating
	// [AnalyzeOrgPoliciesResponse.policy_bundle][].
	// The evaluation will respect the organization policy [hierarchy
	// rules](https://cloud.google.com/resource-manager/docs/organization-policy/understanding-hierarchy).
	ConsolidatedPolicy *AnalyzerOrgPolicy `protobuf:"bytes,1,opt,name=consolidated_policy,json=consolidatedPolicy,proto3" json:"consolidated_policy,omitempty"`
	// The ordered list of all organization policies from the
	// [AnalyzeOrgPoliciesResponse.OrgPolicyResult.consolidated_policy.attached_resource][].
	// to the scope specified in the request.
	//
	// If the constraint is defined with default policy, it will also appear in
	// the list.
	PolicyBundle []*AnalyzerOrgPolicy `protobuf:"bytes,2,rep,name=policy_bundle,json=policyBundle,proto3" json:"policy_bundle,omitempty"`
	// The project that this consolidated policy belongs to, in the format of
	// projects/{PROJECT_NUMBER}. This field is available when the consolidated
	// policy belongs to a project.
	Project string `protobuf:"bytes,3,opt,name=project,proto3" json:"project,omitempty"`
	// The folder(s) that this consolidated policy belongs to, in the format of
	// folders/{FOLDER_NUMBER}. This field is available when the consolidated
	// policy belongs (directly or cascadingly) to one or more folders.
	Folders []string `protobuf:"bytes,4,rep,name=folders,proto3" json:"folders,omitempty"`
	// The organization that this consolidated policy belongs to, in the format
	// of organizations/{ORGANIZATION_NUMBER}. This field is available when the
	// consolidated policy belongs (directly or cascadingly) to an organization.
	Organization string `protobuf:"bytes,5,opt,name=organization,proto3" json:"organization,omitempty"`
}

func (x *AnalyzeOrgPoliciesResponse_OrgPolicyResult) Reset() {
	*x = AnalyzeOrgPoliciesResponse_OrgPolicyResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[79]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPoliciesResponse_OrgPolicyResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPoliciesResponse_OrgPolicyResult) ProtoMessage() {}

func (x *AnalyzeOrgPoliciesResponse_OrgPolicyResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[79]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPoliciesResponse_OrgPolicyResult.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPoliciesResponse_OrgPolicyResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{55, 0}
}

func (x *AnalyzeOrgPoliciesResponse_OrgPolicyResult) GetConsolidatedPolicy() *AnalyzerOrgPolicy {
	if x != nil {
		return x.ConsolidatedPolicy
	}
	return nil
}

func (x *AnalyzeOrgPoliciesResponse_OrgPolicyResult) GetPolicyBundle() []*AnalyzerOrgPolicy {
	if x != nil {
		return x.PolicyBundle
	}
	return nil
}

func (x *AnalyzeOrgPoliciesResponse_OrgPolicyResult) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AnalyzeOrgPoliciesResponse_OrgPolicyResult) GetFolders() []string {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *AnalyzeOrgPoliciesResponse_OrgPolicyResult) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

// The organization/folder/project resource governed by organization policies
// of
// [AnalyzeOrgPolicyGovernedContainersRequest.constraint][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersRequest.constraint].
type AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [full resource name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
	// an organization/folder/project resource.
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// The [full resource name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
	// the parent of
	// [AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.full_resource_name][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.full_resource_name].
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The consolidated organization policy for the analyzed resource. The
	// consolidated organization policy is computed by merging and evaluating
	// [AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.policy_bundle][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.policy_bundle].
	// The evaluation will respect the organization policy [hierarchy
	// rules](https://cloud.google.com/resource-manager/docs/organization-policy/understanding-hierarchy).
	ConsolidatedPolicy *AnalyzerOrgPolicy `protobuf:"bytes,3,opt,name=consolidated_policy,json=consolidatedPolicy,proto3" json:"consolidated_policy,omitempty"`
	// The ordered list of all organization policies from the
	// [AnalyzeOrgPoliciesResponse.OrgPolicyResult.consolidated_policy.attached_resource][].
	// to the scope specified in the request.
	//
	// If the constraint is defined with default policy, it will also appear in
	// the list.
	PolicyBundle []*AnalyzerOrgPolicy `protobuf:"bytes,4,rep,name=policy_bundle,json=policyBundle,proto3" json:"policy_bundle,omitempty"`
	// The project that this resource belongs to, in the format of
	// projects/{PROJECT_NUMBER}. This field is available when the resource
	// belongs to a project.
	Project string `protobuf:"bytes,5,opt,name=project,proto3" json:"project,omitempty"`
	// The folder(s) that this resource belongs to, in the format of
	// folders/{FOLDER_NUMBER}. This field is available when the resource
	// belongs (directly or cascadingly) to one or more folders.
	Folders []string `protobuf:"bytes,6,rep,name=folders,proto3" json:"folders,omitempty"`
	// The organization that this resource belongs to, in the format of
	// organizations/{ORGANIZATION_NUMBER}. This field is available when the
	// resource belongs (directly or cascadingly) to an organization.
	Organization string `protobuf:"bytes,7,opt,name=organization,proto3" json:"organization,omitempty"`
	// The effective tags on this resource.
	EffectiveTags []*EffectiveTagDetails `protobuf:"bytes,8,rep,name=effective_tags,json=effectiveTags,proto3" json:"effective_tags,omitempty"`
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) Reset() {
	*x = AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[80]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) ProtoMessage() {}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[80]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{57, 0}
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) GetConsolidatedPolicy() *AnalyzerOrgPolicy {
	if x != nil {
		return x.ConsolidatedPolicy
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) GetPolicyBundle() []*AnalyzerOrgPolicy {
	if x != nil {
		return x.PolicyBundle
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) GetFolders() []string {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer) GetEffectiveTags() []*EffectiveTagDetails {
	if x != nil {
		return x.EffectiveTags
	}
	return nil
}

// The Google Cloud resources governed by the organization policies of the
// [AnalyzeOrgPolicyGovernedAssetsRequest.constraint][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest.constraint].
type AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [full resource name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
	// the Google Cloud resource.
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
	// The [full resource name]
	// (https://cloud.google.com/asset-inventory/docs/resource-name-format) of
	// the parent of
	// [AnalyzeOrgPolicyGovernedAssetsResponse.GovernedResource.full_resource_name][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedResource.full_resource_name].
	Parent string `protobuf:"bytes,2,opt,name=parent,proto3" json:"parent,omitempty"`
	// The project that this resource belongs to, in the format of
	// projects/{PROJECT_NUMBER}. This field is available when the resource
	// belongs to a project.
	Project string `protobuf:"bytes,5,opt,name=project,proto3" json:"project,omitempty"`
	// The folder(s) that this resource belongs to, in the format of
	// folders/{FOLDER_NUMBER}. This field is available when the resource
	// belongs (directly or cascadingly) to one or more folders.
	Folders []string `protobuf:"bytes,6,rep,name=folders,proto3" json:"folders,omitempty"`
	// The organization that this resource belongs to, in the format of
	// organizations/{ORGANIZATION_NUMBER}. This field is available when the
	// resource belongs (directly or cascadingly) to an organization.
	Organization string `protobuf:"bytes,7,opt,name=organization,proto3" json:"organization,omitempty"`
	// The asset type of the
	// [AnalyzeOrgPolicyGovernedAssetsResponse.GovernedResource.full_resource_name][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedResource.full_resource_name]
	// Example:
	// `cloudresourcemanager.googleapis.com/Project`
	// See [Cloud Asset Inventory Supported Asset
	// Types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// for all supported asset types.
	AssetType string `protobuf:"bytes,8,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// The effective tags on this resource.
	EffectiveTags []*EffectiveTagDetails `protobuf:"bytes,9,rep,name=effective_tags,json=effectiveTags,proto3" json:"effective_tags,omitempty"`
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) Reset() {
	*x = AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[81]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) ProtoMessage() {}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[81]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{59, 0}
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) GetFolders() []string {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource) GetEffectiveTags() []*EffectiveTagDetails {
	if x != nil {
		return x.EffectiveTags
	}
	return nil
}

// The IAM policies governed by the organization policies of the
// [AnalyzeOrgPolicyGovernedAssetsRequest.constraint][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest.constraint].
type AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full resource name of the resource on which this IAM policy is set.
	// Example:
	// `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
	// See [Cloud Asset Inventory Resource Name
	// Format](https://cloud.google.com/asset-inventory/docs/resource-name-format)
	// for more information.
	AttachedResource string `protobuf:"bytes,1,opt,name=attached_resource,json=attachedResource,proto3" json:"attached_resource,omitempty"`
	// The IAM policy directly set on the given resource.
	Policy *iampb.Policy `protobuf:"bytes,2,opt,name=policy,proto3" json:"policy,omitempty"`
	// The project that this IAM policy belongs to, in the format of
	// projects/{PROJECT_NUMBER}. This field is available when the IAM policy
	// belongs to a project.
	Project string `protobuf:"bytes,5,opt,name=project,proto3" json:"project,omitempty"`
	// The folder(s) that this IAM policy belongs to, in the format of
	// folders/{FOLDER_NUMBER}. This field is available when the IAM policy
	// belongs (directly or cascadingly) to one or more folders.
	Folders []string `protobuf:"bytes,6,rep,name=folders,proto3" json:"folders,omitempty"`
	// The organization that this IAM policy belongs to, in the format of
	// organizations/{ORGANIZATION_NUMBER}. This field is available when the
	// IAM policy belongs (directly or cascadingly) to an organization.
	Organization string `protobuf:"bytes,7,opt,name=organization,proto3" json:"organization,omitempty"`
	// The asset type of the
	// [AnalyzeOrgPolicyGovernedAssetsResponse.GovernedIamPolicy.attached_resource][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedIamPolicy.attached_resource].
	// Example:
	// `cloudresourcemanager.googleapis.com/Project`
	// See [Cloud Asset Inventory Supported Asset
	// Types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// for all supported asset types.
	AssetType string `protobuf:"bytes,8,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) Reset() {
	*x = AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[82]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) ProtoMessage() {}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[82]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{59, 1}
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) GetAttachedResource() string {
	if x != nil {
		return x.AttachedResource
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) GetPolicy() *iampb.Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) GetFolders() []string {
	if x != nil {
		return x.Folders
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) GetOrganization() string {
	if x != nil {
		return x.Organization
	}
	return ""
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy) GetAssetType() string {
	if x != nil {
		return x.AssetType
	}
	return ""
}

// Represents a Google Cloud asset(resource or IAM policy) governed by the
// organization policies of the
// [AnalyzeOrgPolicyGovernedAssetsRequest.constraint][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest.constraint].
type AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to GovernedAsset:
	//
	//	*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedResource
	//	*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedIamPolicy
	GovernedAsset isAnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedAsset `protobuf_oneof:"governed_asset"`
	// The consolidated policy for the analyzed asset. The consolidated
	// policy is computed by merging and evaluating
	// [AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.policy_bundle][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.policy_bundle].
	// The evaluation will respect the organization policy [hierarchy
	// rules](https://cloud.google.com/resource-manager/docs/organization-policy/understanding-hierarchy).
	ConsolidatedPolicy *AnalyzerOrgPolicy `protobuf:"bytes,3,opt,name=consolidated_policy,json=consolidatedPolicy,proto3" json:"consolidated_policy,omitempty"`
	// The ordered list of all organization policies from the
	// [AnalyzeOrgPoliciesResponse.OrgPolicyResult.consolidated_policy.attached_resource][]
	// to the scope specified in the request.
	//
	// If the constraint is defined with default policy, it will also appear in
	// the list.
	PolicyBundle []*AnalyzerOrgPolicy `protobuf:"bytes,4,rep,name=policy_bundle,json=policyBundle,proto3" json:"policy_bundle,omitempty"`
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset) Reset() {
	*x = AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[83]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset) ProtoMessage() {}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1_asset_service_proto_msgTypes[83]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset.ProtoReflect.Descriptor instead.
func (*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP(), []int{59, 2}
}

func (m *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset) GetGovernedAsset() isAnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedAsset {
	if m != nil {
		return m.GovernedAsset
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset) GetGovernedResource() *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource {
	if x, ok := x.GetGovernedAsset().(*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedResource); ok {
		return x.GovernedResource
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset) GetGovernedIamPolicy() *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy {
	if x, ok := x.GetGovernedAsset().(*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedIamPolicy); ok {
		return x.GovernedIamPolicy
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset) GetConsolidatedPolicy() *AnalyzerOrgPolicy {
	if x != nil {
		return x.ConsolidatedPolicy
	}
	return nil
}

func (x *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset) GetPolicyBundle() []*AnalyzerOrgPolicy {
	if x != nil {
		return x.PolicyBundle
	}
	return nil
}

type isAnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedAsset interface {
	isAnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedAsset()
}

type AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedResource struct {
	// A Google Cloud resource governed by the organization
	// policies of the
	// [AnalyzeOrgPolicyGovernedAssetsRequest.constraint][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest.constraint].
	GovernedResource *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource `protobuf:"bytes,1,opt,name=governed_resource,json=governedResource,proto3,oneof"`
}

type AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedIamPolicy struct {
	// An IAM policy governed by the organization
	// policies of the
	// [AnalyzeOrgPolicyGovernedAssetsRequest.constraint][google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest.constraint].
	GovernedIamPolicy *AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy `protobuf:"bytes,2,opt,name=governed_iam_policy,json=governedIamPolicy,proto3,oneof"`
}

func (*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedResource) isAnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedAsset() {
}

func (*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedIamPolicy) isAnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedAsset() {
}

var File_google_cloud_asset_v1_asset_service_proto protoreflect.FileDescriptor

var file_google_cloud_asset_v1_asset_service_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x15, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x65,
	0x78, 0x70, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x67, 0x0a, 0x23, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0xf5, 0x02, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x21, 0x12, 0x1f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4d, 0x0a, 0x0d,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2d, 0x0a, 0x12, 0x72,
	0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0xe3, 0x01, 0x0a, 0x14, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x0d,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x48, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x22, 0xe0, 0x02, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x12, 0x45, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x68, 0x69, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x54, 0x79,
	0x70, 0x65, 0x73, 0x22, 0xab, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x09, 0x72, 0x65,
	0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x52, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x22, 0xd2, 0x02, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x50, 0x0a, 0x10, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x77, 0x69,
	0x6e, 0x64, 0x6f, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64,
	0x6f, 0x77, 0x12, 0x32, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68,
	0x69, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69,
	0x70, 0x54, 0x79, 0x70, 0x65, 0x73, 0x22, 0x5d, 0x0a, 0x1d, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47,
	0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x06, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x6c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x22, 0x84, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x07, 0x66, 0x65, 0x65, 0x64,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x66, 0x65, 0x65, 0x64, 0x49, 0x64, 0x12, 0x34, 0x0a, 0x04, 0x66, 0x65, 0x65, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65,
	0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x66, 0x65, 0x65, 0x64, 0x22, 0x4c, 0x0a, 0x0e,
	0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x46, 0x65, 0x65, 0x64, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x2f, 0x0a, 0x10, 0x4c, 0x69,
	0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x46, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x31, 0x0a, 0x05, 0x66, 0x65, 0x65, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x52, 0x05, 0x66, 0x65,
	0x65, 0x64, 0x73, 0x22, 0x8b, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65,
	0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x34, 0x0a, 0x04, 0x66, 0x65, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x65, 0x65, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x66, 0x65, 0x65, 0x64, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73,
	0x6b, 0x22, 0x4f, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x50, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x14, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x61, 0x0a, 0x0c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x47, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x63, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x08,
	0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x25, 0x0a, 0x0f, 0x47, 0x63, 0x73, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x75,
	0x72, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x75, 0x72, 0x69, 0x73, 0x22,
	0x53, 0x0a, 0x0e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x0a, 0x75, 0x72, 0x69, 0x5f, 0x70, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x75, 0x72, 0x69,
	0x50, 0x72, 0x65, 0x66, 0x69, 0x78, 0x42, 0x0c, 0x0a, 0x0a, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x75, 0x72, 0x69, 0x22, 0xf6, 0x01, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07,
	0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x4b, 0x0a, 0x0e,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x42, 0x0a, 0x1e, 0x73, 0x65, 0x70,
	0x61, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72,
	0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x1a, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x50, 0x65, 0x72, 0x41, 0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0xb7, 0x01,
	0x0a, 0x0d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x56, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x22, 0x4e, 0x0a, 0x0c, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x41, 0x52, 0x54, 0x49,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x54,
	0x49, 0x4d, 0x45, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54,
	0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10, 0x02, 0x22, 0x29, 0x0a, 0x11, 0x50, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x70,
	0x69, 0x63, 0x22, 0x7c, 0x0a, 0x10, 0x46, 0x65, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x12, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62,
	0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75,
	0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x11,
	0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xf8, 0x03, 0x0a, 0x04, 0x46, 0x65, 0x65, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x73, 0x12, 0x45, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x12, 0x66,
	0x65, 0x65, 0x64, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x65, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x66, 0x65, 0x65, 0x64, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x12, 0x72, 0x65, 0x6c, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x07,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68,
	0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x73, 0x3a, 0x91, 0x01, 0xea, 0x41, 0x8d, 0x01, 0x0a, 0x1e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65, 0x65, 0x64, 0x12, 0x1f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64, 0x7d, 0x12,
	0x1d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64, 0x7d, 0x12, 0x29,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x65, 0x65,
	0x64, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x65, 0x64, 0x7d, 0x20, 0x01, 0x22, 0x9b, 0x02, 0x0a, 0x19,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x24, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x3c, 0x0a, 0x09, 0x72,
	0x65, 0x61, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x8b, 0x01, 0x0a, 0x1a, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x07, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xdf, 0x01, 0x0a, 0x1b, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x8e, 0x01, 0x0a, 0x1c, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x07, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xcf, 0x09, 0x0a, 0x16, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x12, 0x70, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x12, 0x70, 0x0a, 0x11, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x12, 0x6a, 0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x12, 0x54, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x70, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x1a, 0x45, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x31, 0x0a, 0x12,
	0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x66,
	0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a,
	0x33, 0x0a, 0x10, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x1a, 0x52, 0x0a, 0x0e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x19, 0x0a, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x72, 0x6f, 0x6c, 0x65,
	0x73, 0x12, 0x25, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xcf, 0x02, 0x0a, 0x07, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26,
	0x0a, 0x0c, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x61, 0x6e,
	0x64, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65, 0x64, 0x67, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x64, 0x67, 0x65, 0x73, 0x12,
	0x31, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x65, 0x64, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x64, 0x67,
	0x65, 0x73, 0x12, 0x56, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x6d,
	0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x22, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x6d, 0x70,
	0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x60, 0x0a, 0x10, 0x43, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x3d,
	0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48,
	0x00, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x0d, 0x0a,
	0x0b, 0x54, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0xf8, 0x01, 0x0a,
	0x17, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x61, 0x76, 0x65, 0x64, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x4b, 0x0a, 0x11, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0x8f, 0x05, 0x0a, 0x18, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x66, 0x0a, 0x0d, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x0c,
	0x6d, 0x61, 0x69, 0x6e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x96, 0x01, 0x0a,
	0x26, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x69, 0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x52, 0x23, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x49, 0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x65,
	0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x66,
	0x75, 0x6c, 0x6c, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x1a, 0xca, 0x02, 0x0a,
	0x11, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x12, 0x54, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x59, 0x0a, 0x10, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x52, 0x0f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x5f, 0x65, 0x78, 0x70,
	0x6c, 0x6f, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x66, 0x75, 0x6c,
	0x6c, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x12, 0x5d, 0x0a, 0x13, 0x6e, 0x6f,
	0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x11, 0x6e, 0x6f, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x69,
	0x63, 0x61, 0x6c, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x22, 0x94, 0x05, 0x0a, 0x1d, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6e, 0x0a, 0x0f, 0x67,
	0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7d, 0x0a, 0x14, 0x62,
	0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x27, 0x0a, 0x0e, 0x47, 0x63,
	0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03,
	0x75, 0x72, 0x69, 0x1a, 0xcb, 0x02, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07, 0x64,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x65, 0x66,
	0x69, 0x78, 0x12, 0x7a, 0x0a, 0x0d, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79, 0x12, 0x30,
	0x0a, 0x11, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x77, 0x72, 0x69, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x3f, 0x0a, 0x0c, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4b, 0x65, 0x79,
	0x12, 0x1d, 0x0a, 0x19, 0x50, 0x41, 0x52, 0x54, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4b, 0x45,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x10, 0x0a, 0x0c, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x54, 0x49, 0x4d, 0x45, 0x10,
	0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x96, 0x02, 0x0a, 0x22, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x59, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0x35, 0x0a, 0x14, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x61, 0x76, 0x65, 0x64, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x5e, 0x0a, 0x0d, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x25, 0x0a, 0x23, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xb2, 0x06, 0x0a, 0x0a, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x49, 0x0a, 0x10, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0e, 0x6c, 0x61, 0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x26, 0x0a, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x6c, 0x61,
	0x73, 0x74, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x72, 0x12, 0x45, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x48, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x1a, 0x8b, 0x01, 0x0a, 0x0c, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x6a, 0x0a, 0x19, 0x69,
	0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x48, 0x00, 0x52,
	0x16, 0x69, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x0f, 0x0a, 0x0d, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x3a, 0xbf, 0x01, 0xea, 0x41, 0xbb, 0x01, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x2d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x2f, 0x7b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x7d, 0x12,
	0x2b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x7d, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b,
	0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x7d, 0x12, 0x37, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x7d, 0x22, 0xd3, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x64,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x29, 0x0a, 0x0e, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x73,
	0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x49, 0x64, 0x22, 0x58, 0x0a, 0x14, 0x47,
	0x65, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc2, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61,
	0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x44, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x12, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x8a, 0x01, 0x0a, 0x18, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x0d, 0x73, 0x61, 0x76, 0x65, 0x64,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x0c, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa4, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x5b,
	0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x26, 0x0a,
	0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x61, 0x76, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xaf, 0x02, 0x0a, 0x12,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4f, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x38, 0x0a, 0x12, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03, 0x0a, 0x01, 0x2a, 0x52, 0x11, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x4a, 0x0a,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4d, 0x6f, 0x76, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x56,
	0x69, 0x65, 0x77, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0x42, 0x0a, 0x0c, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x4e, 0x41,
	0x4c, 0x59, 0x53, 0x49, 0x53, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x02, 0x22, 0x5f, 0x0a,
	0x13, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0d, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x52, 0x0c, 0x6d, 0x6f, 0x76, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x22, 0xb0,
	0x01, 0x0a, 0x0c, 0x4d, 0x6f, 0x76, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x76,
	0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48,
	0x00, 0x52, 0x08, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x2a, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00,
	0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x22, 0x92, 0x01, 0x0a, 0x12, 0x4d, 0x6f, 0x76, 0x65, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x3d, 0x0a, 0x08, 0x62, 0x6c, 0x6f, 0x63,
	0x6b, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52, 0x08, 0x62,
	0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x72, 0x73, 0x12, 0x3d, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x52, 0x08, 0x77, 0x61,
	0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x24, 0x0a, 0x0a, 0x4d, 0x6f, 0x76, 0x65, 0x49, 0x6d,
	0x70, 0x61, 0x63, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x8e, 0x02, 0x0a,
	0x17, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x75, 0x0a, 0x14, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0x7c, 0x0a, 0x13, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65, 0x72, 0x79, 0x44, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x12, 0x2b, 0x0a, 0x11, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x77, 0x72, 0x69,
	0x74, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa5, 0x04,
	0x0a, 0x12, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x12, 0x1f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x0d, 0x6a, 0x6f,
	0x62, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x6a, 0x6f, 0x62, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x38, 0x0a, 0x07,
	0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x74,
	0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x52, 0x0a, 0x10, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e,
	0x64, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0e, 0x72, 0x65, 0x61, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x12, 0x3e, 0x0a, 0x09, 0x72, 0x65,
	0x61, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01,
	0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0d, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x07, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x42, 0x06, 0x0a,
	0x04, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xa6, 0x02, 0x0a, 0x13, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x23, 0x0a,
	0x0d, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6a, 0x6f, 0x62, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x47, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0b,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x55, 0x0a, 0x0d, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xbd,
	0x01, 0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x2b,
	0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x3a, 0x0a, 0x06, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52,
	0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x52, 0x6f, 0x77, 0x73, 0x22, 0x4e,
	0x0a, 0x0b, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x3f, 0x0a,
	0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x22, 0x91,
	0x01, 0x0a, 0x10, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6d, 0x6f, 0x64,
	0x65, 0x12, 0x3f, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x73, 0x22, 0x67, 0x0a, 0x23, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x45, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x03,
	0x12, 0x01, 0x2a, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x05, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x09, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x03, 0x0a, 0x01, 0x2a, 0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0xc3, 0x03, 0x0a, 0x24,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x75, 0x0a, 0x0e, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0d, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0xa3, 0x02, 0x0a, 0x12,
	0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10,
	0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x75, 0x0a, 0x08, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x1a, 0x68, 0x0a, 0x0a, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x2d, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x22, 0xa1, 0x05, 0x0a, 0x11, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x10, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x43, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f,
	0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x75, 0x6c, 0x65, 0x52, 0x05, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x69, 0x6e, 0x68, 0x65, 0x72, 0x69, 0x74, 0x5f,
	0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x11, 0x69, 0x6e, 0x68, 0x65, 0x72, 0x69, 0x74, 0x46, 0x72, 0x6f, 0x6d, 0x50, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x65, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x05, 0x72, 0x65, 0x73, 0x65, 0x74, 0x1a, 0xa8, 0x03, 0x0a, 0x04, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x54, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x52, 0x75,
	0x6c, 0x65, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x48,
	0x00, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x09, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x5f, 0x61, 0x6c, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x08,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x41, 0x6c, 0x6c, 0x12, 0x1b, 0x0a, 0x08, 0x64, 0x65, 0x6e, 0x79,
	0x5f, 0x61, 0x6c, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x64, 0x65,
	0x6e, 0x79, 0x41, 0x6c, 0x6c, 0x12, 0x1a, 0x0a, 0x07, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x07, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x12, 0x2f, 0x0a, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x2e, 0x45, 0x78, 0x70, 0x72, 0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x1a, 0x5a, 0x0a, 0x0c, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x65, 0x6e, 0x69,
	0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0c, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x06, 0x0a,
	0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0x81, 0x0c, 0x0a, 0x1b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x7b, 0x0a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f,
	0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x12, 0x72, 0x0a, 0x11, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x48, 0x00, 0x52, 0x10, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x1a, 0xb1, 0x05, 0x0a, 0x0a, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7e,
	0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x52, 0x11, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x77,
	0x0a, 0x0f, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x6c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x80, 0x01, 0x0a, 0x12, 0x62, 0x6f, 0x6f, 0x6c,
	0x65, 0x61, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x11, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e,
	0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x1a, 0x58, 0x0a, 0x0e, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x69, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0a, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x49, 0x6e, 0x12, 0x25, 0x0a,
	0x0e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x5f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x55,
	0x6e, 0x64, 0x65, 0x72, 0x1a, 0x13, 0x0a, 0x11, 0x42, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x22, 0x4c, 0x0a, 0x11, 0x43, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x22,
	0x0a, 0x1e, 0x43, 0x4f, 0x4e, 0x53, 0x54, 0x52, 0x41, 0x49, 0x4e, 0x54, 0x5f, 0x44, 0x45, 0x46,
	0x41, 0x55, 0x4c, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x08, 0x0a,
	0x04, 0x44, 0x45, 0x4e, 0x59, 0x10, 0x02, 0x42, 0x11, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a, 0xa3, 0x04, 0x0a, 0x10, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x71, 0x0a, 0x0c, 0x6d, 0x65,
	0x74, 0x68, 0x6f, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0e,
	0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0b, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x73, 0x12, 0x1c, 0x0a,
	0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6f, 0x0a, 0x0b, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x43, 0x6f, 0x6e, 0x73, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x0a, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x4d, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1b, 0x0a, 0x17, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41,
	0x54, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03,
	0x22, 0x3e, 0x0a, 0x0a, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b,
	0x0a, 0x17, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x41,
	0x4c, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x44, 0x45, 0x4e, 0x59, 0x10, 0x02,
	0x42, 0x17, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x5f, 0x64,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc2, 0x01, 0x0a, 0x19, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x70, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x00, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x22, 0x9f,
	0x04, 0x0a, 0x1a, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6f, 0x0a,
	0x12, 0x6f, 0x72, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4f, 0x72, 0x67,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x10, 0x6f, 0x72,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x52,
	0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0x93, 0x02, 0x0a, 0x0f, 0x4f,
	0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x59,
	0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4d, 0x0a, 0x0d, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0c, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x22, 0x0a, 0x0c,
	0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xd2, 0x01, 0x0a, 0x29, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x19,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x22, 0xe0, 0x05, 0x0a, 0x2a, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e,
	0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x84, 0x01, 0x0a, 0x13, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65, 0x72,
	0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x52, 0x12, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x63,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72,
	0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x74, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0xae, 0x03, 0x0a, 0x11, 0x47, 0x6f, 0x76, 0x65,
	0x72, 0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x12, 0x2c, 0x0a,
	0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x73,
	0x6f, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x4d,
	0x0a, 0x0d, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x0c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65, 0x12, 0x18, 0x0a,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0e, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54,
	0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0d, 0x65, 0x66, 0x66, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x54, 0x61, 0x67, 0x73, 0x22, 0xce, 0x01, 0x0a, 0x25, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76,
	0x65, 0x72, 0x6e, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x23, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x22, 0xf9, 0x09, 0x0a, 0x26, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f,
	0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x74, 0x0a, 0x0f, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64,
	0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x47, 0x6f, 0x76,
	0x65, 0x72, 0x6e, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x0e, 0x67, 0x6f, 0x76, 0x65,
	0x72, 0x6e, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x52, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f,
	0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x74, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x1a, 0xa2, 0x02, 0x0a, 0x10, 0x47, 0x6f, 0x76, 0x65, 0x72,
	0x6e, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x66,
	0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x65, 0x66, 0x66, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x54, 0x61, 0x67, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0d, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x54, 0x61, 0x67, 0x73, 0x1a, 0xe6, 0x01, 0x0a, 0x11,
	0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x2b, 0x0a, 0x11, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x61, 0x74,
	0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2d,
	0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x18, 0x0a,
	0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72,
	0x73, 0x12, 0x22, 0x0a, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x54, 0x79, 0x70, 0x65, 0x1a, 0xce, 0x03, 0x0a, 0x0d, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65,
	0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x12, 0x7d, 0x0a, 0x11, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e,
	0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e,
	0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x10, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x81, 0x01, 0x0a, 0x13, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e,
	0x65, 0x64, 0x5f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65,
	0x72, 0x6e, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x48, 0x00, 0x52, 0x11, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x59, 0x0a, 0x13, 0x63, 0x6f, 0x6e,
	0x73, 0x6f, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x12, 0x63, 0x6f, 0x6e, 0x73, 0x6f, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x64, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x12, 0x4d, 0x0a, 0x0d, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62,
	0x75, 0x6e, 0x64, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x72, 0x4f, 0x72, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x75, 0x6e,
	0x64, 0x6c, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x5f,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2a, 0x90, 0x01, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x10,
	0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x41, 0x4d, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10,
	0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x4f, 0x52, 0x47, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x10,
	0x04, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f, 0x50, 0x4f, 0x4c, 0x49,
	0x43, 0x59, 0x10, 0x05, 0x12, 0x10, 0x0a, 0x0c, 0x4f, 0x53, 0x5f, 0x49, 0x4e, 0x56, 0x45, 0x4e,
	0x54, 0x4f, 0x52, 0x59, 0x10, 0x06, 0x12, 0x10, 0x0a, 0x0c, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x53, 0x48, 0x49, 0x50, 0x10, 0x07, 0x32, 0xd1, 0x20, 0x0a, 0x0c, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xde, 0x01, 0x0a, 0x0c, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x82, 0x01, 0xca, 0x41, 0x57, 0x0a, 0x2a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x3a, 0x01, 0x2a, 0x22, 0x1d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x8b, 0x01, 0x0a, 0x0a, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x28,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x19, 0x12,
	0x17, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a,
	0x7d, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0xb2, 0x01, 0x0a, 0x15, 0x42, 0x61, 0x74,
	0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69,
	0x73, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2e, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x28, 0x12, 0x26, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x62, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x7f, 0x0a,
	0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x12, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65,
	0x65, 0x64, 0x22, 0x2a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x1b, 0x3a, 0x01, 0x2a, 0x22, 0x16, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x12, 0x74,
	0x0a, 0x07, 0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x65, 0x64, 0x22, 0x25, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x12, 0x16, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x65, 0x64,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x87, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65,
	0x64, 0x73, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46,
	0x65, 0x65, 0x64, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x65, 0x65, 0x64, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x27, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x12, 0x16, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x12, 0x82,
	0x01, 0x0a, 0x0a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64, 0x12, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x46, 0x65, 0x65, 0x64,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x46, 0x65, 0x65, 0x64, 0x22, 0x2d, 0xda, 0x41, 0x04, 0x66, 0x65, 0x65, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x20, 0x3a, 0x01, 0x2a, 0x32, 0x1b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x66, 0x65, 0x65,
	0x64, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x75, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x46, 0x65, 0x65,
	0x64, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x46, 0x65, 0x65, 0x64, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x22, 0x25, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x18, 0x2a, 0x16, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f,
	0x2a, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbf, 0x01, 0x0a, 0x12, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0xda, 0x41, 0x17, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c, 0x61, 0x73, 0x73, 0x65, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x41, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0xbb, 0x01, 0x0a,
	0x14, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3a,
	0xda, 0x41, 0x0b, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x26, 0x12, 0x24, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x63, 0x6f, 0x70, 0x65,
	0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x41, 0x6c, 0x6c, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0xac, 0x01, 0x0a, 0x10, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xb8, 0x02, 0x0a, 0x1b, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x4c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xbe, 0x01, 0xca, 0x41, 0x76, 0x0a, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x4c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x39, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3f, 0x3a, 0x01, 0x2a, 0x22, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x12, 0x8c, 0x01, 0x0a, 0x0b, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x4d, 0x6f, 0x76, 0x65, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x4d, 0x6f, 0x76, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4d,
	0x6f, 0x76, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x26, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x20, 0x12, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4d,
	0x6f, 0x76, 0x65, 0x12, 0x8d, 0x01, 0x0a, 0x0b, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x27, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x21, 0x3a, 0x01, 0x2a, 0x22, 0x1c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x12, 0xbd, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x61,
	0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0x56, 0xda, 0x41, 0x21,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2c, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x69,
	0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x22, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x8d, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x22, 0x2c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x1f, 0x12, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xa3, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65,
	0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x2e, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x12, 0x1d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x61, 0x76,
	0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0xbf, 0x01, 0x0a, 0x10, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x61, 0x76,
	0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x22, 0x58, 0xda, 0x41, 0x17, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x38, 0x3a, 0x0b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x32, 0x29, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x76, 0x65,
	0x64, 0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x88, 0x01, 0x0a, 0x10,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1f, 0x2a, 0x1d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x2f, 0x73, 0x61, 0x76, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xce, 0x01, 0x0a, 0x1c, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x42, 0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x47, 0x65, 0x74, 0x45, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x3a, 0x62,
	0x61, 0x74, 0x63, 0x68, 0x47, 0x65, 0x74, 0x12, 0xbf, 0x01, 0x0a, 0x12, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x44, 0xda, 0x41, 0x17, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x2c, 0x63, 0x6f,
	0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x24, 0x12, 0x22, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x63, 0x6f, 0x70,
	0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0xff, 0x01, 0x0a, 0x22, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f,
	0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65, 0x72,
	0x6e, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x54, 0xda, 0x41, 0x17, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x2c,
	0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x73, 0x12, 0xef, 0x01, 0x0a, 0x1e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72,
	0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x41, 0x73, 0x73,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0xda, 0x41, 0x17,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x2c, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x2c, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x4f, 0x72, 0x67, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x47,
	0x6f, 0x76, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x1a, 0x4d, 0xca,
	0x41, 0x19, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x91, 0x01, 0x0a,
	0x19, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x11, 0x41, 0x73, 0x73, 0x65,
	0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x70, 0x62, 0x3b, 0x61, 0x73, 0x73, 0x65, 0x74, 0x70, 0x62,
	0xaa, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x15, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x73, 0x73, 0x65, 0x74, 0x5c, 0x56, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_asset_v1_asset_service_proto_rawDescOnce sync.Once
	file_google_cloud_asset_v1_asset_service_proto_rawDescData = file_google_cloud_asset_v1_asset_service_proto_rawDesc
)

func file_google_cloud_asset_v1_asset_service_proto_rawDescGZIP() []byte {
	file_google_cloud_asset_v1_asset_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_asset_v1_asset_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_asset_v1_asset_service_proto_rawDescData)
	})
	return file_google_cloud_asset_v1_asset_service_proto_rawDescData
}

var file_google_cloud_asset_v1_asset_service_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_google_cloud_asset_v1_asset_service_proto_msgTypes = make([]protoimpl.MessageInfo, 84)
var file_google_cloud_asset_v1_asset_service_proto_goTypes = []any{
	(ContentType)(0),                // 0: google.cloud.asset.v1.ContentType
	(PartitionSpec_PartitionKey)(0), // 1: google.cloud.asset.v1.PartitionSpec.PartitionKey
	(IamPolicyAnalysisOutputConfig_BigQueryDestination_PartitionKey)(0),        // 2: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.BigQueryDestination.PartitionKey
	(AnalyzeMoveRequest_AnalysisView)(0),                                       // 3: google.cloud.asset.v1.AnalyzeMoveRequest.AnalysisView
	(AnalyzerOrgPolicyConstraint_Constraint_ConstraintDefault)(0),              // 4: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint.ConstraintDefault
	(AnalyzerOrgPolicyConstraint_CustomConstraint_MethodType)(0),               // 5: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.CustomConstraint.MethodType
	(AnalyzerOrgPolicyConstraint_CustomConstraint_ActionType)(0),               // 6: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.CustomConstraint.ActionType
	(*AnalyzeIamPolicyLongrunningMetadata)(nil),                                // 7: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningMetadata
	(*ExportAssetsRequest)(nil),                                                // 8: google.cloud.asset.v1.ExportAssetsRequest
	(*ExportAssetsResponse)(nil),                                               // 9: google.cloud.asset.v1.ExportAssetsResponse
	(*ListAssetsRequest)(nil),                                                  // 10: google.cloud.asset.v1.ListAssetsRequest
	(*ListAssetsResponse)(nil),                                                 // 11: google.cloud.asset.v1.ListAssetsResponse
	(*BatchGetAssetsHistoryRequest)(nil),                                       // 12: google.cloud.asset.v1.BatchGetAssetsHistoryRequest
	(*BatchGetAssetsHistoryResponse)(nil),                                      // 13: google.cloud.asset.v1.BatchGetAssetsHistoryResponse
	(*CreateFeedRequest)(nil),                                                  // 14: google.cloud.asset.v1.CreateFeedRequest
	(*GetFeedRequest)(nil),                                                     // 15: google.cloud.asset.v1.GetFeedRequest
	(*ListFeedsRequest)(nil),                                                   // 16: google.cloud.asset.v1.ListFeedsRequest
	(*ListFeedsResponse)(nil),                                                  // 17: google.cloud.asset.v1.ListFeedsResponse
	(*UpdateFeedRequest)(nil),                                                  // 18: google.cloud.asset.v1.UpdateFeedRequest
	(*DeleteFeedRequest)(nil),                                                  // 19: google.cloud.asset.v1.DeleteFeedRequest
	(*OutputConfig)(nil),                                                       // 20: google.cloud.asset.v1.OutputConfig
	(*OutputResult)(nil),                                                       // 21: google.cloud.asset.v1.OutputResult
	(*GcsOutputResult)(nil),                                                    // 22: google.cloud.asset.v1.GcsOutputResult
	(*GcsDestination)(nil),                                                     // 23: google.cloud.asset.v1.GcsDestination
	(*BigQueryDestination)(nil),                                                // 24: google.cloud.asset.v1.BigQueryDestination
	(*PartitionSpec)(nil),                                                      // 25: google.cloud.asset.v1.PartitionSpec
	(*PubsubDestination)(nil),                                                  // 26: google.cloud.asset.v1.PubsubDestination
	(*FeedOutputConfig)(nil),                                                   // 27: google.cloud.asset.v1.FeedOutputConfig
	(*Feed)(nil),                                                               // 28: google.cloud.asset.v1.Feed
	(*SearchAllResourcesRequest)(nil),                                          // 29: google.cloud.asset.v1.SearchAllResourcesRequest
	(*SearchAllResourcesResponse)(nil),                                         // 30: google.cloud.asset.v1.SearchAllResourcesResponse
	(*SearchAllIamPoliciesRequest)(nil),                                        // 31: google.cloud.asset.v1.SearchAllIamPoliciesRequest
	(*SearchAllIamPoliciesResponse)(nil),                                       // 32: google.cloud.asset.v1.SearchAllIamPoliciesResponse
	(*IamPolicyAnalysisQuery)(nil),                                             // 33: google.cloud.asset.v1.IamPolicyAnalysisQuery
	(*AnalyzeIamPolicyRequest)(nil),                                            // 34: google.cloud.asset.v1.AnalyzeIamPolicyRequest
	(*AnalyzeIamPolicyResponse)(nil),                                           // 35: google.cloud.asset.v1.AnalyzeIamPolicyResponse
	(*IamPolicyAnalysisOutputConfig)(nil),                                      // 36: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig
	(*AnalyzeIamPolicyLongrunningRequest)(nil),                                 // 37: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest
	(*AnalyzeIamPolicyLongrunningResponse)(nil),                                // 38: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningResponse
	(*SavedQuery)(nil),                                                         // 39: google.cloud.asset.v1.SavedQuery
	(*CreateSavedQueryRequest)(nil),                                            // 40: google.cloud.asset.v1.CreateSavedQueryRequest
	(*GetSavedQueryRequest)(nil),                                               // 41: google.cloud.asset.v1.GetSavedQueryRequest
	(*ListSavedQueriesRequest)(nil),                                            // 42: google.cloud.asset.v1.ListSavedQueriesRequest
	(*ListSavedQueriesResponse)(nil),                                           // 43: google.cloud.asset.v1.ListSavedQueriesResponse
	(*UpdateSavedQueryRequest)(nil),                                            // 44: google.cloud.asset.v1.UpdateSavedQueryRequest
	(*DeleteSavedQueryRequest)(nil),                                            // 45: google.cloud.asset.v1.DeleteSavedQueryRequest
	(*AnalyzeMoveRequest)(nil),                                                 // 46: google.cloud.asset.v1.AnalyzeMoveRequest
	(*AnalyzeMoveResponse)(nil),                                                // 47: google.cloud.asset.v1.AnalyzeMoveResponse
	(*MoveAnalysis)(nil),                                                       // 48: google.cloud.asset.v1.MoveAnalysis
	(*MoveAnalysisResult)(nil),                                                 // 49: google.cloud.asset.v1.MoveAnalysisResult
	(*MoveImpact)(nil),                                                         // 50: google.cloud.asset.v1.MoveImpact
	(*QueryAssetsOutputConfig)(nil),                                            // 51: google.cloud.asset.v1.QueryAssetsOutputConfig
	(*QueryAssetsRequest)(nil),                                                 // 52: google.cloud.asset.v1.QueryAssetsRequest
	(*QueryAssetsResponse)(nil),                                                // 53: google.cloud.asset.v1.QueryAssetsResponse
	(*QueryResult)(nil),                                                        // 54: google.cloud.asset.v1.QueryResult
	(*TableSchema)(nil),                                                        // 55: google.cloud.asset.v1.TableSchema
	(*TableFieldSchema)(nil),                                                   // 56: google.cloud.asset.v1.TableFieldSchema
	(*BatchGetEffectiveIamPoliciesRequest)(nil),                                // 57: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest
	(*BatchGetEffectiveIamPoliciesResponse)(nil),                               // 58: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse
	(*AnalyzerOrgPolicy)(nil),                                                  // 59: google.cloud.asset.v1.AnalyzerOrgPolicy
	(*AnalyzerOrgPolicyConstraint)(nil),                                        // 60: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint
	(*AnalyzeOrgPoliciesRequest)(nil),                                          // 61: google.cloud.asset.v1.AnalyzeOrgPoliciesRequest
	(*AnalyzeOrgPoliciesResponse)(nil),                                         // 62: google.cloud.asset.v1.AnalyzeOrgPoliciesResponse
	(*AnalyzeOrgPolicyGovernedContainersRequest)(nil),                          // 63: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersRequest
	(*AnalyzeOrgPolicyGovernedContainersResponse)(nil),                         // 64: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse
	(*AnalyzeOrgPolicyGovernedAssetsRequest)(nil),                              // 65: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest
	(*AnalyzeOrgPolicyGovernedAssetsResponse)(nil),                             // 66: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse
	(*IamPolicyAnalysisQuery_ResourceSelector)(nil),                            // 67: google.cloud.asset.v1.IamPolicyAnalysisQuery.ResourceSelector
	(*IamPolicyAnalysisQuery_IdentitySelector)(nil),                            // 68: google.cloud.asset.v1.IamPolicyAnalysisQuery.IdentitySelector
	(*IamPolicyAnalysisQuery_AccessSelector)(nil),                              // 69: google.cloud.asset.v1.IamPolicyAnalysisQuery.AccessSelector
	(*IamPolicyAnalysisQuery_Options)(nil),                                     // 70: google.cloud.asset.v1.IamPolicyAnalysisQuery.Options
	(*IamPolicyAnalysisQuery_ConditionContext)(nil),                            // 71: google.cloud.asset.v1.IamPolicyAnalysisQuery.ConditionContext
	(*AnalyzeIamPolicyResponse_IamPolicyAnalysis)(nil),                         // 72: google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis
	(*IamPolicyAnalysisOutputConfig_GcsDestination)(nil),                       // 73: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.GcsDestination
	(*IamPolicyAnalysisOutputConfig_BigQueryDestination)(nil),                  // 74: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.BigQueryDestination
	(*SavedQuery_QueryContent)(nil),                                            // 75: google.cloud.asset.v1.SavedQuery.QueryContent
	nil,                                                                        // 76: google.cloud.asset.v1.SavedQuery.LabelsEntry
	(*QueryAssetsOutputConfig_BigQueryDestination)(nil),                        // 77: google.cloud.asset.v1.QueryAssetsOutputConfig.BigQueryDestination
	(*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy)(nil),            // 78: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy
	(*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo)(nil), // 79: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo
	(*AnalyzerOrgPolicy_Rule)(nil),                                             // 80: google.cloud.asset.v1.AnalyzerOrgPolicy.Rule
	(*AnalyzerOrgPolicy_Rule_StringValues)(nil),                                // 81: google.cloud.asset.v1.AnalyzerOrgPolicy.Rule.StringValues
	(*AnalyzerOrgPolicyConstraint_Constraint)(nil),                             // 82: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint
	(*AnalyzerOrgPolicyConstraint_CustomConstraint)(nil),                       // 83: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.CustomConstraint
	(*AnalyzerOrgPolicyConstraint_Constraint_ListConstraint)(nil),              // 84: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint.ListConstraint
	(*AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint)(nil),           // 85: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint.BooleanConstraint
	(*AnalyzeOrgPoliciesResponse_OrgPolicyResult)(nil),                         // 86: google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.OrgPolicyResult
	(*AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer)(nil),       // 87: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer
	(*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource)(nil),            // 88: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedResource
	(*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy)(nil),           // 89: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedIamPolicy
	(*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset)(nil),               // 90: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset
	(*timestamppb.Timestamp)(nil),                                              // 91: google.protobuf.Timestamp
	(*Asset)(nil),                                                              // 92: google.cloud.asset.v1.Asset
	(*TimeWindow)(nil),                                                         // 93: google.cloud.asset.v1.TimeWindow
	(*TemporalAsset)(nil),                                                      // 94: google.cloud.asset.v1.TemporalAsset
	(*fieldmaskpb.FieldMask)(nil),                                              // 95: google.protobuf.FieldMask
	(*expr.Expr)(nil),                                                          // 96: google.type.Expr
	(*ResourceSearchResult)(nil),                                               // 97: google.cloud.asset.v1.ResourceSearchResult
	(*IamPolicySearchResult)(nil),                                              // 98: google.cloud.asset.v1.IamPolicySearchResult
	(*durationpb.Duration)(nil),                                                // 99: google.protobuf.Duration
	(*status.Status)(nil),                                                      // 100: google.rpc.Status
	(*structpb.Struct)(nil),                                                    // 101: google.protobuf.Struct
	(*IamPolicyAnalysisResult)(nil),                                            // 102: google.cloud.asset.v1.IamPolicyAnalysisResult
	(*IamPolicyAnalysisState)(nil),                                             // 103: google.cloud.asset.v1.IamPolicyAnalysisState
	(*iampb.Policy)(nil),                                                       // 104: google.iam.v1.Policy
	(*ConditionEvaluation)(nil),                                                // 105: google.cloud.asset.v1.ConditionEvaluation
	(*EffectiveTagDetails)(nil),                                                // 106: google.cloud.asset.v1.EffectiveTagDetails
	(*longrunningpb.Operation)(nil),                                            // 107: google.longrunning.Operation
	(*emptypb.Empty)(nil),                                                      // 108: google.protobuf.Empty
}
var file_google_cloud_asset_v1_asset_service_proto_depIdxs = []int32{
	91,  // 0: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningMetadata.create_time:type_name -> google.protobuf.Timestamp
	91,  // 1: google.cloud.asset.v1.ExportAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	0,   // 2: google.cloud.asset.v1.ExportAssetsRequest.content_type:type_name -> google.cloud.asset.v1.ContentType
	20,  // 3: google.cloud.asset.v1.ExportAssetsRequest.output_config:type_name -> google.cloud.asset.v1.OutputConfig
	91,  // 4: google.cloud.asset.v1.ExportAssetsResponse.read_time:type_name -> google.protobuf.Timestamp
	20,  // 5: google.cloud.asset.v1.ExportAssetsResponse.output_config:type_name -> google.cloud.asset.v1.OutputConfig
	21,  // 6: google.cloud.asset.v1.ExportAssetsResponse.output_result:type_name -> google.cloud.asset.v1.OutputResult
	91,  // 7: google.cloud.asset.v1.ListAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	0,   // 8: google.cloud.asset.v1.ListAssetsRequest.content_type:type_name -> google.cloud.asset.v1.ContentType
	91,  // 9: google.cloud.asset.v1.ListAssetsResponse.read_time:type_name -> google.protobuf.Timestamp
	92,  // 10: google.cloud.asset.v1.ListAssetsResponse.assets:type_name -> google.cloud.asset.v1.Asset
	0,   // 11: google.cloud.asset.v1.BatchGetAssetsHistoryRequest.content_type:type_name -> google.cloud.asset.v1.ContentType
	93,  // 12: google.cloud.asset.v1.BatchGetAssetsHistoryRequest.read_time_window:type_name -> google.cloud.asset.v1.TimeWindow
	94,  // 13: google.cloud.asset.v1.BatchGetAssetsHistoryResponse.assets:type_name -> google.cloud.asset.v1.TemporalAsset
	28,  // 14: google.cloud.asset.v1.CreateFeedRequest.feed:type_name -> google.cloud.asset.v1.Feed
	28,  // 15: google.cloud.asset.v1.ListFeedsResponse.feeds:type_name -> google.cloud.asset.v1.Feed
	28,  // 16: google.cloud.asset.v1.UpdateFeedRequest.feed:type_name -> google.cloud.asset.v1.Feed
	95,  // 17: google.cloud.asset.v1.UpdateFeedRequest.update_mask:type_name -> google.protobuf.FieldMask
	23,  // 18: google.cloud.asset.v1.OutputConfig.gcs_destination:type_name -> google.cloud.asset.v1.GcsDestination
	24,  // 19: google.cloud.asset.v1.OutputConfig.bigquery_destination:type_name -> google.cloud.asset.v1.BigQueryDestination
	22,  // 20: google.cloud.asset.v1.OutputResult.gcs_result:type_name -> google.cloud.asset.v1.GcsOutputResult
	25,  // 21: google.cloud.asset.v1.BigQueryDestination.partition_spec:type_name -> google.cloud.asset.v1.PartitionSpec
	1,   // 22: google.cloud.asset.v1.PartitionSpec.partition_key:type_name -> google.cloud.asset.v1.PartitionSpec.PartitionKey
	26,  // 23: google.cloud.asset.v1.FeedOutputConfig.pubsub_destination:type_name -> google.cloud.asset.v1.PubsubDestination
	0,   // 24: google.cloud.asset.v1.Feed.content_type:type_name -> google.cloud.asset.v1.ContentType
	27,  // 25: google.cloud.asset.v1.Feed.feed_output_config:type_name -> google.cloud.asset.v1.FeedOutputConfig
	96,  // 26: google.cloud.asset.v1.Feed.condition:type_name -> google.type.Expr
	95,  // 27: google.cloud.asset.v1.SearchAllResourcesRequest.read_mask:type_name -> google.protobuf.FieldMask
	97,  // 28: google.cloud.asset.v1.SearchAllResourcesResponse.results:type_name -> google.cloud.asset.v1.ResourceSearchResult
	98,  // 29: google.cloud.asset.v1.SearchAllIamPoliciesResponse.results:type_name -> google.cloud.asset.v1.IamPolicySearchResult
	67,  // 30: google.cloud.asset.v1.IamPolicyAnalysisQuery.resource_selector:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery.ResourceSelector
	68,  // 31: google.cloud.asset.v1.IamPolicyAnalysisQuery.identity_selector:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery.IdentitySelector
	69,  // 32: google.cloud.asset.v1.IamPolicyAnalysisQuery.access_selector:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery.AccessSelector
	70,  // 33: google.cloud.asset.v1.IamPolicyAnalysisQuery.options:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery.Options
	71,  // 34: google.cloud.asset.v1.IamPolicyAnalysisQuery.condition_context:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery.ConditionContext
	33,  // 35: google.cloud.asset.v1.AnalyzeIamPolicyRequest.analysis_query:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery
	99,  // 36: google.cloud.asset.v1.AnalyzeIamPolicyRequest.execution_timeout:type_name -> google.protobuf.Duration
	72,  // 37: google.cloud.asset.v1.AnalyzeIamPolicyResponse.main_analysis:type_name -> google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis
	72,  // 38: google.cloud.asset.v1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis:type_name -> google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis
	73,  // 39: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.gcs_destination:type_name -> google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.GcsDestination
	74,  // 40: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.bigquery_destination:type_name -> google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.BigQueryDestination
	33,  // 41: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest.analysis_query:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery
	36,  // 42: google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest.output_config:type_name -> google.cloud.asset.v1.IamPolicyAnalysisOutputConfig
	91,  // 43: google.cloud.asset.v1.SavedQuery.create_time:type_name -> google.protobuf.Timestamp
	91,  // 44: google.cloud.asset.v1.SavedQuery.last_update_time:type_name -> google.protobuf.Timestamp
	76,  // 45: google.cloud.asset.v1.SavedQuery.labels:type_name -> google.cloud.asset.v1.SavedQuery.LabelsEntry
	75,  // 46: google.cloud.asset.v1.SavedQuery.content:type_name -> google.cloud.asset.v1.SavedQuery.QueryContent
	39,  // 47: google.cloud.asset.v1.CreateSavedQueryRequest.saved_query:type_name -> google.cloud.asset.v1.SavedQuery
	39,  // 48: google.cloud.asset.v1.ListSavedQueriesResponse.saved_queries:type_name -> google.cloud.asset.v1.SavedQuery
	39,  // 49: google.cloud.asset.v1.UpdateSavedQueryRequest.saved_query:type_name -> google.cloud.asset.v1.SavedQuery
	95,  // 50: google.cloud.asset.v1.UpdateSavedQueryRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,   // 51: google.cloud.asset.v1.AnalyzeMoveRequest.view:type_name -> google.cloud.asset.v1.AnalyzeMoveRequest.AnalysisView
	48,  // 52: google.cloud.asset.v1.AnalyzeMoveResponse.move_analysis:type_name -> google.cloud.asset.v1.MoveAnalysis
	49,  // 53: google.cloud.asset.v1.MoveAnalysis.analysis:type_name -> google.cloud.asset.v1.MoveAnalysisResult
	100, // 54: google.cloud.asset.v1.MoveAnalysis.error:type_name -> google.rpc.Status
	50,  // 55: google.cloud.asset.v1.MoveAnalysisResult.blockers:type_name -> google.cloud.asset.v1.MoveImpact
	50,  // 56: google.cloud.asset.v1.MoveAnalysisResult.warnings:type_name -> google.cloud.asset.v1.MoveImpact
	77,  // 57: google.cloud.asset.v1.QueryAssetsOutputConfig.bigquery_destination:type_name -> google.cloud.asset.v1.QueryAssetsOutputConfig.BigQueryDestination
	99,  // 58: google.cloud.asset.v1.QueryAssetsRequest.timeout:type_name -> google.protobuf.Duration
	93,  // 59: google.cloud.asset.v1.QueryAssetsRequest.read_time_window:type_name -> google.cloud.asset.v1.TimeWindow
	91,  // 60: google.cloud.asset.v1.QueryAssetsRequest.read_time:type_name -> google.protobuf.Timestamp
	51,  // 61: google.cloud.asset.v1.QueryAssetsRequest.output_config:type_name -> google.cloud.asset.v1.QueryAssetsOutputConfig
	100, // 62: google.cloud.asset.v1.QueryAssetsResponse.error:type_name -> google.rpc.Status
	54,  // 63: google.cloud.asset.v1.QueryAssetsResponse.query_result:type_name -> google.cloud.asset.v1.QueryResult
	51,  // 64: google.cloud.asset.v1.QueryAssetsResponse.output_config:type_name -> google.cloud.asset.v1.QueryAssetsOutputConfig
	101, // 65: google.cloud.asset.v1.QueryResult.rows:type_name -> google.protobuf.Struct
	55,  // 66: google.cloud.asset.v1.QueryResult.schema:type_name -> google.cloud.asset.v1.TableSchema
	56,  // 67: google.cloud.asset.v1.TableSchema.fields:type_name -> google.cloud.asset.v1.TableFieldSchema
	56,  // 68: google.cloud.asset.v1.TableFieldSchema.fields:type_name -> google.cloud.asset.v1.TableFieldSchema
	78,  // 69: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.policy_results:type_name -> google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy
	80,  // 70: google.cloud.asset.v1.AnalyzerOrgPolicy.rules:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicy.Rule
	82,  // 71: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.google_defined_constraint:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint
	83,  // 72: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.custom_constraint:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.CustomConstraint
	86,  // 73: google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.org_policy_results:type_name -> google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.OrgPolicyResult
	60,  // 74: google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.constraint:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicyConstraint
	87,  // 75: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.governed_containers:type_name -> google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer
	60,  // 76: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.constraint:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicyConstraint
	90,  // 77: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.governed_assets:type_name -> google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset
	60,  // 78: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.constraint:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicyConstraint
	91,  // 79: google.cloud.asset.v1.IamPolicyAnalysisQuery.ConditionContext.access_time:type_name -> google.protobuf.Timestamp
	33,  // 80: google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_query:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery
	102, // 81: google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_results:type_name -> google.cloud.asset.v1.IamPolicyAnalysisResult
	103, // 82: google.cloud.asset.v1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.non_critical_errors:type_name -> google.cloud.asset.v1.IamPolicyAnalysisState
	2,   // 83: google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.BigQueryDestination.partition_key:type_name -> google.cloud.asset.v1.IamPolicyAnalysisOutputConfig.BigQueryDestination.PartitionKey
	33,  // 84: google.cloud.asset.v1.SavedQuery.QueryContent.iam_policy_analysis_query:type_name -> google.cloud.asset.v1.IamPolicyAnalysisQuery
	79,  // 85: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.policies:type_name -> google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo
	104, // 86: google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse.EffectiveIamPolicy.PolicyInfo.policy:type_name -> google.iam.v1.Policy
	81,  // 87: google.cloud.asset.v1.AnalyzerOrgPolicy.Rule.values:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicy.Rule.StringValues
	96,  // 88: google.cloud.asset.v1.AnalyzerOrgPolicy.Rule.condition:type_name -> google.type.Expr
	105, // 89: google.cloud.asset.v1.AnalyzerOrgPolicy.Rule.condition_evaluation:type_name -> google.cloud.asset.v1.ConditionEvaluation
	4,   // 90: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint.constraint_default:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint.ConstraintDefault
	84,  // 91: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint.list_constraint:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint.ListConstraint
	85,  // 92: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint.boolean_constraint:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.Constraint.BooleanConstraint
	5,   // 93: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.CustomConstraint.method_types:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.CustomConstraint.MethodType
	6,   // 94: google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.CustomConstraint.action_type:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicyConstraint.CustomConstraint.ActionType
	59,  // 95: google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.OrgPolicyResult.consolidated_policy:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicy
	59,  // 96: google.cloud.asset.v1.AnalyzeOrgPoliciesResponse.OrgPolicyResult.policy_bundle:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicy
	59,  // 97: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.consolidated_policy:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicy
	59,  // 98: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.policy_bundle:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicy
	106, // 99: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse.GovernedContainer.effective_tags:type_name -> google.cloud.asset.v1.EffectiveTagDetails
	106, // 100: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedResource.effective_tags:type_name -> google.cloud.asset.v1.EffectiveTagDetails
	104, // 101: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedIamPolicy.policy:type_name -> google.iam.v1.Policy
	88,  // 102: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.governed_resource:type_name -> google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedResource
	89,  // 103: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.governed_iam_policy:type_name -> google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedIamPolicy
	59,  // 104: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.consolidated_policy:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicy
	59,  // 105: google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse.GovernedAsset.policy_bundle:type_name -> google.cloud.asset.v1.AnalyzerOrgPolicy
	8,   // 106: google.cloud.asset.v1.AssetService.ExportAssets:input_type -> google.cloud.asset.v1.ExportAssetsRequest
	10,  // 107: google.cloud.asset.v1.AssetService.ListAssets:input_type -> google.cloud.asset.v1.ListAssetsRequest
	12,  // 108: google.cloud.asset.v1.AssetService.BatchGetAssetsHistory:input_type -> google.cloud.asset.v1.BatchGetAssetsHistoryRequest
	14,  // 109: google.cloud.asset.v1.AssetService.CreateFeed:input_type -> google.cloud.asset.v1.CreateFeedRequest
	15,  // 110: google.cloud.asset.v1.AssetService.GetFeed:input_type -> google.cloud.asset.v1.GetFeedRequest
	16,  // 111: google.cloud.asset.v1.AssetService.ListFeeds:input_type -> google.cloud.asset.v1.ListFeedsRequest
	18,  // 112: google.cloud.asset.v1.AssetService.UpdateFeed:input_type -> google.cloud.asset.v1.UpdateFeedRequest
	19,  // 113: google.cloud.asset.v1.AssetService.DeleteFeed:input_type -> google.cloud.asset.v1.DeleteFeedRequest
	29,  // 114: google.cloud.asset.v1.AssetService.SearchAllResources:input_type -> google.cloud.asset.v1.SearchAllResourcesRequest
	31,  // 115: google.cloud.asset.v1.AssetService.SearchAllIamPolicies:input_type -> google.cloud.asset.v1.SearchAllIamPoliciesRequest
	34,  // 116: google.cloud.asset.v1.AssetService.AnalyzeIamPolicy:input_type -> google.cloud.asset.v1.AnalyzeIamPolicyRequest
	37,  // 117: google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning:input_type -> google.cloud.asset.v1.AnalyzeIamPolicyLongrunningRequest
	46,  // 118: google.cloud.asset.v1.AssetService.AnalyzeMove:input_type -> google.cloud.asset.v1.AnalyzeMoveRequest
	52,  // 119: google.cloud.asset.v1.AssetService.QueryAssets:input_type -> google.cloud.asset.v1.QueryAssetsRequest
	40,  // 120: google.cloud.asset.v1.AssetService.CreateSavedQuery:input_type -> google.cloud.asset.v1.CreateSavedQueryRequest
	41,  // 121: google.cloud.asset.v1.AssetService.GetSavedQuery:input_type -> google.cloud.asset.v1.GetSavedQueryRequest
	42,  // 122: google.cloud.asset.v1.AssetService.ListSavedQueries:input_type -> google.cloud.asset.v1.ListSavedQueriesRequest
	44,  // 123: google.cloud.asset.v1.AssetService.UpdateSavedQuery:input_type -> google.cloud.asset.v1.UpdateSavedQueryRequest
	45,  // 124: google.cloud.asset.v1.AssetService.DeleteSavedQuery:input_type -> google.cloud.asset.v1.DeleteSavedQueryRequest
	57,  // 125: google.cloud.asset.v1.AssetService.BatchGetEffectiveIamPolicies:input_type -> google.cloud.asset.v1.BatchGetEffectiveIamPoliciesRequest
	61,  // 126: google.cloud.asset.v1.AssetService.AnalyzeOrgPolicies:input_type -> google.cloud.asset.v1.AnalyzeOrgPoliciesRequest
	63,  // 127: google.cloud.asset.v1.AssetService.AnalyzeOrgPolicyGovernedContainers:input_type -> google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersRequest
	65,  // 128: google.cloud.asset.v1.AssetService.AnalyzeOrgPolicyGovernedAssets:input_type -> google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsRequest
	107, // 129: google.cloud.asset.v1.AssetService.ExportAssets:output_type -> google.longrunning.Operation
	11,  // 130: google.cloud.asset.v1.AssetService.ListAssets:output_type -> google.cloud.asset.v1.ListAssetsResponse
	13,  // 131: google.cloud.asset.v1.AssetService.BatchGetAssetsHistory:output_type -> google.cloud.asset.v1.BatchGetAssetsHistoryResponse
	28,  // 132: google.cloud.asset.v1.AssetService.CreateFeed:output_type -> google.cloud.asset.v1.Feed
	28,  // 133: google.cloud.asset.v1.AssetService.GetFeed:output_type -> google.cloud.asset.v1.Feed
	17,  // 134: google.cloud.asset.v1.AssetService.ListFeeds:output_type -> google.cloud.asset.v1.ListFeedsResponse
	28,  // 135: google.cloud.asset.v1.AssetService.UpdateFeed:output_type -> google.cloud.asset.v1.Feed
	108, // 136: google.cloud.asset.v1.AssetService.DeleteFeed:output_type -> google.protobuf.Empty
	30,  // 137: google.cloud.asset.v1.AssetService.SearchAllResources:output_type -> google.cloud.asset.v1.SearchAllResourcesResponse
	32,  // 138: google.cloud.asset.v1.AssetService.SearchAllIamPolicies:output_type -> google.cloud.asset.v1.SearchAllIamPoliciesResponse
	35,  // 139: google.cloud.asset.v1.AssetService.AnalyzeIamPolicy:output_type -> google.cloud.asset.v1.AnalyzeIamPolicyResponse
	107, // 140: google.cloud.asset.v1.AssetService.AnalyzeIamPolicyLongrunning:output_type -> google.longrunning.Operation
	47,  // 141: google.cloud.asset.v1.AssetService.AnalyzeMove:output_type -> google.cloud.asset.v1.AnalyzeMoveResponse
	53,  // 142: google.cloud.asset.v1.AssetService.QueryAssets:output_type -> google.cloud.asset.v1.QueryAssetsResponse
	39,  // 143: google.cloud.asset.v1.AssetService.CreateSavedQuery:output_type -> google.cloud.asset.v1.SavedQuery
	39,  // 144: google.cloud.asset.v1.AssetService.GetSavedQuery:output_type -> google.cloud.asset.v1.SavedQuery
	43,  // 145: google.cloud.asset.v1.AssetService.ListSavedQueries:output_type -> google.cloud.asset.v1.ListSavedQueriesResponse
	39,  // 146: google.cloud.asset.v1.AssetService.UpdateSavedQuery:output_type -> google.cloud.asset.v1.SavedQuery
	108, // 147: google.cloud.asset.v1.AssetService.DeleteSavedQuery:output_type -> google.protobuf.Empty
	58,  // 148: google.cloud.asset.v1.AssetService.BatchGetEffectiveIamPolicies:output_type -> google.cloud.asset.v1.BatchGetEffectiveIamPoliciesResponse
	62,  // 149: google.cloud.asset.v1.AssetService.AnalyzeOrgPolicies:output_type -> google.cloud.asset.v1.AnalyzeOrgPoliciesResponse
	64,  // 150: google.cloud.asset.v1.AssetService.AnalyzeOrgPolicyGovernedContainers:output_type -> google.cloud.asset.v1.AnalyzeOrgPolicyGovernedContainersResponse
	66,  // 151: google.cloud.asset.v1.AssetService.AnalyzeOrgPolicyGovernedAssets:output_type -> google.cloud.asset.v1.AnalyzeOrgPolicyGovernedAssetsResponse
	129, // [129:152] is the sub-list for method output_type
	106, // [106:129] is the sub-list for method input_type
	106, // [106:106] is the sub-list for extension type_name
	106, // [106:106] is the sub-list for extension extendee
	0,   // [0:106] is the sub-list for field type_name
}

func init() { file_google_cloud_asset_v1_asset_service_proto_init() }
func file_google_cloud_asset_v1_asset_service_proto_init() {
	if File_google_cloud_asset_v1_asset_service_proto != nil {
		return
	}
	file_google_cloud_asset_v1_assets_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeIamPolicyLongrunningMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ExportAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ExportAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ListAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ListAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*BatchGetAssetsHistoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*BatchGetAssetsHistoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*CreateFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*GetFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ListFeedsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ListFeedsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteFeedRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*OutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*OutputResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*GcsOutputResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*PartitionSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*PubsubDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*FeedOutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*Feed); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*SearchAllResourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*SearchAllResourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*SearchAllIamPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[25].Exporter = func(v any, i int) any {
			switch v := v.(*SearchAllIamPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[26].Exporter = func(v any, i int) any {
			switch v := v.(*IamPolicyAnalysisQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[27].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeIamPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[28].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeIamPolicyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[29].Exporter = func(v any, i int) any {
			switch v := v.(*IamPolicyAnalysisOutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[30].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeIamPolicyLongrunningRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[31].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeIamPolicyLongrunningResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[32].Exporter = func(v any, i int) any {
			switch v := v.(*SavedQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[33].Exporter = func(v any, i int) any {
			switch v := v.(*CreateSavedQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[34].Exporter = func(v any, i int) any {
			switch v := v.(*GetSavedQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[35].Exporter = func(v any, i int) any {
			switch v := v.(*ListSavedQueriesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[36].Exporter = func(v any, i int) any {
			switch v := v.(*ListSavedQueriesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[37].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateSavedQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[38].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteSavedQueryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[39].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeMoveRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[40].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeMoveResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[41].Exporter = func(v any, i int) any {
			switch v := v.(*MoveAnalysis); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[42].Exporter = func(v any, i int) any {
			switch v := v.(*MoveAnalysisResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[43].Exporter = func(v any, i int) any {
			switch v := v.(*MoveImpact); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[44].Exporter = func(v any, i int) any {
			switch v := v.(*QueryAssetsOutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[45].Exporter = func(v any, i int) any {
			switch v := v.(*QueryAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[46].Exporter = func(v any, i int) any {
			switch v := v.(*QueryAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[47].Exporter = func(v any, i int) any {
			switch v := v.(*QueryResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[48].Exporter = func(v any, i int) any {
			switch v := v.(*TableSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[49].Exporter = func(v any, i int) any {
			switch v := v.(*TableFieldSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[50].Exporter = func(v any, i int) any {
			switch v := v.(*BatchGetEffectiveIamPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[51].Exporter = func(v any, i int) any {
			switch v := v.(*BatchGetEffectiveIamPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[52].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzerOrgPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[53].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzerOrgPolicyConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[54].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPoliciesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[55].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPoliciesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[56].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPolicyGovernedContainersRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[57].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPolicyGovernedContainersResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[58].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPolicyGovernedAssetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[59].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPolicyGovernedAssetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[60].Exporter = func(v any, i int) any {
			switch v := v.(*IamPolicyAnalysisQuery_ResourceSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[61].Exporter = func(v any, i int) any {
			switch v := v.(*IamPolicyAnalysisQuery_IdentitySelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[62].Exporter = func(v any, i int) any {
			switch v := v.(*IamPolicyAnalysisQuery_AccessSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[63].Exporter = func(v any, i int) any {
			switch v := v.(*IamPolicyAnalysisQuery_Options); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[64].Exporter = func(v any, i int) any {
			switch v := v.(*IamPolicyAnalysisQuery_ConditionContext); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[65].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeIamPolicyResponse_IamPolicyAnalysis); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[66].Exporter = func(v any, i int) any {
			switch v := v.(*IamPolicyAnalysisOutputConfig_GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[67].Exporter = func(v any, i int) any {
			switch v := v.(*IamPolicyAnalysisOutputConfig_BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[68].Exporter = func(v any, i int) any {
			switch v := v.(*SavedQuery_QueryContent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[70].Exporter = func(v any, i int) any {
			switch v := v.(*QueryAssetsOutputConfig_BigQueryDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[71].Exporter = func(v any, i int) any {
			switch v := v.(*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[72].Exporter = func(v any, i int) any {
			switch v := v.(*BatchGetEffectiveIamPoliciesResponse_EffectiveIamPolicy_PolicyInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[73].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzerOrgPolicy_Rule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[74].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzerOrgPolicy_Rule_StringValues); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[75].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzerOrgPolicyConstraint_Constraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[76].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzerOrgPolicyConstraint_CustomConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[77].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzerOrgPolicyConstraint_Constraint_ListConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[78].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[79].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPoliciesResponse_OrgPolicyResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[80].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPolicyGovernedContainersResponse_GovernedContainer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[81].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedResource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[82].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedIamPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1_asset_service_proto_msgTypes[83].Exporter = func(v any, i int) any {
			switch v := v.(*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[13].OneofWrappers = []any{
		(*OutputConfig_GcsDestination)(nil),
		(*OutputConfig_BigqueryDestination)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[14].OneofWrappers = []any{
		(*OutputResult_GcsResult)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[16].OneofWrappers = []any{
		(*GcsDestination_Uri)(nil),
		(*GcsDestination_UriPrefix)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[20].OneofWrappers = []any{
		(*FeedOutputConfig_PubsubDestination)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[29].OneofWrappers = []any{
		(*IamPolicyAnalysisOutputConfig_GcsDestination_)(nil),
		(*IamPolicyAnalysisOutputConfig_BigqueryDestination)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[41].OneofWrappers = []any{
		(*MoveAnalysis_Analysis)(nil),
		(*MoveAnalysis_Error)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[45].OneofWrappers = []any{
		(*QueryAssetsRequest_Statement)(nil),
		(*QueryAssetsRequest_JobReference)(nil),
		(*QueryAssetsRequest_ReadTimeWindow)(nil),
		(*QueryAssetsRequest_ReadTime)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[46].OneofWrappers = []any{
		(*QueryAssetsResponse_Error)(nil),
		(*QueryAssetsResponse_QueryResult)(nil),
		(*QueryAssetsResponse_OutputConfig)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[53].OneofWrappers = []any{
		(*AnalyzerOrgPolicyConstraint_GoogleDefinedConstraint)(nil),
		(*AnalyzerOrgPolicyConstraint_CustomConstraint_)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[54].OneofWrappers = []any{}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[56].OneofWrappers = []any{}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[58].OneofWrappers = []any{}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[64].OneofWrappers = []any{
		(*IamPolicyAnalysisQuery_ConditionContext_AccessTime)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[68].OneofWrappers = []any{
		(*SavedQuery_QueryContent_IamPolicyAnalysisQuery)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[73].OneofWrappers = []any{
		(*AnalyzerOrgPolicy_Rule_Values)(nil),
		(*AnalyzerOrgPolicy_Rule_AllowAll)(nil),
		(*AnalyzerOrgPolicy_Rule_DenyAll)(nil),
		(*AnalyzerOrgPolicy_Rule_Enforce)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[75].OneofWrappers = []any{
		(*AnalyzerOrgPolicyConstraint_Constraint_ListConstraint_)(nil),
		(*AnalyzerOrgPolicyConstraint_Constraint_BooleanConstraint_)(nil),
	}
	file_google_cloud_asset_v1_asset_service_proto_msgTypes[83].OneofWrappers = []any{
		(*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedResource)(nil),
		(*AnalyzeOrgPolicyGovernedAssetsResponse_GovernedAsset_GovernedIamPolicy)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_asset_v1_asset_service_proto_rawDesc,
			NumEnums:      7,
			NumMessages:   84,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_asset_v1_asset_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_asset_v1_asset_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_asset_v1_asset_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_asset_v1_asset_service_proto_msgTypes,
	}.Build()
	File_google_cloud_asset_v1_asset_service_proto = out.File
	file_google_cloud_asset_v1_asset_service_proto_rawDesc = nil
	file_google_cloud_asset_v1_asset_service_proto_goTypes = nil
	file_google_cloud_asset_v1_asset_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location/BigQuery table. For Cloud Storage location destinations, the
	// output format is newline-delimited JSON. Each line represents a
	// [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
	// format; for BigQuery table destinations, the output table stores the fields
	// in asset Protobuf as columns. This API implements the
	// [google.longrunning.Operation][google.longrunning.Operation] API, which
	// allows you to keep track of the export. We recommend intervals of at least
	// 2 seconds with exponential retry to poll the export operation result. For
	// regular-size resource parent, the export operation usually finishes within
	// 5 minutes.
	ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists assets with time and resource types and returns paged results in
	// response.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Batch gets the update history of assets that overlap a time window.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	// Otherwise, this API outputs history with asset in both non-delete or
	// deleted status.
	// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
	// error.
	BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Searches all Google Cloud resources within the specified scope, such as a
	// project, folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllResources` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllResources(ctx context.Context, in *SearchAllResourcesRequest, opts ...grpc.CallOption) (*SearchAllResourcesResponse, error)
	// Searches all IAM policies within the specified scope, such as a project,
	// folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllIamPolicies(ctx context.Context, in *SearchAllIamPoliciesRequest, opts ...grpc.CallOption) (*SearchAllIamPoliciesResponse, error)
	// Analyzes IAM policies to answer which identities have what accesses on
	// which resources.
	AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error)
	// Analyzes IAM policies asynchronously to answer which identities have what
	// accesses on which resources, and writes the analysis results to a Google
	// Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
	// output format is the JSON format that represents a
	// [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
	// This method implements the
	// [google.longrunning.Operation][google.longrunning.Operation], which allows
	// you to track the operation status. We recommend intervals of at least 2
	// seconds with exponential backoff retry to poll the operation result. The
	// metadata contains the metadata for the long-running operation.
	AnalyzeIamPolicyLongrunning(ctx context.Context, in *AnalyzeIamPolicyLongrunningRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Analyze moving a resource to a specified destination without kicking off
	// the actual move. The analysis is best effort depending on the user's
	// permissions of viewing different hierarchical policies and configurations.
	// The policies and configuration are subject to change before the actual
	// resource migration takes place.
	AnalyzeMove(ctx context.Context, in *AnalyzeMoveRequest, opts ...grpc.CallOption) (*AnalyzeMoveResponse, error)
	// Issue a job that queries assets using a SQL statement compatible with
	// [BigQuery SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
	//
	// If the query execution finishes within timeout and there's no pagination,
	// the full query results will be returned in the `QueryAssetsResponse`.
	//
	// Otherwise, full query results can be obtained by issuing extra requests
	// with the `job_reference` from the a previous `QueryAssets` call.
	//
	// Note, the query result has approximately 10 GB limitation enforced by
	// [BigQuery](https://cloud.google.com/bigquery/docs/best-practices-performance-output).
	// Queries return larger results will result in errors.
	QueryAssets(ctx context.Context, in *QueryAssetsRequest, opts ...grpc.CallOption) (*QueryAssetsResponse, error)
	// Creates a saved query in a parent project/folder/organization.
	CreateSavedQuery(ctx context.Context, in *CreateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error)
	// Gets details about a saved query.
	GetSavedQuery(ctx context.Context, in *GetSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error)
	// Lists all saved queries in a parent project/folder/organization.
	ListSavedQueries(ctx context.Context, in *ListSavedQueriesRequest, opts ...grpc.CallOption) (*ListSavedQueriesResponse, error)
	// Updates a saved query.
	UpdateSavedQuery(ctx context.Context, in *UpdateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error)
	// Deletes a saved query.
	DeleteSavedQuery(ctx context.Context, in *DeleteSavedQueryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets effective IAM policies for a batch of resources.
	BatchGetEffectiveIamPolicies(ctx context.Context, in *BatchGetEffectiveIamPoliciesRequest, opts ...grpc.CallOption) (*BatchGetEffectiveIamPoliciesResponse, error)
	// Analyzes organization policies under a scope.
	AnalyzeOrgPolicies(ctx context.Context, in *AnalyzeOrgPoliciesRequest, opts ...grpc.CallOption) (*AnalyzeOrgPoliciesResponse, error)
	// Analyzes organization policies governed containers (projects, folders or
	// organization) under a scope.
	AnalyzeOrgPolicyGovernedContainers(ctx context.Context, in *AnalyzeOrgPolicyGovernedContainersRequest, opts ...grpc.CallOption) (*AnalyzeOrgPolicyGovernedContainersResponse, error)
	// Analyzes organization policies governed assets (Google Cloud resources or
	// policies) under a scope. This RPC supports custom constraints and the
	// following canned constraints:
	//
	// * constraints/ainotebooks.accessMode
	// * constraints/ainotebooks.disableFileDownloads
	// * constraints/ainotebooks.disableRootAccess
	// * constraints/ainotebooks.disableTerminal
	// * constraints/ainotebooks.environmentOptions
	// * constraints/ainotebooks.requireAutoUpgradeSchedule
	// * constraints/ainotebooks.restrictVpcNetworks
	// * constraints/compute.disableGuestAttributesAccess
	// * constraints/compute.disableInstanceDataAccessApis
	// * constraints/compute.disableNestedVirtualization
	// * constraints/compute.disableSerialPortAccess
	// * constraints/compute.disableSerialPortLogging
	// * constraints/compute.disableVpcExternalIpv6
	// * constraints/compute.requireOsLogin
	// * constraints/compute.requireShieldedVm
	// * constraints/compute.restrictLoadBalancerCreationForTypes
	// * constraints/compute.restrictProtocolForwardingCreationForTypes
	// * constraints/compute.restrictXpnProjectLienRemoval
	// * constraints/compute.setNewProjectDefaultToZonalDNSOnly
	// * constraints/compute.skipDefaultNetworkCreation
	// * constraints/compute.trustedImageProjects
	// * constraints/compute.vmCanIpForward
	// * constraints/compute.vmExternalIpAccess
	// * constraints/gcp.detailedAuditLoggingMode
	// * constraints/gcp.resourceLocations
	// * constraints/iam.allowedPolicyMemberDomains
	// * constraints/iam.automaticIamGrantsForDefaultServiceAccounts
	// * constraints/iam.disableServiceAccountCreation
	// * constraints/iam.disableServiceAccountKeyCreation
	// * constraints/iam.disableServiceAccountKeyUpload
	// * constraints/iam.restrictCrossProjectServiceAccountLienRemoval
	// * constraints/iam.serviceAccountKeyExpiryHours
	// * constraints/resourcemanager.accessBoundaries
	// * constraints/resourcemanager.allowedExportDestinations
	// * constraints/sql.restrictAuthorizedNetworks
	// * constraints/sql.restrictNoncompliantDiagnosticDataAccess
	// * constraints/sql.restrictNoncompliantResourceCreation
	// * constraints/sql.restrictPublicIp
	// * constraints/storage.publicAccessPrevention
	// * constraints/storage.restrictAuthTypes
	// * constraints/storage.uniformBucketLevelAccess
	//
	// This RPC only returns either resources of types [supported by search
	// APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// or IAM policies.
	AnalyzeOrgPolicyGovernedAssets(ctx context.Context, in *AnalyzeOrgPolicyGovernedAssetsRequest, opts ...grpc.CallOption) (*AnalyzeOrgPolicyGovernedAssetsResponse, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) ExportAssets(ctx context.Context, in *ExportAssetsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ExportAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ListAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) BatchGetAssetsHistory(ctx context.Context, in *BatchGetAssetsHistoryRequest, opts ...grpc.CallOption) (*BatchGetAssetsHistoryResponse, error) {
	out := new(BatchGetAssetsHistoryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/BatchGetAssetsHistory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) CreateFeed(ctx context.Context, in *CreateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/CreateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) GetFeed(ctx context.Context, in *GetFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/GetFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListFeeds(ctx context.Context, in *ListFeedsRequest, opts ...grpc.CallOption) (*ListFeedsResponse, error) {
	out := new(ListFeedsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ListFeeds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) UpdateFeed(ctx context.Context, in *UpdateFeedRequest, opts ...grpc.CallOption) (*Feed, error) {
	out := new(Feed)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/UpdateFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) DeleteFeed(ctx context.Context, in *DeleteFeedRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/DeleteFeed", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchAllResources(ctx context.Context, in *SearchAllResourcesRequest, opts ...grpc.CallOption) (*SearchAllResourcesResponse, error) {
	out := new(SearchAllResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/SearchAllResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) SearchAllIamPolicies(ctx context.Context, in *SearchAllIamPoliciesRequest, opts ...grpc.CallOption) (*SearchAllIamPoliciesResponse, error) {
	out := new(SearchAllIamPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/SearchAllIamPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error) {
	out := new(AnalyzeIamPolicyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/AnalyzeIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeIamPolicyLongrunning(ctx context.Context, in *AnalyzeIamPolicyLongrunningRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/AnalyzeIamPolicyLongrunning", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeMove(ctx context.Context, in *AnalyzeMoveRequest, opts ...grpc.CallOption) (*AnalyzeMoveResponse, error) {
	out := new(AnalyzeMoveResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/AnalyzeMove", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) QueryAssets(ctx context.Context, in *QueryAssetsRequest, opts ...grpc.CallOption) (*QueryAssetsResponse, error) {
	out := new(QueryAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/QueryAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) CreateSavedQuery(ctx context.Context, in *CreateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error) {
	out := new(SavedQuery)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/CreateSavedQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) GetSavedQuery(ctx context.Context, in *GetSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error) {
	out := new(SavedQuery)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/GetSavedQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ListSavedQueries(ctx context.Context, in *ListSavedQueriesRequest, opts ...grpc.CallOption) (*ListSavedQueriesResponse, error) {
	out := new(ListSavedQueriesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/ListSavedQueries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) UpdateSavedQuery(ctx context.Context, in *UpdateSavedQueryRequest, opts ...grpc.CallOption) (*SavedQuery, error) {
	out := new(SavedQuery)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/UpdateSavedQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) DeleteSavedQuery(ctx context.Context, in *DeleteSavedQueryRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/DeleteSavedQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) BatchGetEffectiveIamPolicies(ctx context.Context, in *BatchGetEffectiveIamPoliciesRequest, opts ...grpc.CallOption) (*BatchGetEffectiveIamPoliciesResponse, error) {
	out := new(BatchGetEffectiveIamPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/BatchGetEffectiveIamPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeOrgPolicies(ctx context.Context, in *AnalyzeOrgPoliciesRequest, opts ...grpc.CallOption) (*AnalyzeOrgPoliciesResponse, error) {
	out := new(AnalyzeOrgPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/AnalyzeOrgPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeOrgPolicyGovernedContainers(ctx context.Context, in *AnalyzeOrgPolicyGovernedContainersRequest, opts ...grpc.CallOption) (*AnalyzeOrgPolicyGovernedContainersResponse, error) {
	out := new(AnalyzeOrgPolicyGovernedContainersResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/AnalyzeOrgPolicyGovernedContainers", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) AnalyzeOrgPolicyGovernedAssets(ctx context.Context, in *AnalyzeOrgPolicyGovernedAssetsRequest, opts ...grpc.CallOption) (*AnalyzeOrgPolicyGovernedAssetsResponse, error) {
	out := new(AnalyzeOrgPolicyGovernedAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1.AssetService/AnalyzeOrgPolicyGovernedAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Exports assets with time and resource types to a given Cloud Storage
	// location/BigQuery table. For Cloud Storage location destinations, the
	// output format is newline-delimited JSON. Each line represents a
	// [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
	// format; for BigQuery table destinations, the output table stores the fields
	// in asset Protobuf as columns. This API implements the
	// [google.longrunning.Operation][google.longrunning.Operation] API, which
	// allows you to keep track of the export. We recommend intervals of at least
	// 2 seconds with exponential retry to poll the export operation result. For
	// regular-size resource parent, the export operation usually finishes within
	// 5 minutes.
	ExportAssets(context.Context, *ExportAssetsRequest) (*longrunningpb.Operation, error)
	// Lists assets with time and resource types and returns paged results in
	// response.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Batch gets the update history of assets that overlap a time window.
	// For IAM_POLICY content, this API outputs history when the asset and its
	// attached IAM POLICY both exist. This can create gaps in the output history.
	// Otherwise, this API outputs history with asset in both non-delete or
	// deleted status.
	// If a specified asset does not exist, this API returns an INVALID_ARGUMENT
	// error.
	BatchGetAssetsHistory(context.Context, *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error)
	// Creates a feed in a parent project/folder/organization to listen to its
	// asset updates.
	CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error)
	// Gets details about an asset feed.
	GetFeed(context.Context, *GetFeedRequest) (*Feed, error)
	// Lists all asset feeds in a parent project/folder/organization.
	ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error)
	// Updates an asset feed configuration.
	UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error)
	// Deletes an asset feed.
	DeleteFeed(context.Context, *DeleteFeedRequest) (*emptypb.Empty, error)
	// Searches all Google Cloud resources within the specified scope, such as a
	// project, folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllResources` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllResources(context.Context, *SearchAllResourcesRequest) (*SearchAllResourcesResponse, error)
	// Searches all IAM policies within the specified scope, such as a project,
	// folder, or organization. The caller must be granted the
	// `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
	// otherwise the request will be rejected.
	SearchAllIamPolicies(context.Context, *SearchAllIamPoliciesRequest) (*SearchAllIamPoliciesResponse, error)
	// Analyzes IAM policies to answer which identities have what accesses on
	// which resources.
	AnalyzeIamPolicy(context.Context, *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error)
	// Analyzes IAM policies asynchronously to answer which identities have what
	// accesses on which resources, and writes the analysis results to a Google
	// Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
	// output format is the JSON format that represents a
	// [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
	// This method implements the
	// [google.longrunning.Operation][google.longrunning.Operation], which allows
	// you to track the operation status. We recommend intervals of at least 2
	// seconds with exponential backoff retry to poll the operation result. The
	// metadata contains the metadata for the long-running operation.
	AnalyzeIamPolicyLongrunning(context.Context, *AnalyzeIamPolicyLongrunningRequest) (*longrunningpb.Operation, error)
	// Analyze moving a resource to a specified destination without kicking off
	// the actual move. The analysis is best effort depending on the user's
	// permissions of viewing different hierarchical policies and configurations.
	// The policies and configuration are subject to change before the actual
	// resource migration takes place.
	AnalyzeMove(context.Context, *AnalyzeMoveRequest) (*AnalyzeMoveResponse, error)
	// Issue a job that queries assets using a SQL statement compatible with
	// [BigQuery SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
	//
	// If the query execution finishes within timeout and there's no pagination,
	// the full query results will be returned in the `QueryAssetsResponse`.
	//
	// Otherwise, full query results can be obtained by issuing extra requests
	// with the `job_reference` from the a previous `QueryAssets` call.
	//
	// Note, the query result has approximately 10 GB limitation enforced by
	// [BigQuery](https://cloud.google.com/bigquery/docs/best-practices-performance-output).
	// Queries return larger results will result in errors.
	QueryAssets(context.Context, *QueryAssetsRequest) (*QueryAssetsResponse, error)
	// Creates a saved query in a parent project/folder/organization.
	CreateSavedQuery(context.Context, *CreateSavedQueryRequest) (*SavedQuery, error)
	// Gets details about a saved query.
	GetSavedQuery(context.Context, *GetSavedQueryRequest) (*SavedQuery, error)
	// Lists all saved queries in a parent project/folder/organization.
	ListSavedQueries(context.Context, *ListSavedQueriesRequest) (*ListSavedQueriesResponse, error)
	// Updates a saved query.
	UpdateSavedQuery(context.Context, *UpdateSavedQueryRequest) (*SavedQuery, error)
	// Deletes a saved query.
	DeleteSavedQuery(context.Context, *DeleteSavedQueryRequest) (*emptypb.Empty, error)
	// Gets effective IAM policies for a batch of resources.
	BatchGetEffectiveIamPolicies(context.Context, *BatchGetEffectiveIamPoliciesRequest) (*BatchGetEffectiveIamPoliciesResponse, error)
	// Analyzes organization policies under a scope.
	AnalyzeOrgPolicies(context.Context, *AnalyzeOrgPoliciesRequest) (*AnalyzeOrgPoliciesResponse, error)
	// Analyzes organization policies governed containers (projects, folders or
	// organization) under a scope.
	AnalyzeOrgPolicyGovernedContainers(context.Context, *AnalyzeOrgPolicyGovernedContainersRequest) (*AnalyzeOrgPolicyGovernedContainersResponse, error)
	// Analyzes organization policies governed assets (Google Cloud resources or
	// policies) under a scope. This RPC supports custom constraints and the
	// following canned constraints:
	//
	// * constraints/ainotebooks.accessMode
	// * constraints/ainotebooks.disableFileDownloads
	// * constraints/ainotebooks.disableRootAccess
	// * constraints/ainotebooks.disableTerminal
	// * constraints/ainotebooks.environmentOptions
	// * constraints/ainotebooks.requireAutoUpgradeSchedule
	// * constraints/ainotebooks.restrictVpcNetworks
	// * constraints/compute.disableGuestAttributesAccess
	// * constraints/compute.disableInstanceDataAccessApis
	// * constraints/compute.disableNestedVirtualization
	// * constraints/compute.disableSerialPortAccess
	// * constraints/compute.disableSerialPortLogging
	// * constraints/compute.disableVpcExternalIpv6
	// * constraints/compute.requireOsLogin
	// * constraints/compute.requireShieldedVm
	// * constraints/compute.restrictLoadBalancerCreationForTypes
	// * constraints/compute.restrictProtocolForwardingCreationForTypes
	// * constraints/compute.restrictXpnProjectLienRemoval
	// * constraints/compute.setNewProjectDefaultToZonalDNSOnly
	// * constraints/compute.skipDefaultNetworkCreation
	// * constraints/compute.trustedImageProjects
	// * constraints/compute.vmCanIpForward
	// * constraints/compute.vmExternalIpAccess
	// * constraints/gcp.detailedAuditLoggingMode
	// * constraints/gcp.resourceLocations
	// * constraints/iam.allowedPolicyMemberDomains
	// * constraints/iam.automaticIamGrantsForDefaultServiceAccounts
	// * constraints/iam.disableServiceAccountCreation
	// * constraints/iam.disableServiceAccountKeyCreation
	// * constraints/iam.disableServiceAccountKeyUpload
	// * constraints/iam.restrictCrossProjectServiceAccountLienRemoval
	// * constraints/iam.serviceAccountKeyExpiryHours
	// * constraints/resourcemanager.accessBoundaries
	// * constraints/resourcemanager.allowedExportDestinations
	// * constraints/sql.restrictAuthorizedNetworks
	// * constraints/sql.restrictNoncompliantDiagnosticDataAccess
	// * constraints/sql.restrictNoncompliantResourceCreation
	// * constraints/sql.restrictPublicIp
	// * constraints/storage.publicAccessPrevention
	// * constraints/storage.restrictAuthTypes
	// * constraints/storage.uniformBucketLevelAccess
	//
	// This RPC only returns either resources of types [supported by search
	// APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// or IAM policies.
	AnalyzeOrgPolicyGovernedAssets(context.Context, *AnalyzeOrgPolicyGovernedAssetsRequest) (*AnalyzeOrgPolicyGovernedAssetsResponse, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) ExportAssets(context.Context, *ExportAssetsRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExportAssets not implemented")
}
func (*UnimplementedAssetServiceServer) ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListAssets not implemented")
}
func (*UnimplementedAssetServiceServer) BatchGetAssetsHistory(context.Context, *BatchGetAssetsHistoryRequest) (*BatchGetAssetsHistoryResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchGetAssetsHistory not implemented")
}
func (*UnimplementedAssetServiceServer) CreateFeed(context.Context, *CreateFeedRequest) (*Feed, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateFeed not implemented")
}
func (*UnimplementedAssetServiceServer) GetFeed(context.Context, *GetFeedRequest) (*Feed, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetFeed not implemented")
}
func (*UnimplementedAssetServiceServer) ListFeeds(context.Context, *ListFeedsRequest) (*ListFeedsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListFeeds not implemented")
}
func (*UnimplementedAssetServiceServer) UpdateFeed(context.Context, *UpdateFeedRequest) (*Feed, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateFeed not implemented")
}
func (*UnimplementedAssetServiceServer) DeleteFeed(context.Context, *DeleteFeedRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteFeed not implemented")
}
func (*UnimplementedAssetServiceServer) SearchAllResources(context.Context, *SearchAllResourcesRequest) (*SearchAllResourcesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAllResources not implemented")
}
func (*UnimplementedAssetServiceServer) SearchAllIamPolicies(context.Context, *SearchAllIamPoliciesRequest) (*SearchAllIamPoliciesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchAllIamPolicies not implemented")
}
func (*UnimplementedAssetServiceServer) AnalyzeIamPolicy(context.Context, *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeIamPolicy not implemented")
}
func (*UnimplementedAssetServiceServer) AnalyzeIamPolicyLongrunning(context.Context, *AnalyzeIamPolicyLongrunningRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeIamPolicyLongrunning not implemented")
}
func (*UnimplementedAssetServiceServer) AnalyzeMove(context.Context, *AnalyzeMoveRequest) (*AnalyzeMoveResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeMove not implemented")
}
func (*UnimplementedAssetServiceServer) QueryAssets(context.Context, *QueryAssetsRequest) (*QueryAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method QueryAssets not implemented")
}
func (*UnimplementedAssetServiceServer) CreateSavedQuery(context.Context, *CreateSavedQueryRequest) (*SavedQuery, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateSavedQuery not implemented")
}
func (*UnimplementedAssetServiceServer) GetSavedQuery(context.Context, *GetSavedQueryRequest) (*SavedQuery, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetSavedQuery not implemented")
}
func (*UnimplementedAssetServiceServer) ListSavedQueries(context.Context, *ListSavedQueriesRequest) (*ListSavedQueriesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListSavedQueries not implemented")
}
func (*UnimplementedAssetServiceServer) UpdateSavedQuery(context.Context, *UpdateSavedQueryRequest) (*SavedQuery, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateSavedQuery not implemented")
}
func (*UnimplementedAssetServiceServer) DeleteSavedQuery(context.Context, *DeleteSavedQueryRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteSavedQuery not implemented")
}
func (*UnimplementedAssetServiceServer) BatchGetEffectiveIamPolicies(context.Context, *BatchGetEffectiveIamPoliciesRequest) (*BatchGetEffectiveIamPoliciesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method BatchGetEffectiveIamPolicies not implemented")
}
func (*UnimplementedAssetServiceServer) AnalyzeOrgPolicies(context.Context, *AnalyzeOrgPoliciesRequest) (*AnalyzeOrgPoliciesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeOrgPolicies not implemented")
}
func (*UnimplementedAssetServiceServer) AnalyzeOrgPolicyGovernedContainers(context.Context, *AnalyzeOrgPolicyGovernedContainersRequest) (*AnalyzeOrgPolicyGovernedContainersResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeOrgPolicyGovernedContainers not implemented")
}
func (*UnimplementedAssetServiceServer) AnalyzeOrgPolicyGovernedAssets(context.Context, *AnalyzeOrgPolicyGovernedAssetsRequest) (*AnalyzeOrgPolicyGovernedAssetsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method AnalyzeOrgPolicyGovernedAssets not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_ExportAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ExportAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ExportAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ExportAssets(ctx, req.(*ExportAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ListAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_BatchGetAssetsHistory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetAssetsHistoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/BatchGetAssetsHistory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).BatchGetAssetsHistory(ctx, req.(*BatchGetAssetsHistoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_CreateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).CreateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/CreateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).CreateFeed(ctx, req.(*CreateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_GetFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/GetFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetFeed(ctx, req.(*GetFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListFeeds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFeedsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListFeeds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ListFeeds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListFeeds(ctx, req.(*ListFeedsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_UpdateFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).UpdateFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/UpdateFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).UpdateFeed(ctx, req.(*UpdateFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_DeleteFeed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFeedRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).DeleteFeed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/DeleteFeed",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).DeleteFeed(ctx, req.(*DeleteFeedRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchAllResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchAllResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/SearchAllResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchAllResources(ctx, req.(*SearchAllResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_SearchAllIamPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllIamPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).SearchAllIamPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/SearchAllIamPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).SearchAllIamPolicies(ctx, req.(*SearchAllIamPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/AnalyzeIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, req.(*AnalyzeIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeIamPolicyLongrunning_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeIamPolicyLongrunningRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeIamPolicyLongrunning(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/AnalyzeIamPolicyLongrunning",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeIamPolicyLongrunning(ctx, req.(*AnalyzeIamPolicyLongrunningRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeMove_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeMoveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeMove(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/AnalyzeMove",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeMove(ctx, req.(*AnalyzeMoveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_QueryAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).QueryAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/QueryAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).QueryAssets(ctx, req.(*QueryAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_CreateSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).CreateSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/CreateSavedQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).CreateSavedQuery(ctx, req.(*CreateSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_GetSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).GetSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/GetSavedQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).GetSavedQuery(ctx, req.(*GetSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ListSavedQueries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSavedQueriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ListSavedQueries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/ListSavedQueries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ListSavedQueries(ctx, req.(*ListSavedQueriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_UpdateSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).UpdateSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/UpdateSavedQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).UpdateSavedQuery(ctx, req.(*UpdateSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_DeleteSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).DeleteSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/DeleteSavedQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).DeleteSavedQuery(ctx, req.(*DeleteSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_BatchGetEffectiveIamPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetEffectiveIamPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).BatchGetEffectiveIamPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/BatchGetEffectiveIamPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).BatchGetEffectiveIamPolicies(ctx, req.(*BatchGetEffectiveIamPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeOrgPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeOrgPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeOrgPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/AnalyzeOrgPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeOrgPolicies(ctx, req.(*AnalyzeOrgPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeOrgPolicyGovernedContainers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeOrgPolicyGovernedContainersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeOrgPolicyGovernedContainers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/AnalyzeOrgPolicyGovernedContainers",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeOrgPolicyGovernedContainers(ctx, req.(*AnalyzeOrgPolicyGovernedContainersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_AnalyzeOrgPolicyGovernedAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeOrgPolicyGovernedAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeOrgPolicyGovernedAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1.AssetService/AnalyzeOrgPolicyGovernedAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeOrgPolicyGovernedAssets(ctx, req.(*AnalyzeOrgPolicyGovernedAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportAssets",
			Handler:    _AssetService_ExportAssets_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _AssetService_ListAssets_Handler,
		},
		{
			MethodName: "BatchGetAssetsHistory",
			Handler:    _AssetService_BatchGetAssetsHistory_Handler,
		},
		{
			MethodName: "CreateFeed",
			Handler:    _AssetService_CreateFeed_Handler,
		},
		{
			MethodName: "GetFeed",
			Handler:    _AssetService_GetFeed_Handler,
		},
		{
			MethodName: "ListFeeds",
			Handler:    _AssetService_ListFeeds_Handler,
		},
		{
			MethodName: "UpdateFeed",
			Handler:    _AssetService_UpdateFeed_Handler,
		},
		{
			MethodName: "DeleteFeed",
			Handler:    _AssetService_DeleteFeed_Handler,
		},
		{
			MethodName: "SearchAllResources",
			Handler:    _AssetService_SearchAllResources_Handler,
		},
		{
			MethodName: "SearchAllIamPolicies",
			Handler:    _AssetService_SearchAllIamPolicies_Handler,
		},
		{
			MethodName: "AnalyzeIamPolicy",
			Handler:    _AssetService_AnalyzeIamPolicy_Handler,
		},
		{
			MethodName: "AnalyzeIamPolicyLongrunning",
			Handler:    _AssetService_AnalyzeIamPolicyLongrunning_Handler,
		},
		{
			MethodName: "AnalyzeMove",
			Handler:    _AssetService_AnalyzeMove_Handler,
		},
		{
			MethodName: "QueryAssets",
			Handler:    _AssetService_QueryAssets_Handler,
		},
		{
			MethodName: "CreateSavedQuery",
			Handler:    _AssetService_CreateSavedQuery_Handler,
		},
		{
			MethodName: "GetSavedQuery",
			Handler:    _AssetService_GetSavedQuery_Handler,
		},
		{
			MethodName: "ListSavedQueries",
			Handler:    _AssetService_ListSavedQueries_Handler,
		},
		{
			MethodName: "UpdateSavedQuery",
			Handler:    _AssetService_UpdateSavedQuery_Handler,
		},
		{
			MethodName: "DeleteSavedQuery",
			Handler:    _AssetService_DeleteSavedQuery_Handler,
		},
		{
			MethodName: "BatchGetEffectiveIamPolicies",
			Handler:    _AssetService_BatchGetEffectiveIamPolicies_Handler,
		},
		{
			MethodName: "AnalyzeOrgPolicies",
			Handler:    _AssetService_AnalyzeOrgPolicies_Handler,
		},
		{
			MethodName: "AnalyzeOrgPolicyGovernedContainers",
			Handler:    _AssetService_AnalyzeOrgPolicyGovernedContainers_Handler,
		},
		{
			MethodName: "AnalyzeOrgPolicyGovernedAssets",
			Handler:    _AssetService_AnalyzeOrgPolicyGovernedAssets_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1/asset_service.proto",
}
