// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/channel/v1/entitlements.proto

package channelpb

import (
	reflect "reflect"
	sync "sync"

	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the current provisioning state of the entitlement.
type Entitlement_ProvisioningState int32

const (
	// Not used.
	Entitlement_PROVISIONING_STATE_UNSPECIFIED Entitlement_ProvisioningState = 0
	// The entitlement is currently active.
	Entitlement_ACTIVE Entitlement_ProvisioningState = 1
	// The entitlement is currently suspended.
	Entitlement_SUSPENDED Entitlement_ProvisioningState = 5
)

// Enum value maps for Entitlement_ProvisioningState.
var (
	Entitlement_ProvisioningState_name = map[int32]string{
		0: "PROVISIONING_STATE_UNSPECIFIED",
		1: "ACTIVE",
		5: "SUSPENDED",
	}
	Entitlement_ProvisioningState_value = map[string]int32{
		"PROVISIONING_STATE_UNSPECIFIED": 0,
		"ACTIVE":                         1,
		"SUSPENDED":                      5,
	}
)

func (x Entitlement_ProvisioningState) Enum() *Entitlement_ProvisioningState {
	p := new(Entitlement_ProvisioningState)
	*p = x
	return p
}

func (x Entitlement_ProvisioningState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Entitlement_ProvisioningState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_entitlements_proto_enumTypes[0].Descriptor()
}

func (Entitlement_ProvisioningState) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_entitlements_proto_enumTypes[0]
}

func (x Entitlement_ProvisioningState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Entitlement_ProvisioningState.Descriptor instead.
func (Entitlement_ProvisioningState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{0, 0}
}

// Suspension reason for an entitlement if [provisioning_state][google.cloud.channel.v1.Entitlement.provisioning_state] = SUSPENDED.
type Entitlement_SuspensionReason int32

const (
	// Not used.
	Entitlement_SUSPENSION_REASON_UNSPECIFIED Entitlement_SuspensionReason = 0
	// Entitlement was manually suspended by the Reseller.
	Entitlement_RESELLER_INITIATED Entitlement_SuspensionReason = 1
	// Trial ended.
	Entitlement_TRIAL_ENDED Entitlement_SuspensionReason = 2
	// Entitlement renewal was canceled.
	Entitlement_RENEWAL_WITH_TYPE_CANCEL Entitlement_SuspensionReason = 3
	// Entitlement was automatically suspended on creation for pending ToS
	// acceptance on customer.
	Entitlement_PENDING_TOS_ACCEPTANCE Entitlement_SuspensionReason = 4
	// Other reasons (internal reasons, abuse, etc.).
	Entitlement_OTHER Entitlement_SuspensionReason = 100
)

// Enum value maps for Entitlement_SuspensionReason.
var (
	Entitlement_SuspensionReason_name = map[int32]string{
		0:   "SUSPENSION_REASON_UNSPECIFIED",
		1:   "RESELLER_INITIATED",
		2:   "TRIAL_ENDED",
		3:   "RENEWAL_WITH_TYPE_CANCEL",
		4:   "PENDING_TOS_ACCEPTANCE",
		100: "OTHER",
	}
	Entitlement_SuspensionReason_value = map[string]int32{
		"SUSPENSION_REASON_UNSPECIFIED": 0,
		"RESELLER_INITIATED":            1,
		"TRIAL_ENDED":                   2,
		"RENEWAL_WITH_TYPE_CANCEL":      3,
		"PENDING_TOS_ACCEPTANCE":        4,
		"OTHER":                         100,
	}
)

func (x Entitlement_SuspensionReason) Enum() *Entitlement_SuspensionReason {
	p := new(Entitlement_SuspensionReason)
	*p = x
	return p
}

func (x Entitlement_SuspensionReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Entitlement_SuspensionReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_entitlements_proto_enumTypes[1].Descriptor()
}

func (Entitlement_SuspensionReason) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_entitlements_proto_enumTypes[1]
}

func (x Entitlement_SuspensionReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Entitlement_SuspensionReason.Descriptor instead.
func (Entitlement_SuspensionReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{0, 1}
}

// Reason of ineligibility.
type TransferEligibility_Reason int32

const (
	// Not used.
	TransferEligibility_REASON_UNSPECIFIED TransferEligibility_Reason = 0
	// Reseller needs to accept TOS before transferring the SKU.
	TransferEligibility_PENDING_TOS_ACCEPTANCE TransferEligibility_Reason = 1
	// Reseller not eligible to sell the SKU.
	TransferEligibility_SKU_NOT_ELIGIBLE TransferEligibility_Reason = 2
	// SKU subscription is suspended
	TransferEligibility_SKU_SUSPENDED TransferEligibility_Reason = 3
)

// Enum value maps for TransferEligibility_Reason.
var (
	TransferEligibility_Reason_name = map[int32]string{
		0: "REASON_UNSPECIFIED",
		1: "PENDING_TOS_ACCEPTANCE",
		2: "SKU_NOT_ELIGIBLE",
		3: "SKU_SUSPENDED",
	}
	TransferEligibility_Reason_value = map[string]int32{
		"REASON_UNSPECIFIED":     0,
		"PENDING_TOS_ACCEPTANCE": 1,
		"SKU_NOT_ELIGIBLE":       2,
		"SKU_SUSPENDED":          3,
	}
)

func (x TransferEligibility_Reason) Enum() *TransferEligibility_Reason {
	p := new(TransferEligibility_Reason)
	*p = x
	return p
}

func (x TransferEligibility_Reason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TransferEligibility_Reason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_channel_v1_entitlements_proto_enumTypes[2].Descriptor()
}

func (TransferEligibility_Reason) Type() protoreflect.EnumType {
	return &file_google_cloud_channel_v1_entitlements_proto_enumTypes[2]
}

func (x TransferEligibility_Reason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TransferEligibility_Reason.Descriptor instead.
func (TransferEligibility_Reason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{8, 0}
}

// An entitlement is a representation of a customer's ability to use a service.
type Entitlement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of an entitlement in the form:
	// accounts/{account_id}/customers/{customer_id}/entitlements/{entitlement_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which the entitlement is created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the entitlement is updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. The offer resource name for which the entitlement is to be
	// created. Takes the form: accounts/{account_id}/offers/{offer_id}.
	Offer string `protobuf:"bytes,8,opt,name=offer,proto3" json:"offer,omitempty"`
	// Commitment settings for a commitment-based Offer.
	// Required for commitment based offers.
	CommitmentSettings *CommitmentSettings `protobuf:"bytes,12,opt,name=commitment_settings,json=commitmentSettings,proto3" json:"commitment_settings,omitempty"`
	// Output only. Current provisioning state of the entitlement.
	ProvisioningState Entitlement_ProvisioningState `protobuf:"varint,13,opt,name=provisioning_state,json=provisioningState,proto3,enum=google.cloud.channel.v1.Entitlement_ProvisioningState" json:"provisioning_state,omitempty"`
	// Output only. Service provisioning details for the entitlement.
	ProvisionedService *ProvisionedService `protobuf:"bytes,16,opt,name=provisioned_service,json=provisionedService,proto3" json:"provisioned_service,omitempty"`
	// Output only. Enumerable of all current suspension reasons for an entitlement.
	SuspensionReasons []Entitlement_SuspensionReason `protobuf:"varint,18,rep,packed,name=suspension_reasons,json=suspensionReasons,proto3,enum=google.cloud.channel.v1.Entitlement_SuspensionReason" json:"suspension_reasons,omitempty"`
	// Optional. This purchase order (PO) information is for resellers to use for their
	// company tracking usage. If a purchaseOrderId value is given, it appears in
	// the API responses and shows up in the invoice. The property accepts up to
	// 80 plain text characters. This is only supported for Google Workspace
	// entitlements.
	PurchaseOrderId string `protobuf:"bytes,19,opt,name=purchase_order_id,json=purchaseOrderId,proto3" json:"purchase_order_id,omitempty"`
	// Output only. Settings for trial offers.
	TrialSettings *TrialSettings `protobuf:"bytes,21,opt,name=trial_settings,json=trialSettings,proto3" json:"trial_settings,omitempty"`
	// Association information to other entitlements.
	AssociationInfo *AssociationInfo `protobuf:"bytes,23,opt,name=association_info,json=associationInfo,proto3" json:"association_info,omitempty"`
	// Extended entitlement parameters. When creating an entitlement, valid
	// parameter names and values are defined in the
	// [Offer.parameter_definitions][google.cloud.channel.v1.Offer.parameter_definitions].
	//
	// The response may include the following output-only Parameters:
	//
	// - assigned_units: The number of licenses assigned to users.
	//
	// - max_units: The maximum assignable units for a flexible offer.
	//
	// - num_units: The total commitment for commitment-based offers.
	Parameters []*Parameter `protobuf:"bytes,26,rep,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *Entitlement) Reset() {
	*x = Entitlement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Entitlement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entitlement) ProtoMessage() {}

func (x *Entitlement) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entitlement.ProtoReflect.Descriptor instead.
func (*Entitlement) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{0}
}

func (x *Entitlement) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Entitlement) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Entitlement) GetUpdateTime() *timestamp.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Entitlement) GetOffer() string {
	if x != nil {
		return x.Offer
	}
	return ""
}

func (x *Entitlement) GetCommitmentSettings() *CommitmentSettings {
	if x != nil {
		return x.CommitmentSettings
	}
	return nil
}

func (x *Entitlement) GetProvisioningState() Entitlement_ProvisioningState {
	if x != nil {
		return x.ProvisioningState
	}
	return Entitlement_PROVISIONING_STATE_UNSPECIFIED
}

func (x *Entitlement) GetProvisionedService() *ProvisionedService {
	if x != nil {
		return x.ProvisionedService
	}
	return nil
}

func (x *Entitlement) GetSuspensionReasons() []Entitlement_SuspensionReason {
	if x != nil {
		return x.SuspensionReasons
	}
	return nil
}

func (x *Entitlement) GetPurchaseOrderId() string {
	if x != nil {
		return x.PurchaseOrderId
	}
	return ""
}

func (x *Entitlement) GetTrialSettings() *TrialSettings {
	if x != nil {
		return x.TrialSettings
	}
	return nil
}

func (x *Entitlement) GetAssociationInfo() *AssociationInfo {
	if x != nil {
		return x.AssociationInfo
	}
	return nil
}

func (x *Entitlement) GetParameters() []*Parameter {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Definition for extended entitlement parameters.
type Parameter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Value of the parameter.
	Value *Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Output only. Specifies whether this parameter is allowed to be changed. For example, for
	// a Google Workspace Business Starter entitlement in commitment plan,
	// num_units is editable when entitlement is active.
	Editable bool `protobuf:"varint,3,opt,name=editable,proto3" json:"editable,omitempty"`
}

func (x *Parameter) Reset() {
	*x = Parameter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Parameter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Parameter) ProtoMessage() {}

func (x *Parameter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Parameter.ProtoReflect.Descriptor instead.
func (*Parameter) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{1}
}

func (x *Parameter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Parameter) GetValue() *Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Parameter) GetEditable() bool {
	if x != nil {
		return x.Editable
	}
	return false
}

// Association links that an entitlement has to other entitlements.
type AssociationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the base entitlement, for which this entitlement is an add-on.
	BaseEntitlement string `protobuf:"bytes,1,opt,name=base_entitlement,json=baseEntitlement,proto3" json:"base_entitlement,omitempty"`
}

func (x *AssociationInfo) Reset() {
	*x = AssociationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AssociationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssociationInfo) ProtoMessage() {}

func (x *AssociationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssociationInfo.ProtoReflect.Descriptor instead.
func (*AssociationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{2}
}

func (x *AssociationInfo) GetBaseEntitlement() string {
	if x != nil {
		return x.BaseEntitlement
	}
	return ""
}

// Service provisioned for an entitlement.
type ProvisionedService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Provisioning ID of the entitlement. For Google Workspace, this is the
	// underlying Subscription ID. For Google Cloud Platform, this is the
	// Billing Account ID of the billing subaccount."
	ProvisioningId string `protobuf:"bytes,1,opt,name=provisioning_id,json=provisioningId,proto3" json:"provisioning_id,omitempty"`
	// Output only. The product pertaining to the provisioning resource as specified in the
	// Offer.
	ProductId string `protobuf:"bytes,2,opt,name=product_id,json=productId,proto3" json:"product_id,omitempty"`
	// Output only. The SKU pertaining to the provisioning resource as specified in the Offer.
	SkuId string `protobuf:"bytes,3,opt,name=sku_id,json=skuId,proto3" json:"sku_id,omitempty"`
}

func (x *ProvisionedService) Reset() {
	*x = ProvisionedService{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ProvisionedService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisionedService) ProtoMessage() {}

func (x *ProvisionedService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisionedService.ProtoReflect.Descriptor instead.
func (*ProvisionedService) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{3}
}

func (x *ProvisionedService) GetProvisioningId() string {
	if x != nil {
		return x.ProvisioningId
	}
	return ""
}

func (x *ProvisionedService) GetProductId() string {
	if x != nil {
		return x.ProductId
	}
	return ""
}

func (x *ProvisionedService) GetSkuId() string {
	if x != nil {
		return x.SkuId
	}
	return ""
}

// Commitment settings for commitment-based offers.
type CommitmentSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Commitment start timestamp.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Commitment end timestamp.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Optional. Renewal settings applicable for a commitment-based Offer.
	RenewalSettings *RenewalSettings `protobuf:"bytes,4,opt,name=renewal_settings,json=renewalSettings,proto3" json:"renewal_settings,omitempty"`
}

func (x *CommitmentSettings) Reset() {
	*x = CommitmentSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CommitmentSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CommitmentSettings) ProtoMessage() {}

func (x *CommitmentSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CommitmentSettings.ProtoReflect.Descriptor instead.
func (*CommitmentSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{4}
}

func (x *CommitmentSettings) GetStartTime() *timestamp.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CommitmentSettings) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CommitmentSettings) GetRenewalSettings() *RenewalSettings {
	if x != nil {
		return x.RenewalSettings
	}
	return nil
}

// Renewal settings for renewable Offers.
type RenewalSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If false, the plan will be completed at the end date.
	EnableRenewal bool `protobuf:"varint,1,opt,name=enable_renewal,json=enableRenewal,proto3" json:"enable_renewal,omitempty"`
	// If true and enable_renewal = true, the unit (for example seats or licenses)
	// will be set to the number of active units at renewal time.
	ResizeUnitCount bool `protobuf:"varint,2,opt,name=resize_unit_count,json=resizeUnitCount,proto3" json:"resize_unit_count,omitempty"`
	// Describes how a reseller will be billed.
	PaymentPlan PaymentPlan `protobuf:"varint,5,opt,name=payment_plan,json=paymentPlan,proto3,enum=google.cloud.channel.v1.PaymentPlan" json:"payment_plan,omitempty"`
	// Describes how frequently the reseller will be billed, such as
	// once per month.
	PaymentCycle *Period `protobuf:"bytes,6,opt,name=payment_cycle,json=paymentCycle,proto3" json:"payment_cycle,omitempty"`
}

func (x *RenewalSettings) Reset() {
	*x = RenewalSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenewalSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenewalSettings) ProtoMessage() {}

func (x *RenewalSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenewalSettings.ProtoReflect.Descriptor instead.
func (*RenewalSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{5}
}

func (x *RenewalSettings) GetEnableRenewal() bool {
	if x != nil {
		return x.EnableRenewal
	}
	return false
}

func (x *RenewalSettings) GetResizeUnitCount() bool {
	if x != nil {
		return x.ResizeUnitCount
	}
	return false
}

func (x *RenewalSettings) GetPaymentPlan() PaymentPlan {
	if x != nil {
		return x.PaymentPlan
	}
	return PaymentPlan_PAYMENT_PLAN_UNSPECIFIED
}

func (x *RenewalSettings) GetPaymentCycle() *Period {
	if x != nil {
		return x.PaymentCycle
	}
	return nil
}

// Settings for trial offers.
type TrialSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Determines if the entitlement is in a trial or not:
	//
	// * `true` - The entitlement is in trial.
	// * `false` - The entitlement is not in trial.
	Trial bool `protobuf:"varint,1,opt,name=trial,proto3" json:"trial,omitempty"`
	// Date when the trial ends. The value is in milliseconds
	// using the UNIX Epoch format. See an example [Epoch
	// converter](https://www.epochconverter.com).
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *TrialSettings) Reset() {
	*x = TrialSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TrialSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TrialSettings) ProtoMessage() {}

func (x *TrialSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TrialSettings.ProtoReflect.Descriptor instead.
func (*TrialSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{6}
}

func (x *TrialSettings) GetTrial() bool {
	if x != nil {
		return x.Trial
	}
	return false
}

func (x *TrialSettings) GetEndTime() *timestamp.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// TransferableSku represents information a reseller needs to view existing
// provisioned services for a customer that they do not own.
// Read-only.
type TransferableSku struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Describes the transfer eligibility of a SKU.
	TransferEligibility *TransferEligibility `protobuf:"bytes,9,opt,name=transfer_eligibility,json=transferEligibility,proto3" json:"transfer_eligibility,omitempty"`
	// The SKU pertaining to the provisioning resource as specified in the Offer.
	Sku *Sku `protobuf:"bytes,11,opt,name=sku,proto3" json:"sku,omitempty"`
	// Optional. The customer to transfer has an entitlement with the populated legacy SKU.
	LegacySku *Sku `protobuf:"bytes,12,opt,name=legacy_sku,json=legacySku,proto3" json:"legacy_sku,omitempty"`
}

func (x *TransferableSku) Reset() {
	*x = TransferableSku{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferableSku) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferableSku) ProtoMessage() {}

func (x *TransferableSku) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferableSku.ProtoReflect.Descriptor instead.
func (*TransferableSku) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{7}
}

func (x *TransferableSku) GetTransferEligibility() *TransferEligibility {
	if x != nil {
		return x.TransferEligibility
	}
	return nil
}

func (x *TransferableSku) GetSku() *Sku {
	if x != nil {
		return x.Sku
	}
	return nil
}

func (x *TransferableSku) GetLegacySku() *Sku {
	if x != nil {
		return x.LegacySku
	}
	return nil
}

// Specifies transfer eligibility of a SKU.
type TransferEligibility struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether reseller is eligible to transfer the SKU.
	IsEligible bool `protobuf:"varint,1,opt,name=is_eligible,json=isEligible,proto3" json:"is_eligible,omitempty"`
	// Localized description if reseller is not eligible to transfer the SKU.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Specified the reason for ineligibility.
	IneligibilityReason TransferEligibility_Reason `protobuf:"varint,3,opt,name=ineligibility_reason,json=ineligibilityReason,proto3,enum=google.cloud.channel.v1.TransferEligibility_Reason" json:"ineligibility_reason,omitempty"`
}

func (x *TransferEligibility) Reset() {
	*x = TransferEligibility{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TransferEligibility) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TransferEligibility) ProtoMessage() {}

func (x *TransferEligibility) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_channel_v1_entitlements_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TransferEligibility.ProtoReflect.Descriptor instead.
func (*TransferEligibility) Descriptor() ([]byte, []int) {
	return file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP(), []int{8}
}

func (x *TransferEligibility) GetIsEligible() bool {
	if x != nil {
		return x.IsEligible
	}
	return false
}

func (x *TransferEligibility) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TransferEligibility) GetIneligibilityReason() TransferEligibility_Reason {
	if x != nil {
		return x.IneligibilityReason
	}
	return TransferEligibility_REASON_UNSPECIFIED
}

var File_google_cloud_channel_v1_entitlements_proto protoreflect.FileDescriptor

var file_google_cloud_channel_v1_entitlements_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x24, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31,
	0x2f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8d, 0x0a, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x3f, 0x0a, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x52, 0x05, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x12, 0x5c, 0x0a, 0x13, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x6d,
	0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x12,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x6a, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x61,
	0x0a, 0x13, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65,
	0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x70,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x69, 0x0a, 0x12, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x18, 0x12, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x73, 0x75, 0x73, 0x70, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x12, 0x2f, 0x0a, 0x11,
	0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x70, 0x75,
	0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x49, 0x64, 0x12, 0x52, 0x0a,
	0x0e, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67,
	0x73, 0x12, 0x53, 0x0a, 0x10, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e,
	0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x42, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x18, 0x1a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65,
	0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x0a,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x52, 0x0a, 0x11, 0x50, 0x72,
	0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x22, 0x0a, 0x1e, 0x50, 0x52, 0x4f, 0x56, 0x49, 0x53, 0x49, 0x4f, 0x4e, 0x49, 0x4e, 0x47, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12,
	0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x05, 0x22, 0xa3,
	0x01, 0x0a, 0x10, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x53, 0x49, 0x4f,
	0x4e, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x45, 0x4c, 0x4c,
	0x45, 0x52, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x5f, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x1c, 0x0a, 0x18, 0x52, 0x45, 0x4e, 0x45, 0x57, 0x41, 0x4c, 0x5f, 0x57, 0x49, 0x54, 0x48, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x10, 0x03, 0x12, 0x1a, 0x0a,
	0x16, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x4f, 0x53, 0x5f, 0x41, 0x43, 0x43,
	0x45, 0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48,
	0x45, 0x52, 0x10, 0x64, 0x3a, 0x70, 0xea, 0x41, 0x6d, 0x0a, 0x27, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x42, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73,
	0x2f, 0x7b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x22, 0x76, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a,
	0x08, 0x65, 0x64, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x65, 0x64, 0x69, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x6a,
	0x0a, 0x0f, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x57, 0x0a, 0x10, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0f, 0x62, 0x61, 0x73, 0x65, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x82, 0x01, 0x0a, 0x12, 0x50,
	0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0e, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x49, 0x64, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x06, 0x73, 0x6b, 0x75, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x6b, 0x75, 0x49, 0x64, 0x22,
	0xea, 0x01, 0x0a, 0x12, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x58, 0x0a, 0x10, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e,
	0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x6e,
	0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x22, 0xf3, 0x01, 0x0a,
	0x0f, 0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73,
	0x12, 0x25, 0x0a, 0x0e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x6e, 0x65, 0x77,
	0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x65, 0x6e, 0x65, 0x77, 0x61, 0x6c, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x69, 0x7a,
	0x65, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x55, 0x6e, 0x69, 0x74, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x47, 0x0a, 0x0c, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70,
	0x6c, 0x61, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x52,
	0x0b, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6c, 0x61, 0x6e, 0x12, 0x44, 0x0a, 0x0d,
	0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65,
	0x72, 0x69, 0x6f, 0x64, 0x52, 0x0c, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x79, 0x63,
	0x6c, 0x65, 0x22, 0x5c, 0x0a, 0x0d, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x22, 0xe4, 0x01, 0x0a, 0x0f, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x61, 0x62, 0x6c,
	0x65, 0x53, 0x6b, 0x75, 0x12, 0x5f, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x5f, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x2e, 0x0a, 0x03, 0x73, 0x6b, 0x75, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x75,
	0x52, 0x03, 0x73, 0x6b, 0x75, 0x12, 0x40, 0x0a, 0x0a, 0x6c, 0x65, 0x67, 0x61, 0x63, 0x79, 0x5f,
	0x73, 0x6b, 0x75, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x75, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6c, 0x65,
	0x67, 0x61, 0x63, 0x79, 0x53, 0x6b, 0x75, 0x22, 0xa7, 0x02, 0x0a, 0x13, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12,
	0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x66, 0x0a, 0x14, 0x69, 0x6e, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x45, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x2e, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x52, 0x13, 0x69, 0x6e, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x65, 0x0a, 0x06, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16,
	0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x4f, 0x53, 0x5f, 0x41, 0x43, 0x43, 0x45,
	0x50, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x53, 0x4b, 0x55, 0x5f,
	0x4e, 0x4f, 0x54, 0x5f, 0x45, 0x4c, 0x49, 0x47, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x11,
	0x0a, 0x0d, 0x53, 0x4b, 0x55, 0x5f, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10,
	0x03, 0x42, 0x72, 0x0a, 0x1b, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e, 0x76, 0x31,
	0x42, 0x11, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_channel_v1_entitlements_proto_rawDescOnce sync.Once
	file_google_cloud_channel_v1_entitlements_proto_rawDescData = file_google_cloud_channel_v1_entitlements_proto_rawDesc
)

func file_google_cloud_channel_v1_entitlements_proto_rawDescGZIP() []byte {
	file_google_cloud_channel_v1_entitlements_proto_rawDescOnce.Do(func() {
		file_google_cloud_channel_v1_entitlements_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_channel_v1_entitlements_proto_rawDescData)
	})
	return file_google_cloud_channel_v1_entitlements_proto_rawDescData
}

var file_google_cloud_channel_v1_entitlements_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_channel_v1_entitlements_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_channel_v1_entitlements_proto_goTypes = []interface{}{
	(Entitlement_ProvisioningState)(0), // 0: google.cloud.channel.v1.Entitlement.ProvisioningState
	(Entitlement_SuspensionReason)(0),  // 1: google.cloud.channel.v1.Entitlement.SuspensionReason
	(TransferEligibility_Reason)(0),    // 2: google.cloud.channel.v1.TransferEligibility.Reason
	(*Entitlement)(nil),                // 3: google.cloud.channel.v1.Entitlement
	(*Parameter)(nil),                  // 4: google.cloud.channel.v1.Parameter
	(*AssociationInfo)(nil),            // 5: google.cloud.channel.v1.AssociationInfo
	(*ProvisionedService)(nil),         // 6: google.cloud.channel.v1.ProvisionedService
	(*CommitmentSettings)(nil),         // 7: google.cloud.channel.v1.CommitmentSettings
	(*RenewalSettings)(nil),            // 8: google.cloud.channel.v1.RenewalSettings
	(*TrialSettings)(nil),              // 9: google.cloud.channel.v1.TrialSettings
	(*TransferableSku)(nil),            // 10: google.cloud.channel.v1.TransferableSku
	(*TransferEligibility)(nil),        // 11: google.cloud.channel.v1.TransferEligibility
	(*timestamp.Timestamp)(nil),        // 12: google.protobuf.Timestamp
	(*Value)(nil),                      // 13: google.cloud.channel.v1.Value
	(PaymentPlan)(0),                   // 14: google.cloud.channel.v1.PaymentPlan
	(*Period)(nil),                     // 15: google.cloud.channel.v1.Period
	(*Sku)(nil),                        // 16: google.cloud.channel.v1.Sku
}
var file_google_cloud_channel_v1_entitlements_proto_depIdxs = []int32{
	12, // 0: google.cloud.channel.v1.Entitlement.create_time:type_name -> google.protobuf.Timestamp
	12, // 1: google.cloud.channel.v1.Entitlement.update_time:type_name -> google.protobuf.Timestamp
	7,  // 2: google.cloud.channel.v1.Entitlement.commitment_settings:type_name -> google.cloud.channel.v1.CommitmentSettings
	0,  // 3: google.cloud.channel.v1.Entitlement.provisioning_state:type_name -> google.cloud.channel.v1.Entitlement.ProvisioningState
	6,  // 4: google.cloud.channel.v1.Entitlement.provisioned_service:type_name -> google.cloud.channel.v1.ProvisionedService
	1,  // 5: google.cloud.channel.v1.Entitlement.suspension_reasons:type_name -> google.cloud.channel.v1.Entitlement.SuspensionReason
	9,  // 6: google.cloud.channel.v1.Entitlement.trial_settings:type_name -> google.cloud.channel.v1.TrialSettings
	5,  // 7: google.cloud.channel.v1.Entitlement.association_info:type_name -> google.cloud.channel.v1.AssociationInfo
	4,  // 8: google.cloud.channel.v1.Entitlement.parameters:type_name -> google.cloud.channel.v1.Parameter
	13, // 9: google.cloud.channel.v1.Parameter.value:type_name -> google.cloud.channel.v1.Value
	12, // 10: google.cloud.channel.v1.CommitmentSettings.start_time:type_name -> google.protobuf.Timestamp
	12, // 11: google.cloud.channel.v1.CommitmentSettings.end_time:type_name -> google.protobuf.Timestamp
	8,  // 12: google.cloud.channel.v1.CommitmentSettings.renewal_settings:type_name -> google.cloud.channel.v1.RenewalSettings
	14, // 13: google.cloud.channel.v1.RenewalSettings.payment_plan:type_name -> google.cloud.channel.v1.PaymentPlan
	15, // 14: google.cloud.channel.v1.RenewalSettings.payment_cycle:type_name -> google.cloud.channel.v1.Period
	12, // 15: google.cloud.channel.v1.TrialSettings.end_time:type_name -> google.protobuf.Timestamp
	11, // 16: google.cloud.channel.v1.TransferableSku.transfer_eligibility:type_name -> google.cloud.channel.v1.TransferEligibility
	16, // 17: google.cloud.channel.v1.TransferableSku.sku:type_name -> google.cloud.channel.v1.Sku
	16, // 18: google.cloud.channel.v1.TransferableSku.legacy_sku:type_name -> google.cloud.channel.v1.Sku
	2,  // 19: google.cloud.channel.v1.TransferEligibility.ineligibility_reason:type_name -> google.cloud.channel.v1.TransferEligibility.Reason
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_channel_v1_entitlements_proto_init() }
func file_google_cloud_channel_v1_entitlements_proto_init() {
	if File_google_cloud_channel_v1_entitlements_proto != nil {
		return
	}
	file_google_cloud_channel_v1_common_proto_init()
	file_google_cloud_channel_v1_offers_proto_init()
	file_google_cloud_channel_v1_products_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_channel_v1_entitlements_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Entitlement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_entitlements_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Parameter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_entitlements_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AssociationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_entitlements_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ProvisionedService); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_entitlements_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CommitmentSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_entitlements_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenewalSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_entitlements_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TrialSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_entitlements_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferableSku); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_channel_v1_entitlements_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TransferEligibility); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_channel_v1_entitlements_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_channel_v1_entitlements_proto_goTypes,
		DependencyIndexes: file_google_cloud_channel_v1_entitlements_proto_depIdxs,
		EnumInfos:         file_google_cloud_channel_v1_entitlements_proto_enumTypes,
		MessageInfos:      file_google_cloud_channel_v1_entitlements_proto_msgTypes,
	}.Build()
	File_google_cloud_channel_v1_entitlements_proto = out.File
	file_google_cloud_channel_v1_entitlements_proto_rawDesc = nil
	file_google_cloud_channel_v1_entitlements_proto_goTypes = nil
	file_google_cloud_channel_v1_entitlements_proto_depIdxs = nil
}
