// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/spanner/admin/database/v1/backup.proto

package databasepb

import (
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the current state of the backup.
type Backup_State int32

const (
	// Not specified.
	Backup_STATE_UNSPECIFIED Backup_State = 0
	// The pending backup is still being created. Operations on the
	// backup may fail with `FAILED_PRECONDITION` in this state.
	Backup_CREATING Backup_State = 1
	// The backup is complete and ready for use.
	Backup_READY Backup_State = 2
)

// Enum value maps for Backup_State.
var (
	Backup_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
	}
	Backup_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
	}
)

func (x Backup_State) Enum() *Backup_State {
	p := new(Backup_State)
	*p = x
	return p
}

func (x Backup_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backup_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_database_v1_backup_proto_enumTypes[0].Descriptor()
}

func (Backup_State) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_database_v1_backup_proto_enumTypes[0]
}

func (x Backup_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backup_State.Descriptor instead.
func (Backup_State) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{0, 0}
}

// Encryption types for the backup.
type CreateBackupEncryptionConfig_EncryptionType int32

const (
	// Unspecified. Do not use.
	CreateBackupEncryptionConfig_ENCRYPTION_TYPE_UNSPECIFIED CreateBackupEncryptionConfig_EncryptionType = 0
	// Use the same encryption configuration as the database. This is the
	// default option when
	// [encryption_config][google.spanner.admin.database.v1.CreateBackupEncryptionConfig]
	// is empty. For example, if the database is using
	// `Customer_Managed_Encryption`, the backup will be using the same Cloud
	// KMS key as the database.
	CreateBackupEncryptionConfig_USE_DATABASE_ENCRYPTION CreateBackupEncryptionConfig_EncryptionType = 1
	// Use Google default encryption.
	CreateBackupEncryptionConfig_GOOGLE_DEFAULT_ENCRYPTION CreateBackupEncryptionConfig_EncryptionType = 2
	// Use customer managed encryption. If specified, `kms_key_name`
	// must contain a valid Cloud KMS key.
	CreateBackupEncryptionConfig_CUSTOMER_MANAGED_ENCRYPTION CreateBackupEncryptionConfig_EncryptionType = 3
)

// Enum value maps for CreateBackupEncryptionConfig_EncryptionType.
var (
	CreateBackupEncryptionConfig_EncryptionType_name = map[int32]string{
		0: "ENCRYPTION_TYPE_UNSPECIFIED",
		1: "USE_DATABASE_ENCRYPTION",
		2: "GOOGLE_DEFAULT_ENCRYPTION",
		3: "CUSTOMER_MANAGED_ENCRYPTION",
	}
	CreateBackupEncryptionConfig_EncryptionType_value = map[string]int32{
		"ENCRYPTION_TYPE_UNSPECIFIED": 0,
		"USE_DATABASE_ENCRYPTION":     1,
		"GOOGLE_DEFAULT_ENCRYPTION":   2,
		"CUSTOMER_MANAGED_ENCRYPTION": 3,
	}
)

func (x CreateBackupEncryptionConfig_EncryptionType) Enum() *CreateBackupEncryptionConfig_EncryptionType {
	p := new(CreateBackupEncryptionConfig_EncryptionType)
	*p = x
	return p
}

func (x CreateBackupEncryptionConfig_EncryptionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CreateBackupEncryptionConfig_EncryptionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_database_v1_backup_proto_enumTypes[1].Descriptor()
}

func (CreateBackupEncryptionConfig_EncryptionType) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_database_v1_backup_proto_enumTypes[1]
}

func (x CreateBackupEncryptionConfig_EncryptionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CreateBackupEncryptionConfig_EncryptionType.Descriptor instead.
func (CreateBackupEncryptionConfig_EncryptionType) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{13, 0}
}

// Encryption types for the backup.
type CopyBackupEncryptionConfig_EncryptionType int32

const (
	// Unspecified. Do not use.
	CopyBackupEncryptionConfig_ENCRYPTION_TYPE_UNSPECIFIED CopyBackupEncryptionConfig_EncryptionType = 0
	// This is the default option for
	// [CopyBackup][google.spanner.admin.database.v1.DatabaseAdmin.CopyBackup]
	// when
	// [encryption_config][google.spanner.admin.database.v1.CopyBackupEncryptionConfig]
	// is not specified. For example, if the source backup is using
	// `Customer_Managed_Encryption`, the backup will be using the same Cloud
	// KMS key as the source backup.
	CopyBackupEncryptionConfig_USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION CopyBackupEncryptionConfig_EncryptionType = 1
	// Use Google default encryption.
	CopyBackupEncryptionConfig_GOOGLE_DEFAULT_ENCRYPTION CopyBackupEncryptionConfig_EncryptionType = 2
	// Use customer managed encryption. If specified, either `kms_key_name` or
	// `kms_key_names` must contain valid Cloud KMS key(s).
	CopyBackupEncryptionConfig_CUSTOMER_MANAGED_ENCRYPTION CopyBackupEncryptionConfig_EncryptionType = 3
)

// Enum value maps for CopyBackupEncryptionConfig_EncryptionType.
var (
	CopyBackupEncryptionConfig_EncryptionType_name = map[int32]string{
		0: "ENCRYPTION_TYPE_UNSPECIFIED",
		1: "USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION",
		2: "GOOGLE_DEFAULT_ENCRYPTION",
		3: "CUSTOMER_MANAGED_ENCRYPTION",
	}
	CopyBackupEncryptionConfig_EncryptionType_value = map[string]int32{
		"ENCRYPTION_TYPE_UNSPECIFIED":             0,
		"USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION": 1,
		"GOOGLE_DEFAULT_ENCRYPTION":               2,
		"CUSTOMER_MANAGED_ENCRYPTION":             3,
	}
)

func (x CopyBackupEncryptionConfig_EncryptionType) Enum() *CopyBackupEncryptionConfig_EncryptionType {
	p := new(CopyBackupEncryptionConfig_EncryptionType)
	*p = x
	return p
}

func (x CopyBackupEncryptionConfig_EncryptionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CopyBackupEncryptionConfig_EncryptionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_database_v1_backup_proto_enumTypes[2].Descriptor()
}

func (CopyBackupEncryptionConfig_EncryptionType) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_database_v1_backup_proto_enumTypes[2]
}

func (x CopyBackupEncryptionConfig_EncryptionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CopyBackupEncryptionConfig_EncryptionType.Descriptor instead.
func (CopyBackupEncryptionConfig_EncryptionType) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{14, 0}
}

// A backup of a Cloud Spanner database.
type Backup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required for the
	// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
	// operation. Name of the database from which this backup was created. This
	// needs to be in the same instance as the backup. Values are of the form
	// `projects/<project>/instances/<instance>/databases/<database>`.
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// The backup will contain an externally consistent copy of the database at
	// the timestamp specified by `version_time`. If `version_time` is not
	// specified, the system will set `version_time` to the `create_time` of the
	// backup.
	VersionTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=version_time,json=versionTime,proto3" json:"version_time,omitempty"`
	// Required for the
	// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
	// operation. The expiration time of the backup, with microseconds
	// granularity that must be at least 6 hours and at most 366 days
	// from the time the CreateBackup request is processed. Once the `expire_time`
	// has passed, the backup is eligible to be automatically deleted by Cloud
	// Spanner to free the resources used by the backup.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only for the
	// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
	// operation. Required for the
	// [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup]
	// operation.
	//
	// A globally unique identifier for the backup which cannot be
	// changed. Values are of the form
	// `projects/<project>/instances/<instance>/backups/[a-z][a-z0-9_\-]*[a-z0-9]`
	// The final segment of the name must be between 2 and 60 characters
	// in length.
	//
	// The backup is stored in the location(s) specified in the instance
	// configuration of the instance containing the backup, identified
	// by the prefix of the backup name of the form
	// `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time the
	// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
	// request is received. If the request does not specify `version_time`, the
	// `version_time` of the backup will be equivalent to the `create_time`.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Size of the backup in bytes.
	SizeBytes int64 `protobuf:"varint,5,opt,name=size_bytes,json=sizeBytes,proto3" json:"size_bytes,omitempty"`
	// Output only. The current state of the backup.
	State Backup_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.spanner.admin.database.v1.Backup_State" json:"state,omitempty"`
	// Output only. The names of the restored databases that reference the backup.
	// The database names are of
	// the form `projects/<project>/instances/<instance>/databases/<database>`.
	// Referencing databases may exist in different instances. The existence of
	// any referencing database prevents the backup from being deleted. When a
	// restored database from the backup enters the `READY` state, the reference
	// to the backup is removed.
	ReferencingDatabases []string `protobuf:"bytes,7,rep,name=referencing_databases,json=referencingDatabases,proto3" json:"referencing_databases,omitempty"`
	// Output only. The encryption information for the backup.
	EncryptionInfo *EncryptionInfo `protobuf:"bytes,8,opt,name=encryption_info,json=encryptionInfo,proto3" json:"encryption_info,omitempty"`
	// Output only. The encryption information for the backup, whether it is
	// protected by one or more KMS keys. The information includes all Cloud
	// KMS key versions used to encrypt the backup. The `encryption_status' field
	// inside of each `EncryptionInfo` is not populated. At least one of the key
	// versions must be available for the backup to be restored. If a key version
	// is revoked in the middle of a restore, the restore behavior is undefined.
	EncryptionInformation []*EncryptionInfo `protobuf:"bytes,13,rep,name=encryption_information,json=encryptionInformation,proto3" json:"encryption_information,omitempty"`
	// Output only. The database dialect information for the backup.
	DatabaseDialect DatabaseDialect `protobuf:"varint,10,opt,name=database_dialect,json=databaseDialect,proto3,enum=google.spanner.admin.database.v1.DatabaseDialect" json:"database_dialect,omitempty"`
	// Output only. The names of the destination backups being created by copying
	// this source backup. The backup names are of the form
	// `projects/<project>/instances/<instance>/backups/<backup>`.
	// Referencing backups may exist in different instances. The existence of
	// any referencing backup prevents the backup from being deleted. When the
	// copy operation is done (either successfully completed or cancelled or the
	// destination backup is deleted), the reference to the backup is removed.
	ReferencingBackups []string `protobuf:"bytes,11,rep,name=referencing_backups,json=referencingBackups,proto3" json:"referencing_backups,omitempty"`
	// Output only. The max allowed expiration time of the backup, with
	// microseconds granularity. A backup's expiration time can be configured in
	// multiple APIs: CreateBackup, UpdateBackup, CopyBackup. When updating or
	// copying an existing backup, the expiration time specified must be
	// less than `Backup.max_expire_time`.
	MaxExpireTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=max_expire_time,json=maxExpireTime,proto3" json:"max_expire_time,omitempty"`
}

func (x *Backup) Reset() {
	*x = Backup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Backup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backup) ProtoMessage() {}

func (x *Backup) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backup.ProtoReflect.Descriptor instead.
func (*Backup) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{0}
}

func (x *Backup) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *Backup) GetVersionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.VersionTime
	}
	return nil
}

func (x *Backup) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *Backup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Backup) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Backup) GetSizeBytes() int64 {
	if x != nil {
		return x.SizeBytes
	}
	return 0
}

func (x *Backup) GetState() Backup_State {
	if x != nil {
		return x.State
	}
	return Backup_STATE_UNSPECIFIED
}

func (x *Backup) GetReferencingDatabases() []string {
	if x != nil {
		return x.ReferencingDatabases
	}
	return nil
}

func (x *Backup) GetEncryptionInfo() *EncryptionInfo {
	if x != nil {
		return x.EncryptionInfo
	}
	return nil
}

func (x *Backup) GetEncryptionInformation() []*EncryptionInfo {
	if x != nil {
		return x.EncryptionInformation
	}
	return nil
}

func (x *Backup) GetDatabaseDialect() DatabaseDialect {
	if x != nil {
		return x.DatabaseDialect
	}
	return DatabaseDialect_DATABASE_DIALECT_UNSPECIFIED
}

func (x *Backup) GetReferencingBackups() []string {
	if x != nil {
		return x.ReferencingBackups
	}
	return nil
}

func (x *Backup) GetMaxExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MaxExpireTime
	}
	return nil
}

// The request for
// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup].
type CreateBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance in which the backup will be
	// created. This must be the same instance that contains the database the
	// backup will be created from. The backup will be stored in the
	// location(s) specified in the instance configuration of this
	// instance. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the backup to be created. The `backup_id` appended to
	// `parent` forms the full backup name of the form
	// `projects/<project>/instances/<instance>/backups/<backup_id>`.
	BackupId string `protobuf:"bytes,2,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Required. The backup to create.
	Backup *Backup `protobuf:"bytes,3,opt,name=backup,proto3" json:"backup,omitempty"`
	// Optional. The encryption configuration used to encrypt the backup. If this
	// field is not specified, the backup will use the same encryption
	// configuration as the database by default, namely
	// [encryption_type][google.spanner.admin.database.v1.CreateBackupEncryptionConfig.encryption_type]
	// = `USE_DATABASE_ENCRYPTION`.
	EncryptionConfig *CreateBackupEncryptionConfig `protobuf:"bytes,4,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
}

func (x *CreateBackupRequest) Reset() {
	*x = CreateBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupRequest) ProtoMessage() {}

func (x *CreateBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{1}
}

func (x *CreateBackupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupRequest) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

func (x *CreateBackupRequest) GetBackup() *Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

func (x *CreateBackupRequest) GetEncryptionConfig() *CreateBackupEncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

// Metadata type for the operation returned by
// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup].
type CreateBackupMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the backup being created.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the database the backup is created from.
	Database string `protobuf:"bytes,2,opt,name=database,proto3" json:"database,omitempty"`
	// The progress of the
	// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
	// operation.
	Progress *OperationProgress `protobuf:"bytes,3,opt,name=progress,proto3" json:"progress,omitempty"`
	// The time at which cancellation of this operation was received.
	// [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
	// starts asynchronous cancellation on a long-running operation. The server
	// makes a best effort to cancel the operation, but success is not guaranteed.
	// Clients can use
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
	// other methods to check whether the cancellation succeeded or whether the
	// operation completed despite cancellation. On successful cancellation,
	// the operation is not deleted; instead, it becomes an operation with
	// an [Operation.error][google.longrunning.Operation.error] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
}

func (x *CreateBackupMetadata) Reset() {
	*x = CreateBackupMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBackupMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupMetadata) ProtoMessage() {}

func (x *CreateBackupMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupMetadata.ProtoReflect.Descriptor instead.
func (*CreateBackupMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{2}
}

func (x *CreateBackupMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CreateBackupMetadata) GetDatabase() string {
	if x != nil {
		return x.Database
	}
	return ""
}

func (x *CreateBackupMetadata) GetProgress() *OperationProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *CreateBackupMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

// The request for
// [CopyBackup][google.spanner.admin.database.v1.DatabaseAdmin.CopyBackup].
type CopyBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the destination instance that will contain the backup
	// copy. Values are of the form: `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The id of the backup copy.
	// The `backup_id` appended to `parent` forms the full backup_uri of the form
	// `projects/<project>/instances/<instance>/backups/<backup>`.
	BackupId string `protobuf:"bytes,2,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
	// Required. The source backup to be copied.
	// The source backup needs to be in READY state for it to be copied.
	// Once CopyBackup is in progress, the source backup cannot be deleted or
	// cleaned up on expiration until CopyBackup is finished.
	// Values are of the form:
	// `projects/<project>/instances/<instance>/backups/<backup>`.
	SourceBackup string `protobuf:"bytes,3,opt,name=source_backup,json=sourceBackup,proto3" json:"source_backup,omitempty"`
	// Required. The expiration time of the backup in microsecond granularity.
	// The expiration time must be at least 6 hours and at most 366 days
	// from the `create_time` of the source backup. Once the `expire_time` has
	// passed, the backup is eligible to be automatically deleted by Cloud Spanner
	// to free the resources used by the backup.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Optional. The encryption configuration used to encrypt the backup. If this
	// field is not specified, the backup will use the same encryption
	// configuration as the source backup by default, namely
	// [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
	// = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
	EncryptionConfig *CopyBackupEncryptionConfig `protobuf:"bytes,5,opt,name=encryption_config,json=encryptionConfig,proto3" json:"encryption_config,omitempty"`
}

func (x *CopyBackupRequest) Reset() {
	*x = CopyBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CopyBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CopyBackupRequest) ProtoMessage() {}

func (x *CopyBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CopyBackupRequest.ProtoReflect.Descriptor instead.
func (*CopyBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{3}
}

func (x *CopyBackupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CopyBackupRequest) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

func (x *CopyBackupRequest) GetSourceBackup() string {
	if x != nil {
		return x.SourceBackup
	}
	return ""
}

func (x *CopyBackupRequest) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *CopyBackupRequest) GetEncryptionConfig() *CopyBackupEncryptionConfig {
	if x != nil {
		return x.EncryptionConfig
	}
	return nil
}

// Metadata type for the operation returned by
// [CopyBackup][google.spanner.admin.database.v1.DatabaseAdmin.CopyBackup].
type CopyBackupMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the backup being created through the copy operation.
	// Values are of the form
	// `projects/<project>/instances/<instance>/backups/<backup>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the source backup that is being copied.
	// Values are of the form
	// `projects/<project>/instances/<instance>/backups/<backup>`.
	SourceBackup string `protobuf:"bytes,2,opt,name=source_backup,json=sourceBackup,proto3" json:"source_backup,omitempty"`
	// The progress of the
	// [CopyBackup][google.spanner.admin.database.v1.DatabaseAdmin.CopyBackup]
	// operation.
	Progress *OperationProgress `protobuf:"bytes,3,opt,name=progress,proto3" json:"progress,omitempty"`
	// The time at which cancellation of CopyBackup operation was received.
	// [Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
	// starts asynchronous cancellation on a long-running operation. The server
	// makes a best effort to cancel the operation, but success is not guaranteed.
	// Clients can use
	// [Operations.GetOperation][google.longrunning.Operations.GetOperation] or
	// other methods to check whether the cancellation succeeded or whether the
	// operation completed despite cancellation. On successful cancellation,
	// the operation is not deleted; instead, it becomes an operation with
	// an [Operation.error][google.longrunning.Operation.error] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
}

func (x *CopyBackupMetadata) Reset() {
	*x = CopyBackupMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CopyBackupMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CopyBackupMetadata) ProtoMessage() {}

func (x *CopyBackupMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CopyBackupMetadata.ProtoReflect.Descriptor instead.
func (*CopyBackupMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{4}
}

func (x *CopyBackupMetadata) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CopyBackupMetadata) GetSourceBackup() string {
	if x != nil {
		return x.SourceBackup
	}
	return ""
}

func (x *CopyBackupMetadata) GetProgress() *OperationProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *CopyBackupMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

// The request for
// [UpdateBackup][google.spanner.admin.database.v1.DatabaseAdmin.UpdateBackup].
type UpdateBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The backup to update. `backup.name`, and the fields to be updated
	// as specified by `update_mask` are required. Other fields are ignored.
	// Update is only supported for the following fields:
	//   - `backup.expire_time`.
	Backup *Backup `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
	// Required. A mask specifying which fields (e.g. `expire_time`) in the
	// Backup resource should be updated. This mask is relative to the Backup
	// resource, not to the request message. The field mask must always be
	// specified; this prevents any future fields from being erased accidentally
	// by clients that do not know about them.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBackupRequest) Reset() {
	*x = UpdateBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBackupRequest) ProtoMessage() {}

func (x *UpdateBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBackupRequest.ProtoReflect.Descriptor instead.
func (*UpdateBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateBackupRequest) GetBackup() *Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

func (x *UpdateBackupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request for
// [GetBackup][google.spanner.admin.database.v1.DatabaseAdmin.GetBackup].
type GetBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the backup.
	// Values are of the form
	// `projects/<project>/instances/<instance>/backups/<backup>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupRequest) Reset() {
	*x = GetBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupRequest) ProtoMessage() {}

func (x *GetBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupRequest.ProtoReflect.Descriptor instead.
func (*GetBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{6}
}

func (x *GetBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [DeleteBackup][google.spanner.admin.database.v1.DatabaseAdmin.DeleteBackup].
type DeleteBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the backup to delete.
	// Values are of the form
	// `projects/<project>/instances/<instance>/backups/<backup>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBackupRequest) Reset() {
	*x = DeleteBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupRequest) ProtoMessage() {}

func (x *DeleteBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{7}
}

func (x *DeleteBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [ListBackups][google.spanner.admin.database.v1.DatabaseAdmin.ListBackups].
type ListBackupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance to list backups from.  Values are of the
	// form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression that filters the list of returned backups.
	//
	// A filter expression consists of a field name, a comparison operator, and a
	// value for filtering.
	// The value must be a string, a number, or a boolean. The comparison operator
	// must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
	// Colon `:` is the contains operator. Filter rules are not case sensitive.
	//
	// The following fields in the
	// [Backup][google.spanner.admin.database.v1.Backup] are eligible for
	// filtering:
	//
	//   - `name`
	//   - `database`
	//   - `state`
	//   - `create_time`  (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
	//   - `expire_time`  (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
	//   - `version_time` (and values are of the format YYYY-MM-DDTHH:MM:SSZ)
	//   - `size_bytes`
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. By default, expressions are combined with AND logic, but
	// you can specify AND, OR, and NOT logic explicitly.
	//
	// Here are a few examples:
	//
	//   - `name:Howl` - The backup's name contains the string "howl".
	//   - `database:prod`
	//   - The database's name contains the string "prod".
	//   - `state:CREATING` - The backup is pending creation.
	//   - `state:READY` - The backup is fully created and ready for use.
	//   - `(name:howl) AND (create_time < \"2018-03-28T14:50:00Z\")`
	//   - The backup name contains the string "howl" and `create_time`
	//     of the backup is before 2018-03-28T14:50:00Z.
	//   - `expire_time < \"2018-03-28T14:50:00Z\"`
	//   - The backup `expire_time` is before 2018-03-28T14:50:00Z.
	//   - `size_bytes > 10000000000` - The backup's size is greater than 10GB
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of backups to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.database.v1.ListBackupsResponse.next_page_token]
	// from a previous
	// [ListBackupsResponse][google.spanner.admin.database.v1.ListBackupsResponse]
	// to the same `parent` and with the same `filter`.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBackupsRequest) Reset() {
	*x = ListBackupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsRequest) ProtoMessage() {}

func (x *ListBackupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{8}
}

func (x *ListBackupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ListBackups][google.spanner.admin.database.v1.DatabaseAdmin.ListBackups].
type ListBackupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching backups. Backups returned are ordered by `create_time`
	// in descending order, starting from the most recent `create_time`.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListBackups][google.spanner.admin.database.v1.DatabaseAdmin.ListBackups]
	// call to fetch more of the matching backups.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBackupsResponse) Reset() {
	*x = ListBackupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsResponse) ProtoMessage() {}

func (x *ListBackupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{9}
}

func (x *ListBackupsResponse) GetBackups() []*Backup {
	if x != nil {
		return x.Backups
	}
	return nil
}

func (x *ListBackupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [ListBackupOperations][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupOperations].
type ListBackupOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance of the backup operations. Values are of
	// the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression that filters the list of returned backup operations.
	//
	// A filter expression consists of a field name, a
	// comparison operator, and a value for filtering.
	// The value must be a string, a number, or a boolean. The comparison operator
	// must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
	// Colon `:` is the contains operator. Filter rules are not case sensitive.
	//
	// The following fields in the [operation][google.longrunning.Operation]
	// are eligible for filtering:
	//
	//   - `name` - The name of the long-running operation
	//   - `done` - False if the operation is in progress, else true.
	//   - `metadata.@type` - the type of metadata. For example, the type string
	//     for
	//     [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata]
	//     is
	//     `type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata`.
	//   - `metadata.<field_name>` - any field in metadata.value.
	//     `metadata.@type` must be specified first if filtering on metadata
	//     fields.
	//   - `error` - Error associated with the long-running operation.
	//   - `response.@type` - the type of response.
	//   - `response.<field_name>` - any field in response.value.
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. By default, expressions are combined with AND logic, but
	// you can specify AND, OR, and NOT logic explicitly.
	//
	// Here are a few examples:
	//
	//   - `done:true` - The operation is complete.
	//   - `(metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` \
	//     `metadata.database:prod` - Returns operations where:
	//   - The operation's metadata type is
	//     [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
	//   - The source database name of backup contains the string "prod".
	//   - `(metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` \
	//     `(metadata.name:howl) AND` \
	//     `(metadata.progress.start_time < \"2018-03-28T14:50:00Z\") AND` \
	//     `(error:*)` - Returns operations where:
	//   - The operation's metadata type is
	//     [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata].
	//   - The backup name contains the string "howl".
	//   - The operation started before 2018-03-28T14:50:00Z.
	//   - The operation resulted in an error.
	//   - `(metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata) AND` \
	//     `(metadata.source_backup:test) AND` \
	//     `(metadata.progress.start_time < \"2022-01-18T14:50:00Z\") AND` \
	//     `(error:*)` - Returns operations where:
	//   - The operation's metadata type is
	//     [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata].
	//   - The source backup name contains the string "test".
	//   - The operation started before 2022-01-18T14:50:00Z.
	//   - The operation resulted in an error.
	//   - `((metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CreateBackupMetadata) AND` \
	//     `(metadata.database:test_db)) OR` \
	//     `((metadata.@type=type.googleapis.com/google.spanner.admin.database.v1.CopyBackupMetadata)
	//     AND` \
	//     `(metadata.source_backup:test_bkp)) AND` \
	//     `(error:*)` - Returns operations where:
	//   - The operation's metadata matches either of criteria:
	//   - The operation's metadata type is
	//     [CreateBackupMetadata][google.spanner.admin.database.v1.CreateBackupMetadata]
	//     AND the source database name of the backup contains the string
	//     "test_db"
	//   - The operation's metadata type is
	//     [CopyBackupMetadata][google.spanner.admin.database.v1.CopyBackupMetadata]
	//     AND the source backup name contains the string "test_bkp"
	//   - The operation resulted in an error.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of operations to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.database.v1.ListBackupOperationsResponse.next_page_token]
	// from a previous
	// [ListBackupOperationsResponse][google.spanner.admin.database.v1.ListBackupOperationsResponse]
	// to the same `parent` and with the same `filter`.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListBackupOperationsRequest) Reset() {
	*x = ListBackupOperationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupOperationsRequest) ProtoMessage() {}

func (x *ListBackupOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{10}
}

func (x *ListBackupOperationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupOperationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListBackupOperationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ListBackupOperations][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupOperations].
type ListBackupOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching backup [long-running
	// operations][google.longrunning.Operation]. Each operation's name will be
	// prefixed by the backup's name. The operation's
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that are pending or have completed/failed/canceled within the
	// last 7 days. Operations returned are ordered by
	// `operation.metadata.value.progress.start_time` in descending order starting
	// from the most recently started operation.
	Operations []*longrunningpb.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListBackupOperations][google.spanner.admin.database.v1.DatabaseAdmin.ListBackupOperations]
	// call to fetch more of the matching metadata.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListBackupOperationsResponse) Reset() {
	*x = ListBackupOperationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupOperationsResponse) ProtoMessage() {}

func (x *ListBackupOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{11}
}

func (x *ListBackupOperationsResponse) GetOperations() []*longrunningpb.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListBackupOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Information about a backup.
type BackupInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the backup.
	Backup string `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
	// The backup contains an externally consistent copy of `source_database` at
	// the timestamp specified by `version_time`. If the
	// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
	// request did not specify `version_time`, the `version_time` of the backup is
	// equivalent to the `create_time`.
	VersionTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=version_time,json=versionTime,proto3" json:"version_time,omitempty"`
	// The time the
	// [CreateBackup][google.spanner.admin.database.v1.DatabaseAdmin.CreateBackup]
	// request was received.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Name of the database the backup was created from.
	SourceDatabase string `protobuf:"bytes,3,opt,name=source_database,json=sourceDatabase,proto3" json:"source_database,omitempty"`
}

func (x *BackupInfo) Reset() {
	*x = BackupInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BackupInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BackupInfo) ProtoMessage() {}

func (x *BackupInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BackupInfo.ProtoReflect.Descriptor instead.
func (*BackupInfo) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{12}
}

func (x *BackupInfo) GetBackup() string {
	if x != nil {
		return x.Backup
	}
	return ""
}

func (x *BackupInfo) GetVersionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.VersionTime
	}
	return nil
}

func (x *BackupInfo) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *BackupInfo) GetSourceDatabase() string {
	if x != nil {
		return x.SourceDatabase
	}
	return ""
}

// Encryption configuration for the backup to create.
type CreateBackupEncryptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The encryption type of the backup.
	EncryptionType CreateBackupEncryptionConfig_EncryptionType `protobuf:"varint,1,opt,name=encryption_type,json=encryptionType,proto3,enum=google.spanner.admin.database.v1.CreateBackupEncryptionConfig_EncryptionType" json:"encryption_type,omitempty"`
	// Optional. The Cloud KMS key that will be used to protect the backup.
	// This field should be set only when
	// [encryption_type][google.spanner.admin.database.v1.CreateBackupEncryptionConfig.encryption_type]
	// is `CUSTOMER_MANAGED_ENCRYPTION`. Values are of the form
	// `projects/<project>/locations/<location>/keyRings/<key_ring>/cryptoKeys/<kms_key_name>`.
	KmsKeyName string `protobuf:"bytes,2,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Optional. Specifies the KMS configuration for the one or more keys used to
	// protect the backup. Values are of the form
	// `projects/<project>/locations/<location>/keyRings/<key_ring>/cryptoKeys/<kms_key_name>`.
	//
	// The keys referenced by kms_key_names must fully cover all
	// regions of the backup's instance configuration. Some examples:
	// * For single region instance configs, specify a single regional
	// location KMS key.
	// * For multi-regional instance configs of type GOOGLE_MANAGED,
	// either specify a multi-regional location KMS key or multiple regional
	// location KMS keys that cover all regions in the instance config.
	// * For an instance config of type USER_MANAGED, please specify only
	// regional location KMS keys to cover each region in the instance config.
	// Multi-regional location KMS keys are not supported for USER_MANAGED
	// instance configs.
	KmsKeyNames []string `protobuf:"bytes,3,rep,name=kms_key_names,json=kmsKeyNames,proto3" json:"kms_key_names,omitempty"`
}

func (x *CreateBackupEncryptionConfig) Reset() {
	*x = CreateBackupEncryptionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBackupEncryptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupEncryptionConfig) ProtoMessage() {}

func (x *CreateBackupEncryptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupEncryptionConfig.ProtoReflect.Descriptor instead.
func (*CreateBackupEncryptionConfig) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{13}
}

func (x *CreateBackupEncryptionConfig) GetEncryptionType() CreateBackupEncryptionConfig_EncryptionType {
	if x != nil {
		return x.EncryptionType
	}
	return CreateBackupEncryptionConfig_ENCRYPTION_TYPE_UNSPECIFIED
}

func (x *CreateBackupEncryptionConfig) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *CreateBackupEncryptionConfig) GetKmsKeyNames() []string {
	if x != nil {
		return x.KmsKeyNames
	}
	return nil
}

// Encryption configuration for the copied backup.
type CopyBackupEncryptionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The encryption type of the backup.
	EncryptionType CopyBackupEncryptionConfig_EncryptionType `protobuf:"varint,1,opt,name=encryption_type,json=encryptionType,proto3,enum=google.spanner.admin.database.v1.CopyBackupEncryptionConfig_EncryptionType" json:"encryption_type,omitempty"`
	// Optional. The Cloud KMS key that will be used to protect the backup.
	// This field should be set only when
	// [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
	// is `CUSTOMER_MANAGED_ENCRYPTION`. Values are of the form
	// `projects/<project>/locations/<location>/keyRings/<key_ring>/cryptoKeys/<kms_key_name>`.
	KmsKeyName string `protobuf:"bytes,2,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Optional. Specifies the KMS configuration for the one or more keys used to
	// protect the backup. Values are of the form
	// `projects/<project>/locations/<location>/keyRings/<key_ring>/cryptoKeys/<kms_key_name>`.
	// Kms keys specified can be in any order.
	//
	// The keys referenced by kms_key_names must fully cover all
	// regions of the backup's instance configuration. Some examples:
	// * For single region instance configs, specify a single regional
	// location KMS key.
	// * For multi-regional instance configs of type GOOGLE_MANAGED,
	// either specify a multi-regional location KMS key or multiple regional
	// location KMS keys that cover all regions in the instance config.
	// * For an instance config of type USER_MANAGED, please specify only
	// regional location KMS keys to cover each region in the instance config.
	// Multi-regional location KMS keys are not supported for USER_MANAGED
	// instance configs.
	KmsKeyNames []string `protobuf:"bytes,3,rep,name=kms_key_names,json=kmsKeyNames,proto3" json:"kms_key_names,omitempty"`
}

func (x *CopyBackupEncryptionConfig) Reset() {
	*x = CopyBackupEncryptionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CopyBackupEncryptionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CopyBackupEncryptionConfig) ProtoMessage() {}

func (x *CopyBackupEncryptionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_database_v1_backup_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CopyBackupEncryptionConfig.ProtoReflect.Descriptor instead.
func (*CopyBackupEncryptionConfig) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP(), []int{14}
}

func (x *CopyBackupEncryptionConfig) GetEncryptionType() CopyBackupEncryptionConfig_EncryptionType {
	if x != nil {
		return x.EncryptionType
	}
	return CopyBackupEncryptionConfig_ENCRYPTION_TYPE_UNSPECIFIED
}

func (x *CopyBackupEncryptionConfig) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *CopyBackupEncryptionConfig) GetKmsKeyNames() []string {
	if x != nil {
		return x.KmsKeyNames
	}
	return nil
}

var File_google_spanner_admin_database_v1_backup_proto protoreflect.FileDescriptor

var file_google_spanner_admin_database_v1_backup_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd2, 0x08, 0x0a, 0x06, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12,
	0x40, 0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x12, 0x3d, 0x0a, 0x0c, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3b, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x69,
	0x7a, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x5c, 0x0a, 0x15, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e,
	0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x14, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73,
	0x12, 0x5e, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x6c, 0x0a, 0x16, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61,
	0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x65,
	0x63, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x44, 0x69, 0x61, 0x6c, 0x65, 0x63,
	0x74, 0x12, 0x56, 0x0a, 0x13, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e, 0x67,
	0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x25,
	0xe0, 0x41, 0x03, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x12, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69,
	0x6e, 0x67, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x47, 0x0a, 0x0f, 0x6d, 0x61, 0x78,
	0x5f, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6d, 0x61, 0x78, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0x37, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x3a, 0x5c, 0xea, 0x41, 0x59,
	0x0a, 0x1d, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12,
	0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73,
	0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x7d, 0x22, 0xb1, 0x02, 0x0a, 0x13, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x49, 0x64, 0x12, 0x45, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x70, 0x0a, 0x11, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x9e, 0x02,
	0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x52, 0x08, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x12, 0x4f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xf4,
	0x02, 0x0a, 0x11, 0x43, 0x6f, 0x70, 0x79, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x6e, 0x0a, 0x11, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x70, 0x79, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x45, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xa3, 0x02, 0x0a, 0x12, 0x43, 0x6f, 0x70, 0x79, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x36, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x0a,
	0x1d, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x47, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f,
	0x0a, 0x1d, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x4f, 0x0a,
	0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x3b,
	0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x9e, 0x01, 0x0a, 0x13,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x4d, 0x0a, 0x10,
	0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x50, 0x0a, 0x13, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x01,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x81, 0x01, 0x0a, 0x13, 0x4c, 0x69,
	0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x42, 0x0a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x07, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb2, 0x01,
	0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x85, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x93, 0x02, 0x0a, 0x0a, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x3a, 0x0a, 0x06, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xfa, 0x41, 0x1f, 0x0a, 0x1d,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x06, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x3d, 0x0a, 0x0c, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x4d, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xfa, 0x41, 0x21, 0x0a,
	0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x22, 0xc8, 0x03, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x7b, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4b,
	0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52,
	0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x0d, 0x6b,
	0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0b, 0x6b,
	0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x22, 0x8e, 0x01, 0x0a, 0x0e, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a,
	0x1b, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1b,
	0x0a, 0x17, 0x55, 0x53, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x45,
	0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x47,
	0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x45, 0x4e,
	0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x55,
	0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x45,
	0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x22, 0xd4, 0x03, 0x0a, 0x1a,
	0x43, 0x6f, 0x70, 0x79, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x79, 0x0a, 0x0f, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x62,
	0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x70, 0x79, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x0d, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74,
	0x6f, 0x4b, 0x65, 0x79, 0x52, 0x0b, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x73, 0x22, 0x9e, 0x01, 0x0a, 0x0e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x2b, 0x0a, 0x27, 0x55, 0x53, 0x45, 0x5f, 0x43, 0x4f, 0x4e,
	0x46, 0x49, 0x47, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x5f, 0x4f, 0x52, 0x5f, 0x42,
	0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x44, 0x45, 0x46,
	0x41, 0x55, 0x4c, 0x54, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x10,
	0x02, 0x12, 0x1f, 0x0a, 0x1b, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d, 0x45, 0x52, 0x5f, 0x4d, 0x41,
	0x4e, 0x41, 0x47, 0x45, 0x44, 0x5f, 0x45, 0x4e, 0x43, 0x52, 0x59, 0x50, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x03, 0x42, 0xfd, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x46, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65,
	0x70, 0x62, 0xaa, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x26, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3a, 0x3a, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_admin_database_v1_backup_proto_rawDescOnce sync.Once
	file_google_spanner_admin_database_v1_backup_proto_rawDescData = file_google_spanner_admin_database_v1_backup_proto_rawDesc
)

func file_google_spanner_admin_database_v1_backup_proto_rawDescGZIP() []byte {
	file_google_spanner_admin_database_v1_backup_proto_rawDescOnce.Do(func() {
		file_google_spanner_admin_database_v1_backup_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_admin_database_v1_backup_proto_rawDescData)
	})
	return file_google_spanner_admin_database_v1_backup_proto_rawDescData
}

var file_google_spanner_admin_database_v1_backup_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_spanner_admin_database_v1_backup_proto_msgTypes = make([]protoimpl.MessageInfo, 15)
var file_google_spanner_admin_database_v1_backup_proto_goTypes = []any{
	(Backup_State)(0), // 0: google.spanner.admin.database.v1.Backup.State
	(CreateBackupEncryptionConfig_EncryptionType)(0), // 1: google.spanner.admin.database.v1.CreateBackupEncryptionConfig.EncryptionType
	(CopyBackupEncryptionConfig_EncryptionType)(0),   // 2: google.spanner.admin.database.v1.CopyBackupEncryptionConfig.EncryptionType
	(*Backup)(nil),                       // 3: google.spanner.admin.database.v1.Backup
	(*CreateBackupRequest)(nil),          // 4: google.spanner.admin.database.v1.CreateBackupRequest
	(*CreateBackupMetadata)(nil),         // 5: google.spanner.admin.database.v1.CreateBackupMetadata
	(*CopyBackupRequest)(nil),            // 6: google.spanner.admin.database.v1.CopyBackupRequest
	(*CopyBackupMetadata)(nil),           // 7: google.spanner.admin.database.v1.CopyBackupMetadata
	(*UpdateBackupRequest)(nil),          // 8: google.spanner.admin.database.v1.UpdateBackupRequest
	(*GetBackupRequest)(nil),             // 9: google.spanner.admin.database.v1.GetBackupRequest
	(*DeleteBackupRequest)(nil),          // 10: google.spanner.admin.database.v1.DeleteBackupRequest
	(*ListBackupsRequest)(nil),           // 11: google.spanner.admin.database.v1.ListBackupsRequest
	(*ListBackupsResponse)(nil),          // 12: google.spanner.admin.database.v1.ListBackupsResponse
	(*ListBackupOperationsRequest)(nil),  // 13: google.spanner.admin.database.v1.ListBackupOperationsRequest
	(*ListBackupOperationsResponse)(nil), // 14: google.spanner.admin.database.v1.ListBackupOperationsResponse
	(*BackupInfo)(nil),                   // 15: google.spanner.admin.database.v1.BackupInfo
	(*CreateBackupEncryptionConfig)(nil), // 16: google.spanner.admin.database.v1.CreateBackupEncryptionConfig
	(*CopyBackupEncryptionConfig)(nil),   // 17: google.spanner.admin.database.v1.CopyBackupEncryptionConfig
	(*timestamppb.Timestamp)(nil),        // 18: google.protobuf.Timestamp
	(*EncryptionInfo)(nil),               // 19: google.spanner.admin.database.v1.EncryptionInfo
	(DatabaseDialect)(0),                 // 20: google.spanner.admin.database.v1.DatabaseDialect
	(*OperationProgress)(nil),            // 21: google.spanner.admin.database.v1.OperationProgress
	(*fieldmaskpb.FieldMask)(nil),        // 22: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),      // 23: google.longrunning.Operation
}
var file_google_spanner_admin_database_v1_backup_proto_depIdxs = []int32{
	18, // 0: google.spanner.admin.database.v1.Backup.version_time:type_name -> google.protobuf.Timestamp
	18, // 1: google.spanner.admin.database.v1.Backup.expire_time:type_name -> google.protobuf.Timestamp
	18, // 2: google.spanner.admin.database.v1.Backup.create_time:type_name -> google.protobuf.Timestamp
	0,  // 3: google.spanner.admin.database.v1.Backup.state:type_name -> google.spanner.admin.database.v1.Backup.State
	19, // 4: google.spanner.admin.database.v1.Backup.encryption_info:type_name -> google.spanner.admin.database.v1.EncryptionInfo
	19, // 5: google.spanner.admin.database.v1.Backup.encryption_information:type_name -> google.spanner.admin.database.v1.EncryptionInfo
	20, // 6: google.spanner.admin.database.v1.Backup.database_dialect:type_name -> google.spanner.admin.database.v1.DatabaseDialect
	18, // 7: google.spanner.admin.database.v1.Backup.max_expire_time:type_name -> google.protobuf.Timestamp
	3,  // 8: google.spanner.admin.database.v1.CreateBackupRequest.backup:type_name -> google.spanner.admin.database.v1.Backup
	16, // 9: google.spanner.admin.database.v1.CreateBackupRequest.encryption_config:type_name -> google.spanner.admin.database.v1.CreateBackupEncryptionConfig
	21, // 10: google.spanner.admin.database.v1.CreateBackupMetadata.progress:type_name -> google.spanner.admin.database.v1.OperationProgress
	18, // 11: google.spanner.admin.database.v1.CreateBackupMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	18, // 12: google.spanner.admin.database.v1.CopyBackupRequest.expire_time:type_name -> google.protobuf.Timestamp
	17, // 13: google.spanner.admin.database.v1.CopyBackupRequest.encryption_config:type_name -> google.spanner.admin.database.v1.CopyBackupEncryptionConfig
	21, // 14: google.spanner.admin.database.v1.CopyBackupMetadata.progress:type_name -> google.spanner.admin.database.v1.OperationProgress
	18, // 15: google.spanner.admin.database.v1.CopyBackupMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	3,  // 16: google.spanner.admin.database.v1.UpdateBackupRequest.backup:type_name -> google.spanner.admin.database.v1.Backup
	22, // 17: google.spanner.admin.database.v1.UpdateBackupRequest.update_mask:type_name -> google.protobuf.FieldMask
	3,  // 18: google.spanner.admin.database.v1.ListBackupsResponse.backups:type_name -> google.spanner.admin.database.v1.Backup
	23, // 19: google.spanner.admin.database.v1.ListBackupOperationsResponse.operations:type_name -> google.longrunning.Operation
	18, // 20: google.spanner.admin.database.v1.BackupInfo.version_time:type_name -> google.protobuf.Timestamp
	18, // 21: google.spanner.admin.database.v1.BackupInfo.create_time:type_name -> google.protobuf.Timestamp
	1,  // 22: google.spanner.admin.database.v1.CreateBackupEncryptionConfig.encryption_type:type_name -> google.spanner.admin.database.v1.CreateBackupEncryptionConfig.EncryptionType
	2,  // 23: google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type:type_name -> google.spanner.admin.database.v1.CopyBackupEncryptionConfig.EncryptionType
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_spanner_admin_database_v1_backup_proto_init() }
func file_google_spanner_admin_database_v1_backup_proto_init() {
	if File_google_spanner_admin_database_v1_backup_proto != nil {
		return
	}
	file_google_spanner_admin_database_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Backup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*CreateBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*CreateBackupMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*CopyBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*CopyBackupMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*GetBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ListBackupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ListBackupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ListBackupOperationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*ListBackupOperationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*BackupInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*CreateBackupEncryptionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_database_v1_backup_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*CopyBackupEncryptionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_admin_database_v1_backup_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   15,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_spanner_admin_database_v1_backup_proto_goTypes,
		DependencyIndexes: file_google_spanner_admin_database_v1_backup_proto_depIdxs,
		EnumInfos:         file_google_spanner_admin_database_v1_backup_proto_enumTypes,
		MessageInfos:      file_google_spanner_admin_database_v1_backup_proto_msgTypes,
	}.Build()
	File_google_spanner_admin_database_v1_backup_proto = out.File
	file_google_spanner_admin_database_v1_backup_proto_rawDesc = nil
	file_google_spanner_admin_database_v1_backup_proto_goTypes = nil
	file_google_spanner_admin_database_v1_backup_proto_depIdxs = nil
}
