// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

package instancepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicates the type of replica.  See the [replica types
// documentation](https://cloud.google.com/spanner/docs/replication#replica_types)
// for more details.
type ReplicaInfo_ReplicaType int32

const (
	// Not specified.
	ReplicaInfo_TYPE_UNSPECIFIED ReplicaInfo_ReplicaType = 0
	// Read-write replicas support both reads and writes. These replicas:
	//
	// * Maintain a full copy of your data.
	// * Serve reads.
	// * Can vote whether to commit a write.
	// * Participate in leadership election.
	// * Are eligible to become a leader.
	ReplicaInfo_READ_WRITE ReplicaInfo_ReplicaType = 1
	// Read-only replicas only support reads (not writes). Read-only replicas:
	//
	// * Maintain a full copy of your data.
	// * Serve reads.
	// * Do not participate in voting to commit writes.
	// * Are not eligible to become a leader.
	ReplicaInfo_READ_ONLY ReplicaInfo_ReplicaType = 2
	// Witness replicas don't support reads but do participate in voting to
	// commit writes. Witness replicas:
	//
	// * Do not maintain a full copy of data.
	// * Do not serve reads.
	// * Vote whether to commit writes.
	// * Participate in leader election but are not eligible to become leader.
	ReplicaInfo_WITNESS ReplicaInfo_ReplicaType = 3
)

// Enum value maps for ReplicaInfo_ReplicaType.
var (
	ReplicaInfo_ReplicaType_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "READ_WRITE",
		2: "READ_ONLY",
		3: "WITNESS",
	}
	ReplicaInfo_ReplicaType_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"READ_WRITE":       1,
		"READ_ONLY":        2,
		"WITNESS":          3,
	}
)

func (x ReplicaInfo_ReplicaType) Enum() *ReplicaInfo_ReplicaType {
	p := new(ReplicaInfo_ReplicaType)
	*p = x
	return p
}

func (x ReplicaInfo_ReplicaType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReplicaInfo_ReplicaType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[0].Descriptor()
}

func (ReplicaInfo_ReplicaType) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[0]
}

func (x ReplicaInfo_ReplicaType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReplicaInfo_ReplicaType.Descriptor instead.
func (ReplicaInfo_ReplicaType) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{0, 0}
}

// The type of this configuration.
type InstanceConfig_Type int32

const (
	// Unspecified.
	InstanceConfig_TYPE_UNSPECIFIED InstanceConfig_Type = 0
	// Google managed configuration.
	InstanceConfig_GOOGLE_MANAGED InstanceConfig_Type = 1
	// User managed configuration.
	InstanceConfig_USER_MANAGED InstanceConfig_Type = 2
)

// Enum value maps for InstanceConfig_Type.
var (
	InstanceConfig_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "GOOGLE_MANAGED",
		2: "USER_MANAGED",
	}
	InstanceConfig_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"GOOGLE_MANAGED":   1,
		"USER_MANAGED":     2,
	}
)

func (x InstanceConfig_Type) Enum() *InstanceConfig_Type {
	p := new(InstanceConfig_Type)
	*p = x
	return p
}

func (x InstanceConfig_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceConfig_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[1].Descriptor()
}

func (InstanceConfig_Type) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[1]
}

func (x InstanceConfig_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceConfig_Type.Descriptor instead.
func (InstanceConfig_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{1, 0}
}

// Indicates the current state of the instance config.
type InstanceConfig_State int32

const (
	// Not specified.
	InstanceConfig_STATE_UNSPECIFIED InstanceConfig_State = 0
	// The instance config is still being created.
	InstanceConfig_CREATING InstanceConfig_State = 1
	// The instance config is fully created and ready to be used to create
	// instances.
	InstanceConfig_READY InstanceConfig_State = 2
)

// Enum value maps for InstanceConfig_State.
var (
	InstanceConfig_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
	}
	InstanceConfig_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
	}
)

func (x InstanceConfig_State) Enum() *InstanceConfig_State {
	p := new(InstanceConfig_State)
	*p = x
	return p
}

func (x InstanceConfig_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstanceConfig_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[2].Descriptor()
}

func (InstanceConfig_State) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[2]
}

func (x InstanceConfig_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstanceConfig_State.Descriptor instead.
func (InstanceConfig_State) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{1, 1}
}

// Indicates the current state of the instance.
type Instance_State int32

const (
	// Not specified.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// The instance is still being created. Resources may not be
	// available yet, and operations such as database creation may not
	// work.
	Instance_CREATING Instance_State = 1
	// The instance is fully created and ready to do work such as
	// creating databases.
	Instance_READY Instance_State = 2
)

// Enum value maps for Instance_State.
var (
	Instance_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
	}
	Instance_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
	}
)

func (x Instance_State) Enum() *Instance_State {
	p := new(Instance_State)
	*p = x
	return p
}

func (x Instance_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[3].Descriptor()
}

func (Instance_State) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[3]
}

func (x Instance_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_State.Descriptor instead.
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{3, 0}
}

// Indicates the current state of the instance partition.
type InstancePartition_State int32

const (
	// Not specified.
	InstancePartition_STATE_UNSPECIFIED InstancePartition_State = 0
	// The instance partition is still being created. Resources may not be
	// available yet, and operations such as creating placements using this
	// instance partition may not work.
	InstancePartition_CREATING InstancePartition_State = 1
	// The instance partition is fully created and ready to do work such as
	// creating placements and using in databases.
	InstancePartition_READY InstancePartition_State = 2
)

// Enum value maps for InstancePartition_State.
var (
	InstancePartition_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
	}
	InstancePartition_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
	}
)

func (x InstancePartition_State) Enum() *InstancePartition_State {
	p := new(InstancePartition_State)
	*p = x
	return p
}

func (x InstancePartition_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InstancePartition_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[4].Descriptor()
}

func (InstancePartition_State) Type() protoreflect.EnumType {
	return &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes[4]
}

func (x InstancePartition_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InstancePartition_State.Descriptor instead.
func (InstancePartition_State) EnumDescriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{22, 0}
}

type ReplicaInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location of the serving resources, e.g. "us-central1".
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The type of replica.
	Type ReplicaInfo_ReplicaType `protobuf:"varint,2,opt,name=type,proto3,enum=google.spanner.admin.instance.v1.ReplicaInfo_ReplicaType" json:"type,omitempty"`
	// If true, this location is designated as the default leader location where
	// leader replicas are placed. See the [region types
	// documentation](https://cloud.google.com/spanner/docs/instances#region_types)
	// for more details.
	DefaultLeaderLocation bool `protobuf:"varint,3,opt,name=default_leader_location,json=defaultLeaderLocation,proto3" json:"default_leader_location,omitempty"`
}

func (x *ReplicaInfo) Reset() {
	*x = ReplicaInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReplicaInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicaInfo) ProtoMessage() {}

func (x *ReplicaInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicaInfo.ProtoReflect.Descriptor instead.
func (*ReplicaInfo) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{0}
}

func (x *ReplicaInfo) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *ReplicaInfo) GetType() ReplicaInfo_ReplicaType {
	if x != nil {
		return x.Type
	}
	return ReplicaInfo_TYPE_UNSPECIFIED
}

func (x *ReplicaInfo) GetDefaultLeaderLocation() bool {
	if x != nil {
		return x.DefaultLeaderLocation
	}
	return false
}

// A possible configuration for a Cloud Spanner instance. Configurations
// define the geographic placement of nodes and their replication.
type InstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique identifier for the instance configuration.  Values
	// are of the form
	// `projects/<project>/instanceConfigs/[a-z][-a-z0-9]*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of this instance configuration as it appears in UIs.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Whether this instance config is a Google or User Managed
	// Configuration.
	ConfigType InstanceConfig_Type `protobuf:"varint,5,opt,name=config_type,json=configType,proto3,enum=google.spanner.admin.instance.v1.InstanceConfig_Type" json:"config_type,omitempty"`
	// The geographic placement of nodes in this instance configuration and their
	// replication properties.
	Replicas []*ReplicaInfo `protobuf:"bytes,3,rep,name=replicas,proto3" json:"replicas,omitempty"`
	// Output only. The available optional replicas to choose from for user
	// managed configurations. Populated for Google managed configurations.
	OptionalReplicas []*ReplicaInfo `protobuf:"bytes,6,rep,name=optional_replicas,json=optionalReplicas,proto3" json:"optional_replicas,omitempty"`
	// Base configuration name, e.g. projects/<project_name>/instanceConfigs/nam3,
	// based on which this configuration is created. Only set for user managed
	// configurations. `base_config` must refer to a configuration of type
	// GOOGLE_MANAGED in the same project as this configuration.
	BaseConfig string `protobuf:"bytes,7,opt,name=base_config,json=baseConfig,proto3" json:"base_config,omitempty"`
	// Cloud Labels are a flexible and lightweight mechanism for organizing cloud
	// resources into groups that reflect a customer's organizational needs and
	// deployment strategies. Cloud Labels can be used to filter collections of
	// resources. They can be used to control how resource metrics are aggregated.
	// And they can be used as arguments to policy management rules (e.g. route,
	// firewall, load balancing, etc.).
	//
	//   - Label keys must be between 1 and 63 characters long and must conform to
	//     the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
	//   - Label values must be between 0 and 63 characters long and must conform
	//     to the regular expression `[a-z0-9_-]{0,63}`.
	//   - No more than 64 labels can be associated with a given resource.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	//
	// If you plan to use labels in your own code, please note that additional
	// characters may be allowed in the future. Therefore, you are advised to use
	// an internal label representation, such as JSON, which doesn't rely upon
	// specific characters being disallowed.  For example, representing labels
	// as the string:  name + "_" + value  would prove problematic if we were to
	// allow "_" in a future release.
	Labels map[string]string `protobuf:"bytes,8,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// etag is used for optimistic concurrency control as a way
	// to help prevent simultaneous updates of a instance config from overwriting
	// each other. It is strongly suggested that systems make use of the etag in
	// the read-modify-write cycle to perform instance config updates in order to
	// avoid race conditions: An etag is returned in the response which contains
	// instance configs, and systems are expected to put that etag in the request
	// to update instance config to ensure that their change will be applied to
	// the same version of the instance config.
	// If no etag is provided in the call to update instance config, then the
	// existing instance config is overwritten blindly.
	Etag string `protobuf:"bytes,9,opt,name=etag,proto3" json:"etag,omitempty"`
	// Allowed values of the "default_leader" schema option for databases in
	// instances that use this instance configuration.
	LeaderOptions []string `protobuf:"bytes,4,rep,name=leader_options,json=leaderOptions,proto3" json:"leader_options,omitempty"`
	// Output only. If true, the instance config is being created or updated. If
	// false, there are no ongoing operations for the instance config.
	Reconciling bool `protobuf:"varint,10,opt,name=reconciling,proto3" json:"reconciling,omitempty"`
	// Output only. The current instance config state.
	State InstanceConfig_State `protobuf:"varint,11,opt,name=state,proto3,enum=google.spanner.admin.instance.v1.InstanceConfig_State" json:"state,omitempty"`
}

func (x *InstanceConfig) Reset() {
	*x = InstanceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstanceConfig) ProtoMessage() {}

func (x *InstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstanceConfig.ProtoReflect.Descriptor instead.
func (*InstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{1}
}

func (x *InstanceConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InstanceConfig) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *InstanceConfig) GetConfigType() InstanceConfig_Type {
	if x != nil {
		return x.ConfigType
	}
	return InstanceConfig_TYPE_UNSPECIFIED
}

func (x *InstanceConfig) GetReplicas() []*ReplicaInfo {
	if x != nil {
		return x.Replicas
	}
	return nil
}

func (x *InstanceConfig) GetOptionalReplicas() []*ReplicaInfo {
	if x != nil {
		return x.OptionalReplicas
	}
	return nil
}

func (x *InstanceConfig) GetBaseConfig() string {
	if x != nil {
		return x.BaseConfig
	}
	return ""
}

func (x *InstanceConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *InstanceConfig) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *InstanceConfig) GetLeaderOptions() []string {
	if x != nil {
		return x.LeaderOptions
	}
	return nil
}

func (x *InstanceConfig) GetReconciling() bool {
	if x != nil {
		return x.Reconciling
	}
	return false
}

func (x *InstanceConfig) GetState() InstanceConfig_State {
	if x != nil {
		return x.State
	}
	return InstanceConfig_STATE_UNSPECIFIED
}

// Autoscaling config for an instance.
type AutoscalingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Autoscaling limits for an instance.
	AutoscalingLimits *AutoscalingConfig_AutoscalingLimits `protobuf:"bytes,1,opt,name=autoscaling_limits,json=autoscalingLimits,proto3" json:"autoscaling_limits,omitempty"`
	// Required. The autoscaling targets for an instance.
	AutoscalingTargets *AutoscalingConfig_AutoscalingTargets `protobuf:"bytes,2,opt,name=autoscaling_targets,json=autoscalingTargets,proto3" json:"autoscaling_targets,omitempty"`
}

func (x *AutoscalingConfig) Reset() {
	*x = AutoscalingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingConfig) ProtoMessage() {}

func (x *AutoscalingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingConfig.ProtoReflect.Descriptor instead.
func (*AutoscalingConfig) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{2}
}

func (x *AutoscalingConfig) GetAutoscalingLimits() *AutoscalingConfig_AutoscalingLimits {
	if x != nil {
		return x.AutoscalingLimits
	}
	return nil
}

func (x *AutoscalingConfig) GetAutoscalingTargets() *AutoscalingConfig_AutoscalingTargets {
	if x != nil {
		return x.AutoscalingTargets
	}
	return nil
}

// An isolated set of Cloud Spanner resources on which databases can be hosted.
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique identifier for the instance, which cannot be changed
	// after the instance is created. Values are of the form
	// `projects/<project>/instances/[a-z][-a-z0-9]*[a-z0-9]`. The final
	// segment of the name must be between 2 and 64 characters in length.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the instance's configuration. Values are of the form
	// `projects/<project>/instanceConfigs/<configuration>`. See
	// also [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
	// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
	Config string `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The descriptive name for this instance as it appears in UIs.
	// Must be unique per project and between 4 and 30 characters in length.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The number of nodes allocated to this instance. At most one of either
	// node_count or processing_units should be present in the message.
	//
	// Users can set the node_count field to specify the target number of nodes
	// allocated to the instance.
	//
	// This may be zero in API responses for instances that are not yet in state
	// `READY`.
	//
	// See [the
	// documentation](https://cloud.google.com/spanner/docs/compute-capacity)
	// for more information about nodes and processing units.
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount,proto3" json:"node_count,omitempty"`
	// The number of processing units allocated to this instance. At most one of
	// processing_units or node_count should be present in the message.
	//
	// Users can set the processing_units field to specify the target number of
	// processing units allocated to the instance.
	//
	// This may be zero in API responses for instances that are not yet in state
	// `READY`.
	//
	// See [the
	// documentation](https://cloud.google.com/spanner/docs/compute-capacity)
	// for more information about nodes and processing units.
	ProcessingUnits int32 `protobuf:"varint,9,opt,name=processing_units,json=processingUnits,proto3" json:"processing_units,omitempty"`
	// Optional. The autoscaling configuration. Autoscaling is enabled if this
	// field is set. When autoscaling is enabled, node_count and processing_units
	// are treated as OUTPUT_ONLY fields and reflect the current compute capacity
	// allocated to the instance.
	AutoscalingConfig *AutoscalingConfig `protobuf:"bytes,17,opt,name=autoscaling_config,json=autoscalingConfig,proto3" json:"autoscaling_config,omitempty"`
	// Output only. The current instance state. For
	// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance],
	// the state must be either omitted or set to `CREATING`. For
	// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance],
	// the state must be either omitted or set to `READY`.
	State Instance_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.spanner.admin.instance.v1.Instance_State" json:"state,omitempty"`
	// Cloud Labels are a flexible and lightweight mechanism for organizing cloud
	// resources into groups that reflect a customer's organizational needs and
	// deployment strategies. Cloud Labels can be used to filter collections of
	// resources. They can be used to control how resource metrics are aggregated.
	// And they can be used as arguments to policy management rules (e.g. route,
	// firewall, load balancing, etc.).
	//
	//   - Label keys must be between 1 and 63 characters long and must conform to
	//     the following regular expression: `[a-z][a-z0-9_-]{0,62}`.
	//   - Label values must be between 0 and 63 characters long and must conform
	//     to the regular expression `[a-z0-9_-]{0,63}`.
	//   - No more than 64 labels can be associated with a given resource.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	//
	// If you plan to use labels in your own code, please note that additional
	// characters may be allowed in the future. And so you are advised to use an
	// internal label representation, such as JSON, which doesn't rely upon
	// specific characters being disallowed.  For example, representing labels
	// as the string:  name + "_" + value  would prove problematic if we were to
	// allow "_" in a future release.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Deprecated. This field is not populated.
	EndpointUris []string `protobuf:"bytes,8,rep,name=endpoint_uris,json=endpointUris,proto3" json:"endpoint_uris,omitempty"`
	// Output only. The time at which the instance was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the instance was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{3}
}

func (x *Instance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Instance) GetConfig() string {
	if x != nil {
		return x.Config
	}
	return ""
}

func (x *Instance) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Instance) GetNodeCount() int32 {
	if x != nil {
		return x.NodeCount
	}
	return 0
}

func (x *Instance) GetProcessingUnits() int32 {
	if x != nil {
		return x.ProcessingUnits
	}
	return 0
}

func (x *Instance) GetAutoscalingConfig() *AutoscalingConfig {
	if x != nil {
		return x.AutoscalingConfig
	}
	return nil
}

func (x *Instance) GetState() Instance_State {
	if x != nil {
		return x.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (x *Instance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Instance) GetEndpointUris() []string {
	if x != nil {
		return x.EndpointUris
	}
	return nil
}

func (x *Instance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Instance) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// The request for
// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
type ListInstanceConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project for which a list of supported instance
	// configurations is requested. Values are of the form
	// `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of instance configurations to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstanceConfigsResponse.next_page_token]
	// from a previous
	// [ListInstanceConfigsResponse][google.spanner.admin.instance.v1.ListInstanceConfigsResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListInstanceConfigsRequest) Reset() {
	*x = ListInstanceConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstanceConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstanceConfigsRequest) ProtoMessage() {}

func (x *ListInstanceConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstanceConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListInstanceConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{4}
}

func (x *ListInstanceConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstanceConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstanceConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
type ListInstanceConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested instance configurations.
	InstanceConfigs []*InstanceConfig `protobuf:"bytes,1,rep,name=instance_configs,json=instanceConfigs,proto3" json:"instance_configs,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs]
	// call to fetch more of the matching instance configurations.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListInstanceConfigsResponse) Reset() {
	*x = ListInstanceConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstanceConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstanceConfigsResponse) ProtoMessage() {}

func (x *ListInstanceConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstanceConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListInstanceConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{5}
}

func (x *ListInstanceConfigsResponse) GetInstanceConfigs() []*InstanceConfig {
	if x != nil {
		return x.InstanceConfigs
	}
	return nil
}

func (x *ListInstanceConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [GetInstanceConfigRequest][google.spanner.admin.instance.v1.InstanceAdmin.GetInstanceConfig].
type GetInstanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the requested instance configuration. Values are of
	// the form `projects/<project>/instanceConfigs/<config>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInstanceConfigRequest) Reset() {
	*x = GetInstanceConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInstanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInstanceConfigRequest) ProtoMessage() {}

func (x *GetInstanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInstanceConfigRequest.ProtoReflect.Descriptor instead.
func (*GetInstanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{6}
}

func (x *GetInstanceConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [CreateInstanceConfigRequest][InstanceAdmin.CreateInstanceConfigRequest].
type CreateInstanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which to create the instance config.
	// Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the instance config to create.  Valid identifiers are
	// of the form `custom-[-a-z0-9]*[a-z0-9]` and must be between 2 and 64
	// characters in length. The `custom-` prefix is required to avoid name
	// conflicts with Google managed configurations.
	InstanceConfigId string `protobuf:"bytes,2,opt,name=instance_config_id,json=instanceConfigId,proto3" json:"instance_config_id,omitempty"`
	// Required. The InstanceConfig proto of the configuration to create.
	// instance_config.name must be
	// `<parent>/instanceConfigs/<instance_config_id>`.
	// instance_config.base_config must be a Google managed configuration name,
	// e.g. <parent>/instanceConfigs/us-east1, <parent>/instanceConfigs/nam3.
	InstanceConfig *InstanceConfig `protobuf:"bytes,3,opt,name=instance_config,json=instanceConfig,proto3" json:"instance_config,omitempty"`
	// An option to validate, but not actually execute, a request,
	// and provide the same response.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreateInstanceConfigRequest) Reset() {
	*x = CreateInstanceConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInstanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceConfigRequest) ProtoMessage() {}

func (x *CreateInstanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateInstanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{7}
}

func (x *CreateInstanceConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInstanceConfigRequest) GetInstanceConfigId() string {
	if x != nil {
		return x.InstanceConfigId
	}
	return ""
}

func (x *CreateInstanceConfigRequest) GetInstanceConfig() *InstanceConfig {
	if x != nil {
		return x.InstanceConfig
	}
	return nil
}

func (x *CreateInstanceConfigRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request for
// [UpdateInstanceConfigRequest][InstanceAdmin.UpdateInstanceConfigRequest].
type UpdateInstanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user instance config to update, which must always include the
	// instance config name. Otherwise, only fields mentioned in
	// [update_mask][google.spanner.admin.instance.v1.UpdateInstanceConfigRequest.update_mask]
	// need be included. To prevent conflicts of concurrent updates,
	// [etag][google.spanner.admin.instance.v1.InstanceConfig.reconciling] can
	// be used.
	InstanceConfig *InstanceConfig `protobuf:"bytes,1,opt,name=instance_config,json=instanceConfig,proto3" json:"instance_config,omitempty"`
	// Required. A mask specifying which fields in
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] should be
	// updated. The field mask must always be specified; this prevents any future
	// fields in [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig]
	// from being erased accidentally by clients that do not know about them. Only
	// display_name and labels can be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// An option to validate, but not actually execute, a request,
	// and provide the same response.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *UpdateInstanceConfigRequest) Reset() {
	*x = UpdateInstanceConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateInstanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstanceConfigRequest) ProtoMessage() {}

func (x *UpdateInstanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstanceConfigRequest.ProtoReflect.Descriptor instead.
func (*UpdateInstanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{8}
}

func (x *UpdateInstanceConfigRequest) GetInstanceConfig() *InstanceConfig {
	if x != nil {
		return x.InstanceConfig
	}
	return nil
}

func (x *UpdateInstanceConfigRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateInstanceConfigRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request for
// [DeleteInstanceConfigRequest][InstanceAdmin.DeleteInstanceConfigRequest].
type DeleteInstanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance configuration to be deleted.
	// Values are of the form
	// `projects/<project>/instanceConfigs/<instance_config>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Used for optimistic concurrency control as a way to help prevent
	// simultaneous deletes of an instance config from overwriting each
	// other. If not empty, the API
	// only deletes the instance config when the etag provided matches the current
	// status of the requested instance config. Otherwise, deletes the instance
	// config without checking the current status of the requested instance
	// config.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// An option to validate, but not actually execute, a request,
	// and provide the same response.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *DeleteInstanceConfigRequest) Reset() {
	*x = DeleteInstanceConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteInstanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInstanceConfigRequest) ProtoMessage() {}

func (x *DeleteInstanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInstanceConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteInstanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteInstanceConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteInstanceConfigRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeleteInstanceConfigRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// The request for
// [ListInstanceConfigOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigOperations].
type ListInstanceConfigOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project of the instance config operations.
	// Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// An expression that filters the list of returned operations.
	//
	// A filter expression consists of a field name, a
	// comparison operator, and a value for filtering.
	// The value must be a string, a number, or a boolean. The comparison operator
	// must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
	// Colon `:` is the contains operator. Filter rules are not case sensitive.
	//
	// The following fields in the [Operation][google.longrunning.Operation]
	// are eligible for filtering:
	//
	//   - `name` - The name of the long-running operation
	//   - `done` - False if the operation is in progress, else true.
	//   - `metadata.@type` - the type of metadata. For example, the type string
	//     for
	//     [CreateInstanceConfigMetadata][google.spanner.admin.instance.v1.CreateInstanceConfigMetadata]
	//     is
	//     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata`.
	//   - `metadata.<field_name>` - any field in metadata.value.
	//     `metadata.@type` must be specified first, if filtering on metadata
	//     fields.
	//   - `error` - Error associated with the long-running operation.
	//   - `response.@type` - the type of response.
	//   - `response.<field_name>` - any field in response.value.
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. By default, expressions are combined with AND logic. However,
	// you can specify AND, OR, and NOT logic explicitly.
	//
	// Here are a few examples:
	//
	//   - `done:true` - The operation is complete.
	//   - `(metadata.@type=` \
	//     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstanceConfigMetadata)
	//     AND` \
	//     `(metadata.instance_config.name:custom-config) AND` \
	//     `(metadata.progress.start_time < \"2021-03-28T14:50:00Z\") AND` \
	//     `(error:*)` - Return operations where:
	//   - The operation's metadata type is
	//     [CreateInstanceConfigMetadata][google.spanner.admin.instance.v1.CreateInstanceConfigMetadata].
	//   - The instance config name contains "custom-config".
	//   - The operation started before 2021-03-28T14:50:00Z.
	//   - The operation resulted in an error.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Number of operations to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse.next_page_token]
	// from a previous
	// [ListInstanceConfigOperationsResponse][google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse]
	// to the same `parent` and with the same `filter`.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListInstanceConfigOperationsRequest) Reset() {
	*x = ListInstanceConfigOperationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstanceConfigOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstanceConfigOperationsRequest) ProtoMessage() {}

func (x *ListInstanceConfigOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstanceConfigOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListInstanceConfigOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{10}
}

func (x *ListInstanceConfigOperationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstanceConfigOperationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInstanceConfigOperationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstanceConfigOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response for
// [ListInstanceConfigOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigOperations].
type ListInstanceConfigOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching instance config [long-running
	// operations][google.longrunning.Operation]. Each operation's name will be
	// prefixed by the instance config's name. The operation's
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata.
	Operations []*longrunningpb.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstanceConfigOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigOperations]
	// call to fetch more of the matching metadata.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListInstanceConfigOperationsResponse) Reset() {
	*x = ListInstanceConfigOperationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstanceConfigOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstanceConfigOperationsResponse) ProtoMessage() {}

func (x *ListInstanceConfigOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstanceConfigOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListInstanceConfigOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{11}
}

func (x *ListInstanceConfigOperationsResponse) GetOperations() []*longrunningpb.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListInstanceConfigOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request for
// [GetInstance][google.spanner.admin.instance.v1.InstanceAdmin.GetInstance].
type GetInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the requested instance. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If field_mask is present, specifies the subset of
	// [Instance][google.spanner.admin.instance.v1.Instance] fields that should be
	// returned. If absent, all
	// [Instance][google.spanner.admin.instance.v1.Instance] fields are returned.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *GetInstanceRequest) Reset() {
	*x = GetInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInstanceRequest) ProtoMessage() {}

func (x *GetInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInstanceRequest.ProtoReflect.Descriptor instead.
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{12}
}

func (x *GetInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetInstanceRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

// The request for
// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance].
type CreateInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project in which to create the instance. Values
	// are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the instance to create.  Valid identifiers are of the
	// form `[a-z][-a-z0-9]*[a-z0-9]` and must be between 2 and 64 characters in
	// length.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. The instance to create.  The name may be omitted, but if
	// specified must be `<parent>/instances/<instance_id>`.
	Instance *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *CreateInstanceRequest) Reset() {
	*x = CreateInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceRequest) ProtoMessage() {}

func (x *CreateInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceRequest.ProtoReflect.Descriptor instead.
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{13}
}

func (x *CreateInstanceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInstanceRequest) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CreateInstanceRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// The request for
// [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances].
type ListInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the project for which a list of instances is
	// requested. Values are of the form `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of instances to be returned in the response. If 0 or less, defaults
	// to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstancesResponse.next_page_token]
	// from a previous
	// [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// An expression for filtering the results of the request. Filter rules are
	// case insensitive. The fields eligible for filtering are:
	//
	//   - `name`
	//   - `display_name`
	//   - `labels.key` where key is the name of a label
	//
	// Some examples of using filters are:
	//
	//   - `name:*` --> The instance has a name.
	//   - `name:Howl` --> The instance's name contains the string "howl".
	//   - `name:HOWL` --> Equivalent to above.
	//   - `NAME:howl` --> Equivalent to above.
	//   - `labels.env:*` --> The instance has the label "env".
	//   - `labels.env:dev` --> The instance has the label "env" and the value of
	//     the label contains the string "dev".
	//   - `name:howl labels.env:dev` --> The instance's name contains "howl" and
	//     it has the label "env" with its value
	//     containing "dev".
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Deadline used while retrieving metadata for instances.
	// Instances whose metadata cannot be retrieved within this deadline will be
	// added to
	// [unreachable][google.spanner.admin.instance.v1.ListInstancesResponse.unreachable]
	// in
	// [ListInstancesResponse][google.spanner.admin.instance.v1.ListInstancesResponse].
	InstanceDeadline *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=instance_deadline,json=instanceDeadline,proto3" json:"instance_deadline,omitempty"`
}

func (x *ListInstancesRequest) Reset() {
	*x = ListInstancesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesRequest) ProtoMessage() {}

func (x *ListInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesRequest.ProtoReflect.Descriptor instead.
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{14}
}

func (x *ListInstancesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstancesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstancesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInstancesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInstancesRequest) GetInstanceDeadline() *timestamppb.Timestamp {
	if x != nil {
		return x.InstanceDeadline
	}
	return nil
}

// The response for
// [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances].
type ListInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested instances.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstances][google.spanner.admin.instance.v1.InstanceAdmin.ListInstances]
	// call to fetch more of the matching instances.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The list of unreachable instances.
	// It includes the names of instances whose metadata could not be retrieved
	// within
	// [instance_deadline][google.spanner.admin.instance.v1.ListInstancesRequest.instance_deadline].
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListInstancesResponse) Reset() {
	*x = ListInstancesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesResponse) ProtoMessage() {}

func (x *ListInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesResponse.ProtoReflect.Descriptor instead.
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{15}
}

func (x *ListInstancesResponse) GetInstances() []*Instance {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *ListInstancesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListInstancesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request for
// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance].
type UpdateInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance to update, which must always include the instance
	// name.  Otherwise, only fields mentioned in
	// [field_mask][google.spanner.admin.instance.v1.UpdateInstanceRequest.field_mask]
	// need be included.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Required. A mask specifying which fields in
	// [Instance][google.spanner.admin.instance.v1.Instance] should be updated.
	// The field mask must always be specified; this prevents any future fields in
	// [Instance][google.spanner.admin.instance.v1.Instance] from being erased
	// accidentally by clients that do not know about them.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdateInstanceRequest) Reset() {
	*x = UpdateInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstanceRequest) ProtoMessage() {}

func (x *UpdateInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstanceRequest.ProtoReflect.Descriptor instead.
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateInstanceRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *UpdateInstanceRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

// The request for
// [DeleteInstance][google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstance].
type DeleteInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance to be deleted. Values are of the form
	// `projects/<project>/instances/<instance>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteInstanceRequest) Reset() {
	*x = DeleteInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInstanceRequest) ProtoMessage() {}

func (x *DeleteInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInstanceRequest.ProtoReflect.Descriptor instead.
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{17}
}

func (x *DeleteInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Metadata type for the operation returned by
// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance].
type CreateInstanceMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance being created.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The time at which the
	// [CreateInstance][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance]
	// request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The expected fulfillment period of this create operation.
	ExpectedFulfillmentPeriod FulfillmentPeriod `protobuf:"varint,5,opt,name=expected_fulfillment_period,json=expectedFulfillmentPeriod,proto3,enum=google.spanner.admin.instance.v1.FulfillmentPeriod" json:"expected_fulfillment_period,omitempty"`
}

func (x *CreateInstanceMetadata) Reset() {
	*x = CreateInstanceMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInstanceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceMetadata) ProtoMessage() {}

func (x *CreateInstanceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceMetadata.ProtoReflect.Descriptor instead.
func (*CreateInstanceMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{18}
}

func (x *CreateInstanceMetadata) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *CreateInstanceMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CreateInstanceMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

func (x *CreateInstanceMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CreateInstanceMetadata) GetExpectedFulfillmentPeriod() FulfillmentPeriod {
	if x != nil {
		return x.ExpectedFulfillmentPeriod
	}
	return FulfillmentPeriod_FULFILLMENT_PERIOD_UNSPECIFIED
}

// Metadata type for the operation returned by
// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance].
type UpdateInstanceMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The desired end state of the update.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// The time at which
	// [UpdateInstance][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance]
	// request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The expected fulfillment period of this update operation.
	ExpectedFulfillmentPeriod FulfillmentPeriod `protobuf:"varint,5,opt,name=expected_fulfillment_period,json=expectedFulfillmentPeriod,proto3,enum=google.spanner.admin.instance.v1.FulfillmentPeriod" json:"expected_fulfillment_period,omitempty"`
}

func (x *UpdateInstanceMetadata) Reset() {
	*x = UpdateInstanceMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateInstanceMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstanceMetadata) ProtoMessage() {}

func (x *UpdateInstanceMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstanceMetadata.ProtoReflect.Descriptor instead.
func (*UpdateInstanceMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{19}
}

func (x *UpdateInstanceMetadata) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

func (x *UpdateInstanceMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *UpdateInstanceMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

func (x *UpdateInstanceMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *UpdateInstanceMetadata) GetExpectedFulfillmentPeriod() FulfillmentPeriod {
	if x != nil {
		return x.ExpectedFulfillmentPeriod
	}
	return FulfillmentPeriod_FULFILLMENT_PERIOD_UNSPECIFIED
}

// Metadata type for the operation returned by
// [CreateInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstanceConfig].
type CreateInstanceConfigMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target instance config end state.
	InstanceConfig *InstanceConfig `protobuf:"bytes,1,opt,name=instance_config,json=instanceConfig,proto3" json:"instance_config,omitempty"`
	// The progress of the
	// [CreateInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstanceConfig]
	// operation.
	Progress *OperationProgress `protobuf:"bytes,2,opt,name=progress,proto3" json:"progress,omitempty"`
	// The time at which this operation was cancelled.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
}

func (x *CreateInstanceConfigMetadata) Reset() {
	*x = CreateInstanceConfigMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInstanceConfigMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceConfigMetadata) ProtoMessage() {}

func (x *CreateInstanceConfigMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceConfigMetadata.ProtoReflect.Descriptor instead.
func (*CreateInstanceConfigMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{20}
}

func (x *CreateInstanceConfigMetadata) GetInstanceConfig() *InstanceConfig {
	if x != nil {
		return x.InstanceConfig
	}
	return nil
}

func (x *CreateInstanceConfigMetadata) GetProgress() *OperationProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *CreateInstanceConfigMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

// Metadata type for the operation returned by
// [UpdateInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstanceConfig].
type UpdateInstanceConfigMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The desired instance config after updating.
	InstanceConfig *InstanceConfig `protobuf:"bytes,1,opt,name=instance_config,json=instanceConfig,proto3" json:"instance_config,omitempty"`
	// The progress of the
	// [UpdateInstanceConfig][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstanceConfig]
	// operation.
	Progress *OperationProgress `protobuf:"bytes,2,opt,name=progress,proto3" json:"progress,omitempty"`
	// The time at which this operation was cancelled.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
}

func (x *UpdateInstanceConfigMetadata) Reset() {
	*x = UpdateInstanceConfigMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateInstanceConfigMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstanceConfigMetadata) ProtoMessage() {}

func (x *UpdateInstanceConfigMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstanceConfigMetadata.ProtoReflect.Descriptor instead.
func (*UpdateInstanceConfigMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{21}
}

func (x *UpdateInstanceConfigMetadata) GetInstanceConfig() *InstanceConfig {
	if x != nil {
		return x.InstanceConfig
	}
	return nil
}

func (x *UpdateInstanceConfigMetadata) GetProgress() *OperationProgress {
	if x != nil {
		return x.Progress
	}
	return nil
}

func (x *UpdateInstanceConfigMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

// An isolated set of Cloud Spanner resources that databases can define
// placements on.
type InstancePartition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A unique identifier for the instance partition. Values are of the
	// form
	// `projects/<project>/instances/<instance>/instancePartitions/[a-z][-a-z0-9]*[a-z0-9]`.
	// The final segment of the name must be between 2 and 64 characters in
	// length. An instance partition's name cannot be changed after the instance
	// partition is created.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the instance partition's configuration. Values are of
	// the form `projects/<project>/instanceConfigs/<configuration>`. See also
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig] and
	// [ListInstanceConfigs][google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs].
	Config string `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The descriptive name for this instance partition as it appears in
	// UIs. Must be unique per project and between 4 and 30 characters in length.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Compute capacity defines amount of server and storage resources that are
	// available to the databases in an instance partition. At most one of either
	// node_count or processing_units should be present in the message. See [the
	// documentation](https://cloud.google.com/spanner/docs/compute-capacity)
	// for more information about nodes and processing units.
	//
	// Types that are assignable to ComputeCapacity:
	//
	//	*InstancePartition_NodeCount
	//	*InstancePartition_ProcessingUnits
	ComputeCapacity isInstancePartition_ComputeCapacity `protobuf_oneof:"compute_capacity"`
	// Output only. The current instance partition state.
	State InstancePartition_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.spanner.admin.instance.v1.InstancePartition_State" json:"state,omitempty"`
	// Output only. The time at which the instance partition was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time at which the instance partition was most recently
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The names of the databases that reference this
	// instance partition. Referencing databases should share the parent instance.
	// The existence of any referencing database prevents the instance partition
	// from being deleted.
	ReferencingDatabases []string `protobuf:"bytes,10,rep,name=referencing_databases,json=referencingDatabases,proto3" json:"referencing_databases,omitempty"`
	// Output only. The names of the backups that reference this instance
	// partition. Referencing backups should share the parent instance. The
	// existence of any referencing backup prevents the instance partition from
	// being deleted.
	ReferencingBackups []string `protobuf:"bytes,11,rep,name=referencing_backups,json=referencingBackups,proto3" json:"referencing_backups,omitempty"`
	// Used for optimistic concurrency control as a way
	// to help prevent simultaneous updates of a instance partition from
	// overwriting each other. It is strongly suggested that systems make use of
	// the etag in the read-modify-write cycle to perform instance partition
	// updates in order to avoid race conditions: An etag is returned in the
	// response which contains instance partitions, and systems are expected to
	// put that etag in the request to update instance partitions to ensure that
	// their change will be applied to the same version of the instance partition.
	// If no etag is provided in the call to update instance partition, then the
	// existing instance partition is overwritten blindly.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *InstancePartition) Reset() {
	*x = InstancePartition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InstancePartition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstancePartition) ProtoMessage() {}

func (x *InstancePartition) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstancePartition.ProtoReflect.Descriptor instead.
func (*InstancePartition) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{22}
}

func (x *InstancePartition) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InstancePartition) GetConfig() string {
	if x != nil {
		return x.Config
	}
	return ""
}

func (x *InstancePartition) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *InstancePartition) GetComputeCapacity() isInstancePartition_ComputeCapacity {
	if m != nil {
		return m.ComputeCapacity
	}
	return nil
}

func (x *InstancePartition) GetNodeCount() int32 {
	if x, ok := x.GetComputeCapacity().(*InstancePartition_NodeCount); ok {
		return x.NodeCount
	}
	return 0
}

func (x *InstancePartition) GetProcessingUnits() int32 {
	if x, ok := x.GetComputeCapacity().(*InstancePartition_ProcessingUnits); ok {
		return x.ProcessingUnits
	}
	return 0
}

func (x *InstancePartition) GetState() InstancePartition_State {
	if x != nil {
		return x.State
	}
	return InstancePartition_STATE_UNSPECIFIED
}

func (x *InstancePartition) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *InstancePartition) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *InstancePartition) GetReferencingDatabases() []string {
	if x != nil {
		return x.ReferencingDatabases
	}
	return nil
}

func (x *InstancePartition) GetReferencingBackups() []string {
	if x != nil {
		return x.ReferencingBackups
	}
	return nil
}

func (x *InstancePartition) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

type isInstancePartition_ComputeCapacity interface {
	isInstancePartition_ComputeCapacity()
}

type InstancePartition_NodeCount struct {
	// The number of nodes allocated to this instance partition.
	//
	// Users can set the node_count field to specify the target number of nodes
	// allocated to the instance partition.
	//
	// This may be zero in API responses for instance partitions that are not
	// yet in state `READY`.
	NodeCount int32 `protobuf:"varint,5,opt,name=node_count,json=nodeCount,proto3,oneof"`
}

type InstancePartition_ProcessingUnits struct {
	// The number of processing units allocated to this instance partition.
	//
	// Users can set the processing_units field to specify the target number of
	// processing units allocated to the instance partition.
	//
	// This may be zero in API responses for instance partitions that are not
	// yet in state `READY`.
	ProcessingUnits int32 `protobuf:"varint,6,opt,name=processing_units,json=processingUnits,proto3,oneof"`
}

func (*InstancePartition_NodeCount) isInstancePartition_ComputeCapacity() {}

func (*InstancePartition_ProcessingUnits) isInstancePartition_ComputeCapacity() {}

// Metadata type for the operation returned by
// [CreateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstancePartition].
type CreateInstancePartitionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The instance partition being created.
	InstancePartition *InstancePartition `protobuf:"bytes,1,opt,name=instance_partition,json=instancePartition,proto3" json:"instance_partition,omitempty"`
	// The time at which the
	// [CreateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstancePartition]
	// request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *CreateInstancePartitionMetadata) Reset() {
	*x = CreateInstancePartitionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInstancePartitionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstancePartitionMetadata) ProtoMessage() {}

func (x *CreateInstancePartitionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstancePartitionMetadata.ProtoReflect.Descriptor instead.
func (*CreateInstancePartitionMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{23}
}

func (x *CreateInstancePartitionMetadata) GetInstancePartition() *InstancePartition {
	if x != nil {
		return x.InstancePartition
	}
	return nil
}

func (x *CreateInstancePartitionMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CreateInstancePartitionMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

func (x *CreateInstancePartitionMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// The request for
// [CreateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.CreateInstancePartition].
type CreateInstancePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance in which to create the instance
	// partition. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the instance partition to create. Valid identifiers are
	// of the form `[a-z][-a-z0-9]*[a-z0-9]` and must be between 2 and 64
	// characters in length.
	InstancePartitionId string `protobuf:"bytes,2,opt,name=instance_partition_id,json=instancePartitionId,proto3" json:"instance_partition_id,omitempty"`
	// Required. The instance partition to create. The instance_partition.name may
	// be omitted, but if specified must be
	// `<parent>/instancePartitions/<instance_partition_id>`.
	InstancePartition *InstancePartition `protobuf:"bytes,3,opt,name=instance_partition,json=instancePartition,proto3" json:"instance_partition,omitempty"`
}

func (x *CreateInstancePartitionRequest) Reset() {
	*x = CreateInstancePartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInstancePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstancePartitionRequest) ProtoMessage() {}

func (x *CreateInstancePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstancePartitionRequest.ProtoReflect.Descriptor instead.
func (*CreateInstancePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{24}
}

func (x *CreateInstancePartitionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInstancePartitionRequest) GetInstancePartitionId() string {
	if x != nil {
		return x.InstancePartitionId
	}
	return ""
}

func (x *CreateInstancePartitionRequest) GetInstancePartition() *InstancePartition {
	if x != nil {
		return x.InstancePartition
	}
	return nil
}

// The request for
// [DeleteInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstancePartition].
type DeleteInstancePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the instance partition to be deleted.
	// Values are of the form
	// `projects/{project}/instances/{instance}/instancePartitions/{instance_partition}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If not empty, the API only deletes the instance partition when
	// the etag provided matches the current status of the requested instance
	// partition. Otherwise, deletes the instance partition without checking the
	// current status of the requested instance partition.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *DeleteInstancePartitionRequest) Reset() {
	*x = DeleteInstancePartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteInstancePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInstancePartitionRequest) ProtoMessage() {}

func (x *DeleteInstancePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInstancePartitionRequest.ProtoReflect.Descriptor instead.
func (*DeleteInstancePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{25}
}

func (x *DeleteInstancePartitionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteInstancePartitionRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// The request for
// [GetInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.GetInstancePartition].
type GetInstancePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the requested instance partition. Values are of
	// the form
	// `projects/{project}/instances/{instance}/instancePartitions/{instance_partition}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInstancePartitionRequest) Reset() {
	*x = GetInstancePartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInstancePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInstancePartitionRequest) ProtoMessage() {}

func (x *GetInstancePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInstancePartitionRequest.ProtoReflect.Descriptor instead.
func (*GetInstancePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{26}
}

func (x *GetInstancePartitionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request for
// [UpdateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstancePartition].
type UpdateInstancePartitionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance partition to update, which must always include the
	// instance partition name. Otherwise, only fields mentioned in
	// [field_mask][google.spanner.admin.instance.v1.UpdateInstancePartitionRequest.field_mask]
	// need be included.
	InstancePartition *InstancePartition `protobuf:"bytes,1,opt,name=instance_partition,json=instancePartition,proto3" json:"instance_partition,omitempty"`
	// Required. A mask specifying which fields in
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition]
	// should be updated. The field mask must always be specified; this prevents
	// any future fields in
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition]
	// from being erased accidentally by clients that do not know about them.
	FieldMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
}

func (x *UpdateInstancePartitionRequest) Reset() {
	*x = UpdateInstancePartitionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateInstancePartitionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstancePartitionRequest) ProtoMessage() {}

func (x *UpdateInstancePartitionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstancePartitionRequest.ProtoReflect.Descriptor instead.
func (*UpdateInstancePartitionRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{27}
}

func (x *UpdateInstancePartitionRequest) GetInstancePartition() *InstancePartition {
	if x != nil {
		return x.InstancePartition
	}
	return nil
}

func (x *UpdateInstancePartitionRequest) GetFieldMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.FieldMask
	}
	return nil
}

// Metadata type for the operation returned by
// [UpdateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstancePartition].
type UpdateInstancePartitionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The desired end state of the update.
	InstancePartition *InstancePartition `protobuf:"bytes,1,opt,name=instance_partition,json=instancePartition,proto3" json:"instance_partition,omitempty"`
	// The time at which
	// [UpdateInstancePartition][google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstancePartition]
	// request was received.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which this operation was cancelled. If set, this operation is
	// in the process of undoing itself (which is guaranteed to succeed) and
	// cannot be cancelled again.
	CancelTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=cancel_time,json=cancelTime,proto3" json:"cancel_time,omitempty"`
	// The time at which this operation failed or was completed successfully.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *UpdateInstancePartitionMetadata) Reset() {
	*x = UpdateInstancePartitionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateInstancePartitionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstancePartitionMetadata) ProtoMessage() {}

func (x *UpdateInstancePartitionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstancePartitionMetadata.ProtoReflect.Descriptor instead.
func (*UpdateInstancePartitionMetadata) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{28}
}

func (x *UpdateInstancePartitionMetadata) GetInstancePartition() *InstancePartition {
	if x != nil {
		return x.InstancePartition
	}
	return nil
}

func (x *UpdateInstancePartitionMetadata) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *UpdateInstancePartitionMetadata) GetCancelTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CancelTime
	}
	return nil
}

func (x *UpdateInstancePartitionMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// The request for
// [ListInstancePartitions][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitions].
type ListInstancePartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance whose instance partitions should be listed. Values
	// are of the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Number of instance partitions to be returned in the response. If 0 or less,
	// defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionsResponse.next_page_token]
	// from a previous
	// [ListInstancePartitionsResponse][google.spanner.admin.instance.v1.ListInstancePartitionsResponse].
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Deadline used while retrieving metadata for instance partitions.
	// Instance partitions whose metadata cannot be retrieved within this deadline
	// will be added to
	// [unreachable][google.spanner.admin.instance.v1.ListInstancePartitionsResponse.unreachable]
	// in
	// [ListInstancePartitionsResponse][google.spanner.admin.instance.v1.ListInstancePartitionsResponse].
	InstancePartitionDeadline *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=instance_partition_deadline,json=instancePartitionDeadline,proto3" json:"instance_partition_deadline,omitempty"`
}

func (x *ListInstancePartitionsRequest) Reset() {
	*x = ListInstancePartitionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancePartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancePartitionsRequest) ProtoMessage() {}

func (x *ListInstancePartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancePartitionsRequest.ProtoReflect.Descriptor instead.
func (*ListInstancePartitionsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{29}
}

func (x *ListInstancePartitionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstancePartitionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstancePartitionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInstancePartitionsRequest) GetInstancePartitionDeadline() *timestamppb.Timestamp {
	if x != nil {
		return x.InstancePartitionDeadline
	}
	return nil
}

// The response for
// [ListInstancePartitions][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitions].
type ListInstancePartitionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of requested instancePartitions.
	InstancePartitions []*InstancePartition `protobuf:"bytes,1,rep,name=instance_partitions,json=instancePartitions,proto3" json:"instance_partitions,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstancePartitions][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitions]
	// call to fetch more of the matching instance partitions.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The list of unreachable instance partitions.
	// It includes the names of instance partitions whose metadata could
	// not be retrieved within
	// [instance_partition_deadline][google.spanner.admin.instance.v1.ListInstancePartitionsRequest.instance_partition_deadline].
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListInstancePartitionsResponse) Reset() {
	*x = ListInstancePartitionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancePartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancePartitionsResponse) ProtoMessage() {}

func (x *ListInstancePartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancePartitionsResponse.ProtoReflect.Descriptor instead.
func (*ListInstancePartitionsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{30}
}

func (x *ListInstancePartitionsResponse) GetInstancePartitions() []*InstancePartition {
	if x != nil {
		return x.InstancePartitions
	}
	return nil
}

func (x *ListInstancePartitionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListInstancePartitionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// The request for
// [ListInstancePartitionOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations].
type ListInstancePartitionOperationsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent instance of the instance partition operations.
	// Values are of the form `projects/<project>/instances/<instance>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. An expression that filters the list of returned operations.
	//
	// A filter expression consists of a field name, a
	// comparison operator, and a value for filtering.
	// The value must be a string, a number, or a boolean. The comparison operator
	// must be one of: `<`, `>`, `<=`, `>=`, `!=`, `=`, or `:`.
	// Colon `:` is the contains operator. Filter rules are not case sensitive.
	//
	// The following fields in the [Operation][google.longrunning.Operation]
	// are eligible for filtering:
	//
	//   - `name` - The name of the long-running operation
	//   - `done` - False if the operation is in progress, else true.
	//   - `metadata.@type` - the type of metadata. For example, the type string
	//     for
	//     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata]
	//     is
	//     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata`.
	//   - `metadata.<field_name>` - any field in metadata.value.
	//     `metadata.@type` must be specified first, if filtering on metadata
	//     fields.
	//   - `error` - Error associated with the long-running operation.
	//   - `response.@type` - the type of response.
	//   - `response.<field_name>` - any field in response.value.
	//
	// You can combine multiple expressions by enclosing each expression in
	// parentheses. By default, expressions are combined with AND logic. However,
	// you can specify AND, OR, and NOT logic explicitly.
	//
	// Here are a few examples:
	//
	//   - `done:true` - The operation is complete.
	//   - `(metadata.@type=` \
	//     `type.googleapis.com/google.spanner.admin.instance.v1.CreateInstancePartitionMetadata)
	//     AND` \
	//     `(metadata.instance_partition.name:custom-instance-partition) AND` \
	//     `(metadata.start_time < \"2021-03-28T14:50:00Z\") AND` \
	//     `(error:*)` - Return operations where:
	//   - The operation's metadata type is
	//     [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
	//   - The instance partition name contains "custom-instance-partition".
	//   - The operation started before 2021-03-28T14:50:00Z.
	//   - The operation resulted in an error.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Number of operations to be returned in the response. If 0 or
	// less, defaults to the server's maximum allowed page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. If non-empty, `page_token` should contain a
	// [next_page_token][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.next_page_token]
	// from a previous
	// [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse]
	// to the same `parent` and with the same `filter`.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Deadline used while retrieving metadata for instance partition
	// operations. Instance partitions whose operation metadata cannot be
	// retrieved within this deadline will be added to
	// [unreachable][ListInstancePartitionOperationsResponse.unreachable] in
	// [ListInstancePartitionOperationsResponse][google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse].
	InstancePartitionDeadline *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=instance_partition_deadline,json=instancePartitionDeadline,proto3" json:"instance_partition_deadline,omitempty"`
}

func (x *ListInstancePartitionOperationsRequest) Reset() {
	*x = ListInstancePartitionOperationsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancePartitionOperationsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancePartitionOperationsRequest) ProtoMessage() {}

func (x *ListInstancePartitionOperationsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancePartitionOperationsRequest.ProtoReflect.Descriptor instead.
func (*ListInstancePartitionOperationsRequest) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{31}
}

func (x *ListInstancePartitionOperationsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstancePartitionOperationsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListInstancePartitionOperationsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstancePartitionOperationsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInstancePartitionOperationsRequest) GetInstancePartitionDeadline() *timestamppb.Timestamp {
	if x != nil {
		return x.InstancePartitionDeadline
	}
	return nil
}

// The response for
// [ListInstancePartitionOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations].
type ListInstancePartitionOperationsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching instance partition [long-running
	// operations][google.longrunning.Operation]. Each operation's name will be
	// prefixed by the instance partition's name. The operation's
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata.
	Operations []*longrunningpb.Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// `next_page_token` can be sent in a subsequent
	// [ListInstancePartitionOperations][google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations]
	// call to fetch more of the matching metadata.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The list of unreachable instance partitions.
	// It includes the names of instance partitions whose operation metadata could
	// not be retrieved within
	// [instance_partition_deadline][google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.instance_partition_deadline].
	UnreachableInstancePartitions []string `protobuf:"bytes,3,rep,name=unreachable_instance_partitions,json=unreachableInstancePartitions,proto3" json:"unreachable_instance_partitions,omitempty"`
}

func (x *ListInstancePartitionOperationsResponse) Reset() {
	*x = ListInstancePartitionOperationsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancePartitionOperationsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancePartitionOperationsResponse) ProtoMessage() {}

func (x *ListInstancePartitionOperationsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancePartitionOperationsResponse.ProtoReflect.Descriptor instead.
func (*ListInstancePartitionOperationsResponse) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{32}
}

func (x *ListInstancePartitionOperationsResponse) GetOperations() []*longrunningpb.Operation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ListInstancePartitionOperationsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListInstancePartitionOperationsResponse) GetUnreachableInstancePartitions() []string {
	if x != nil {
		return x.UnreachableInstancePartitions
	}
	return nil
}

// The autoscaling limits for the instance. Users can define the minimum and
// maximum compute capacity allocated to the instance, and the autoscaler will
// only scale within that range. Users can either use nodes or processing
// units to specify the limits, but should use the same unit to set both the
// min_limit and max_limit.
type AutoscalingConfig_AutoscalingLimits struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The minimum compute capacity for the instance.
	//
	// Types that are assignable to MinLimit:
	//
	//	*AutoscalingConfig_AutoscalingLimits_MinNodes
	//	*AutoscalingConfig_AutoscalingLimits_MinProcessingUnits
	MinLimit isAutoscalingConfig_AutoscalingLimits_MinLimit `protobuf_oneof:"min_limit"`
	// The maximum compute capacity for the instance. The maximum compute
	// capacity should be less than or equal to 10X the minimum compute
	// capacity.
	//
	// Types that are assignable to MaxLimit:
	//
	//	*AutoscalingConfig_AutoscalingLimits_MaxNodes
	//	*AutoscalingConfig_AutoscalingLimits_MaxProcessingUnits
	MaxLimit isAutoscalingConfig_AutoscalingLimits_MaxLimit `protobuf_oneof:"max_limit"`
}

func (x *AutoscalingConfig_AutoscalingLimits) Reset() {
	*x = AutoscalingConfig_AutoscalingLimits{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingConfig_AutoscalingLimits) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingConfig_AutoscalingLimits) ProtoMessage() {}

func (x *AutoscalingConfig_AutoscalingLimits) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingConfig_AutoscalingLimits.ProtoReflect.Descriptor instead.
func (*AutoscalingConfig_AutoscalingLimits) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{2, 0}
}

func (m *AutoscalingConfig_AutoscalingLimits) GetMinLimit() isAutoscalingConfig_AutoscalingLimits_MinLimit {
	if m != nil {
		return m.MinLimit
	}
	return nil
}

func (x *AutoscalingConfig_AutoscalingLimits) GetMinNodes() int32 {
	if x, ok := x.GetMinLimit().(*AutoscalingConfig_AutoscalingLimits_MinNodes); ok {
		return x.MinNodes
	}
	return 0
}

func (x *AutoscalingConfig_AutoscalingLimits) GetMinProcessingUnits() int32 {
	if x, ok := x.GetMinLimit().(*AutoscalingConfig_AutoscalingLimits_MinProcessingUnits); ok {
		return x.MinProcessingUnits
	}
	return 0
}

func (m *AutoscalingConfig_AutoscalingLimits) GetMaxLimit() isAutoscalingConfig_AutoscalingLimits_MaxLimit {
	if m != nil {
		return m.MaxLimit
	}
	return nil
}

func (x *AutoscalingConfig_AutoscalingLimits) GetMaxNodes() int32 {
	if x, ok := x.GetMaxLimit().(*AutoscalingConfig_AutoscalingLimits_MaxNodes); ok {
		return x.MaxNodes
	}
	return 0
}

func (x *AutoscalingConfig_AutoscalingLimits) GetMaxProcessingUnits() int32 {
	if x, ok := x.GetMaxLimit().(*AutoscalingConfig_AutoscalingLimits_MaxProcessingUnits); ok {
		return x.MaxProcessingUnits
	}
	return 0
}

type isAutoscalingConfig_AutoscalingLimits_MinLimit interface {
	isAutoscalingConfig_AutoscalingLimits_MinLimit()
}

type AutoscalingConfig_AutoscalingLimits_MinNodes struct {
	// Minimum number of nodes allocated to the instance. If set, this number
	// should be greater than or equal to 1.
	MinNodes int32 `protobuf:"varint,1,opt,name=min_nodes,json=minNodes,proto3,oneof"`
}

type AutoscalingConfig_AutoscalingLimits_MinProcessingUnits struct {
	// Minimum number of processing units allocated to the instance. If set,
	// this number should be multiples of 1000.
	MinProcessingUnits int32 `protobuf:"varint,2,opt,name=min_processing_units,json=minProcessingUnits,proto3,oneof"`
}

func (*AutoscalingConfig_AutoscalingLimits_MinNodes) isAutoscalingConfig_AutoscalingLimits_MinLimit() {
}

func (*AutoscalingConfig_AutoscalingLimits_MinProcessingUnits) isAutoscalingConfig_AutoscalingLimits_MinLimit() {
}

type isAutoscalingConfig_AutoscalingLimits_MaxLimit interface {
	isAutoscalingConfig_AutoscalingLimits_MaxLimit()
}

type AutoscalingConfig_AutoscalingLimits_MaxNodes struct {
	// Maximum number of nodes allocated to the instance. If set, this number
	// should be greater than or equal to min_nodes.
	MaxNodes int32 `protobuf:"varint,3,opt,name=max_nodes,json=maxNodes,proto3,oneof"`
}

type AutoscalingConfig_AutoscalingLimits_MaxProcessingUnits struct {
	// Maximum number of processing units allocated to the instance. If set,
	// this number should be multiples of 1000 and be greater than or equal to
	// min_processing_units.
	MaxProcessingUnits int32 `protobuf:"varint,4,opt,name=max_processing_units,json=maxProcessingUnits,proto3,oneof"`
}

func (*AutoscalingConfig_AutoscalingLimits_MaxNodes) isAutoscalingConfig_AutoscalingLimits_MaxLimit() {
}

func (*AutoscalingConfig_AutoscalingLimits_MaxProcessingUnits) isAutoscalingConfig_AutoscalingLimits_MaxLimit() {
}

// The autoscaling targets for an instance.
type AutoscalingConfig_AutoscalingTargets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The target high priority cpu utilization percentage that the
	// autoscaler should be trying to achieve for the instance. This number is
	// on a scale from 0 (no utilization) to 100 (full utilization). The valid
	// range is [10, 90] inclusive.
	HighPriorityCpuUtilizationPercent int32 `protobuf:"varint,1,opt,name=high_priority_cpu_utilization_percent,json=highPriorityCpuUtilizationPercent,proto3" json:"high_priority_cpu_utilization_percent,omitempty"`
	// Required. The target storage utilization percentage that the autoscaler
	// should be trying to achieve for the instance. This number is on a scale
	// from 0 (no utilization) to 100 (full utilization). The valid range is
	// [10, 100] inclusive.
	StorageUtilizationPercent int32 `protobuf:"varint,2,opt,name=storage_utilization_percent,json=storageUtilizationPercent,proto3" json:"storage_utilization_percent,omitempty"`
}

func (x *AutoscalingConfig_AutoscalingTargets) Reset() {
	*x = AutoscalingConfig_AutoscalingTargets{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AutoscalingConfig_AutoscalingTargets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutoscalingConfig_AutoscalingTargets) ProtoMessage() {}

func (x *AutoscalingConfig_AutoscalingTargets) ProtoReflect() protoreflect.Message {
	mi := &file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutoscalingConfig_AutoscalingTargets.ProtoReflect.Descriptor instead.
func (*AutoscalingConfig_AutoscalingTargets) Descriptor() ([]byte, []int) {
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP(), []int{2, 1}
}

func (x *AutoscalingConfig_AutoscalingTargets) GetHighPriorityCpuUtilizationPercent() int32 {
	if x != nil {
		return x.HighPriorityCpuUtilizationPercent
	}
	return 0
}

func (x *AutoscalingConfig_AutoscalingTargets) GetStorageUtilizationPercent() int32 {
	if x != nil {
		return x.StorageUtilizationPercent
	}
	return 0
}

var File_google_spanner_admin_instance_v1_spanner_instance_admin_proto protoreflect.FileDescriptor

var file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDesc = []byte{
	0x0a, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x81, 0x02, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x4d, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12,
	0x36, 0x0a, 0x17, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x6c, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x15, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x4c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x4f, 0x0a, 0x0b, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a,
	0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x57,
	0x49, 0x54, 0x4e, 0x45, 0x53, 0x53, 0x10, 0x03, 0x22, 0xc2, 0x07, 0x0a, 0x0e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x5b, 0x0a, 0x0b, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x49, 0x0a, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x49, 0x6e, 0x66, 0x6f,
	0x52, 0x08, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x5f, 0x0a, 0x11, 0x6f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x61, 0x6c, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x12, 0x4b, 0x0a, 0x0b, 0x62,
	0x61, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x62, 0x61,
	0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x54, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x12,
	0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74,
	0x61, 0x67, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x65, 0x61, 0x64,
	0x65, 0x72, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x72, 0x65, 0x63,
	0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x6e, 0x67,
	0x12, 0x51, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x42,
	0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e,
	0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x10, 0x0a, 0x0c, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x4d, 0x41, 0x4e, 0x41, 0x47, 0x45, 0x44,
	0x10, 0x02, 0x22, 0x37, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01,
	0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x3a, 0x60, 0xea, 0x41, 0x5d,
	0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x22, 0x95, 0x05,
	0x0a, 0x11, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x79, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67,
	0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x75, 0x74,
	0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x12, 0x7c,
	0x0a, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63,
	0x61, 0x6c, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x1a, 0xd3, 0x01, 0x0a,
	0x11, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x4c, 0x69, 0x6d, 0x69,
	0x74, 0x73, 0x12, 0x1d, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65,
	0x73, 0x12, 0x32, 0x0a, 0x14, 0x6d, 0x69, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x48,
	0x00, 0x52, 0x12, 0x6d, 0x69, 0x6e, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67,
	0x55, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x6e, 0x6f, 0x64,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x4e,
	0x6f, 0x64, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x14, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x48, 0x01, 0x52, 0x12, 0x6d, 0x61, 0x78, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x6d, 0x69, 0x6e, 0x5f,
	0x6c, 0x69, 0x6d, 0x69, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x6c, 0x69, 0x6d,
	0x69, 0x74, 0x1a, 0xb0, 0x01, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69,
	0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12, 0x55, 0x0a, 0x25, 0x68, 0x69, 0x67,
	0x68, 0x5f, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x63, 0x70, 0x75, 0x5f, 0x75,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x21, 0x68,
	0x69, 0x67, 0x68, 0x50, 0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x43, 0x70, 0x75, 0x55, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
	0x12, 0x43, 0x0a, 0x1b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x74, 0x69, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x19, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x65,
	0x72, 0x63, 0x65, 0x6e, 0x74, 0x22, 0xce, 0x06, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09,
	0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x55,
	0x6e, 0x69, 0x74, 0x73, 0x12, 0x67, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x75, 0x74, 0x6f,
	0x73, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4b, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4e, 0x0a, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0c, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x55, 0x72, 0x69, 0x73, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x37,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05,
	0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x3a, 0x4d, 0xea, 0x41, 0x4a, 0x0a, 0x1f, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x27, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x22, 0xa5, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2,
	0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b,
	0x0a, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x5d, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xa2, 0x02, 0x0a, 0x1b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x31, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x10, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x49, 0x64, 0x12, 0x5e, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f,
	0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xe4, 0x01, 0x0a, 0x1b, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x99,
	0x01, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0xc6, 0x01, 0x0a, 0x23, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x8d, 0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x0a,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x8c, 0x01, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0xd7, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12,
	0x4b, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x80, 0x02, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x22,
	0xab, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x09, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xa4, 0x01,
	0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x22, 0x54, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x84, 0x03, 0x0a, 0x16, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x46, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x39, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x73, 0x0a, 0x1b,
	0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e,
	0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74,
	0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x52, 0x19, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f,
	0x64, 0x22, 0x84, 0x03, 0x0a, 0x16, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x46, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08,
	0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x73, 0x0a, 0x1b, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f,
	0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66,
	0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x52, 0x19, 0x65,
	0x78, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x87, 0x02, 0x0a, 0x1c, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x59, 0x0a, 0x0f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0x87, 0x02, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x12, 0x59, 0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f,
	0x0a, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12,
	0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x94, 0x06, 0x0a,
	0x11, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x27, 0x0a, 0x25, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x6e, 0x6f,
	0x64, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00,
	0x52, 0x09, 0x6e, 0x6f, 0x64, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x10, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x55, 0x6e, 0x69, 0x74, 0x73, 0x12, 0x54, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x38, 0x0a, 0x15, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e,
	0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x13,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x6e, 0x67, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x37, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x3a,
	0x7e, 0xea, 0x41, 0x7b, 0x0a, 0x28, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x42,
	0x12, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x22, 0xb4, 0x02, 0x0a, 0x1f, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x62, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x83, 0x02, 0x0a, 0x1e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37,
	0x0a, 0x15, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x67, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x7a, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x22, 0x63, 0x0a, 0x1b,
	0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xc9, 0x01, 0x0a, 0x1e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x67, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3e, 0x0a,
	0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xb4, 0x02,
	0x0a, 0x1f, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x62, 0x0a, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0xfd, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x5f, 0x0a, 0x1b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x61, 0x64, 0x6c, 0x69,
	0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x61, 0x64,
	0x6c, 0x69, 0x6e, 0x65, 0x22, 0xd0, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xad, 0x02, 0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x5f, 0x0a, 0x1b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x61,
	0x64, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0xd8, 0x01, 0x0a, 0x27, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3d, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x46, 0x0a, 0x1f, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x1d, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x32, 0xce, 0x25, 0x0a, 0x0d, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41,
	0x64, 0x6d, 0x69, 0x6e, 0x12, 0xcc, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x38, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x73, 0x12, 0xb9, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x36, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x12, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xc8, 0x02, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd1, 0x01, 0xca, 0x41, 0x70, 0x0a, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x29, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x3a, 0x01,
	0x2a, 0x22, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0xca, 0x02, 0x0a, 0x14, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xd3, 0x01, 0xca, 0x41, 0x70, 0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x32, 0x37,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa5, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x36, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x29, 0x2a, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xf0, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x41, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32,
	0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0xb4, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x32, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0xe4, 0x01, 0x0a, 0x16, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0xa1, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x22, 0x30, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x23, 0x12, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9c, 0x02, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xb1, 0x01, 0xca, 0x41, 0x64, 0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x2c, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x3a, 0x01, 0x2a,
	0x22, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0x9d, 0x02, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb2,
	0x01, 0xca, 0x41, 0x64, 0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2c, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2f, 0x3a, 0x01, 0x2a, 0x32, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x93, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x30, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x2a, 0x21, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x9a, 0x01, 0x0a, 0x0c, 0x53, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x4f, 0xda, 0x41, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2c, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a,
	0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x93, 0x01, 0x0a, 0x0c, 0x47, 0x65, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x22, 0x48, 0xda, 0x41, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xc5, 0x01, 0x0a,
	0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65,
	0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5a, 0xda, 0x41, 0x14, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x01, 0x2a, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0xd1, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38,
	0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe9, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xec, 0x01, 0xca, 0x41, 0x76, 0x0a, 0x32, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01, 0x2a, 0x22, 0x36, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0xba, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x45, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xea, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xed,
	0x01, 0xca, 0x41, 0x76, 0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61,
	0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1d, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e,
	0x3a, 0x01, 0x2a, 0x32, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x88,
	0x02, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e,
	0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x49, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x78, 0xca, 0x41, 0x16, 0x73, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x5c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x42, 0x8b, 0x02, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x19, 0x53, 0x70,
	0x61, 0x6e, 0x6e, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x41, 0x64, 0x6d,
	0x69, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x46, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73,
	0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x70, 0x62, 0x3b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x70,
	0x62, 0xaa, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x2e, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x26, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x5c, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x5c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x2b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3a, 0x3a, 0x41, 0x64,
	0x6d, 0x69, 0x6e, 0x3a, 0x3a, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescOnce sync.Once
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescData = file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDesc
)

func file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescGZIP() []byte {
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescOnce.Do(func() {
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescData)
	})
	return file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDescData
}

var file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_goTypes = []any{
	(ReplicaInfo_ReplicaType)(0),                    // 0: google.spanner.admin.instance.v1.ReplicaInfo.ReplicaType
	(InstanceConfig_Type)(0),                        // 1: google.spanner.admin.instance.v1.InstanceConfig.Type
	(InstanceConfig_State)(0),                       // 2: google.spanner.admin.instance.v1.InstanceConfig.State
	(Instance_State)(0),                             // 3: google.spanner.admin.instance.v1.Instance.State
	(InstancePartition_State)(0),                    // 4: google.spanner.admin.instance.v1.InstancePartition.State
	(*ReplicaInfo)(nil),                             // 5: google.spanner.admin.instance.v1.ReplicaInfo
	(*InstanceConfig)(nil),                          // 6: google.spanner.admin.instance.v1.InstanceConfig
	(*AutoscalingConfig)(nil),                       // 7: google.spanner.admin.instance.v1.AutoscalingConfig
	(*Instance)(nil),                                // 8: google.spanner.admin.instance.v1.Instance
	(*ListInstanceConfigsRequest)(nil),              // 9: google.spanner.admin.instance.v1.ListInstanceConfigsRequest
	(*ListInstanceConfigsResponse)(nil),             // 10: google.spanner.admin.instance.v1.ListInstanceConfigsResponse
	(*GetInstanceConfigRequest)(nil),                // 11: google.spanner.admin.instance.v1.GetInstanceConfigRequest
	(*CreateInstanceConfigRequest)(nil),             // 12: google.spanner.admin.instance.v1.CreateInstanceConfigRequest
	(*UpdateInstanceConfigRequest)(nil),             // 13: google.spanner.admin.instance.v1.UpdateInstanceConfigRequest
	(*DeleteInstanceConfigRequest)(nil),             // 14: google.spanner.admin.instance.v1.DeleteInstanceConfigRequest
	(*ListInstanceConfigOperationsRequest)(nil),     // 15: google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest
	(*ListInstanceConfigOperationsResponse)(nil),    // 16: google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse
	(*GetInstanceRequest)(nil),                      // 17: google.spanner.admin.instance.v1.GetInstanceRequest
	(*CreateInstanceRequest)(nil),                   // 18: google.spanner.admin.instance.v1.CreateInstanceRequest
	(*ListInstancesRequest)(nil),                    // 19: google.spanner.admin.instance.v1.ListInstancesRequest
	(*ListInstancesResponse)(nil),                   // 20: google.spanner.admin.instance.v1.ListInstancesResponse
	(*UpdateInstanceRequest)(nil),                   // 21: google.spanner.admin.instance.v1.UpdateInstanceRequest
	(*DeleteInstanceRequest)(nil),                   // 22: google.spanner.admin.instance.v1.DeleteInstanceRequest
	(*CreateInstanceMetadata)(nil),                  // 23: google.spanner.admin.instance.v1.CreateInstanceMetadata
	(*UpdateInstanceMetadata)(nil),                  // 24: google.spanner.admin.instance.v1.UpdateInstanceMetadata
	(*CreateInstanceConfigMetadata)(nil),            // 25: google.spanner.admin.instance.v1.CreateInstanceConfigMetadata
	(*UpdateInstanceConfigMetadata)(nil),            // 26: google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata
	(*InstancePartition)(nil),                       // 27: google.spanner.admin.instance.v1.InstancePartition
	(*CreateInstancePartitionMetadata)(nil),         // 28: google.spanner.admin.instance.v1.CreateInstancePartitionMetadata
	(*CreateInstancePartitionRequest)(nil),          // 29: google.spanner.admin.instance.v1.CreateInstancePartitionRequest
	(*DeleteInstancePartitionRequest)(nil),          // 30: google.spanner.admin.instance.v1.DeleteInstancePartitionRequest
	(*GetInstancePartitionRequest)(nil),             // 31: google.spanner.admin.instance.v1.GetInstancePartitionRequest
	(*UpdateInstancePartitionRequest)(nil),          // 32: google.spanner.admin.instance.v1.UpdateInstancePartitionRequest
	(*UpdateInstancePartitionMetadata)(nil),         // 33: google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata
	(*ListInstancePartitionsRequest)(nil),           // 34: google.spanner.admin.instance.v1.ListInstancePartitionsRequest
	(*ListInstancePartitionsResponse)(nil),          // 35: google.spanner.admin.instance.v1.ListInstancePartitionsResponse
	(*ListInstancePartitionOperationsRequest)(nil),  // 36: google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
	(*ListInstancePartitionOperationsResponse)(nil), // 37: google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse
	nil, // 38: google.spanner.admin.instance.v1.InstanceConfig.LabelsEntry
	(*AutoscalingConfig_AutoscalingLimits)(nil),  // 39: google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
	(*AutoscalingConfig_AutoscalingTargets)(nil), // 40: google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
	nil,                                      // 41: google.spanner.admin.instance.v1.Instance.LabelsEntry
	(*timestamppb.Timestamp)(nil),            // 42: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),            // 43: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),          // 44: google.longrunning.Operation
	(FulfillmentPeriod)(0),                   // 45: google.spanner.admin.instance.v1.FulfillmentPeriod
	(*OperationProgress)(nil),                // 46: google.spanner.admin.instance.v1.OperationProgress
	(*iampb.SetIamPolicyRequest)(nil),        // 47: google.iam.v1.SetIamPolicyRequest
	(*iampb.GetIamPolicyRequest)(nil),        // 48: google.iam.v1.GetIamPolicyRequest
	(*iampb.TestIamPermissionsRequest)(nil),  // 49: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                    // 50: google.protobuf.Empty
	(*iampb.Policy)(nil),                     // 51: google.iam.v1.Policy
	(*iampb.TestIamPermissionsResponse)(nil), // 52: google.iam.v1.TestIamPermissionsResponse
}
var file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_depIdxs = []int32{
	0,  // 0: google.spanner.admin.instance.v1.ReplicaInfo.type:type_name -> google.spanner.admin.instance.v1.ReplicaInfo.ReplicaType
	1,  // 1: google.spanner.admin.instance.v1.InstanceConfig.config_type:type_name -> google.spanner.admin.instance.v1.InstanceConfig.Type
	5,  // 2: google.spanner.admin.instance.v1.InstanceConfig.replicas:type_name -> google.spanner.admin.instance.v1.ReplicaInfo
	5,  // 3: google.spanner.admin.instance.v1.InstanceConfig.optional_replicas:type_name -> google.spanner.admin.instance.v1.ReplicaInfo
	38, // 4: google.spanner.admin.instance.v1.InstanceConfig.labels:type_name -> google.spanner.admin.instance.v1.InstanceConfig.LabelsEntry
	2,  // 5: google.spanner.admin.instance.v1.InstanceConfig.state:type_name -> google.spanner.admin.instance.v1.InstanceConfig.State
	39, // 6: google.spanner.admin.instance.v1.AutoscalingConfig.autoscaling_limits:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
	40, // 7: google.spanner.admin.instance.v1.AutoscalingConfig.autoscaling_targets:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
	7,  // 8: google.spanner.admin.instance.v1.Instance.autoscaling_config:type_name -> google.spanner.admin.instance.v1.AutoscalingConfig
	3,  // 9: google.spanner.admin.instance.v1.Instance.state:type_name -> google.spanner.admin.instance.v1.Instance.State
	41, // 10: google.spanner.admin.instance.v1.Instance.labels:type_name -> google.spanner.admin.instance.v1.Instance.LabelsEntry
	42, // 11: google.spanner.admin.instance.v1.Instance.create_time:type_name -> google.protobuf.Timestamp
	42, // 12: google.spanner.admin.instance.v1.Instance.update_time:type_name -> google.protobuf.Timestamp
	6,  // 13: google.spanner.admin.instance.v1.ListInstanceConfigsResponse.instance_configs:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	6,  // 14: google.spanner.admin.instance.v1.CreateInstanceConfigRequest.instance_config:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	6,  // 15: google.spanner.admin.instance.v1.UpdateInstanceConfigRequest.instance_config:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	43, // 16: google.spanner.admin.instance.v1.UpdateInstanceConfigRequest.update_mask:type_name -> google.protobuf.FieldMask
	44, // 17: google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse.operations:type_name -> google.longrunning.Operation
	43, // 18: google.spanner.admin.instance.v1.GetInstanceRequest.field_mask:type_name -> google.protobuf.FieldMask
	8,  // 19: google.spanner.admin.instance.v1.CreateInstanceRequest.instance:type_name -> google.spanner.admin.instance.v1.Instance
	42, // 20: google.spanner.admin.instance.v1.ListInstancesRequest.instance_deadline:type_name -> google.protobuf.Timestamp
	8,  // 21: google.spanner.admin.instance.v1.ListInstancesResponse.instances:type_name -> google.spanner.admin.instance.v1.Instance
	8,  // 22: google.spanner.admin.instance.v1.UpdateInstanceRequest.instance:type_name -> google.spanner.admin.instance.v1.Instance
	43, // 23: google.spanner.admin.instance.v1.UpdateInstanceRequest.field_mask:type_name -> google.protobuf.FieldMask
	8,  // 24: google.spanner.admin.instance.v1.CreateInstanceMetadata.instance:type_name -> google.spanner.admin.instance.v1.Instance
	42, // 25: google.spanner.admin.instance.v1.CreateInstanceMetadata.start_time:type_name -> google.protobuf.Timestamp
	42, // 26: google.spanner.admin.instance.v1.CreateInstanceMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	42, // 27: google.spanner.admin.instance.v1.CreateInstanceMetadata.end_time:type_name -> google.protobuf.Timestamp
	45, // 28: google.spanner.admin.instance.v1.CreateInstanceMetadata.expected_fulfillment_period:type_name -> google.spanner.admin.instance.v1.FulfillmentPeriod
	8,  // 29: google.spanner.admin.instance.v1.UpdateInstanceMetadata.instance:type_name -> google.spanner.admin.instance.v1.Instance
	42, // 30: google.spanner.admin.instance.v1.UpdateInstanceMetadata.start_time:type_name -> google.protobuf.Timestamp
	42, // 31: google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	42, // 32: google.spanner.admin.instance.v1.UpdateInstanceMetadata.end_time:type_name -> google.protobuf.Timestamp
	45, // 33: google.spanner.admin.instance.v1.UpdateInstanceMetadata.expected_fulfillment_period:type_name -> google.spanner.admin.instance.v1.FulfillmentPeriod
	6,  // 34: google.spanner.admin.instance.v1.CreateInstanceConfigMetadata.instance_config:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	46, // 35: google.spanner.admin.instance.v1.CreateInstanceConfigMetadata.progress:type_name -> google.spanner.admin.instance.v1.OperationProgress
	42, // 36: google.spanner.admin.instance.v1.CreateInstanceConfigMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	6,  // 37: google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.instance_config:type_name -> google.spanner.admin.instance.v1.InstanceConfig
	46, // 38: google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.progress:type_name -> google.spanner.admin.instance.v1.OperationProgress
	42, // 39: google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	4,  // 40: google.spanner.admin.instance.v1.InstancePartition.state:type_name -> google.spanner.admin.instance.v1.InstancePartition.State
	42, // 41: google.spanner.admin.instance.v1.InstancePartition.create_time:type_name -> google.protobuf.Timestamp
	42, // 42: google.spanner.admin.instance.v1.InstancePartition.update_time:type_name -> google.protobuf.Timestamp
	27, // 43: google.spanner.admin.instance.v1.CreateInstancePartitionMetadata.instance_partition:type_name -> google.spanner.admin.instance.v1.InstancePartition
	42, // 44: google.spanner.admin.instance.v1.CreateInstancePartitionMetadata.start_time:type_name -> google.protobuf.Timestamp
	42, // 45: google.spanner.admin.instance.v1.CreateInstancePartitionMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	42, // 46: google.spanner.admin.instance.v1.CreateInstancePartitionMetadata.end_time:type_name -> google.protobuf.Timestamp
	27, // 47: google.spanner.admin.instance.v1.CreateInstancePartitionRequest.instance_partition:type_name -> google.spanner.admin.instance.v1.InstancePartition
	27, // 48: google.spanner.admin.instance.v1.UpdateInstancePartitionRequest.instance_partition:type_name -> google.spanner.admin.instance.v1.InstancePartition
	43, // 49: google.spanner.admin.instance.v1.UpdateInstancePartitionRequest.field_mask:type_name -> google.protobuf.FieldMask
	27, // 50: google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.instance_partition:type_name -> google.spanner.admin.instance.v1.InstancePartition
	42, // 51: google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.start_time:type_name -> google.protobuf.Timestamp
	42, // 52: google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.cancel_time:type_name -> google.protobuf.Timestamp
	42, // 53: google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.end_time:type_name -> google.protobuf.Timestamp
	42, // 54: google.spanner.admin.instance.v1.ListInstancePartitionsRequest.instance_partition_deadline:type_name -> google.protobuf.Timestamp
	27, // 55: google.spanner.admin.instance.v1.ListInstancePartitionsResponse.instance_partitions:type_name -> google.spanner.admin.instance.v1.InstancePartition
	42, // 56: google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.instance_partition_deadline:type_name -> google.protobuf.Timestamp
	44, // 57: google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse.operations:type_name -> google.longrunning.Operation
	9,  // 58: google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs:input_type -> google.spanner.admin.instance.v1.ListInstanceConfigsRequest
	11, // 59: google.spanner.admin.instance.v1.InstanceAdmin.GetInstanceConfig:input_type -> google.spanner.admin.instance.v1.GetInstanceConfigRequest
	12, // 60: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstanceConfig:input_type -> google.spanner.admin.instance.v1.CreateInstanceConfigRequest
	13, // 61: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstanceConfig:input_type -> google.spanner.admin.instance.v1.UpdateInstanceConfigRequest
	14, // 62: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstanceConfig:input_type -> google.spanner.admin.instance.v1.DeleteInstanceConfigRequest
	15, // 63: google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigOperations:input_type -> google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest
	19, // 64: google.spanner.admin.instance.v1.InstanceAdmin.ListInstances:input_type -> google.spanner.admin.instance.v1.ListInstancesRequest
	34, // 65: google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitions:input_type -> google.spanner.admin.instance.v1.ListInstancePartitionsRequest
	17, // 66: google.spanner.admin.instance.v1.InstanceAdmin.GetInstance:input_type -> google.spanner.admin.instance.v1.GetInstanceRequest
	18, // 67: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance:input_type -> google.spanner.admin.instance.v1.CreateInstanceRequest
	21, // 68: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance:input_type -> google.spanner.admin.instance.v1.UpdateInstanceRequest
	22, // 69: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstance:input_type -> google.spanner.admin.instance.v1.DeleteInstanceRequest
	47, // 70: google.spanner.admin.instance.v1.InstanceAdmin.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	48, // 71: google.spanner.admin.instance.v1.InstanceAdmin.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	49, // 72: google.spanner.admin.instance.v1.InstanceAdmin.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	31, // 73: google.spanner.admin.instance.v1.InstanceAdmin.GetInstancePartition:input_type -> google.spanner.admin.instance.v1.GetInstancePartitionRequest
	29, // 74: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstancePartition:input_type -> google.spanner.admin.instance.v1.CreateInstancePartitionRequest
	30, // 75: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstancePartition:input_type -> google.spanner.admin.instance.v1.DeleteInstancePartitionRequest
	32, // 76: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstancePartition:input_type -> google.spanner.admin.instance.v1.UpdateInstancePartitionRequest
	36, // 77: google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations:input_type -> google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest
	10, // 78: google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigs:output_type -> google.spanner.admin.instance.v1.ListInstanceConfigsResponse
	6,  // 79: google.spanner.admin.instance.v1.InstanceAdmin.GetInstanceConfig:output_type -> google.spanner.admin.instance.v1.InstanceConfig
	44, // 80: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstanceConfig:output_type -> google.longrunning.Operation
	44, // 81: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstanceConfig:output_type -> google.longrunning.Operation
	50, // 82: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstanceConfig:output_type -> google.protobuf.Empty
	16, // 83: google.spanner.admin.instance.v1.InstanceAdmin.ListInstanceConfigOperations:output_type -> google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse
	20, // 84: google.spanner.admin.instance.v1.InstanceAdmin.ListInstances:output_type -> google.spanner.admin.instance.v1.ListInstancesResponse
	35, // 85: google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitions:output_type -> google.spanner.admin.instance.v1.ListInstancePartitionsResponse
	8,  // 86: google.spanner.admin.instance.v1.InstanceAdmin.GetInstance:output_type -> google.spanner.admin.instance.v1.Instance
	44, // 87: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstance:output_type -> google.longrunning.Operation
	44, // 88: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstance:output_type -> google.longrunning.Operation
	50, // 89: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstance:output_type -> google.protobuf.Empty
	51, // 90: google.spanner.admin.instance.v1.InstanceAdmin.SetIamPolicy:output_type -> google.iam.v1.Policy
	51, // 91: google.spanner.admin.instance.v1.InstanceAdmin.GetIamPolicy:output_type -> google.iam.v1.Policy
	52, // 92: google.spanner.admin.instance.v1.InstanceAdmin.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	27, // 93: google.spanner.admin.instance.v1.InstanceAdmin.GetInstancePartition:output_type -> google.spanner.admin.instance.v1.InstancePartition
	44, // 94: google.spanner.admin.instance.v1.InstanceAdmin.CreateInstancePartition:output_type -> google.longrunning.Operation
	50, // 95: google.spanner.admin.instance.v1.InstanceAdmin.DeleteInstancePartition:output_type -> google.protobuf.Empty
	44, // 96: google.spanner.admin.instance.v1.InstanceAdmin.UpdateInstancePartition:output_type -> google.longrunning.Operation
	37, // 97: google.spanner.admin.instance.v1.InstanceAdmin.ListInstancePartitionOperations:output_type -> google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse
	78, // [78:98] is the sub-list for method output_type
	58, // [58:78] is the sub-list for method input_type
	58, // [58:58] is the sub-list for extension type_name
	58, // [58:58] is the sub-list for extension extendee
	0,  // [0:58] is the sub-list for field type_name
}

func init() { file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_init() }
func file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_init() {
	if File_google_spanner_admin_instance_v1_spanner_instance_admin_proto != nil {
		return
	}
	file_google_spanner_admin_instance_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*ReplicaInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*InstanceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*AutoscalingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*Instance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ListInstanceConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ListInstanceConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*GetInstanceConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*CreateInstanceConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateInstanceConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteInstanceConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ListInstanceConfigOperationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*ListInstanceConfigOperationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*GetInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*CreateInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*ListInstancesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[15].Exporter = func(v any, i int) any {
			switch v := v.(*ListInstancesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[16].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[17].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[18].Exporter = func(v any, i int) any {
			switch v := v.(*CreateInstanceMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[19].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateInstanceMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[20].Exporter = func(v any, i int) any {
			switch v := v.(*CreateInstanceConfigMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[21].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateInstanceConfigMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[22].Exporter = func(v any, i int) any {
			switch v := v.(*InstancePartition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[23].Exporter = func(v any, i int) any {
			switch v := v.(*CreateInstancePartitionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[24].Exporter = func(v any, i int) any {
			switch v := v.(*CreateInstancePartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[25].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteInstancePartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[26].Exporter = func(v any, i int) any {
			switch v := v.(*GetInstancePartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[27].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateInstancePartitionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[28].Exporter = func(v any, i int) any {
			switch v := v.(*UpdateInstancePartitionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[29].Exporter = func(v any, i int) any {
			switch v := v.(*ListInstancePartitionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[30].Exporter = func(v any, i int) any {
			switch v := v.(*ListInstancePartitionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[31].Exporter = func(v any, i int) any {
			switch v := v.(*ListInstancePartitionOperationsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[32].Exporter = func(v any, i int) any {
			switch v := v.(*ListInstancePartitionOperationsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[34].Exporter = func(v any, i int) any {
			switch v := v.(*AutoscalingConfig_AutoscalingLimits); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[35].Exporter = func(v any, i int) any {
			switch v := v.(*AutoscalingConfig_AutoscalingTargets); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[22].OneofWrappers = []any{
		(*InstancePartition_NodeCount)(nil),
		(*InstancePartition_ProcessingUnits)(nil),
	}
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes[34].OneofWrappers = []any{
		(*AutoscalingConfig_AutoscalingLimits_MinNodes)(nil),
		(*AutoscalingConfig_AutoscalingLimits_MinProcessingUnits)(nil),
		(*AutoscalingConfig_AutoscalingLimits_MaxNodes)(nil),
		(*AutoscalingConfig_AutoscalingLimits_MaxProcessingUnits)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_goTypes,
		DependencyIndexes: file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_depIdxs,
		EnumInfos:         file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_enumTypes,
		MessageInfos:      file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_msgTypes,
	}.Build()
	File_google_spanner_admin_instance_v1_spanner_instance_admin_proto = out.File
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_rawDesc = nil
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_goTypes = nil
	file_google_spanner_admin_instance_v1_spanner_instance_admin_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// InstanceAdminClient is the client API for InstanceAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type InstanceAdminClient interface {
	// Lists the supported instance configurations for a given project.
	ListInstanceConfigs(ctx context.Context, in *ListInstanceConfigsRequest, opts ...grpc.CallOption) (*ListInstanceConfigsResponse, error)
	// Gets information about a particular instance configuration.
	GetInstanceConfig(ctx context.Context, in *GetInstanceConfigRequest, opts ...grpc.CallOption) (*InstanceConfig, error)
	// Creates an instance config and begins preparing it to be used. The
	// returned [long-running operation][google.longrunning.Operation]
	// can be used to track the progress of preparing the new
	// instance config. The instance config name is assigned by the caller. If the
	// named instance config already exists, `CreateInstanceConfig` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately after the request returns:
	//
	//   - The instance config is readable via the API, with all requested
	//     attributes. The instance config's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field is set to true. Its state is `CREATING`.
	//
	// While the operation is pending:
	//
	//   - Cancelling the operation renders the instance config immediately
	//     unreadable via the API.
	//   - Except for deleting the creating resource, all other attempts to modify
	//     the instance config are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Instances can be created using the instance configuration.
	//   - The instance config's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field becomes false. Its state becomes `READY`.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format
	// `<instance_config_name>/operations/<operation_id>` and can be used to track
	// creation of the instance config. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateInstanceConfigMetadata][google.spanner.admin.instance.v1.CreateInstanceConfigMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig], if
	// successful.
	//
	// Authorization requires `spanner.instanceConfigs.create` permission on
	// the resource
	// [parent][google.spanner.admin.instance.v1.CreateInstanceConfigRequest.parent].
	CreateInstanceConfig(ctx context.Context, in *CreateInstanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an instance config. The returned
	// [long-running operation][google.longrunning.Operation] can be used to track
	// the progress of updating the instance. If the named instance config does
	// not exist, returns `NOT_FOUND`.
	//
	// Only user managed configurations can be updated.
	//
	// Immediately after the request returns:
	//
	//   - The instance config's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field is set to true.
	//
	// While the operation is pending:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.cancel_time].
	//     The operation is guaranteed to succeed at undoing all changes, after
	//     which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance config are rejected.
	//   - Reading the instance config via the API continues to give the
	//     pre-request values.
	//
	// Upon completion of the returned operation:
	//
	//   - Creating instances using the instance configuration uses the new
	//     values.
	//   - The instance config's new values are readable via the API.
	//   - The instance config's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field becomes false.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format
	// `<instance_config_name>/operations/<operation_id>` and can be used to track
	// the instance config modification.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateInstanceConfigMetadata][google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig], if
	// successful.
	//
	// Authorization requires `spanner.instanceConfigs.update` permission on
	// the resource [name][google.spanner.admin.instance.v1.InstanceConfig.name].
	UpdateInstanceConfig(ctx context.Context, in *UpdateInstanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the instance config. Deletion is only allowed when no
	// instances are using the configuration. If any instances are using
	// the config, returns `FAILED_PRECONDITION`.
	//
	// Only user managed configurations can be deleted.
	//
	// Authorization requires `spanner.instanceConfigs.delete` permission on
	// the resource [name][google.spanner.admin.instance.v1.InstanceConfig.name].
	DeleteInstanceConfig(ctx context.Context, in *DeleteInstanceConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists the user-managed instance config [long-running
	// operations][google.longrunning.Operation] in the given project. An instance
	// config operation has a name of the form
	// `projects/<project>/instanceConfigs/<instance_config>/operations/<operation>`.
	// The long-running operation
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations. Operations returned are ordered by
	// `operation.metadata.value.start_time` in descending order starting
	// from the most recently started operation.
	ListInstanceConfigOperations(ctx context.Context, in *ListInstanceConfigOperationsRequest, opts ...grpc.CallOption) (*ListInstanceConfigOperationsResponse, error)
	// Lists all instances in the given project.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Lists all instance partitions for the given instance.
	ListInstancePartitions(ctx context.Context, in *ListInstancePartitionsRequest, opts ...grpc.CallOption) (*ListInstancePartitionsResponse, error)
	// Gets information about a particular instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates an instance and begins preparing it to begin serving. The
	// returned [long-running operation][google.longrunning.Operation]
	// can be used to track the progress of preparing the new
	// instance. The instance name is assigned by the caller. If the
	// named instance already exists, `CreateInstance` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   - The instance is readable via the API, with all requested attributes
	//     but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation renders the instance immediately unreadable
	//     via the API.
	//   - The instance can be deleted.
	//   - All other attempts to modify the instance are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   - Databases can be created in the instance.
	//   - The instance's allocated resource levels are readable via the API.
	//   - The instance's state becomes `READY`.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track creation of the instance.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateInstanceMetadata][google.spanner.admin.instance.v1.CreateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an instance, and begins allocating or releasing resources
	// as requested. The returned [long-running
	// operation][google.longrunning.Operation] can be used to track the
	// progress of updating the instance. If the named instance does not
	// exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   - For resource types for which a decrease in the instance's allocation
	//     has been requested, billing is based on the newly-requested level.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time],
	//     and begins restoring resources to their pre-request values. The
	//     operation is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance are rejected.
	//   - Reading the instance via the API continues to give the pre-request
	//     resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   - All newly-reserved resources are available for serving the instance's
	//     tables.
	//   - The instance's new resource levels are readable via the API.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track the instance modification.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateInstanceMetadata][google.spanner.admin.instance.v1.UpdateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	//
	// Authorization requires `spanner.instances.update` permission on
	// the resource [name][google.spanner.admin.instance.v1.Instance.name].
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an instance.
	//
	// Immediately upon completion of the request:
	//
	//   - Billing ceases for all of the instance's reserved resources.
	//
	// Soon afterward:
	//
	//   - The instance and *all of its databases* immediately and
	//     irrevocably disappear from the API. All data in the databases
	//     is permanently deleted.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	//
	// Authorization requires `spanner.instances.setIamPolicy` on
	// [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	//
	// Authorization requires `spanner.instances.getIamPolicy` on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner instance resource will
	// result in a NOT_FOUND error if the user has `spanner.instances.list`
	// permission on the containing Google Cloud Project. Otherwise returns an
	// empty set of permissions.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Gets information about a particular instance partition.
	GetInstancePartition(ctx context.Context, in *GetInstancePartitionRequest, opts ...grpc.CallOption) (*InstancePartition, error)
	// Creates an instance partition and begins preparing it to be used. The
	// returned [long-running operation][google.longrunning.Operation]
	// can be used to track the progress of preparing the new instance partition.
	// The instance partition name is assigned by the caller. If the named
	// instance partition already exists, `CreateInstancePartition` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   - The instance partition is readable via the API, with all requested
	//     attributes but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation renders the instance partition immediately
	//     unreadable via the API.
	//   - The instance partition can be deleted.
	//   - All other attempts to modify the instance partition are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   - Databases can start using this instance partition.
	//   - The instance partition's allocated resource levels are readable via the
	//     API.
	//   - The instance partition's state becomes `READY`.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format
	// `<instance_partition_name>/operations/<operation_id>` and can be used to
	// track creation of the instance partition.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition], if
	// successful.
	CreateInstancePartition(ctx context.Context, in *CreateInstancePartitionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an existing instance partition. Requires that the
	// instance partition is not used by any database or backup and is not the
	// default instance partition of an instance.
	//
	// Authorization requires `spanner.instancePartitions.delete` permission on
	// the resource
	// [name][google.spanner.admin.instance.v1.InstancePartition.name].
	DeleteInstancePartition(ctx context.Context, in *DeleteInstancePartitionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an instance partition, and begins allocating or releasing resources
	// as requested. The returned [long-running
	// operation][google.longrunning.Operation] can be used to track the
	// progress of updating the instance partition. If the named instance
	// partition does not exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   - For resource types for which a decrease in the instance partition's
	//     allocation has been requested, billing is based on the newly-requested
	//     level.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.cancel_time],
	//     and begins restoring resources to their pre-request values. The
	//     operation is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance partition are rejected.
	//   - Reading the instance partition via the API continues to give the
	//     pre-request resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   - All newly-reserved resources are available for serving the instance
	//     partition's tables.
	//   - The instance partition's new resource levels are readable via the API.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format
	// `<instance_partition_name>/operations/<operation_id>` and can be used to
	// track the instance partition modification. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateInstancePartitionMetadata][google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition], if
	// successful.
	//
	// Authorization requires `spanner.instancePartitions.update` permission on
	// the resource
	// [name][google.spanner.admin.instance.v1.InstancePartition.name].
	UpdateInstancePartition(ctx context.Context, in *UpdateInstancePartitionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists instance partition [long-running
	// operations][google.longrunning.Operation] in the given instance.
	// An instance partition operation has a name of the form
	// `projects/<project>/instances/<instance>/instancePartitions/<instance_partition>/operations/<operation>`.
	// The long-running operation
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations. Operations returned are ordered by
	// `operation.metadata.value.start_time` in descending order starting from the
	// most recently started operation.
	//
	// Authorization requires `spanner.instancePartitionOperations.list`
	// permission on the resource
	// [parent][google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.parent].
	ListInstancePartitionOperations(ctx context.Context, in *ListInstancePartitionOperationsRequest, opts ...grpc.CallOption) (*ListInstancePartitionOperationsResponse, error)
}

type instanceAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewInstanceAdminClient(cc grpc.ClientConnInterface) InstanceAdminClient {
	return &instanceAdminClient{cc}
}

func (c *instanceAdminClient) ListInstanceConfigs(ctx context.Context, in *ListInstanceConfigsRequest, opts ...grpc.CallOption) (*ListInstanceConfigsResponse, error) {
	out := new(ListInstanceConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstanceConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetInstanceConfig(ctx context.Context, in *GetInstanceConfigRequest, opts ...grpc.CallOption) (*InstanceConfig, error) {
	out := new(InstanceConfig)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstanceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) CreateInstanceConfig(ctx context.Context, in *CreateInstanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstanceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) UpdateInstanceConfig(ctx context.Context, in *UpdateInstanceConfigRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstanceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) DeleteInstanceConfig(ctx context.Context, in *DeleteInstanceConfigRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstanceConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) ListInstanceConfigOperations(ctx context.Context, in *ListInstanceConfigOperationsRequest, opts ...grpc.CallOption) (*ListInstanceConfigOperationsResponse, error) {
	out := new(ListInstanceConfigOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstanceConfigOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) ListInstancePartitions(ctx context.Context, in *ListInstancePartitionsRequest, opts ...grpc.CallOption) (*ListInstancePartitionsResponse, error) {
	out := new(ListInstancePartitionsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstancePartitions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) GetInstancePartition(ctx context.Context, in *GetInstancePartitionRequest, opts ...grpc.CallOption) (*InstancePartition, error) {
	out := new(InstancePartition)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstancePartition", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) CreateInstancePartition(ctx context.Context, in *CreateInstancePartitionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstancePartition", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) DeleteInstancePartition(ctx context.Context, in *DeleteInstancePartitionRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstancePartition", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) UpdateInstancePartition(ctx context.Context, in *UpdateInstancePartitionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstancePartition", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceAdminClient) ListInstancePartitionOperations(ctx context.Context, in *ListInstancePartitionOperationsRequest, opts ...grpc.CallOption) (*ListInstancePartitionOperationsResponse, error) {
	out := new(ListInstancePartitionOperationsResponse)
	err := c.cc.Invoke(ctx, "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstancePartitionOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceAdminServer is the server API for InstanceAdmin service.
type InstanceAdminServer interface {
	// Lists the supported instance configurations for a given project.
	ListInstanceConfigs(context.Context, *ListInstanceConfigsRequest) (*ListInstanceConfigsResponse, error)
	// Gets information about a particular instance configuration.
	GetInstanceConfig(context.Context, *GetInstanceConfigRequest) (*InstanceConfig, error)
	// Creates an instance config and begins preparing it to be used. The
	// returned [long-running operation][google.longrunning.Operation]
	// can be used to track the progress of preparing the new
	// instance config. The instance config name is assigned by the caller. If the
	// named instance config already exists, `CreateInstanceConfig` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately after the request returns:
	//
	//   - The instance config is readable via the API, with all requested
	//     attributes. The instance config's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field is set to true. Its state is `CREATING`.
	//
	// While the operation is pending:
	//
	//   - Cancelling the operation renders the instance config immediately
	//     unreadable via the API.
	//   - Except for deleting the creating resource, all other attempts to modify
	//     the instance config are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Instances can be created using the instance configuration.
	//   - The instance config's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field becomes false. Its state becomes `READY`.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format
	// `<instance_config_name>/operations/<operation_id>` and can be used to track
	// creation of the instance config. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateInstanceConfigMetadata][google.spanner.admin.instance.v1.CreateInstanceConfigMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig], if
	// successful.
	//
	// Authorization requires `spanner.instanceConfigs.create` permission on
	// the resource
	// [parent][google.spanner.admin.instance.v1.CreateInstanceConfigRequest.parent].
	CreateInstanceConfig(context.Context, *CreateInstanceConfigRequest) (*longrunningpb.Operation, error)
	// Updates an instance config. The returned
	// [long-running operation][google.longrunning.Operation] can be used to track
	// the progress of updating the instance. If the named instance config does
	// not exist, returns `NOT_FOUND`.
	//
	// Only user managed configurations can be updated.
	//
	// Immediately after the request returns:
	//
	//   - The instance config's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field is set to true.
	//
	// While the operation is pending:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata.cancel_time].
	//     The operation is guaranteed to succeed at undoing all changes, after
	//     which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance config are rejected.
	//   - Reading the instance config via the API continues to give the
	//     pre-request values.
	//
	// Upon completion of the returned operation:
	//
	//   - Creating instances using the instance configuration uses the new
	//     values.
	//   - The instance config's new values are readable via the API.
	//   - The instance config's
	//     [reconciling][google.spanner.admin.instance.v1.InstanceConfig.reconciling]
	//     field becomes false.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format
	// `<instance_config_name>/operations/<operation_id>` and can be used to track
	// the instance config modification.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateInstanceConfigMetadata][google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [InstanceConfig][google.spanner.admin.instance.v1.InstanceConfig], if
	// successful.
	//
	// Authorization requires `spanner.instanceConfigs.update` permission on
	// the resource [name][google.spanner.admin.instance.v1.InstanceConfig.name].
	UpdateInstanceConfig(context.Context, *UpdateInstanceConfigRequest) (*longrunningpb.Operation, error)
	// Deletes the instance config. Deletion is only allowed when no
	// instances are using the configuration. If any instances are using
	// the config, returns `FAILED_PRECONDITION`.
	//
	// Only user managed configurations can be deleted.
	//
	// Authorization requires `spanner.instanceConfigs.delete` permission on
	// the resource [name][google.spanner.admin.instance.v1.InstanceConfig.name].
	DeleteInstanceConfig(context.Context, *DeleteInstanceConfigRequest) (*emptypb.Empty, error)
	// Lists the user-managed instance config [long-running
	// operations][google.longrunning.Operation] in the given project. An instance
	// config operation has a name of the form
	// `projects/<project>/instanceConfigs/<instance_config>/operations/<operation>`.
	// The long-running operation
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations. Operations returned are ordered by
	// `operation.metadata.value.start_time` in descending order starting
	// from the most recently started operation.
	ListInstanceConfigOperations(context.Context, *ListInstanceConfigOperationsRequest) (*ListInstanceConfigOperationsResponse, error)
	// Lists all instances in the given project.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Lists all instance partitions for the given instance.
	ListInstancePartitions(context.Context, *ListInstancePartitionsRequest) (*ListInstancePartitionsResponse, error)
	// Gets information about a particular instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates an instance and begins preparing it to begin serving. The
	// returned [long-running operation][google.longrunning.Operation]
	// can be used to track the progress of preparing the new
	// instance. The instance name is assigned by the caller. If the
	// named instance already exists, `CreateInstance` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   - The instance is readable via the API, with all requested attributes
	//     but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation renders the instance immediately unreadable
	//     via the API.
	//   - The instance can be deleted.
	//   - All other attempts to modify the instance are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   - Databases can be created in the instance.
	//   - The instance's allocated resource levels are readable via the API.
	//   - The instance's state becomes `READY`.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track creation of the instance.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateInstanceMetadata][google.spanner.admin.instance.v1.CreateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error)
	// Updates an instance, and begins allocating or releasing resources
	// as requested. The returned [long-running
	// operation][google.longrunning.Operation] can be used to track the
	// progress of updating the instance. If the named instance does not
	// exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   - For resource types for which a decrease in the instance's allocation
	//     has been requested, billing is based on the newly-requested level.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstanceMetadata.cancel_time],
	//     and begins restoring resources to their pre-request values. The
	//     operation is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance are rejected.
	//   - Reading the instance via the API continues to give the pre-request
	//     resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   - All newly-reserved resources are available for serving the instance's
	//     tables.
	//   - The instance's new resource levels are readable via the API.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format `<instance_name>/operations/<operation_id>` and
	// can be used to track the instance modification.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateInstanceMetadata][google.spanner.admin.instance.v1.UpdateInstanceMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [Instance][google.spanner.admin.instance.v1.Instance], if successful.
	//
	// Authorization requires `spanner.instances.update` permission on
	// the resource [name][google.spanner.admin.instance.v1.Instance.name].
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error)
	// Deletes an instance.
	//
	// Immediately upon completion of the request:
	//
	//   - Billing ceases for all of the instance's reserved resources.
	//
	// Soon afterward:
	//
	//   - The instance and *all of its databases* immediately and
	//     irrevocably disappear from the API. All data in the databases
	//     is permanently deleted.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*emptypb.Empty, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	//
	// Authorization requires `spanner.instances.setIamPolicy` on
	// [resource][google.iam.v1.SetIamPolicyRequest.resource].
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	//
	// Authorization requires `spanner.instances.getIamPolicy` on
	// [resource][google.iam.v1.GetIamPolicyRequest.resource].
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	//
	// Attempting this RPC on a non-existent Cloud Spanner instance resource will
	// result in a NOT_FOUND error if the user has `spanner.instances.list`
	// permission on the containing Google Cloud Project. Otherwise returns an
	// empty set of permissions.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Gets information about a particular instance partition.
	GetInstancePartition(context.Context, *GetInstancePartitionRequest) (*InstancePartition, error)
	// Creates an instance partition and begins preparing it to be used. The
	// returned [long-running operation][google.longrunning.Operation]
	// can be used to track the progress of preparing the new instance partition.
	// The instance partition name is assigned by the caller. If the named
	// instance partition already exists, `CreateInstancePartition` returns
	// `ALREADY_EXISTS`.
	//
	// Immediately upon completion of this request:
	//
	//   - The instance partition is readable via the API, with all requested
	//     attributes but no allocated resources. Its state is `CREATING`.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation renders the instance partition immediately
	//     unreadable via the API.
	//   - The instance partition can be deleted.
	//   - All other attempts to modify the instance partition are rejected.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing for all successfully-allocated resources begins (some types
	//     may have lower than the requested levels).
	//   - Databases can start using this instance partition.
	//   - The instance partition's allocated resource levels are readable via the
	//     API.
	//   - The instance partition's state becomes `READY`.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format
	// `<instance_partition_name>/operations/<operation_id>` and can be used to
	// track creation of the instance partition.  The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [CreateInstancePartitionMetadata][google.spanner.admin.instance.v1.CreateInstancePartitionMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition], if
	// successful.
	CreateInstancePartition(context.Context, *CreateInstancePartitionRequest) (*longrunningpb.Operation, error)
	// Deletes an existing instance partition. Requires that the
	// instance partition is not used by any database or backup and is not the
	// default instance partition of an instance.
	//
	// Authorization requires `spanner.instancePartitions.delete` permission on
	// the resource
	// [name][google.spanner.admin.instance.v1.InstancePartition.name].
	DeleteInstancePartition(context.Context, *DeleteInstancePartitionRequest) (*emptypb.Empty, error)
	// Updates an instance partition, and begins allocating or releasing resources
	// as requested. The returned [long-running
	// operation][google.longrunning.Operation] can be used to track the
	// progress of updating the instance partition. If the named instance
	// partition does not exist, returns `NOT_FOUND`.
	//
	// Immediately upon completion of this request:
	//
	//   - For resource types for which a decrease in the instance partition's
	//     allocation has been requested, billing is based on the newly-requested
	//     level.
	//
	// Until completion of the returned operation:
	//
	//   - Cancelling the operation sets its metadata's
	//     [cancel_time][google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata.cancel_time],
	//     and begins restoring resources to their pre-request values. The
	//     operation is guaranteed to succeed at undoing all resource changes,
	//     after which point it terminates with a `CANCELLED` status.
	//   - All other attempts to modify the instance partition are rejected.
	//   - Reading the instance partition via the API continues to give the
	//     pre-request resource levels.
	//
	// Upon completion of the returned operation:
	//
	//   - Billing begins for all successfully-allocated resources (some types
	//     may have lower than the requested levels).
	//   - All newly-reserved resources are available for serving the instance
	//     partition's tables.
	//   - The instance partition's new resource levels are readable via the API.
	//
	// The returned [long-running operation][google.longrunning.Operation] will
	// have a name of the format
	// `<instance_partition_name>/operations/<operation_id>` and can be used to
	// track the instance partition modification. The
	// [metadata][google.longrunning.Operation.metadata] field type is
	// [UpdateInstancePartitionMetadata][google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata].
	// The [response][google.longrunning.Operation.response] field type is
	// [InstancePartition][google.spanner.admin.instance.v1.InstancePartition], if
	// successful.
	//
	// Authorization requires `spanner.instancePartitions.update` permission on
	// the resource
	// [name][google.spanner.admin.instance.v1.InstancePartition.name].
	UpdateInstancePartition(context.Context, *UpdateInstancePartitionRequest) (*longrunningpb.Operation, error)
	// Lists instance partition [long-running
	// operations][google.longrunning.Operation] in the given instance.
	// An instance partition operation has a name of the form
	// `projects/<project>/instances/<instance>/instancePartitions/<instance_partition>/operations/<operation>`.
	// The long-running operation
	// [metadata][google.longrunning.Operation.metadata] field type
	// `metadata.type_url` describes the type of the metadata. Operations returned
	// include those that have completed/failed/canceled within the last 7 days,
	// and pending operations. Operations returned are ordered by
	// `operation.metadata.value.start_time` in descending order starting from the
	// most recently started operation.
	//
	// Authorization requires `spanner.instancePartitionOperations.list`
	// permission on the resource
	// [parent][google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest.parent].
	ListInstancePartitionOperations(context.Context, *ListInstancePartitionOperationsRequest) (*ListInstancePartitionOperationsResponse, error)
}

// UnimplementedInstanceAdminServer can be embedded to have forward compatible implementations.
type UnimplementedInstanceAdminServer struct {
}

func (*UnimplementedInstanceAdminServer) ListInstanceConfigs(context.Context, *ListInstanceConfigsRequest) (*ListInstanceConfigsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstanceConfigs not implemented")
}
func (*UnimplementedInstanceAdminServer) GetInstanceConfig(context.Context, *GetInstanceConfigRequest) (*InstanceConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstanceConfig not implemented")
}
func (*UnimplementedInstanceAdminServer) CreateInstanceConfig(context.Context, *CreateInstanceConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstanceConfig not implemented")
}
func (*UnimplementedInstanceAdminServer) UpdateInstanceConfig(context.Context, *UpdateInstanceConfigRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstanceConfig not implemented")
}
func (*UnimplementedInstanceAdminServer) DeleteInstanceConfig(context.Context, *DeleteInstanceConfigRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstanceConfig not implemented")
}
func (*UnimplementedInstanceAdminServer) ListInstanceConfigOperations(context.Context, *ListInstanceConfigOperationsRequest) (*ListInstanceConfigOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstanceConfigOperations not implemented")
}
func (*UnimplementedInstanceAdminServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedInstanceAdminServer) ListInstancePartitions(context.Context, *ListInstancePartitionsRequest) (*ListInstancePartitionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstancePartitions not implemented")
}
func (*UnimplementedInstanceAdminServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (*UnimplementedInstanceAdminServer) CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (*UnimplementedInstanceAdminServer) UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (*UnimplementedInstanceAdminServer) DeleteInstance(context.Context, *DeleteInstanceRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (*UnimplementedInstanceAdminServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedInstanceAdminServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedInstanceAdminServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (*UnimplementedInstanceAdminServer) GetInstancePartition(context.Context, *GetInstancePartitionRequest) (*InstancePartition, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstancePartition not implemented")
}
func (*UnimplementedInstanceAdminServer) CreateInstancePartition(context.Context, *CreateInstancePartitionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstancePartition not implemented")
}
func (*UnimplementedInstanceAdminServer) DeleteInstancePartition(context.Context, *DeleteInstancePartitionRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstancePartition not implemented")
}
func (*UnimplementedInstanceAdminServer) UpdateInstancePartition(context.Context, *UpdateInstancePartitionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstancePartition not implemented")
}
func (*UnimplementedInstanceAdminServer) ListInstancePartitionOperations(context.Context, *ListInstancePartitionOperationsRequest) (*ListInstancePartitionOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstancePartitionOperations not implemented")
}

func RegisterInstanceAdminServer(s *grpc.Server, srv InstanceAdminServer) {
	s.RegisterService(&_InstanceAdmin_serviceDesc, srv)
}

func _InstanceAdmin_ListInstanceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstanceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstanceConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstanceConfigs(ctx, req.(*ListInstanceConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstanceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetInstanceConfig(ctx, req.(*GetInstanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_CreateInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).CreateInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstanceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).CreateInstanceConfig(ctx, req.(*CreateInstanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_UpdateInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).UpdateInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstanceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).UpdateInstanceConfig(ctx, req.(*UpdateInstanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_DeleteInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).DeleteInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstanceConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).DeleteInstanceConfig(ctx, req.(*DeleteInstanceConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_ListInstanceConfigOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceConfigOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstanceConfigOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstanceConfigOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstanceConfigOperations(ctx, req.(*ListInstanceConfigOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_ListInstancePartitions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancePartitionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstancePartitions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstancePartitions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstancePartitions(ctx, req.(*ListInstancePartitionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_GetInstancePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstancePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).GetInstancePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/GetInstancePartition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).GetInstancePartition(ctx, req.(*GetInstancePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_CreateInstancePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstancePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).CreateInstancePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/CreateInstancePartition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).CreateInstancePartition(ctx, req.(*CreateInstancePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_DeleteInstancePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstancePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).DeleteInstancePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/DeleteInstancePartition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).DeleteInstancePartition(ctx, req.(*DeleteInstancePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_UpdateInstancePartition_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstancePartitionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).UpdateInstancePartition(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/UpdateInstancePartition",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).UpdateInstancePartition(ctx, req.(*UpdateInstancePartitionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceAdmin_ListInstancePartitionOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancePartitionOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceAdminServer).ListInstancePartitionOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.spanner.admin.instance.v1.InstanceAdmin/ListInstancePartitionOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceAdminServer).ListInstancePartitionOperations(ctx, req.(*ListInstancePartitionOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _InstanceAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.spanner.admin.instance.v1.InstanceAdmin",
	HandlerType: (*InstanceAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstanceConfigs",
			Handler:    _InstanceAdmin_ListInstanceConfigs_Handler,
		},
		{
			MethodName: "GetInstanceConfig",
			Handler:    _InstanceAdmin_GetInstanceConfig_Handler,
		},
		{
			MethodName: "CreateInstanceConfig",
			Handler:    _InstanceAdmin_CreateInstanceConfig_Handler,
		},
		{
			MethodName: "UpdateInstanceConfig",
			Handler:    _InstanceAdmin_UpdateInstanceConfig_Handler,
		},
		{
			MethodName: "DeleteInstanceConfig",
			Handler:    _InstanceAdmin_DeleteInstanceConfig_Handler,
		},
		{
			MethodName: "ListInstanceConfigOperations",
			Handler:    _InstanceAdmin_ListInstanceConfigOperations_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _InstanceAdmin_ListInstances_Handler,
		},
		{
			MethodName: "ListInstancePartitions",
			Handler:    _InstanceAdmin_ListInstancePartitions_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _InstanceAdmin_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _InstanceAdmin_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _InstanceAdmin_UpdateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _InstanceAdmin_DeleteInstance_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _InstanceAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _InstanceAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InstanceAdmin_TestIamPermissions_Handler,
		},
		{
			MethodName: "GetInstancePartition",
			Handler:    _InstanceAdmin_GetInstancePartition_Handler,
		},
		{
			MethodName: "CreateInstancePartition",
			Handler:    _InstanceAdmin_CreateInstancePartition_Handler,
		},
		{
			MethodName: "DeleteInstancePartition",
			Handler:    _InstanceAdmin_DeleteInstancePartition_Handler,
		},
		{
			MethodName: "UpdateInstancePartition",
			Handler:    _InstanceAdmin_UpdateInstancePartition_Handler,
		},
		{
			MethodName: "ListInstancePartitionOperations",
			Handler:    _InstanceAdmin_ListInstancePartitionOperations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/spanner/admin/instance/v1/spanner_instance_admin.proto",
}
