// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

// Package executor is an auto-generated package for the
// Cloud Spanner Executor test API.
//
// Stop. This folder is likely not what you are looking for. This folder
// contains protocol buffer definitions for test-only API for Cloud Spanner
// clients. Unless told otherwise by a Google Cloud representative, do not
// use any of the contents of this folder. If you would like to use Cloud
// Spanner, please consult our official documentation (at
// https://cloud.google.com/spanner/docs/apis) for details on our APIs, or
// else consider one of our client libraries (at
// https://cloud.google.com/spanner/docs/reference/libraries). This API
// defined in this folder is unreleased and may shut off, break, or fail at
// any time for any users who are not registered as a part of a private
// preview program.
//
//	NOTE: This package is in beta. It is not stable, and may be subject to changes.
//
// # General documentation
//
// For information that is relevant for all client libraries please reference
// https://pkg.go.dev/cloud.google.com/go#pkg-overview. Some information on this
// page includes:
//
//   - [Authentication and Authorization]
//   - [Timeouts and Cancellation]
//   - [Testing against Client Libraries]
//   - [Debugging Client Libraries]
//   - [Inspecting errors]
//
// # Example usage
//
// To get started with this package, create a client.
//
//	// go get cloud.google.com/go/spanner/executor/apiv1@latest
//	ctx := context.Background()
//	// This snippet has been automatically generated and should be regarded as a code template only.
//	// It will require modifications to work:
//	// - It may require correct/in-range values for request initialization.
//	// - It may require specifying regional endpoints when creating the service client as shown in:
//	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
//	c, err := executor.NewSpannerExecutorProxyClient(ctx)
//	if err != nil {
//		// TODO: Handle error.
//	}
//	defer c.Close()
//
// The client will use your default application credentials. Clients should be reused instead of created as needed.
// The methods of Client are safe for concurrent use by multiple goroutines.
// The returned client must be Closed when it is done being used.
//
// # Using the Client
//
// The following is an example of making an API call with the newly created client, mentioned above.
//
//	stream, err := c.ExecuteActionAsync(ctx)
//	if err != nil {
//		// TODO: Handle error.
//	}
//	go func() {
//		reqs := []*executorpb.SpannerAsyncActionRequest{
//			// TODO: Create requests.
//		}
//		for _, req := range reqs {
//			if err := stream.Send(req); err != nil {
//				// TODO: Handle error.
//			}
//		}
//		stream.CloseSend()
//	}()
//	for {
//		resp, err := stream.Recv()
//		if err == io.EOF {
//			break
//		}
//		if err != nil {
//			// TODO: handle error.
//		}
//		// TODO: Use resp.
//		_ = resp
//	}
//
// # Use of Context
//
// The ctx passed to NewSpannerExecutorProxyClient is used for authentication requests and
// for creating the underlying connection, but is not used for subsequent calls.
// Individual methods on the client use the ctx given to them.
//
// To close the open connection, use the Close() method.
//
// [Authentication and Authorization]: https://pkg.go.dev/cloud.google.com/go#hdr-Authentication_and_Authorization
// [Timeouts and Cancellation]: https://pkg.go.dev/cloud.google.com/go#hdr-Timeouts_and_Cancellation
// [Testing against Client Libraries]: https://pkg.go.dev/cloud.google.com/go#hdr-Testing
// [Debugging Client Libraries]: https://pkg.go.dev/cloud.google.com/go#hdr-Debugging
// [Inspecting errors]: https://pkg.go.dev/cloud.google.com/go#hdr-Inspecting_errors
package executor // import "cloud.google.com/go/spanner/executor/apiv1"
