// Code generated by github.com/whyrusleeping/cbor-gen. DO NOT EDIT.

package testing

import (
	"fmt"
	"io"
	"math"
	"sort"

	cid "github.com/ipfs/go-cid"
	cbg "github.com/whyrusleeping/cbor-gen"
	xerrors "golang.org/x/xerrors"
)

var _ = xerrors.Errorf
var _ = cid.Undef
var _ = math.E
var _ = sort.Sort

var lengthBufSignedArray = []byte{129}

func (t *SignedArray) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufSignedArray); err != nil {
		return err
	}

	// t.Signed ([]uint64) (slice)
	if len(t.Signed) > cbg.MaxLength {
		return xerrors.Errorf("Slice value in field t.Signed was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Signed))); err != nil {
		return err
	}
	for _, v := range t.Signed {

		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(v)); err != nil {
			return err
		}

	}
	return nil
}

func (t *SignedArray) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SignedArray{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 1 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.Signed ([]uint64) (slice)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("t.Signed: array too large (%d)", extra)
	}

	if maj != cbg.MajArray {
		return fmt.Errorf("expected cbor array")
	}

	if extra > 0 {
		t.Signed = make([]uint64, extra)
	}

	for i := 0; i < int(extra); i++ {
		{
			var maj byte
			var extra uint64
			var err error
			_ = maj
			_ = extra
			_ = err

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.Signed[i] = uint64(extra)

			}

		}
	}
	return nil
}

var lengthBufSimpleTypeOne = []byte{134}

func (t *SimpleTypeOne) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufSimpleTypeOne); err != nil {
		return err
	}

	// t.Foo (string) (string)
	if len(t.Foo) > cbg.MaxLength {
		return xerrors.Errorf("Value in field t.Foo was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Foo))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Foo)); err != nil {
		return err
	}

	// t.Value (uint64) (uint64)

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Value)); err != nil {
		return err
	}

	// t.Binary ([]uint8) (slice)
	if len(t.Binary) > cbg.ByteArrayMaxLen {
		return xerrors.Errorf("Byte array in field t.Binary was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.Binary))); err != nil {
		return err
	}

	if _, err := cw.Write(t.Binary); err != nil {
		return err
	}

	// t.Signed (int64) (int64)
	if t.Signed >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Signed)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Signed-1)); err != nil {
			return err
		}
	}

	// t.NString (testing.NamedString) (string)
	if len(t.NString) > cbg.MaxLength {
		return xerrors.Errorf("Value in field t.NString was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.NString))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.NString)); err != nil {
		return err
	}

	// t.Strings ([]string) (slice)
	if len(t.Strings) > cbg.MaxLength {
		return xerrors.Errorf("Slice value in field t.Strings was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Strings))); err != nil {
		return err
	}
	for _, v := range t.Strings {
		if len(v) > cbg.MaxLength {
			return xerrors.Errorf("Value in field v was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(v))); err != nil {
			return err
		}
		if _, err := cw.WriteString(string(v)); err != nil {
			return err
		}

	}
	return nil
}

func (t *SimpleTypeOne) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SimpleTypeOne{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 6 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.Foo (string) (string)

	{
		sval, err := cbg.ReadString(cr)
		if err != nil {
			return err
		}

		t.Foo = string(sval)
	}
	// t.Value (uint64) (uint64)

	{

		maj, extra, err = cr.ReadHeader()
		if err != nil {
			return err
		}
		if maj != cbg.MajUnsignedInt {
			return fmt.Errorf("wrong type for uint64 field")
		}
		t.Value = uint64(extra)

	}
	// t.Binary ([]uint8) (slice)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.ByteArrayMaxLen {
		return fmt.Errorf("t.Binary: byte array too large (%d)", extra)
	}
	if maj != cbg.MajByteString {
		return fmt.Errorf("expected byte array")
	}

	if extra > 0 {
		t.Binary = make([]uint8, extra)
	}

	if _, err := io.ReadFull(cr, t.Binary); err != nil {
		return err
	}

	// t.Signed (int64) (int64)
	{
		maj, extra, err := cr.ReadHeader()
		var extraI int64
		if err != nil {
			return err
		}
		switch maj {
		case cbg.MajUnsignedInt:
			extraI = int64(extra)
			if extraI < 0 {
				return fmt.Errorf("int64 positive overflow")
			}
		case cbg.MajNegativeInt:
			extraI = int64(extra)
			if extraI < 0 {
				return fmt.Errorf("int64 negative overflow")
			}
			extraI = -1 - extraI
		default:
			return fmt.Errorf("wrong type for int64 field: %d", maj)
		}

		t.Signed = int64(extraI)
	}
	// t.NString (testing.NamedString) (string)

	{
		sval, err := cbg.ReadString(cr)
		if err != nil {
			return err
		}

		t.NString = NamedString(sval)
	}
	// t.Strings ([]string) (slice)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("t.Strings: array too large (%d)", extra)
	}

	if maj != cbg.MajArray {
		return fmt.Errorf("expected cbor array")
	}

	if extra > 0 {
		t.Strings = make([]string, extra)
	}

	for i := 0; i < int(extra); i++ {
		{
			var maj byte
			var extra uint64
			var err error
			_ = maj
			_ = extra
			_ = err

			{
				sval, err := cbg.ReadString(cr)
				if err != nil {
					return err
				}

				t.Strings[i] = string(sval)
			}

		}
	}
	return nil
}

var lengthBufSimpleTypeTwo = []byte{137}

func (t *SimpleTypeTwo) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufSimpleTypeTwo); err != nil {
		return err
	}

	// t.Stuff (testing.SimpleTypeTwo) (struct)
	if err := t.Stuff.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Others ([]uint64) (slice)
	if len(t.Others) > cbg.MaxLength {
		return xerrors.Errorf("Slice value in field t.Others was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Others))); err != nil {
		return err
	}
	for _, v := range t.Others {

		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(v)); err != nil {
			return err
		}

	}

	// t.SignedOthers ([]int64) (slice)
	if len(t.SignedOthers) > cbg.MaxLength {
		return xerrors.Errorf("Slice value in field t.SignedOthers was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.SignedOthers))); err != nil {
		return err
	}
	for _, v := range t.SignedOthers {
		if v >= 0 {
			if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(v)); err != nil {
				return err
			}
		} else {
			if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-v-1)); err != nil {
				return err
			}
		}

	}

	// t.Test ([][]uint8) (slice)
	if len(t.Test) > cbg.MaxLength {
		return xerrors.Errorf("Slice value in field t.Test was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Test))); err != nil {
		return err
	}
	for _, v := range t.Test {
		if len(v) > cbg.ByteArrayMaxLen {
			return xerrors.Errorf("Byte array in field v was too long")
		}

		if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(v))); err != nil {
			return err
		}

		if _, err := cw.Write(v); err != nil {
			return err
		}

	}

	// t.Dog (string) (string)
	if len(t.Dog) > cbg.MaxLength {
		return xerrors.Errorf("Value in field t.Dog was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.Dog))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.Dog)); err != nil {
		return err
	}

	// t.Numbers ([]testing.NamedNumber) (slice)
	if len(t.Numbers) > cbg.MaxLength {
		return xerrors.Errorf("Slice value in field t.Numbers was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Numbers))); err != nil {
		return err
	}
	for _, v := range t.Numbers {

		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(v)); err != nil {
			return err
		}

	}

	// t.Pizza (uint64) (uint64)

	if t.Pizza == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(*t.Pizza)); err != nil {
			return err
		}
	}

	// t.PointyPizza (testing.NamedNumber) (uint64)

	if t.PointyPizza == nil {
		if _, err := cw.Write(cbg.CborNull); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(*t.PointyPizza)); err != nil {
			return err
		}
	}

	// t.Arrrrrghay ([3]testing.SimpleTypeOne) (array)
	if len(t.Arrrrrghay) > cbg.MaxLength {
		return xerrors.Errorf("Slice value in field t.Arrrrrghay was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Arrrrrghay))); err != nil {
		return err
	}
	for _, v := range t.Arrrrrghay {
		if err := v.MarshalCBOR(cw); err != nil {
			return err
		}
	}
	return nil
}

func (t *SimpleTypeTwo) UnmarshalCBOR(r io.Reader) (err error) {
	*t = SimpleTypeTwo{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 9 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.Stuff (testing.SimpleTypeTwo) (struct)

	{

		b, err := cr.ReadByte()
		if err != nil {
			return err
		}
		if b != cbg.CborNull[0] {
			if err := cr.UnreadByte(); err != nil {
				return err
			}
			t.Stuff = new(SimpleTypeTwo)
			if err := t.Stuff.UnmarshalCBOR(cr); err != nil {
				return xerrors.Errorf("unmarshaling t.Stuff pointer: %w", err)
			}
		}

	}
	// t.Others ([]uint64) (slice)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("t.Others: array too large (%d)", extra)
	}

	if maj != cbg.MajArray {
		return fmt.Errorf("expected cbor array")
	}

	if extra > 0 {
		t.Others = make([]uint64, extra)
	}

	for i := 0; i < int(extra); i++ {
		{
			var maj byte
			var extra uint64
			var err error
			_ = maj
			_ = extra
			_ = err

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.Others[i] = uint64(extra)

			}

		}
	}
	// t.SignedOthers ([]int64) (slice)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("t.SignedOthers: array too large (%d)", extra)
	}

	if maj != cbg.MajArray {
		return fmt.Errorf("expected cbor array")
	}

	if extra > 0 {
		t.SignedOthers = make([]int64, extra)
	}

	for i := 0; i < int(extra); i++ {
		{
			var maj byte
			var extra uint64
			var err error
			_ = maj
			_ = extra
			_ = err
			{
				maj, extra, err := cr.ReadHeader()
				var extraI int64
				if err != nil {
					return err
				}
				switch maj {
				case cbg.MajUnsignedInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 positive overflow")
					}
				case cbg.MajNegativeInt:
					extraI = int64(extra)
					if extraI < 0 {
						return fmt.Errorf("int64 negative overflow")
					}
					extraI = -1 - extraI
				default:
					return fmt.Errorf("wrong type for int64 field: %d", maj)
				}

				t.SignedOthers[i] = int64(extraI)
			}

		}
	}
	// t.Test ([][]uint8) (slice)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("t.Test: array too large (%d)", extra)
	}

	if maj != cbg.MajArray {
		return fmt.Errorf("expected cbor array")
	}

	if extra > 0 {
		t.Test = make([][]uint8, extra)
	}

	for i := 0; i < int(extra); i++ {
		{
			var maj byte
			var extra uint64
			var err error
			_ = maj
			_ = extra
			_ = err

			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}

			if extra > cbg.ByteArrayMaxLen {
				return fmt.Errorf("t.Test[i]: byte array too large (%d)", extra)
			}
			if maj != cbg.MajByteString {
				return fmt.Errorf("expected byte array")
			}

			if extra > 0 {
				t.Test[i] = make([]uint8, extra)
			}

			if _, err := io.ReadFull(cr, t.Test[i]); err != nil {
				return err
			}

		}
	}
	// t.Dog (string) (string)

	{
		sval, err := cbg.ReadString(cr)
		if err != nil {
			return err
		}

		t.Dog = string(sval)
	}
	// t.Numbers ([]testing.NamedNumber) (slice)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("t.Numbers: array too large (%d)", extra)
	}

	if maj != cbg.MajArray {
		return fmt.Errorf("expected cbor array")
	}

	if extra > 0 {
		t.Numbers = make([]NamedNumber, extra)
	}

	for i := 0; i < int(extra); i++ {
		{
			var maj byte
			var extra uint64
			var err error
			_ = maj
			_ = extra
			_ = err

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.Numbers[i] = NamedNumber(extra)

			}

		}
	}
	// t.Pizza (uint64) (uint64)

	{

		b, err := cr.ReadByte()
		if err != nil {
			return err
		}
		if b != cbg.CborNull[0] {
			if err := cr.UnreadByte(); err != nil {
				return err
			}
			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajUnsignedInt {
				return fmt.Errorf("wrong type for uint64 field")
			}
			typed := uint64(extra)
			t.Pizza = &typed
		}

	}
	// t.PointyPizza (testing.NamedNumber) (uint64)

	{

		b, err := cr.ReadByte()
		if err != nil {
			return err
		}
		if b != cbg.CborNull[0] {
			if err := cr.UnreadByte(); err != nil {
				return err
			}
			maj, extra, err = cr.ReadHeader()
			if err != nil {
				return err
			}
			if maj != cbg.MajUnsignedInt {
				return fmt.Errorf("wrong type for uint64 field")
			}
			typed := NamedNumber(extra)
			t.PointyPizza = &typed
		}

	}
	// t.Arrrrrghay ([3]testing.SimpleTypeOne) (array)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("t.Arrrrrghay: array too large (%d)", extra)
	}

	if maj != cbg.MajArray {
		return fmt.Errorf("expected cbor array")
	}
	if extra != 3 {
		return fmt.Errorf("expected array to have 3 elements")
	}

	t.Arrrrrghay = [3]SimpleTypeOne{}
	for i := 0; i < int(extra); i++ {
		{
			var maj byte
			var extra uint64
			var err error
			_ = maj
			_ = extra
			_ = err

			{

				if err := t.Arrrrrghay[i].UnmarshalCBOR(cr); err != nil {
					return xerrors.Errorf("unmarshaling t.Arrrrrghay[i]: %w", err)
				}

			}
		}
	}

	return nil
}

var lengthBufDeferredContainer = []byte{131}

func (t *DeferredContainer) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufDeferredContainer); err != nil {
		return err
	}

	// t.Stuff (testing.SimpleTypeOne) (struct)
	if err := t.Stuff.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Deferred (typegen.Deferred) (struct)
	if err := t.Deferred.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Value (uint64) (uint64)

	if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Value)); err != nil {
		return err
	}

	return nil
}

func (t *DeferredContainer) UnmarshalCBOR(r io.Reader) (err error) {
	*t = DeferredContainer{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 3 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.Stuff (testing.SimpleTypeOne) (struct)

	{

		b, err := cr.ReadByte()
		if err != nil {
			return err
		}
		if b != cbg.CborNull[0] {
			if err := cr.UnreadByte(); err != nil {
				return err
			}
			t.Stuff = new(SimpleTypeOne)
			if err := t.Stuff.UnmarshalCBOR(cr); err != nil {
				return xerrors.Errorf("unmarshaling t.Stuff pointer: %w", err)
			}
		}

	}
	// t.Deferred (typegen.Deferred) (struct)

	{

		t.Deferred = new(cbg.Deferred)

		if err := t.Deferred.UnmarshalCBOR(cr); err != nil {
			return xerrors.Errorf("failed to read deferred field: %w", err)
		}
	}
	// t.Value (uint64) (uint64)

	{

		maj, extra, err = cr.ReadHeader()
		if err != nil {
			return err
		}
		if maj != cbg.MajUnsignedInt {
			return fmt.Errorf("wrong type for uint64 field")
		}
		t.Value = uint64(extra)

	}
	return nil
}

var lengthBufFixedArrays = []byte{131}

func (t *FixedArrays) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufFixedArrays); err != nil {
		return err
	}

	// t.Bytes ([20]uint8) (array)
	if len(t.Bytes) > cbg.ByteArrayMaxLen {
		return xerrors.Errorf("Byte array in field t.Bytes was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.Bytes))); err != nil {
		return err
	}

	if _, err := cw.Write(t.Bytes[:]); err != nil {
		return err
	}

	// t.Uint8 ([20]uint8) (array)
	if len(t.Uint8) > cbg.ByteArrayMaxLen {
		return xerrors.Errorf("Byte array in field t.Uint8 was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.Uint8))); err != nil {
		return err
	}

	if _, err := cw.Write(t.Uint8[:]); err != nil {
		return err
	}

	// t.Uint64 ([20]uint64) (array)
	if len(t.Uint64) > cbg.MaxLength {
		return xerrors.Errorf("Slice value in field t.Uint64 was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajArray, uint64(len(t.Uint64))); err != nil {
		return err
	}
	for _, v := range t.Uint64 {

		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(v)); err != nil {
			return err
		}

	}
	return nil
}

func (t *FixedArrays) UnmarshalCBOR(r io.Reader) (err error) {
	*t = FixedArrays{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 3 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.Bytes ([20]uint8) (array)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.ByteArrayMaxLen {
		return fmt.Errorf("t.Bytes: byte array too large (%d)", extra)
	}
	if maj != cbg.MajByteString {
		return fmt.Errorf("expected byte array")
	}
	if extra != 20 {
		return fmt.Errorf("expected array to have 20 elements")
	}

	t.Bytes = [20]uint8{}
	if _, err := io.ReadFull(cr, t.Bytes[:]); err != nil {
		return err
	}
	// t.Uint8 ([20]uint8) (array)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.ByteArrayMaxLen {
		return fmt.Errorf("t.Uint8: byte array too large (%d)", extra)
	}
	if maj != cbg.MajByteString {
		return fmt.Errorf("expected byte array")
	}
	if extra != 20 {
		return fmt.Errorf("expected array to have 20 elements")
	}

	t.Uint8 = [20]uint8{}
	if _, err := io.ReadFull(cr, t.Uint8[:]); err != nil {
		return err
	}
	// t.Uint64 ([20]uint64) (array)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > cbg.MaxLength {
		return fmt.Errorf("t.Uint64: array too large (%d)", extra)
	}

	if maj != cbg.MajArray {
		return fmt.Errorf("expected cbor array")
	}
	if extra != 20 {
		return fmt.Errorf("expected array to have 20 elements")
	}

	t.Uint64 = [20]uint64{}
	for i := 0; i < int(extra); i++ {
		{
			var maj byte
			var extra uint64
			var err error
			_ = maj
			_ = extra
			_ = err

			{

				maj, extra, err = cr.ReadHeader()
				if err != nil {
					return err
				}
				if maj != cbg.MajUnsignedInt {
					return fmt.Errorf("wrong type for uint64 field")
				}
				t.Uint64[i] = uint64(extra)

			}
		}
	}

	return nil
}

var lengthBufThingWithSomeTime = []byte{131}

func (t *ThingWithSomeTime) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufThingWithSomeTime); err != nil {
		return err
	}

	// t.When (typegen.CborTime) (struct)
	if err := t.When.MarshalCBOR(cw); err != nil {
		return err
	}

	// t.Stuff (int64) (int64)
	if t.Stuff >= 0 {
		if err := cw.WriteMajorTypeHeader(cbg.MajUnsignedInt, uint64(t.Stuff)); err != nil {
			return err
		}
	} else {
		if err := cw.WriteMajorTypeHeader(cbg.MajNegativeInt, uint64(-t.Stuff-1)); err != nil {
			return err
		}
	}

	// t.CatName (string) (string)
	if len(t.CatName) > cbg.MaxLength {
		return xerrors.Errorf("Value in field t.CatName was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajTextString, uint64(len(t.CatName))); err != nil {
		return err
	}
	if _, err := cw.WriteString(string(t.CatName)); err != nil {
		return err
	}
	return nil
}

func (t *ThingWithSomeTime) UnmarshalCBOR(r io.Reader) (err error) {
	*t = ThingWithSomeTime{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 3 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.When (typegen.CborTime) (struct)

	{

		if err := t.When.UnmarshalCBOR(cr); err != nil {
			return xerrors.Errorf("unmarshaling t.When: %w", err)
		}

	}
	// t.Stuff (int64) (int64)
	{
		maj, extra, err := cr.ReadHeader()
		var extraI int64
		if err != nil {
			return err
		}
		switch maj {
		case cbg.MajUnsignedInt:
			extraI = int64(extra)
			if extraI < 0 {
				return fmt.Errorf("int64 positive overflow")
			}
		case cbg.MajNegativeInt:
			extraI = int64(extra)
			if extraI < 0 {
				return fmt.Errorf("int64 negative overflow")
			}
			extraI = -1 - extraI
		default:
			return fmt.Errorf("wrong type for int64 field: %d", maj)
		}

		t.Stuff = int64(extraI)
	}
	// t.CatName (string) (string)

	{
		sval, err := cbg.ReadString(cr)
		if err != nil {
			return err
		}

		t.CatName = string(sval)
	}
	return nil
}

var lengthBufBigField = []byte{129}

func (t *BigField) MarshalCBOR(w io.Writer) error {
	if t == nil {
		_, err := w.Write(cbg.CborNull)
		return err
	}

	cw := cbg.NewCborWriter(w)

	if _, err := cw.Write(lengthBufBigField); err != nil {
		return err
	}

	// t.LargeBytes ([]uint8) (slice)
	if len(t.LargeBytes) > 10000000 {
		return xerrors.Errorf("Byte array in field t.LargeBytes was too long")
	}

	if err := cw.WriteMajorTypeHeader(cbg.MajByteString, uint64(len(t.LargeBytes))); err != nil {
		return err
	}

	if _, err := cw.Write(t.LargeBytes); err != nil {
		return err
	}

	return nil
}

func (t *BigField) UnmarshalCBOR(r io.Reader) (err error) {
	*t = BigField{}

	cr := cbg.NewCborReader(r)

	maj, extra, err := cr.ReadHeader()
	if err != nil {
		return err
	}
	defer func() {
		if err == io.EOF {
			err = io.ErrUnexpectedEOF
		}
	}()

	if maj != cbg.MajArray {
		return fmt.Errorf("cbor input should be of type array")
	}

	if extra != 1 {
		return fmt.Errorf("cbor input had wrong number of fields")
	}

	// t.LargeBytes ([]uint8) (slice)

	maj, extra, err = cr.ReadHeader()
	if err != nil {
		return err
	}

	if extra > 10000000 {
		return fmt.Errorf("t.LargeBytes: byte array too large (%d)", extra)
	}
	if maj != cbg.MajByteString {
		return fmt.Errorf("expected byte array")
	}

	if extra > 0 {
		t.LargeBytes = make([]uint8, extra)
	}

	if _, err := io.ReadFull(cr, t.LargeBytes); err != nil {
		return err
	}

	return nil
}
